/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import org.zkoss.lang.Objects;
import org.zkoss.xml.HTMLs;
import org.zkoss.zk.ui.Component;
import org.zkoss.zul.Checkbox;
import org.zkoss.zul.Radiogroup;

public class Radio
extends Checkbox {
    private String _value = "";

    public Radio() {
    }

    public Radio(String label) {
        super(label);
    }

    public Radio(String label, String image) {
        super(label, image);
    }

    public Radiogroup getRadiogroup() {
        Radio p = this;
        Component q;
        while (!((q = p.getParent()) instanceof Radiogroup) && q != null) {
            p = q;
        }
        return (Radiogroup)q;
    }

    public final boolean isSelected() {
        return this.isChecked();
    }

    public final void setSelected(boolean selected) {
        this.setChecked(selected);
    }

    public void setChecked(boolean checked) {
        if (checked != this.isChecked()) {
            super.setChecked(checked);
            this.fixSiblings(checked, false);
        }
    }

    private void fixSiblings(boolean checked, boolean byclient) {
        Radiogroup group = this.getRadiogroup();
        if (group != null) {
            Radio sib;
            if (checked && (sib = group.getSelectedItem()) != null && sib != this) {
                if (byclient) {
                    ((ExtraCtrl)((Object)sib.getExtraCtrl())).setCheckedByClient(false);
                } else {
                    sib.setChecked(false);
                }
                return;
            }
            group.fixSelectedIndex();
        }
    }

    public String getValue() {
        return this._value;
    }

    public void setValue(String value) {
        if (value == null) {
            value = "";
        }
        if (!Objects.equals((Object)this._value, (Object)value)) {
            this._value = value;
            this.smartUpdate("value", this._value);
        }
    }

    public final String getName() {
        Radiogroup group = this.getRadiogroup();
        return group != null ? group.getName() : this.getUuid();
    }

    public String getInnerAttrs() {
        StringBuffer sb = new StringBuffer(64).append(super.getInnerAttrs());
        HTMLs.appendAttribute((StringBuffer)sb, (String)"value", (String)this.getValue());
        return sb.toString();
    }

    public void setParent(Component parent) {
        Radiogroup oldgp = this.getRadiogroup();
        super.setParent(parent);
        Radiogroup newgp = this.getRadiogroup();
        if (oldgp != newgp) {
            if (oldgp != null) {
                oldgp.fixOnRemove(this);
            }
            if (newgp != null) {
                newgp.fixOnAdd(this);
            }
        }
    }

    protected Object newExtraCtrl() {
        return new ExtraCtrl();
    }

    protected class ExtraCtrl
    extends Checkbox.ExtraCtrl {
        protected ExtraCtrl() {
        }

        public void setCheckedByClient(boolean checked) {
            super.setCheckedByClient(checked);
            Radio.this.fixSiblings(checked, true);
        }
    }
}

