/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Iterator;
import org.zkoss.lang.MutableInteger;
import org.zkoss.lang.Objects;
import org.zkoss.lang.Strings;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.Deferrable;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zul.Radio;
import org.zkoss.zul.impl.XulElement;

public class Radiogroup
extends XulElement {
    private String _orient = "horizontal";
    private String _name = this.genGroupName();
    private int _jsel = -1;
    private transient EventListener _listener;

    public Radiogroup() {
        this.init();
    }

    private void init() {
        this._listener = new Listener();
    }

    public String getOrient() {
        return this._orient;
    }

    public void setOrient(String orient) throws WrongValueException {
        if (!"horizontal".equals(orient) && !"vertical".equals(orient)) {
            throw new WrongValueException("orient cannot be " + orient);
        }
        if (!Objects.equals((Object)this._orient, (Object)orient)) {
            this._orient = orient;
            this.invalidate();
        }
    }

    public Radio getItemAtIndex(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Wrong index: " + index);
        }
        MutableInteger cur = new MutableInteger(0);
        Radio radio = Radiogroup.getAt((Component)this, cur, index);
        if (radio == null) {
            throw new IndexOutOfBoundsException(index + " out of 0.." + (cur.value - 1));
        }
        return radio;
    }

    private static Radio getAt(Component comp, MutableInteger cur, int index) {
        Iterator it = comp.getChildren().iterator();
        while (it.hasNext()) {
            Radio r;
            Component child = (Component)it.next();
            if (child instanceof Radio) {
                if (cur.value++ != index) continue;
                return (Radio)child;
            }
            if (child instanceof Radiogroup || (r = Radiogroup.getAt(child, cur, index)) == null) continue;
            return r;
        }
        return null;
    }

    public int getItemCount() {
        return Radiogroup.countItems((Component)this);
    }

    private static int countItems(Component comp) {
        int sum = 0;
        Iterator it = comp.getChildren().iterator();
        while (it.hasNext()) {
            Component child = (Component)it.next();
            if (child instanceof Radio) {
                ++sum;
                continue;
            }
            if (child instanceof Radiogroup) continue;
            sum += Radiogroup.countItems(child);
        }
        return sum;
    }

    public int getSelectedIndex() {
        return this._jsel;
    }

    public void setSelectedIndex(int jsel) {
        if (jsel < 0) {
            jsel = -1;
        }
        if (this._jsel != jsel) {
            if (jsel < 0) {
                this.getSelectedItem().setSelected(false);
            } else {
                this.getItemAtIndex(jsel).setSelected(true);
            }
        }
    }

    public Radio getSelectedItem() {
        return this._jsel >= 0 ? this.getItemAtIndex(this._jsel) : null;
    }

    public void setSelectedItem(Radio item) {
        if (item == null) {
            this.setSelectedIndex(-1);
        } else {
            if (item.getParent() != this) {
                throw new UiException("Not a child: " + (Object)((Object)item));
            }
            item.setSelected(true);
        }
    }

    public Radio appendItem(String label, String value) {
        Radio item = new Radio();
        item.setLabel(label);
        item.setValue(value);
        item.setParent((Component)this);
        return item;
    }

    public Radio removeItemAt(int index) {
        Radio item = this.getItemAtIndex(index);
        this.removeChild((Component)item);
        return item;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        if (name != null && name.length() == 0) {
            name = null;
        }
        if (!Objects.equals((Object)this._name, (Object)name)) {
            this._name = name;
            this.smartUpdate("name", this._name);
        }
    }

    void fixOnAdd(Radio child) {
        if (this._jsel >= 0 && child.isSelected()) {
            child.setSelected(false);
        } else {
            this.fixSelectedIndex();
        }
        child.addEventListener("onCheck", this._listener);
    }

    void fixOnRemove(Radio child) {
        if (child.isSelected()) {
            this._jsel = -1;
        } else if (this._jsel > 0) {
            this.fixSelectedIndex();
        }
        child.removeEventListener("onCheck", this._listener);
    }

    void fixSelectedIndex() {
        this._jsel = Radiogroup.fixSelIndex((Component)this, new MutableInteger(0));
    }

    private static int fixSelIndex(Component comp, MutableInteger cur) {
        Iterator it = comp.getChildren().iterator();
        while (it.hasNext()) {
            int jsel;
            Component child = (Component)it.next();
            if (child instanceof Radio) {
                if (((Radio)child).isSelected()) {
                    return cur.value;
                }
                ++cur.value;
                continue;
            }
            if (child instanceof Radiogroup || (jsel = Radiogroup.fixSelIndex(child, cur)) < 0) continue;
            return jsel;
        }
        return -1;
    }

    private String genGroupName() {
        return Strings.encode((StringBuffer)new StringBuffer(16).append("_pg"), (int)System.identityHashCode((Object)this)).toString();
    }

    public Object clone() {
        Radiogroup clone = (Radiogroup)((Object)super.clone());
        Radiogroup.fixClone(clone);
        return clone;
    }

    private static void fixClone(Radiogroup clone) {
        if (clone._name.startsWith("_pg")) {
            clone._name = clone.genGroupName();
        }
        Radiogroup.rmListenerDown((Component)clone, clone._listener);
        clone.init();
        clone.afterUnmarshal();
    }

    private static void rmListenerDown(Component comp, EventListener listener) {
        Iterator it = comp.getChildren().iterator();
        while (it.hasNext()) {
            Component child = (Component)it.next();
            if (child instanceof Radio) {
                ((Radio)child).removeEventListener("onCheck", listener);
                continue;
            }
            if (child instanceof Radiogroup) continue;
            Radiogroup.rmListenerDown(child, listener);
        }
    }

    private void afterUnmarshal() {
        Radiogroup.addListenerDown((Component)this, this._listener);
    }

    private static void addListenerDown(Component comp, EventListener listener) {
        Iterator it = comp.getChildren().iterator();
        while (it.hasNext()) {
            Component child = (Component)it.next();
            if (child instanceof Radio) {
                ((Radio)child).addEventListener("onCheck", listener);
                continue;
            }
            if (child instanceof Radiogroup) continue;
            Radiogroup.addListenerDown(child, listener);
        }
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.init();
        this.afterUnmarshal();
    }

    private class Listener
    implements EventListener,
    Deferrable {
        private Listener() {
        }

        public void onEvent(Event event) {
            Events.sendEvent((Component)Radiogroup.this, (Event)event);
        }

        public boolean isDeferrable() {
            return !Events.isListened((Component)Radiogroup.this, (String)"onCheck", (boolean)true);
        }
    }
}

