/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.zkoss.lang.JVMs;
import org.zkoss.lang.Objects;
import org.zkoss.xml.HTMLs;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zul.Column;
import org.zkoss.zul.Columns;
import org.zkoss.zul.Grid;
import org.zkoss.zul.Rows;
import org.zkoss.zul.impl.Utils;
import org.zkoss.zul.impl.XulElement;

public class Row
extends XulElement {
    private Object _value;
    private String _align;
    private String _valign;
    private int[] _spans;
    private transient int _rsflags;
    private boolean _nowrap;
    private boolean _loaded;

    public Grid getGrid() {
        Component parent = this.getParent();
        return parent != null ? (Grid)parent.getParent() : null;
    }

    public String getAlign() {
        return this._align;
    }

    public void setAlign(String align) {
        if (!Objects.equals((Object)this._align, (Object)align)) {
            this._align = align;
            this.smartUpdate("align", this._align);
        }
    }

    public boolean isNowrap() {
        return this._nowrap;
    }

    public void setNowrap(boolean nowrap) {
        if (this._nowrap != nowrap) {
            this._nowrap = nowrap;
            this.smartUpdate("nowrap", this._nowrap);
        }
    }

    public String getValign() {
        return this._valign;
    }

    public void setValign(String valign) {
        if (!Objects.equals((Object)this._valign, (Object)valign)) {
            this._valign = valign;
            this.smartUpdate("valign", this._valign);
        }
    }

    public Object getValue() {
        return this._value;
    }

    public void setValue(Object value) {
        this._value = value;
    }

    public String getSpans() {
        return Utils.intsToString(this._spans);
    }

    public void setSpans(String spans) throws WrongValueException {
        int[] ispans = Utils.stringToInts(spans, 1);
        if (!Objects.equals((Object)ispans, (Object)this._spans)) {
            this._spans = ispans;
            this.invalidate();
        }
    }

    final void setLoaded(boolean loaded) {
        if (loaded != this._loaded) {
            this._loaded = loaded;
            Grid grid = this.getGrid();
            if (grid != null && grid.getModel() != null) {
                if (grid.inPagingMold()) {
                    this.smartUpdate("z.loaded", this._loaded);
                } else if (loaded) {
                    this.invalidate();
                }
            }
        }
    }

    final boolean isLoaded() {
        return this._loaded;
    }

    int getIndex() {
        int j = 0;
        Iterator it = this.getParent().getChildren().iterator();
        while (it.hasNext() && it.next() != this) {
            ++j;
        }
        return j;
    }

    protected String getRealSclass() {
        String sclx = (String)this.getParent().getAttribute("Z_STRIPE");
        return super.getRealSclass() + (sclx != null ? " " + sclx : "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getChildAttrs(int index) {
        StringBuffer sb;
        String style;
        List colchds;
        Columns cols;
        int realIndex = index;
        int span = 1;
        if (this._spans != null) {
            for (int j = 0; j < this._spans.length; ++j) {
                if (j == index) {
                    span = this._spans[j];
                    break;
                }
                realIndex += this._spans[j] - 1;
            }
        }
        String colattrs = null;
        Object wd = null;
        String hgh = null;
        Grid grid = this.getGrid();
        if (grid != null && (cols = grid.getColumns()) != null && realIndex < (colchds = cols.getChildren()).size()) {
            Column col = (Column)((Object)colchds.get(realIndex));
            colattrs = col.getColAttrs();
            hgh = col.getHeight();
        }
        this._rsflags = 7;
        try {
            style = this.getRealStyle();
        }
        finally {
            this._rsflags = 0;
        }
        if (wd != null || hgh != null) {
            sb = new StringBuffer(80).append(style);
            HTMLs.appendStyle((StringBuffer)sb, (String)"height", (String)hgh);
            style = sb.toString();
        }
        if (colattrs == null && style.length() == 0 && span == 1) {
            return " class=\"gc\"";
        }
        sb = new StringBuffer(100);
        if (colattrs != null) {
            sb.append(colattrs);
        }
        if (span != 1) {
            sb.append(" colspan=\"").append(span).append('\"');
        }
        HTMLs.appendAttribute((StringBuffer)sb, (String)"style", (String)style);
        return sb.append(" class=\"gc\"").toString();
    }

    protected int getRealStyleFlags() {
        return super.getRealStyleFlags() | this._rsflags;
    }

    public String getOuterAttrs() {
        Grid grid;
        StringBuffer sb = new StringBuffer(64).append(super.getOuterAttrs());
        String clkattrs = this.getAllOnClickAttrs(false);
        if (clkattrs != null) {
            sb.append(clkattrs);
        }
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.rid", (String)this.getGrid().getUuid());
        HTMLs.appendAttribute((StringBuffer)sb, (String)"align", (String)this._align);
        HTMLs.appendAttribute((StringBuffer)sb, (String)"valign", (String)this._valign);
        if (this._nowrap) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"nowrap", (String)"nowrap");
        }
        if ((grid = this.getGrid()) != null && grid.getModel() != null) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.loaded", (boolean)this._loaded);
            if (this.getAttribute("org.zkoss.zul.SkipSibling") != null) {
                HTMLs.appendAttribute((StringBuffer)sb, (String)"z.skipsib", (String)"true");
                this.removeAttribute("org.zkoss.zul.SkipSibling");
            }
        }
        return sb.toString();
    }

    public void setStyle(String style) {
        String s;
        if (style != null && style.length() == 0) {
            style = null;
        }
        if (!Objects.equals((Object)(s = this.getStyle()), (Object)style)) {
            super.setStyle(style);
            this.invalidate();
        }
    }

    public void setSclass(String sclass) {
        String s;
        if (sclass != null && sclass.length() == 0) {
            sclass = null;
        }
        if (!Objects.equals((Object)(s = this.getSclass()), (Object)sclass)) {
            super.setSclass(sclass);
            this.invalidate();
        }
    }

    public String getSclass() {
        String sclass = super.getSclass();
        if (sclass != null) {
            return sclass;
        }
        Grid grid = this.getGrid();
        return grid != null ? grid.getSclass() : sclass;
    }

    public void setParent(Component parent) {
        if (parent != null && !(parent instanceof Rows)) {
            throw new UiException("Unsupported parent for row: " + parent);
        }
        super.setParent(parent);
    }

    public void onDrawNewChild(Component child, StringBuffer out) throws IOException {
        StringBuffer sb = new StringBuffer(128).append("<td z.type=\"Gcl\" id=\"").append(child.getUuid()).append("!chdextr\"");
        Grid grid = this.getGrid();
        if (grid != null) {
            int j = 0;
            Iterator it = this.getChildren().iterator();
            while (it.hasNext() && child != it.next()) {
                ++j;
            }
            sb.append(this.getChildAttrs(j));
        }
        sb.append("><div id=\"").append(child.getUuid()).append("!cell\"").append(" class=\"gc cell-inner\">");
        if (JVMs.isJava5()) {
            out.insert(0, sb);
        } else {
            out.insert(0, sb.toString());
        }
        out.append("</div></td>");
    }
}

