/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import org.zkoss.lang.Objects;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zul.impl.XulElement;

public class Separator
extends XulElement {
    private String _orient = "horizontal";
    private String _spacing;
    private boolean _bar;

    public Separator() {
    }

    public Separator(String orient) {
        this.setOrient(orient);
    }

    public String getOrient() {
        return this._orient;
    }

    public void setOrient(String orient) throws WrongValueException {
        if (!"horizontal".equals(orient) && !"vertical".equals(orient)) {
            throw new WrongValueException(orient);
        }
        if (!Objects.equals((Object)this._orient, (Object)orient)) {
            this._orient = orient;
            this.smartUpdate("class", this.getSclass());
        }
    }

    public boolean isBar() {
        return this._bar;
    }

    public void setBar(boolean bar) {
        if (this._bar != bar) {
            this._bar = bar;
            this.smartUpdate("class", this.getSclass());
        }
    }

    public String getSpacing() {
        return this._spacing;
    }

    public void setSpacing(String spacing) {
        if (spacing != null && spacing.length() == 0) {
            spacing = null;
        }
        if (!Objects.equals((Object)this._spacing, (Object)spacing)) {
            this._spacing = spacing;
            this.smartUpdate("style", this.getRealStyle());
        }
    }

    protected String getRealStyle() {
        String style = super.getRealStyle();
        if (this._spacing == null) {
            return style;
        }
        StringBuffer sb = new StringBuffer(64).append("margin:");
        if ("vertical".equals(this._orient)) {
            sb.append("0 ").append(this._spacing);
        } else {
            sb.append(this._spacing).append(" 0");
        }
        return sb.append(';').append(style).toString();
    }

    public String getSclass() {
        String scls = super.getSclass();
        if (scls != null) {
            return scls;
        }
        return "vertical".equals(this.getOrient()) ? (this.isBar() ? "vsep-bar" : "vsep") : (this.isBar() ? "hsep-bar" : "hsep");
    }

    public boolean isChildable() {
        return false;
    }
}

