/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.util.Iterator;
import java.util.Set;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.ext.client.Selectable;
import org.zkoss.zul.Tabbox;
import org.zkoss.zul.Tabpanel;
import org.zkoss.zul.Tabpanels;
import org.zkoss.zul.Tabs;
import org.zkoss.zul.impl.LabelImageElement;

public class Tab
extends LabelImageElement {
    private boolean _selected;
    private boolean _closable;
    private boolean _disabled;

    public Tab() {
    }

    public Tab(String label) {
        this.setLabel(label);
    }

    public Tab(String label, String image) {
        this.setLabel(label);
        this.setImage(image);
    }

    public boolean isClosable() {
        return this._closable;
    }

    public void setClosable(boolean closable) {
        if (this._closable != closable) {
            this._closable = closable;
            this.invalidate();
        }
    }

    public void onClose() {
        Tabpanel panel;
        Tabs tabs;
        if (this._selected && (tabs = (Tabs)this.getParent()) != null) {
            Iterator it = tabs.getChildren().iterator();
            while (it.hasNext()) {
                Tab t = (Tab)((Object)it.next());
                if (t == this) continue;
                t.setSelected(true);
                break;
            }
        }
        if ((panel = this.getLinkedPanel()) != null) {
            panel.detach();
        }
        this.detach();
    }

    public Tabbox getTabbox() {
        Tabs tabs = (Tabs)this.getParent();
        return tabs != null ? tabs.getTabbox() : null;
    }

    public Tabpanel getLinkedPanel() {
        Tabpanels tabpanels;
        Tabbox tabbox;
        int j = this.getIndex();
        if (j >= 0 && (tabbox = this.getTabbox()) != null && (tabpanels = tabbox.getTabpanels()) != null && tabpanels.getChildren().size() > j) {
            return (Tabpanel)((Object)tabpanels.getChildren().get(j));
        }
        return null;
    }

    public final boolean isSelected() {
        return this._selected;
    }

    public void setSelected(boolean selected) {
        if (this._selected != selected) {
            Tabbox tabbox = this.getTabbox();
            if (tabbox != null) {
                tabbox.setSelectedTab(this);
            } else {
                this._selected = selected;
                this.invalidate();
            }
        }
    }

    public final boolean isDisabled() {
        return this._disabled;
    }

    public void setDisabled(boolean disabled) {
        if (this._disabled != disabled) {
            this._disabled = disabled;
            this.smartUpdate("z.disabled", this._disabled);
        }
    }

    void setSelectedDirectly(boolean selected) {
        this._selected = selected;
    }

    public int getIndex() {
        Tabs tabs = (Tabs)this.getParent();
        if (tabs == null) {
            return -1;
        }
        int j = 0;
        Iterator it = tabs.getChildren().iterator();
        while (it.next() != this) {
            ++j;
        }
        return j;
    }

    public String getOuterAttrs() {
        StringBuffer sb = new StringBuffer(64).append(super.getOuterAttrs());
        this.appendAsapAttr(sb, "onSelect");
        String clkattrs = this.getAllOnClickAttrs(false);
        if (clkattrs != null) {
            sb.append(clkattrs);
        }
        return sb.toString();
    }

    public String getSclass() {
        String scls = super.getSclass();
        if (scls == null) {
            scls = "tab";
        }
        if (this.isDisabled()) {
            scls = scls + "dis";
        }
        return this.isSelected() ? scls + "sel" : scls;
    }

    public void invalidate() {
        Tabbox tabbox = this.getTabbox();
        if (tabbox != null && "accordion".equals(tabbox.getMold())) {
            tabbox.invalidate();
        } else {
            super.invalidate();
        }
    }

    public boolean isChildable() {
        return false;
    }

    public void setParent(Component parent) {
        if (parent != null && !(parent instanceof Tabs)) {
            throw new UiException("Wrong parent: " + parent);
        }
        super.setParent(parent);
    }

    protected Object newExtraCtrl() {
        return new ExtraCtrl();
    }

    protected class ExtraCtrl
    extends LabelImageElement.ExtraCtrl
    implements Selectable {
        protected ExtraCtrl() {
            super(Tab.this);
        }

        public void selectItemsByClient(Set selItems) {
            if (selItems == null || selItems.size() != 1) {
                throw new UiException("Exactly one selected tab is required: " + selItems);
            }
            Tabbox tabbox = Tab.this.getTabbox();
            if (tabbox != null) {
                tabbox.selectTabDirectly((Tab)((Object)selItems.iterator().next()), true);
            }
        }
    }
}

