/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.util.Iterator;
import org.zkoss.lang.Objects;
import org.zkoss.xml.HTMLs;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zul.Tab;
import org.zkoss.zul.Tabbox;
import org.zkoss.zul.impl.XulElement;

public class Tabs
extends XulElement {
    private String _align = "start";

    public Tabbox getTabbox() {
        return (Tabbox)this.getParent();
    }

    public String getAlign() {
        return this._align;
    }

    public void setAlign(String align) throws WrongValueException {
        if (!("start".equals(align) || "center".equals(align) || "end".equals(align))) {
            throw new WrongValueException(align);
        }
        if (!Objects.equals((Object)this._align, (Object)align)) {
            this._align = align;
            Tabbox tabbox = this.getTabbox();
            if (!tabbox.inAccordionMold()) {
                this.invalidate();
            }
        }
    }

    public void setParent(Component parent) {
        if (parent != null && !(parent instanceof Tabbox)) {
            throw new UiException("Wrong parent: " + parent);
        }
        Tabbox oldp = (Tabbox)this.getParent();
        super.setParent(parent);
        Tabs.invalidateIfAccordion(oldp);
        Tabs.invalidateIfAccordion((Tabbox)parent);
    }

    public boolean insertBefore(Component child, Component insertBefore) {
        if (!(child instanceof Tab)) {
            throw new UiException("Unsupported child for tabs: " + child);
        }
        boolean sel = this.getChildren().isEmpty();
        boolean desel = false;
        Tab newtab = (Tab)child;
        if (!sel && newtab.isSelected()) {
            newtab.setSelectedDirectly(false);
            desel = true;
            sel = true;
        }
        if (super.insertBefore(child, insertBefore)) {
            Tabbox tabbox = this.getTabbox();
            if (sel) {
                if (tabbox != null) {
                    tabbox.setSelectedTab(newtab);
                } else {
                    newtab.setSelectedDirectly(true);
                    if (desel) {
                        Iterator it = this.getChildren().iterator();
                        while (it.hasNext()) {
                            Tab tab = (Tab)((Object)it.next());
                            if (tab == newtab || !tab.isSelected()) continue;
                            tab.setSelectedDirectly(false);
                            break;
                        }
                    }
                }
            }
            Tabs.invalidateIfAccordion(tabbox);
            return true;
        }
        return false;
    }

    public void onChildRemoved(Component child) {
        super.onChildRemoved(child);
        Tabbox tabbox = this.getTabbox();
        if (tabbox != null) {
            ((Tab)child).removeEventListener("onSelect", tabbox._listener);
        }
        if (tabbox == null || !tabbox.inAccordionMold()) {
            this.smartUpdate("z.init", true);
        }
    }

    public void onChildAdded(Component child) {
        super.onChildAdded(child);
        Tabbox tabbox = this.getTabbox();
        if (tabbox != null) {
            ((Tab)child).addEventListener("onSelect", tabbox._listener);
        }
        if (tabbox == null || !tabbox.inAccordionMold()) {
            this.smartUpdate("z.init", true);
        }
    }

    private static void invalidateIfAccordion(Tabbox tabbox) {
        if (tabbox != null && tabbox.inAccordionMold()) {
            tabbox.invalidate();
        }
    }

    public String getOuterAttrs() {
        Tabbox tabbox = this.getTabbox();
        if (!tabbox.inAccordionMold()) {
            StringBuffer sb = new StringBuffer(64).append(super.getOuterAttrs());
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.align", (String)this.getAlign().substring(0, 1));
            return sb.toString();
        }
        return super.getOuterAttrs();
    }
}

