/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import org.zkoss.xml.HTMLs;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zul.impl.InputElement;

public class Textbox
extends InputElement {
    private String _type = "text";
    private int _rows = 1;
    private boolean _multiline;

    public Textbox() {
    }

    public Textbox(String value) throws WrongValueException {
        this.setValue(value);
    }

    public String getValue() throws WrongValueException {
        return this.getText();
    }

    public void setValue(String value) throws WrongValueException {
        this.setText(value);
    }

    protected Object coerceFromString(String value) throws WrongValueException {
        return value != null ? value : "";
    }

    protected String coerceToString(Object value) {
        return value != null ? (String)value : "";
    }

    public String getType() {
        return this._type;
    }

    public void setType(String type) throws WrongValueException {
        if (!"text".equals(type) && !"password".equals(type)) {
            throw new WrongValueException("Illegal type: " + type);
        }
        if (!this._type.equals(type)) {
            this._type = type;
            this.invalidate();
        }
    }

    public int getRows() {
        return this._rows;
    }

    public void setRows(int rows) throws WrongValueException {
        if (rows <= 0) {
            throw new WrongValueException("Illegal rows: " + rows);
        }
        if (this._rows != rows) {
            this._rows = rows;
            if (this._rows > 1) {
                this.setMultiline(true);
            }
            this.smartUpdate("rows", Integer.toString(this._rows));
        }
    }

    public boolean isMultiline() {
        return this._multiline;
    }

    public void setMultiline(boolean multiline) {
        if (this._multiline != multiline) {
            this._multiline = multiline;
            this.invalidate();
        }
    }

    public String getInnerAttrs() {
        String attrs = super.getInnerAttrs();
        if (!this._multiline) {
            return attrs;
        }
        StringBuffer sb = new StringBuffer(64).append(attrs);
        HTMLs.appendAttribute((StringBuffer)sb, (String)"rows", (int)this._rows);
        return sb.toString();
    }

    public String getOuterAttrs() {
        String attrs = super.getOuterAttrs();
        return this._multiline ? attrs + " z.skipOK=\"true\"" : attrs;
    }
}

