/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.zkoss.lang.Objects;
import org.zkoss.util.Locales;
import org.zkoss.util.TimeZones;
import org.zkoss.xml.HTMLs;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zul.impl.InputElement;
import org.zkoss.zul.mesg.MZul;

public class Timebox
extends InputElement {
    private static final String DEFAULT_IMAGE = "~./zul/img/updnbtn.gif";
    private String _img;
    private TimeZone _tzone;
    private boolean _btnVisible = true;

    public Timebox() {
        this.setCols(5);
        this.setMaxlength(5);
    }

    public Timebox(Date date) throws WrongValueException {
        this();
        this.setValue(date);
    }

    public Date getValue() throws WrongValueException {
        return (Date)this.getTargetValue();
    }

    public void setValue(Date value) throws WrongValueException {
        this.validate(value);
        this.setRawValue(value);
    }

    public boolean isButtonVisible() {
        return this._btnVisible;
    }

    public void setButtonVisible(boolean visible) {
        if (this._btnVisible != visible) {
            this._btnVisible = visible;
            this.smartUpdate("z.btnVisi", visible);
        }
    }

    public String getImage() {
        return this._img != null ? this._img : DEFAULT_IMAGE;
    }

    public void setImage(String img) {
        if (img != null && (img.length() == 0 || DEFAULT_IMAGE.equals(img))) {
            img = null;
        }
        if (!Objects.equals((Object)this._img, (Object)img)) {
            this._img = img;
            this.invalidate();
        }
    }

    public String getInnerAttrs() {
        String attrs = super.getInnerAttrs();
        String style = this.getInnerStyle();
        return style.length() > 0 ? attrs + " style=\"" + style + '\"' : attrs;
    }

    private String getInnerStyle() {
        StringBuffer sb = new StringBuffer(32).append(HTMLs.getTextRelevantStyle((String)this.getRealStyle()));
        HTMLs.appendStyle((StringBuffer)sb, (String)"width", (String)this.getWidth());
        HTMLs.appendStyle((StringBuffer)sb, (String)"height", (String)this.getHeight());
        return sb.toString();
    }

    public TimeZone getTimeZone() {
        return this._tzone;
    }

    public void setTimeZone(TimeZone tzone) {
        this._tzone = tzone;
    }

    protected Object coerceFromString(String value) throws WrongValueException {
        Date date;
        if (value == null || value.length() == 0) {
            return null;
        }
        DateFormat df = this.getDateFormat();
        try {
            date = df.parse(value);
        }
        catch (ParseException ex) {
            throw this.showCustomError(new WrongValueException((Component)this, MZul.DATE_REQUIRED, new Object[]{value, "HH:mm"}));
        }
        return date;
    }

    protected String coerceToString(Object value) {
        if (value == null) {
            return "";
        }
        DateFormat df = this.getDateFormat();
        return value != null ? df.format((Date)value) : "";
    }

    protected DateFormat getDateFormat() {
        String fmt = "HH:mm";
        SimpleDateFormat df = new SimpleDateFormat(fmt, Locales.getCurrent());
        TimeZone tz = this._tzone != null ? this._tzone : TimeZones.getCurrent();
        df.setTimeZone(tz);
        return df;
    }
}

