/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import org.zkoss.xml.HTMLs;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.WrongValueException;

public class Timer
extends HtmlBasedComponent {
    private int _delay;
    private boolean _repeats;
    private boolean _running = true;

    public Timer() {
        super.setVisible(false);
    }

    public Timer(int delay) {
        this();
        this._delay = delay;
    }

    public int getDelay() {
        return this._delay;
    }

    public void setDelay(int delay) throws WrongValueException {
        if (delay < 0) {
            throw new WrongValueException("Negative delay is not allowed: " + delay);
        }
        if (delay != this._delay) {
            this._delay = delay;
            this.smartUpdate("z.delay", Integer.toString(this._delay));
            if (this._running) {
                this.smartUpdate("z.init", true);
            }
        }
    }

    public boolean isRepeats() {
        return this._repeats;
    }

    public void setRepeats(boolean repeats) {
        if (this._repeats != repeats) {
            this._repeats = repeats;
            this.smartUpdate("z.repeats", Boolean.toString(this._repeats));
            if (this._running) {
                this.smartUpdate("z.init", true);
            }
        }
    }

    public boolean isRunning() {
        return this._running;
    }

    public void setRunning(boolean running) {
        if (running) {
            this.start();
        } else {
            this.stop();
        }
    }

    public void stop() {
        if (this._running) {
            this._running = false;
            this.smartUpdate("z.running", false);
        }
    }

    public void start() {
        if (!this._running) {
            this._running = true;
            this.smartUpdate("z.running", true);
        }
    }

    public String getOuterAttrs() {
        StringBuffer sb = new StringBuffer(64).append(super.getOuterAttrs());
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.delay", (int)this._delay);
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.repeats", (boolean)this._repeats);
        if (!this._running) {
            sb.append(" z.running=\"false\"");
        }
        return sb.toString();
    }

    public boolean setVisible(boolean visible) {
        throw new UnsupportedOperationException("timer is always invisible");
    }

    public boolean isChildable() {
        return false;
    }

    protected Object newExtraCtrl() {
        return new ExtraCtrl();
    }

    protected class ExtraCtrl
    extends HtmlBasedComponent.ExtraCtrl
    implements org.zkoss.zk.ui.ext.client.Timer {
        protected ExtraCtrl() {
            super((HtmlBasedComponent)Timer.this);
        }

        public void onTimer() {
            if (!Timer.this._repeats) {
                Timer.this.stop();
            }
        }
    }
}

