/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.zkoss.lang.Exceptions;
import org.zkoss.lang.Objects;
import org.zkoss.util.logging.Log;
import org.zkoss.xml.HTMLs;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.ext.client.InnerWidth;
import org.zkoss.zk.ui.ext.client.Selectable;
import org.zkoss.zul.Auxhead;
import org.zkoss.zul.RendererCtrl;
import org.zkoss.zul.TreeModel;
import org.zkoss.zul.Treecell;
import org.zkoss.zul.Treechildren;
import org.zkoss.zul.Treecols;
import org.zkoss.zul.Treefoot;
import org.zkoss.zul.Treeitem;
import org.zkoss.zul.TreeitemRenderer;
import org.zkoss.zul.Treerow;
import org.zkoss.zul.event.TreeDataEvent;
import org.zkoss.zul.event.TreeDataListener;
import org.zkoss.zul.impl.XulElement;

public class Tree
extends XulElement {
    private transient Treecols _treecols;
    private transient Treefoot _treefoot;
    private transient Treechildren _treechildren;
    private transient Set _selItems;
    private transient Treeitem _sel;
    private transient Collection _heads;
    private int _rows = 0;
    private String _name;
    private String _iconScls = "tree";
    private int _pgsz = 10;
    private boolean _multiple;
    private boolean _checkmark;
    private boolean _vflex;
    private transient boolean _noSmartUpdate;
    private String _innerWidth = "100%";
    private static final Log log;
    private TreeModel _model;
    private TreeitemRenderer _renderer;
    private TreeDataListener _dataListener;
    private static final TreeitemRenderer _defRend;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Tree() {
        this.init();
        this.setSclass("tree");
    }

    private void init() {
        this._selItems = new LinkedHashSet(5);
        this._heads = new AbstractCollection(){

            public int size() {
                int sz = Tree.this.getChildren().size();
                if (Tree.this._treechildren != null) {
                    --sz;
                }
                if (Tree.this._treefoot != null) {
                    --sz;
                }
                return sz;
            }

            public Iterator iterator() {
                return new Iter();
            }
        };
    }

    public Treecols getTreecols() {
        return this._treecols;
    }

    public Treefoot getTreefoot() {
        return this._treefoot;
    }

    public Treechildren getTreechildren() {
        return this._treechildren;
    }

    public Collection getHeads() {
        return this._heads;
    }

    public int getRows() {
        return this._rows;
    }

    public void setRows(int rows) throws WrongValueException {
        if (rows < 0) {
            throw new WrongValueException("Illegal rows: " + rows);
        }
        if (this._rows != rows) {
            this._rows = rows;
            this.smartUpdate("z.size", Integer.toString(this._rows));
        }
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        if (name != null && name.length() == 0) {
            name = null;
        }
        if (!Objects.equals((Object)this._name, (Object)name)) {
            this._name = name;
            if (this._name != null) {
                this.smartUpdate("z.name", this._name);
            } else {
                this.invalidate();
            }
        }
    }

    public final boolean isCheckmark() {
        return this._checkmark;
    }

    public void setCheckmark(boolean checkmark) {
        if (this._checkmark != checkmark) {
            this._checkmark = checkmark;
            this.invalidate();
        }
    }

    public final boolean isVflex() {
        return this._vflex;
    }

    public void setVflex(boolean vflex) {
        if (this._vflex != vflex) {
            this._vflex = vflex;
            this.smartUpdate("z.flex", this._vflex);
        }
    }

    public void setInnerWidth(String innerWidth) {
        if (innerWidth == null) {
            innerWidth = "100%";
        }
        if (!this._innerWidth.equals(innerWidth)) {
            this._innerWidth = innerWidth;
            this.smartUpdate("z.innerWidth", innerWidth);
        }
    }

    public String getInnerWidth() {
        return this._innerWidth;
    }

    public String getSeltype() {
        return this._multiple ? "multiple" : "single";
    }

    public void setSeltype(String seltype) throws WrongValueException {
        if ("single".equals(seltype)) {
            this.setMultiple(false);
        } else if ("multiple".equals(seltype)) {
            this.setMultiple(true);
        } else {
            throw new WrongValueException("Unknown seltype: " + seltype);
        }
    }

    public boolean isMultiple() {
        return this._multiple;
    }

    public void setMultiple(boolean multiple) {
        if (this._multiple != multiple) {
            this._multiple = multiple;
            if (!this._multiple && this._selItems.size() > 1) {
                Treeitem item = this.getSelectedItem();
                Iterator it = this._selItems.iterator();
                while (it.hasNext()) {
                    Treeitem ti = (Treeitem)((Object)it.next());
                    if (ti == item) continue;
                    ti.setSelectedDirectly(false);
                    it.remove();
                }
            }
            if (this.isCheckmark()) {
                this.invalidate();
            } else {
                this.smartUpdate("z.multiple", this._multiple);
            }
        }
    }

    private String getSelectedId() {
        Treerow tr = this._sel != null ? this._sel.getTreerow() : null;
        return tr != null ? tr.getUuid() : "zk_n_a";
    }

    public Collection getItems() {
        return this._treechildren != null ? this._treechildren.getItems() : Collections.EMPTY_LIST;
    }

    public int getItemCount() {
        return this._treechildren != null ? this._treechildren.getItemCount() : 0;
    }

    public void selectItem(Treeitem item) {
        if (item == null) {
            this.clearSelection();
        } else {
            if (item.getTree() != this) {
                throw new UiException("Not a child: " + (Object)((Object)item));
            }
            if (this._sel != item || this._multiple && this._selItems.size() > 1) {
                Iterator it = this._selItems.iterator();
                while (it.hasNext()) {
                    Treeitem ti = (Treeitem)((Object)it.next());
                    ti.setSelectedDirectly(false);
                }
                this._selItems.clear();
                this._sel = item;
                item.setSelectedDirectly(true);
                this._selItems.add(item);
                Treerow tr = item.getTreerow();
                if (tr != null) {
                    this.smartUpdate("select", tr.getUuid());
                }
            }
        }
    }

    public void addItemToSelection(Treeitem item) {
        if (item.getTree() != this) {
            throw new UiException("Not a child: " + (Object)((Object)item));
        }
        if (!item.isSelected()) {
            if (!this._multiple) {
                this.selectItem(item);
            } else {
                item.setSelectedDirectly(true);
                this._selItems.add(item);
                this.smartUpdateSelection();
                if (this.fixSelected()) {
                    this.smartUpdate("z.selId", this.getSelectedId());
                }
            }
        }
    }

    public void removeItemFromSelection(Treeitem item) {
        if (item.getTree() != this) {
            throw new UiException("Not a child: " + (Object)((Object)item));
        }
        if (item.isSelected()) {
            if (!this._multiple) {
                this.clearSelection();
            } else {
                item.setSelectedDirectly(false);
                this._selItems.remove((Object)item);
                this.smartUpdateSelection();
                if (this.fixSelected()) {
                    this.smartUpdate("z.selId", this.getSelectedId());
                }
            }
        }
    }

    private void smartUpdateSelection() {
        StringBuffer sb = new StringBuffer(80);
        Iterator it = this._selItems.iterator();
        while (it.hasNext()) {
            Treeitem item = (Treeitem)((Object)it.next());
            Treerow tr = item.getTreerow();
            if (tr == null) continue;
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(tr.getUuid());
        }
        this.smartUpdate("chgSel", sb.toString());
    }

    public void toggleItemSelection(Treeitem item) {
        if (item.isSelected()) {
            this.removeItemFromSelection(item);
        } else {
            this.addItemToSelection(item);
        }
    }

    public void clearSelection() {
        if (!this._selItems.isEmpty()) {
            Iterator it = this._selItems.iterator();
            while (it.hasNext()) {
                Treeitem item = (Treeitem)((Object)it.next());
                item.setSelectedDirectly(false);
            }
            this._selItems.clear();
            this._sel = null;
            this.smartUpdate("select", "");
        }
    }

    public void selectAll() {
        if (!this._multiple) {
            throw new UiException("Appliable only to the multiple seltype: " + (Object)((Object)this));
        }
        boolean changed = false;
        boolean first = true;
        Iterator it = this.getItems().iterator();
        while (it.hasNext()) {
            Treeitem item = (Treeitem)((Object)it.next());
            if (!item.isSelected()) {
                this._selItems.add(item);
                item.setSelectedDirectly(true);
                changed = true;
            }
            if (!first) continue;
            this._sel = item;
            first = false;
        }
        this.smartUpdate("selectAll", "true");
    }

    public Treeitem getSelectedItem() {
        return this._sel;
    }

    public void setSelectedItem(Treeitem item) {
        this.selectItem(item);
    }

    public Set getSelectedItems() {
        return Collections.unmodifiableSet(this._selItems);
    }

    public int getSelectedCount() {
        return this._selItems.size();
    }

    public void clear() {
        if (this._treechildren == null) {
            return;
        }
        List l = this._treechildren.getChildren();
        if (l.isEmpty()) {
            return;
        }
        Iterator it = new ArrayList(l).iterator();
        while (it.hasNext()) {
            ((Component)it.next()).detach();
        }
    }

    public int getPageSize() {
        return this._pgsz;
    }

    public void setPageSize(int size) throws WrongValueException {
        if (size <= 0) {
            size = -1;
        }
        if (this._pgsz != size) {
            this._pgsz = size;
            Tree.updateActivePageChildren(this._treechildren);
            this.invalidate();
        }
    }

    private static void updateActivePageChildren(Treechildren tc) {
        if (tc != null) {
            if (tc.getPageSizeDirectly() == 0) {
                int pgcnt = tc.getPageCount();
                if (tc.getActivePage() >= pgcnt) {
                    tc.setActivePageDirectly(pgcnt - 1);
                }
            }
            Iterator it = tc.getChildren().iterator();
            while (it.hasNext()) {
                Treeitem ti = (Treeitem)((Object)it.next());
                Tree.updateActivePageChildren(ti.getTreechildren());
            }
        }
    }

    public String getIconSclass() {
        return this._iconScls;
    }

    public void setIconSclass(String scls) {
        if (!Objects.equals((Object)this._iconScls, (Object)scls)) {
            this._iconScls = scls;
            this.invalidate();
        }
    }

    public void smartUpdate(String attr, String value) {
        if (!this._noSmartUpdate) {
            super.smartUpdate(attr, value);
        }
    }

    public boolean insertBefore(Component newChild, Component refChild) {
        if (newChild instanceof Treecols) {
            if (this._treecols != null && this._treecols != newChild) {
                throw new UiException("Only one treecols is allowed: " + (Object)((Object)this));
            }
            this._treecols = (Treecols)newChild;
        } else if (newChild instanceof Treefoot) {
            if (this._treefoot != null && this._treefoot != newChild) {
                throw new UiException("Only one treefoot is allowed: " + (Object)((Object)this));
            }
            this._treefoot = (Treefoot)newChild;
        } else if (newChild instanceof Treechildren) {
            if (this._treechildren != null && this._treechildren != newChild) {
                throw new UiException("Only one treechildren is allowed: " + (Object)((Object)this));
            }
            this._treechildren = (Treechildren)newChild;
            this.fixSelectedSet();
        } else if (!(newChild instanceof Auxhead)) {
            throw new UiException("Unsupported newChild: " + newChild);
        }
        if (super.insertBefore(newChild, refChild)) {
            if (!(newChild instanceof Auxhead)) {
                this.invalidate();
            }
            return true;
        }
        return false;
    }

    void onTreeitemAdded(Treeitem item) {
        this.fixNewChild(item);
        this.onTreechildrenAdded(item.getTreechildren());
    }

    void onTreeitemRemoved(Treeitem item) {
        boolean fixSel = false;
        if (item.isSelected()) {
            this._selItems.remove((Object)item);
            boolean bl = fixSel = this._sel == item;
            if (fixSel && !this._multiple) {
                this._sel = null;
                this.smartUpdate("z.selId", this.getSelectedId());
                if (!$assertionsDisabled && !this._selItems.isEmpty()) {
                    throw new AssertionError();
                }
            }
        }
        this.onTreechildrenRemoved(item.getTreechildren());
        if (fixSel) {
            this.fixSelected();
        }
    }

    void onTreechildrenAdded(Treechildren tchs) {
        if (tchs == null || tchs.getParent() == this) {
            return;
        }
        Iterator it = tchs.getItems().iterator();
        while (it.hasNext()) {
            this.fixNewChild((Treeitem)((Object)it.next()));
        }
    }

    private void fixNewChild(Treeitem item) {
        if (item.isSelected()) {
            if (this._sel != null && !this._multiple) {
                item.setSelectedDirectly(false);
                item.invalidate();
            } else {
                if (this._sel == null) {
                    this._sel = item;
                }
                this._selItems.add(item);
                this.smartUpdate("z.selId", this.getSelectedId());
            }
        }
    }

    void onTreechildrenRemoved(Treechildren tchs) {
        if (tchs == null || tchs.getParent() == this) {
            return;
        }
        boolean fixSel = false;
        Iterator it = tchs.getItems().iterator();
        while (it.hasNext()) {
            Treeitem item = (Treeitem)((Object)it.next());
            if (!item.isSelected()) continue;
            this._selItems.remove((Object)item);
            if (this._sel != item) continue;
            if (!this._multiple) {
                this._sel = null;
                this.smartUpdate("z.selId", this.getSelectedId());
                if (!$assertionsDisabled && !this._selItems.isEmpty()) {
                    throw new AssertionError();
                }
                return;
            }
            fixSel = true;
        }
        if (fixSel) {
            this.fixSelected();
        }
    }

    public void onChildAdded(Component child) {
        super.onChildAdded(child);
        this.invalidate();
    }

    public void onChildRemoved(Component child) {
        if (child instanceof Treecols) {
            this._treecols = null;
        } else if (child instanceof Treefoot) {
            this._treefoot = null;
        } else if (child instanceof Treechildren) {
            this._treechildren = null;
            this._selItems.clear();
            this._sel = null;
        }
        super.onChildRemoved(child);
        this.invalidate();
    }

    private void fixSelectedSet() {
        this._sel = null;
        this._selItems.clear();
        Iterator it = this.getItems().iterator();
        while (it.hasNext()) {
            Treeitem item = (Treeitem)((Object)it.next());
            if (!item.isSelected()) continue;
            if (this._sel == null) {
                this._sel = item;
            } else if (!this._multiple) {
                item.setSelectedDirectly(false);
                continue;
            }
            this._selItems.add(item);
        }
    }

    private boolean fixSelected() {
        Treeitem sel = null;
        block0 : switch (this._selItems.size()) {
            case 1: {
                sel = (Treeitem)((Object)this._selItems.iterator().next());
            }
            case 0: {
                break;
            }
            default: {
                Iterator it = this.getItems().iterator();
                while (it.hasNext()) {
                    Treeitem item = (Treeitem)((Object)it.next());
                    if (!item.isSelected()) continue;
                    sel = item;
                    break block0;
                }
                break block0;
            }
        }
        if (sel != this._sel) {
            this._sel = sel;
            return true;
        }
        return false;
    }

    public String getOuterAttrs() {
        StringBuffer sb = new StringBuffer(64).append(super.getOuterAttrs());
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.name", (String)this._name);
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.size", (int)this.getRows());
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.selId", (String)this.getSelectedId());
        if (this._multiple) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.multiple", (boolean)true);
        }
        if (this._vflex) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.vflex", (boolean)true);
        }
        this.appendAsapAttr(sb, "onSelect");
        Treechildren tc = this.getTreechildren();
        if (tc != null) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.tchsib", (String)tc.getUuid());
            int pgcnt = tc.getPageCount();
            if (pgcnt > 1) {
                HTMLs.appendAttribute((StringBuffer)sb, (String)"z.pgc", (int)pgcnt);
                HTMLs.appendAttribute((StringBuffer)sb, (String)"z.pgi", (int)tc.getActivePage());
                HTMLs.appendAttribute((StringBuffer)sb, (String)"z.pgsz", (int)tc.getPageSize());
            }
        }
        return sb.toString();
    }

    public Object clone() {
        int cntSel = this._selItems.size();
        Tree clone = (Tree)((Object)super.clone());
        clone.init();
        int cnt = 0;
        if (this._treecols != null) {
            ++cnt;
        }
        if (this._treefoot != null) {
            ++cnt;
        }
        if (this._treechildren != null) {
            ++cnt;
        }
        if (cnt > 0 || cntSel > 0) {
            clone.afterUnmarshal(cnt, cntSel);
        }
        return clone;
    }

    private void afterUnmarshal(int cnt, int cntSel) {
        Iterator it;
        if (cnt != 0) {
            it = this.getChildren().iterator();
            while (it.hasNext()) {
                Object child = it.next();
                if (child instanceof Treecols) {
                    this._treecols = (Treecols)((Object)child);
                    if (--cnt != 0) continue;
                    break;
                }
                if (child instanceof Treefoot) {
                    this._treefoot = (Treefoot)((Object)child);
                    if (--cnt != 0) continue;
                    break;
                }
                if (!(child instanceof Treechildren)) continue;
                this._treechildren = (Treechildren)child;
                if (--cnt != 0) continue;
                break;
            }
        }
        this._sel = null;
        this._selItems.clear();
        if (cntSel != 0) {
            it = this.getItems().iterator();
            while (it.hasNext()) {
                Treeitem ti = (Treeitem)((Object)it.next());
                if (!ti.isSelected()) continue;
                if (this._sel == null) {
                    this._sel = ti;
                }
                this._selItems.add(ti);
                if (--cntSel != 0) continue;
                break;
            }
        }
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.init();
        this.afterUnmarshal(-1, -1);
    }

    protected Object newExtraCtrl() {
        return new ExtraCtrl();
    }

    private void onTreeDataChange(TreeDataEvent event) {
        Object data = event.getParent();
        Component parent = this.getChildByNode(data);
        int indexFrom = event.getIndexFrom();
        int indexTo = event.getIndexTo();
        switch (event.getType()) {
            case 1: {
                for (int i = indexFrom; i <= indexTo; ++i) {
                    this.onTreeDataInsert(parent, data, i);
                }
                break;
            }
            case 2: {
                for (int i = indexTo; i >= indexFrom; --i) {
                    this.onTreeDataRemoved(parent, data, i);
                }
                break;
            }
            case 0: {
                for (int i = indexFrom; i <= indexTo; ++i) {
                    this.onTreeDataContentChanged(parent, data, i);
                }
                break;
            }
        }
    }

    private Treechildren getParentTreechildren(Object parent) {
        Treechildren ch = parent instanceof Tree ? ((Tree)((Object)parent)).getTreechildren() : ((Treeitem)((Object)parent)).getTreechildren();
        return ch != null ? ch : new Treechildren();
    }

    private void onTreeDataInsert(Component parent, Object node, int index) {
        Treeitem newTi = new Treeitem();
        Treechildren ch = this.getParentTreechildren(parent);
        this.renderItem(newTi, this._model.getChild(node, index));
        List siblings = ch.getChildren();
        if (siblings.size() == 0 || index == siblings.size()) {
            ch.insertBefore((Component)newTi, null);
        } else {
            ch.insertBefore((Component)newTi, (Component)((Treeitem)((Object)siblings.get(index))));
        }
        ch.setParent(parent);
        if (parent instanceof Treeitem) {
            ((Treeitem)parent).setOpen(true);
        }
    }

    private void onTreeDataRemoved(Component parent, Object node, int index) {
        List items = this.getParentTreechildren(parent).getChildren();
        if (items.size() > 1) {
            ((Treeitem)((Object)items.get(index))).detach();
        } else {
            this.getParentTreechildren(parent).detach();
        }
        if (parent instanceof Treeitem) {
            ((Treeitem)parent).setOpen(true);
        }
    }

    private void onTreeDataContentChanged(Component parent, Object node, int index) {
        List items = this.getParentTreechildren(parent).getChildren();
        if (parent instanceof Tree) {
            this.renderTree();
        } else {
            Treeitem ti = (Treeitem)((Object)items.get(index));
            ti.setLoaded(false);
            this.renderItem(ti, this._model.getChild(node, index));
            ti.setOpen(true);
        }
    }

    protected Component getChildByNode(Object node) {
        int[] path = this._model.getPath(this._model.getRoot(), node);
        if (path == null || path.length == 0) {
            return this;
        }
        Treeitem ti = (Treeitem)((Object)this.getTreechildren().getChildren().get(path[0]));
        for (int i = 1; i < path.length; ++i) {
            ti = (Treeitem)((Object)ti.getTreechildren().getChildren().get(path[i]));
        }
        return ti;
    }

    private void initDataListener() {
        if (this._dataListener == null) {
            this._dataListener = new TreeDataListener(){

                public void onChange(TreeDataEvent event) {
                    Tree.this.onTreeDataChange(event);
                }
            };
        }
        this._model.addTreeDataListener(this._dataListener);
    }

    public void setModel(TreeModel model) throws Exception {
        this._model = model;
        this.syncModel();
        this.initDataListener();
    }

    public TreeModel getModel() {
        return this._model;
    }

    private void syncModel() throws Exception {
        if (this._renderer == null) {
            this._renderer = this.getRealRenderer();
        }
        this.renderTree();
    }

    public void setTreeitemRenderer(TreeitemRenderer renderer) {
        this._renderer = renderer;
    }

    public TreeitemRenderer getTreeitemRenderer() {
        return this._renderer;
    }

    private void renderTree() {
        if (this._treechildren != null) {
            this._treechildren = null;
        }
        Treechildren children = new Treechildren();
        children.setParent((Component)this);
        Object node = this._model.getRoot();
        int childCount = this._model.getChildCount(node);
        for (int i = 0; i < childCount; ++i) {
            this.renderTreeChild(node, i);
        }
    }

    private void renderTreeChild(Object node, int index) {
        Treeitem ti = new Treeitem();
        Object data = this._model.getChild(node, index);
        try {
            this._renderer.render(ti, data);
        }
        catch (Throwable ex) {
            try {
                ti.setLabel(Exceptions.getMessage((Throwable)ex));
            }
            catch (Throwable t) {
                log.error(t);
            }
            ti.setOpen(true);
        }
        if (!this._model.isLeaf(data)) {
            Treechildren ch = new Treechildren();
            ch.setParent((Component)ti);
        }
        ti.setParent((Component)this._treechildren);
    }

    private static final TreeitemRenderer getDefaultItemRenderer() {
        return _defRend;
    }

    private TreeitemRenderer getRealRenderer() {
        return this._renderer != null ? this._renderer : Tree.getDefaultItemRenderer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderItem(Treeitem item) {
        if (this._model == null) {
            return;
        }
        Renderer renderer = new Renderer();
        try {
            this.renderItem(item, this.getAssociatedNode(item, this));
        }
        catch (Throwable ex) {
            renderer.doCatch(ex);
        }
        finally {
            renderer.doFinally();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderItem(Treeitem item, Object data) {
        if (this._model == null) {
            return;
        }
        Renderer renderer = new Renderer();
        try {
            this.dfRenderItem(data, item);
        }
        catch (Throwable ex) {
            renderer.doCatch(ex);
        }
        finally {
            renderer.doFinally();
        }
    }

    private void dfRenderItem(Object node, Treeitem item) throws Exception {
        if (!item.isLoaded()) {
            Treechildren children = null;
            if (item.getTreechildren() != null) {
                children = item.getTreechildren();
                if (children.getItemCount() > 0) {
                    children.getChildren().clear();
                }
            } else {
                children = new Treechildren();
                this._renderer.render(item, node);
            }
            if (this._model.isLeaf(node)) {
                this._renderer.render(item, node);
                if (item.getTreechildren() != null) {
                    item.getTreechildren().detach();
                }
            } else {
                for (int i = 0; i < this._model.getChildCount(node); ++i) {
                    Treeitem ti = new Treeitem();
                    Object data = this._model.getChild(node, i);
                    this._renderer.render(ti, data);
                    if (!this._model.isLeaf(data)) {
                        Treechildren ch = new Treechildren();
                        ch.setParent((Component)ti);
                    }
                    ti.setParent((Component)children);
                }
                children.setParent((Component)item);
            }
            item.setLoaded(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderItems(Set items) {
        if (this._model == null) {
            return;
        }
        if (items.isEmpty()) {
            return;
        }
        Renderer renderer = new Renderer();
        try {
            Iterator it = items.iterator();
            while (it.hasNext()) {
                Treeitem item = (Treeitem)((Object)it.next());
                Object data = this.getAssociatedNode(item, this);
                this.dfRenderItem(data, item);
            }
        }
        catch (Throwable ex) {
            renderer.doCatch(ex);
        }
        finally {
            renderer.doFinally();
        }
    }

    protected Object getAssociatedNode(Treeitem ti, Tree t) {
        return this.getNodeByPath(this.getTreeitemPath((Component)t, (Component)ti), this._model.getRoot());
    }

    private List getTreeitemPath(Component root, Component lastNode) {
        ArrayList<Integer> al = new ArrayList<Integer>();
        Component curNode = lastNode;
        while (!root.equals(curNode)) {
            if (curNode instanceof Treeitem) {
                al.add(new Integer(((Treeitem)curNode).indexOf()));
            }
            curNode = curNode.getParent();
        }
        return al;
    }

    private Object getNodeByPath(List path, Object root) {
        int pathSize;
        Object node = root;
        for (int i = pathSize = path.size() - 1; i >= 0; --i) {
            node = this._model.getChild(node, (Integer)path.get(i));
        }
        return node;
    }

    public Treeitem renderItemByPath(int[] path) {
        if (path == null || path.length == 0) {
            return null;
        }
        Treeitem ti = null;
        List children = this.getTreechildren().getChildren();
        for (int i = 0; i < path.length; ++i) {
            if (path[i] < 0 || path[i] > children.size()) {
                return null;
            }
            ti = (Treeitem)((Object)children.get(path[i]));
            this.renderItem(ti);
            if (i < path.length - 1) {
                ti.setOpen(true);
            }
            if (ti.getTreechildren() != null) {
                children = ti.getTreechildren().getChildren();
                continue;
            }
            if (i == path.length - 1) continue;
            return null;
        }
        return ti;
    }

    static {
        $assertionsDisabled = !Tree.class.desiredAssertionStatus();
        log = Log.lookup((Class)Tree.class);
        _defRend = new TreeitemRenderer(){

            public void render(Treeitem ti, Object data) {
                Treecell tc = new Treecell(data.toString());
                Treerow tr = null;
                if (ti.getTreerow() == null) {
                    tr = new Treerow();
                    tr.setParent((Component)ti);
                } else {
                    tr = ti.getTreerow();
                    tr.getChildren().clear();
                }
                tc.setParent((Component)tr);
                ti.setOpen(false);
            }
        };
    }

    private class Iter
    implements Iterator {
        private final ListIterator _it;

        private Iter() {
            this._it = Tree.this.getChildren().listIterator();
        }

        public boolean hasNext() {
            while (this._it.hasNext()) {
                Object o = this._it.next();
                if (!(o instanceof Treecols) && !(o instanceof Auxhead)) continue;
                this._it.previous();
                return true;
            }
            return false;
        }

        public Object next() {
            Object o;
            while (!((o = this._it.next()) instanceof Treecols) && !(o instanceof Auxhead)) {
            }
            return o;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    protected class ExtraCtrl
    extends HtmlBasedComponent.ExtraCtrl
    implements InnerWidth,
    Selectable {
        protected ExtraCtrl() {
            super((HtmlBasedComponent)Tree.this);
        }

        public void setInnerWidthByClient(String width) {
            Tree.this._innerWidth = width == null ? "100%" : width;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void selectItemsByClient(Set selItems) {
            Tree.this._noSmartUpdate = true;
            try {
                if (!Tree.this._multiple || selItems == null || selItems.size() <= 1) {
                    Treeitem item = selItems != null && selItems.size() > 0 ? (Treeitem)((Object)selItems.iterator().next()) : null;
                    Tree.this.selectItem(item);
                } else {
                    Iterator it = new ArrayList(Tree.this._selItems).iterator();
                    while (it.hasNext()) {
                        Treeitem item = (Treeitem)((Object)it.next());
                        if (selItems.remove((Object)item)) continue;
                        Tree.this.removeItemFromSelection(item);
                    }
                    it = selItems.iterator();
                    while (it.hasNext()) {
                        Tree.this.addItemToSelection((Treeitem)((Object)it.next()));
                    }
                }
            }
            finally {
                Tree.this._noSmartUpdate = false;
            }
        }
    }

    private class Renderer
    implements Serializable {
        private final TreeitemRenderer _renderer;
        private boolean _rendered;
        private boolean _ctrled;

        private Renderer() {
            this._renderer = Tree.this.getRealRenderer();
        }

        private void render(Treeitem item) throws Throwable {
            if (!item.isOpen()) {
                return;
            }
            if (!this._rendered && this._renderer instanceof RendererCtrl) {
                ((RendererCtrl)((Object)this._renderer)).doTry();
                this._ctrled = true;
            }
            try {
                Object node = Tree.this.getAssociatedNode(item, Tree.this);
                this._renderer.render(item, node);
            }
            catch (Throwable ex) {
                try {
                    item.setLabel(Exceptions.getMessage((Throwable)ex));
                }
                catch (Throwable t) {
                    log.error(t);
                }
                item.setOpen(true);
                throw ex;
            }
            item.setOpen(true);
            this._rendered = true;
        }

        private void doCatch(Throwable ex) {
            if (this._ctrled) {
                try {
                    ((RendererCtrl)((Object)this._renderer)).doCatch(ex);
                }
                catch (Throwable t) {
                    throw UiException.Aide.wrap((Throwable)t);
                }
            } else {
                throw UiException.Aide.wrap((Throwable)ex);
            }
        }

        private void doFinally() {
            if (this._ctrled) {
                ((RendererCtrl)((Object)this._renderer)).doFinally();
            }
        }
    }
}

