/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Set;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.ext.render.Cropper;
import org.zkoss.zul.Tree;
import org.zkoss.zul.Treeitem;
import org.zkoss.zul.Treerow;
import org.zkoss.zul.ext.Pageable;
import org.zkoss.zul.impl.XulElement;

public class Treechildren
extends XulElement
implements Pageable {
    private static final String ATTR_NO_CHILD = "org.zkoss.zul.Treechildren.noChild";
    private int _actpg;
    private int _pgsz;

    public Tree getTree() {
        Treechildren p = this;
        while ((p = p.getParent()) != null) {
            if (!(p instanceof Tree)) continue;
            return (Tree)((Object)p);
        }
        return null;
    }

    public Treerow getLinkedTreerow() {
        Component parent = this.getParent();
        return parent instanceof Treeitem ? ((Treeitem)parent).getTreerow() : null;
    }

    public boolean isVisible() {
        if (!super.isVisible()) {
            return false;
        }
        Component comp = this.getParent();
        if (!(comp instanceof Treeitem)) {
            return true;
        }
        if (!((Treeitem)comp).isOpen()) {
            return false;
        }
        return !((comp = comp.getParent()) instanceof Treechildren) || ((Treechildren)comp).isVisible();
    }

    public Collection getItems() {
        return new AbstractCollection(){

            public int size() {
                return Treechildren.this.getItemCount();
            }

            public boolean isEmpty() {
                return Treechildren.this.getChildren().isEmpty();
            }

            public Iterator iterator() {
                return new Iterator(){
                    private final Iterator _it;
                    private Iterator _sub;
                    {
                        this._it = Treechildren.this.getChildren().iterator();
                    }

                    public boolean hasNext() {
                        return this._sub != null && this._sub.hasNext() || this._it.hasNext();
                    }

                    public Object next() {
                        if (this._sub != null && this._sub.hasNext()) {
                            return this._sub.next();
                        }
                        Treeitem item = (Treeitem)((Object)this._it.next());
                        Treechildren tc = item.getTreechildren();
                        this._sub = tc != null ? tc.getItems().iterator() : null;
                        return item;
                    }

                    public void remove() {
                        throw new UnsupportedOperationException("readonly");
                    }
                };
            }
        };
    }

    public int getItemCount() {
        int sz = 0;
        Iterator it = this.getChildren().iterator();
        while (it.hasNext()) {
            Treeitem item = (Treeitem)((Object)it.next());
            Treechildren tchs = item.getTreechildren();
            if (tchs != null) {
                sz += tchs.getItemCount();
            }
            ++sz;
        }
        return sz;
    }

    public int getPageSize() {
        if (this._pgsz != 0) {
            return this._pgsz;
        }
        Tree tree = this.getTree();
        return tree != null ? tree.getPageSize() : -1;
    }

    int getPageSizeDirectly() {
        return this._pgsz;
    }

    public void setPageSize(int size) throws WrongValueException {
        if (size < 0) {
            size = -1;
        }
        if (this._pgsz != size) {
            Tree tree;
            boolean realChanged = true;
            if ((this._pgsz == 0 || size == 0) && (tree = this.getTree()) != null) {
                int treepgsz = tree.getPageSize();
                if (this._pgsz == 0 && treepgsz == size || size == 0 && treepgsz == this._pgsz) {
                    realChanged = false;
                }
            }
            this._pgsz = size;
            if (realChanged) {
                int pgcnt = this.getPageCount();
                if (this._actpg >= pgcnt) {
                    this._actpg = pgcnt - 1;
                }
                this.invalidate();
                this.smartUpdatePaging();
            }
        }
    }

    public int getPageCount() {
        int cnt = this.getChildren().size();
        if (cnt <= 0) {
            return 1;
        }
        int pgsz = this.getPageSize();
        return pgsz <= 0 ? 1 : 1 + (cnt - 1) / pgsz;
    }

    public int getActivePage() {
        return this._actpg;
    }

    public void setActivePage(int pg) throws WrongValueException {
        int pgcnt = this.getPageCount();
        if (pg >= pgcnt || pg < 0) {
            throw new WrongValueException("Unable to set active page to " + pg + " since only " + pgcnt + " pages");
        }
        if (this._actpg != pg) {
            this._actpg = pg;
            this.invalidate();
            this.smartUpdatePaging();
        }
    }

    void setActivePageDirectly(int pg) {
        this._actpg = pg;
    }

    public int getVisibleBegin() {
        int pgsz = this.getPageSize();
        return pgsz <= 0 ? 0 : this.getActivePage() * pgsz;
    }

    public int getVisibleEnd() {
        int pgsz = this.getPageSize();
        return pgsz <= 0 ? Integer.MAX_VALUE : (this.getActivePage() + 1) * this.getPageSize() - 1;
    }

    public void setParent(Component parent) {
        Tree tree;
        Component oldp = this.getParent();
        if (oldp == parent) {
            return;
        }
        if (parent != null && !(parent instanceof Tree) && !(parent instanceof Treeitem)) {
            throw new UiException("Wrong parent: " + parent);
        }
        Tree oldtree = oldp != null ? this.getTree() : null;
        super.setParent(parent);
        if (oldtree != null) {
            oldtree.onTreechildrenRemoved(this);
        }
        if (parent != null && (tree = this.getTree()) != null) {
            tree.onTreechildrenAdded(this);
        }
    }

    public boolean insertBefore(Component child, Component insertBefore) {
        if (!(child instanceof Treeitem)) {
            throw new UiException("Unsupported child for treechildren: " + child);
        }
        if (super.insertBefore(child, insertBefore)) {
            int sz = this.getChildren().size();
            if (sz == 1) {
                Executions.getCurrent().setAttribute(ATTR_NO_CHILD, (Object)Boolean.TRUE);
            } else {
                int pgsz = this.getPageSize();
                if (pgsz > 0 && (sz % pgsz == 1 || pgsz == 1)) {
                    this.smartUpdatePaging();
                }
            }
            return true;
        }
        return false;
    }

    public void onChildRemoved(Component child) {
        super.onChildRemoved(child);
        int pgsz = this.getPageSize();
        if (pgsz > 0) {
            int sz = this.getChildren().size();
            if (sz > 0 && (sz % pgsz == 0 || pgsz == 1)) {
                int pgcnt = this.smartUpdatePaging();
                if (this._actpg >= pgcnt) {
                    this._actpg = pgcnt - 1;
                    this.getParent().invalidate();
                }
            } else if (this.getParent() instanceof Tree) {
                this.smartUpdatePaging();
            }
        }
    }

    public void invalidate() {
        Component parent = this.getParent();
        if (parent instanceof Tree) {
            parent.invalidate();
        } else if (!this.getChildren().isEmpty() && Executions.getCurrent().getAttribute(ATTR_NO_CHILD) == null) {
            super.invalidate();
        }
    }

    public void smartUpdate(String name, String value) {
        Object comp = this.getParent();
        if (comp instanceof Treeitem) {
            comp = ((Treeitem)((Object)comp)).getTreerow();
        }
        if (comp != null) {
            comp.smartUpdate(name, value);
        }
    }

    private int smartUpdatePaging() {
        int pgcnt = this.getPageCount();
        this.smartUpdate("z.pgInfo", pgcnt + "," + this.getActivePage() + "," + this.getPageSize());
        return pgcnt;
    }

    protected Object newExtraCtrl() {
        return new ExtraCtrl();
    }

    protected class ExtraCtrl
    extends HtmlBasedComponent.ExtraCtrl
    implements Cropper {
        protected ExtraCtrl() {
            super((HtmlBasedComponent)Treechildren.this);
        }

        public boolean isCropper() {
            return Treechildren.this.getPageSize() > 0;
        }

        public Set getAvailableAtClient() {
            int pgsz = Treechildren.this.getPageSize();
            int sz = Treechildren.this.getChildren().size();
            if (pgsz <= 0 || sz <= pgsz) {
                return null;
            }
            HashSet avail = new HashSet(37);
            int ofs = Treechildren.this.getActivePage() * pgsz;
            ListIterator it = Treechildren.this.getChildren().listIterator(ofs);
            while (--pgsz >= 0 && it.hasNext()) {
                avail.add(it.next());
            }
            return avail;
        }
    }
}

