/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Iterator;
import java.util.List;
import org.zkoss.lang.Objects;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.ext.client.Openable;
import org.zkoss.zul.Tree;
import org.zkoss.zul.Treecell;
import org.zkoss.zul.Treechildren;
import org.zkoss.zul.Treerow;
import org.zkoss.zul.impl.XulElement;

public class Treeitem
extends XulElement {
    private transient Treerow _treerow;
    private transient Treechildren _treechildren;
    private Object _value;
    private boolean _open = true;
    private boolean _selected = false;
    private boolean _disabled = false;
    private boolean _loaded = false;

    public Treeitem() {
    }

    public Treeitem(String label) {
        this.setLabel(label);
    }

    public Treeitem(String label, Object value) {
        this.setLabel(label);
        this.setValue(value);
    }

    public void setDisabled(boolean disabled) {
        if (this._disabled != disabled) {
            this._disabled = disabled;
            this.invalidate();
        }
    }

    public boolean isDisabled() {
        return this._disabled;
    }

    public boolean isLoaded() {
        return this._loaded;
    }

    public void setLoaded(boolean loaded) {
        this._loaded = loaded;
    }

    public int indexOf() {
        List list = this.getParent().getChildren();
        return list.indexOf((Object)this);
    }

    public Treerow getTreerow() {
        return this._treerow;
    }

    public Treechildren getTreechildren() {
        return this._treechildren;
    }

    public boolean isContainer() {
        return this._treechildren != null;
    }

    public boolean isEmpty() {
        return this._treechildren == null || this._treechildren.getChildren().isEmpty();
    }

    public Object getValue() {
        return this._value;
    }

    public void setValue(Object value) {
        if (!Objects.equals((Object)this._value, (Object)value)) {
            this._value = value;
            Tree tree = this.getTree();
            if (tree != null && tree.getName() != null) {
                this.smartUpdate("z.value", Objects.toString((Object)this._value));
            }
        }
    }

    public boolean isOpen() {
        return this._open;
    }

    public void setOpen(boolean open) {
        if (this._open != open) {
            this._open = open;
            if (this._treerow != null) {
                this._treerow.smartUpdate("open", this._open);
            }
        }
    }

    public boolean isSelected() {
        return this._selected;
    }

    public void setSelected(boolean selected) {
        if (this._selected != selected) {
            Tree tree = this.getTree();
            if (tree != null) {
                tree.toggleItemSelection(this);
            } else {
                this._selected = selected;
            }
        }
    }

    void setSelectedDirectly(boolean selected) {
        this._selected = selected;
    }

    public int getLevel() {
        Component tch;
        int level = 0;
        Treeitem item = this;
        while ((tch = item.getParent()) != null && (item = tch.getParent()) != null && !(item instanceof Tree)) {
            ++level;
        }
        return level;
    }

    public String getLabel() {
        Treecell cell = this.getFirstCell();
        return cell != null ? cell.getLabel() : null;
    }

    public void setLabel(String label) {
        this.autoFirstCell().setLabel(label);
    }

    private Treecell getFirstCell() {
        return this._treerow != null ? (Treecell)this._treerow.getFirstChild() : null;
    }

    private Treecell autoFirstCell() {
        Treecell cell;
        if (this._treerow == null) {
            Treerow row = new Treerow();
            row.applyProperties();
            row.setParent((Component)this);
        }
        if ((cell = (Treecell)this._treerow.getFirstChild()) == null) {
            cell = new Treecell();
            cell.applyProperties();
            cell.setParent((Component)this._treerow);
        }
        return cell;
    }

    public String getSrc() {
        Treecell cell = this.getFirstCell();
        return cell != null ? cell.getSrc() : null;
    }

    public void setSrc(String src) {
        this.autoFirstCell().setSrc(src);
    }

    public String getImage() {
        return this.getSrc();
    }

    public void setImage(String image) {
        this.setSrc(image);
    }

    public Treeitem getParentItem() {
        Component p = this.getParent();
        Component gp = p != null ? p.getParent() : null;
        return gp instanceof Treeitem ? (Treeitem)gp : null;
    }

    public Treeitem getTreeitem() {
        return this.getParentItem();
    }

    public Tree getTree() {
        Treeitem p = this;
        while ((p = p.getParent()) != null) {
            if (!(p instanceof Tree)) continue;
            return (Tree)((Object)p);
        }
        return null;
    }

    boolean isFocusRequired() {
        Tree tree = this.getTree();
        if (tree == null) {
            return false;
        }
        Treeitem sel = tree.getSelectedItem();
        if (sel != null) {
            return sel == this;
        }
        Iterator it = tree.getItems().iterator();
        return it.hasNext() && it.next() == this;
    }

    protected boolean isAsapRequired(String evtnm) {
        return super.isAsapRequired(evtnm);
    }

    public void smartUpdate(String attr, String value) {
        if (this._treerow != null) {
            this._treerow.smartUpdate(attr, value);
        }
    }

    public void setDraggable(String draggable) {
        if (draggable != null) {
            throw new UnsupportedOperationException("Use Treerow.setDraggable() instead");
        }
    }

    public void setDroppable(String dropable) {
        if (dropable != null) {
            throw new UnsupportedOperationException("Use Treerow.setDroppable() instead");
        }
    }

    public void setAction(String action) {
        if (action != null) {
            throw new UnsupportedOperationException("Use Treerow.setAction() instead");
        }
    }

    public void setParent(Component parent) {
        Tree tree;
        List sibs;
        int sz;
        List sibs2;
        int sz2;
        Component oldp = this.getParent();
        if (oldp == parent) {
            return;
        }
        if (parent != null && !(parent instanceof Treechildren)) {
            throw new UiException("Wrong parent: " + parent);
        }
        Treeitem affected = null;
        if (oldp != null && (sz2 = (sibs2 = oldp.getChildren()).size()) > 1 && sibs2.get(sibs2.size() - 1) == this) {
            affected = (Treeitem)((Object)sibs2.get(sibs2.size() - 2));
        }
        Tree oldtree = oldp != null ? this.getTree() : null;
        super.setParent(parent);
        if (affected != null && affected._treerow != null) {
            affected._treerow.invalidate();
        }
        if (parent != null && (sz = (sibs = parent.getChildren()).size()) > 1 && sibs.get(sz - 1) == this) {
            affected = (Treeitem)((Object)sibs.get(sz - 2));
            if (affected._treerow != null) {
                affected._treerow.invalidate();
            }
        }
        if (oldtree != null) {
            oldtree.onTreeitemRemoved(this);
        }
        if (parent != null && (tree = this.getTree()) != null) {
            tree.onTreeitemAdded(this);
        }
    }

    public boolean insertBefore(Component child, Component insertBefore) {
        if (child instanceof Treerow) {
            if (this._treerow != null && this._treerow != child) {
                throw new UiException("Only one treerow is allowed: " + (Object)((Object)this));
            }
            this._treerow = (Treerow)child;
        } else if (child instanceof Treechildren) {
            if (this._treechildren != null && this._treechildren != child) {
                throw new UiException("Only one treechildren is allowed: " + (Object)((Object)this));
            }
            this._treechildren = (Treechildren)child;
            if (this._treerow != null) {
                this._treerow.invalidate();
            }
        } else {
            throw new UiException("Unsupported child for tree item: " + child);
        }
        return super.insertBefore(child, insertBefore);
    }

    public void onChildRemoved(Component child) {
        if (child instanceof Treerow) {
            this._treerow = null;
        } else if (child instanceof Treechildren) {
            this._treechildren = null;
        }
        super.onChildRemoved(child);
    }

    public void invalidate() {
        if (this._treerow != null) {
            super.invalidate();
        }
    }

    public Object clone() {
        Treeitem clone = (Treeitem)((Object)super.clone());
        int cnt = 0;
        if (clone._treerow != null) {
            ++cnt;
        }
        if (clone._treechildren != null) {
            ++cnt;
        }
        if (cnt > 0) {
            clone.afterUnmarshal(cnt);
        }
        return clone;
    }

    private void afterUnmarshal(int cnt) {
        Iterator it = this.getChildren().iterator();
        while (it.hasNext()) {
            Object child = it.next();
            if (child instanceof Treerow) {
                this._treerow = (Treerow)((Object)child);
                if (--cnt != 0) continue;
                break;
            }
            if (!(child instanceof Treechildren)) continue;
            this._treechildren = (Treechildren)child;
            if (--cnt != 0) continue;
            break;
        }
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.afterUnmarshal(-1);
    }

    protected Object newExtraCtrl() {
        return new ExtraCtrl();
    }

    protected class ExtraCtrl
    extends HtmlBasedComponent.ExtraCtrl
    implements Openable {
        protected ExtraCtrl() {
            super((HtmlBasedComponent)Treeitem.this);
        }

        public void setOpenByClient(boolean open) {
            Treeitem.this._open = open;
            if (Treeitem.this.getTree() != null) {
                Treeitem.this.getTree().renderItem(Treeitem.this);
            }
        }
    }
}

