/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import org.zkoss.lang.Objects;
import org.zkoss.xml.HTMLs;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zul.Tree;
import org.zkoss.zul.Treecell;
import org.zkoss.zul.Treechildren;
import org.zkoss.zul.Treeitem;
import org.zkoss.zul.impl.XulElement;

public class Treerow
extends XulElement {
    public Tree getTree() {
        Treerow p = this;
        while ((p = p.getParent()) != null) {
            if (!(p instanceof Tree)) continue;
            return (Tree)((Object)p);
        }
        return null;
    }

    public int getLevel() {
        Component parent = this.getParent();
        return parent != null ? ((Treeitem)parent).getLevel() : 0;
    }

    public Treeitem getTreeitem() {
        return (Treeitem)this.getParent();
    }

    public Treechildren getLinkedTreechildren() {
        Component parent = this.getParent();
        return parent != null ? ((Treeitem)parent).getTreechildren() : null;
    }

    public String getSclass() {
        Treeitem ti;
        String scls = super.getSclass();
        if (scls == null) {
            scls = "item";
        }
        if ((ti = this.getTreeitem()) != null) {
            if (ti.isDisabled()) {
                return scls.length() > 0 ? scls + " disd" : "disd";
            }
            if (ti.isSelected()) {
                return scls.length() > 0 ? scls + " seld" : "seld";
            }
        }
        return scls;
    }

    public void setContext(String context) {
        throw new UnsupportedOperationException("Use treeitem instead");
    }

    public void setPopup(String popup) {
        throw new UnsupportedOperationException("Use treeitem instead");
    }

    public void setTooltip(String tooltip) {
        throw new UnsupportedOperationException("Use treeitem instead");
    }

    public String getContext() {
        Treeitem ti = this.getTreeitem();
        return ti != null ? ti.getContext() : null;
    }

    public String getPopup() {
        Treeitem ti = this.getTreeitem();
        return ti != null ? ti.getPopup() : null;
    }

    public String getTooltip() {
        Treeitem ti = this.getTreeitem();
        return ti != null ? ti.getTooltip() : null;
    }

    public String getTooltiptext() {
        Treeitem ti = this.getTreeitem();
        return ti != null ? ti.getTooltiptext() : null;
    }

    protected boolean isAsapRequired(String evtnm) {
        if (!"onOpen".equals(evtnm)) {
            return super.isAsapRequired(evtnm);
        }
        Treeitem ti = this.getTreeitem();
        return ti != null && ti.isAsapRequired(evtnm);
    }

    public String getOuterAttrs() {
        Treechildren tcsib;
        Component gp;
        String attrs = super.getOuterAttrs();
        Treeitem item = this.getTreeitem();
        if (item == null) {
            return attrs;
        }
        StringBuffer sb = new StringBuffer(80).append(attrs);
        Tree tree = this.getTree();
        if (tree != null && tree.getName() != null) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.value", (String)Objects.toString((Object)item.getValue()));
        }
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.pitem", (String)item.getUuid());
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.sel", (boolean)item.isSelected());
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.disd", (boolean)item.isDisabled());
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.rid", (String)tree.getUuid());
        if (item.isContainer()) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.open", (boolean)item.isOpen());
        }
        if ((gp = item.getParent()) != null) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.ptch", (String)gp.getUuid());
            Component gpitem = gp.getParent();
            if (gpitem instanceof Treeitem) {
                HTMLs.appendAttribute((StringBuffer)sb, (String)"z.gpitem", (String)gpitem.getUuid());
            }
        }
        if ((tcsib = this.getLinkedTreechildren()) != null) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.tchsib", (String)tcsib.getUuid());
            int pgcnt = tcsib.getPageCount();
            if (pgcnt > 1) {
                HTMLs.appendAttribute((StringBuffer)sb, (String)"z.pgc", (int)pgcnt);
                HTMLs.appendAttribute((StringBuffer)sb, (String)"z.pgi", (int)tcsib.getActivePage());
                HTMLs.appendAttribute((StringBuffer)sb, (String)"z.pgsz", (int)tcsib.getPageSize());
            }
        }
        if (this.getTree().getModel() != null) {
            sb.append("z.onopen=\"true\"");
        } else {
            this.appendAsapAttr(sb, "onOpen");
        }
        String clkattrs = this.getAllOnClickAttrs(false);
        if (clkattrs != null) {
            sb.append(clkattrs);
        }
        return sb.toString();
    }

    public boolean isVisible() {
        if (!super.isVisible()) {
            return false;
        }
        Component comp = this.getParent();
        if (!(comp instanceof Treeitem)) {
            return true;
        }
        if (!comp.isVisible()) {
            return false;
        }
        return !((comp = comp.getParent()) instanceof Treechildren) || ((Treechildren)comp).isVisible();
    }

    public void setParent(Component parent) {
        if (parent != null && !(parent instanceof Treeitem)) {
            throw new UiException("Wrong parent: " + parent);
        }
        super.setParent(parent);
    }

    public boolean insertBefore(Component child, Component insertBefore) {
        if (!(child instanceof Treecell)) {
            throw new UiException("Unsupported child for tree row: " + child);
        }
        return super.insertBefore(child, insertBefore);
    }
}

