/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Iterator;
import org.zkoss.lang.Objects;
import org.zkoss.mesg.MCommon;
import org.zkoss.util.logging.Log;
import org.zkoss.xml.HTMLs;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.IdSpace;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.SuspendNotAllowedException;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.ext.client.Openable;
import org.zkoss.zk.ui.ext.render.MultiBranch;
import org.zkoss.zul.Caption;
import org.zkoss.zul.impl.XulElement;

public class Window
extends XulElement
implements IdSpace {
    private static final Log log = Log.lookup((Class)Window.class);
    private static String _onshow = null;
    private transient Caption _caption;
    private String _border = "none";
    private String _title = "";
    private String _ctrlKeys;
    private String _ctkeys;
    private int _mode = 0;
    private transient Object _mutex;
    private String _cntStyle;
    private String _cntscls;
    private String _pos;
    private boolean _closable;
    private boolean _sizable;
    private static final int EMBEDDED = 0;
    private static final int MODAL = 1;
    private static final int OVERLAPPED = 2;
    private static final int POPUP = 3;
    private static final int HIGHLIGHTED = 4;

    public Window() {
        this.init();
    }

    public Window(String title, String border, boolean closable) {
        this();
        this.setTitle(title);
        this.setBorder(border);
        this.setClosable(closable);
    }

    private void init() {
        this._mutex = new Object();
    }

    public static void setDefaultActionOnShow(String onshow) {
        if (!Objects.equals((Object)_onshow, (Object)onshow)) {
            _onshow = onshow;
        }
    }

    public static String getDefaultActionOnShow() {
        return _onshow;
    }

    public Caption getCaption() {
        return this._caption;
    }

    public String getBorder() {
        return this._border;
    }

    public void setBorder(String border) {
        if (border == null || "0".equals(border)) {
            border = "none";
        }
        if (!Objects.equals((Object)this._border, (Object)border)) {
            this._border = border;
            this.smartUpdate("class", this.getSclass());
        }
    }

    public String getTitle() {
        return this._title;
    }

    public void setTitle(String title) {
        if (title == null) {
            title = "";
        }
        if (!Objects.equals((Object)this._title, (Object)title)) {
            this._title = title;
            if (this._caption != null) {
                this._caption.invalidate();
            } else {
                this.invalidate();
            }
        }
    }

    public String getCtrlKeys() {
        return this._ctrlKeys;
    }

    public void setCtrlKeys(String ctrlKeys) throws UiException {
        if (ctrlKeys != null && ctrlKeys.length() == 0) {
            ctrlKeys = null;
        }
        if (!Objects.equals((Object)this._ctrlKeys, (Object)ctrlKeys)) {
            this.parseCtrlKeys(ctrlKeys);
            this.smartUpdate("z.ctkeys", this._ctkeys);
        }
    }

    private void parseCtrlKeys(String keys) throws UiException {
        if (keys == null || keys.length() == 0) {
            this._ctkeys = null;
            this._ctrlKeys = null;
            return;
        }
        StringBuffer sbctl = new StringBuffer();
        StringBuffer sbsft = new StringBuffer();
        StringBuffer sbalt = new StringBuffer();
        StringBuffer sbext = new StringBuffer();
        StringBuffer sbcur = null;
        int len = keys.length();
        block6: for (int j = 0; j < len; ++j) {
            int cc = keys.charAt(j);
            switch (cc) {
                case 36: 
                case 64: 
                case 94: {
                    if (sbcur != null) {
                        throw new WrongValueException("Combination of Shift, Alt and Ctrl not supported: " + keys);
                    }
                    sbcur = cc == 94 ? sbctl : (cc == 64 ? sbalt : sbsft);
                    continue block6;
                }
                case 35: {
                    char c2;
                    int k;
                    for (k = j + 1; k < len && ((c2 = keys.charAt(k)) <= 'Z' && c2 >= 'A' || c2 <= 'z' && c2 >= 'a' || c2 <= '9' && c2 >= '0'); ++k) {
                    }
                    if (k == j + 1) {
                        throw new WrongValueException(MCommon.UNEXPECTED_CHARACTER, new Object[]{new Character((char)cc), keys});
                    }
                    String s = keys.substring(j + 1, k).toLowerCase();
                    if ("pgup".equals(s)) {
                        cc = 65;
                    } else if ("pgdn".equals(s)) {
                        cc = 66;
                    } else if ("end".equals(s)) {
                        cc = 67;
                    } else if ("home".equals(s)) {
                        cc = 68;
                    } else if ("left".equals(s)) {
                        cc = 69;
                    } else if ("up".equals(s)) {
                        cc = 70;
                    } else if ("right".equals(s)) {
                        cc = 71;
                    } else if ("down".equals(s)) {
                        cc = 72;
                    } else if ("ins".equals(s)) {
                        cc = 73;
                    } else if ("del".equals(s)) {
                        cc = 74;
                    } else if (s.length() > 1 && s.charAt(0) == 'f') {
                        int v;
                        try {
                            v = Integer.parseInt(s.substring(1));
                        }
                        catch (Throwable ex) {
                            throw new WrongValueException("Unknown #" + s + " in " + keys);
                        }
                        if (v == 0 || v > 12) {
                            throw new WrongValueException("Unsupported function key: #f" + v);
                        }
                        cc = (char)(79 + v);
                    } else {
                        throw new WrongValueException("Unknown #" + s + " in " + keys);
                    }
                    if (sbcur == null) {
                        sbext.append((char)cc);
                    } else {
                        sbcur.append((char)cc);
                        sbcur = null;
                    }
                    j = k - 1;
                    continue block6;
                }
                default: {
                    if (!(sbcur != null && (cc <= 90 && cc >= 65 || cc <= 122 && cc >= 97 || cc <= 57 && cc >= 48))) {
                        throw new WrongValueException(MCommon.UNEXPECTED_CHARACTER, new Object[]{new Character((char)cc), keys});
                    }
                    if (sbcur == sbsft) {
                        throw new WrongValueException("$" + (char)cc + " not supported: " + keys);
                    }
                    if (cc <= 90 && cc >= 65) {
                        cc = (char)(cc + 32);
                    }
                    sbcur.append((char)cc);
                    sbcur = null;
                }
            }
        }
        this._ctkeys = "" + '^' + sbctl + ';' + '@' + sbalt + ';' + '$' + sbsft + ';' + '#' + sbext + ';';
        this._ctrlKeys = keys;
    }

    public String getMode() {
        return Window.modeToString(this._mode);
    }

    private static String modeToString(int mode) {
        switch (mode) {
            case 1: {
                return "modal";
            }
            case 3: {
                return "popup";
            }
            case 2: {
                return "overlapped";
            }
            case 4: {
                return "highlighted";
            }
        }
        return "embedded";
    }

    public void setMode(String name) throws InterruptedException {
        if ("popup".equals(name)) {
            this.doPopup();
        } else if ("overlapped".equals(name)) {
            this.doOverlapped();
        } else if ("embedded".equals(name)) {
            this.doEmbedded();
        } else if ("modal".equals(name)) {
            this.doModal();
        } else if ("highlighted".equals(name)) {
            this.doHighlighted();
        } else {
            throw new WrongValueException("Uknown mode: " + name);
        }
    }

    public void setMode(int mode) throws InterruptedException {
        switch (mode) {
            case 3: {
                this.doPopup();
                break;
            }
            case 2: {
                this.doOverlapped();
                break;
            }
            case 0: {
                this.doEmbedded();
                break;
            }
            case 1: {
                this.doModal();
                break;
            }
            case 4: {
                this.doHighlighted();
                break;
            }
            default: {
                throw new WrongValueException("Unknown mode: " + mode);
            }
        }
    }

    public boolean inModal() {
        return this._mode == 1;
    }

    public boolean inEmbedded() {
        return this._mode == 0;
    }

    public boolean inOverlapped() {
        return this._mode == 2;
    }

    public boolean inPopup() {
        return this._mode == 3;
    }

    public boolean inHighlighted() {
        return this._mode == 4;
    }

    public void doModal() throws InterruptedException, SuspendNotAllowedException {
        Desktop desktop = this.getDesktop();
        if (desktop == null) {
            desktop = Executions.getCurrent().getDesktop();
        }
        if (!desktop.getWebApp().getConfiguration().isEventThreadEnabled()) {
            this.handleFailedModal(this._mode, this.isVisible());
            throw new SuspendNotAllowedException("Event processing thread is disabled");
        }
        this.checkOverlappable(1);
        if (this._mode != 1) {
            if (!Events.inEventListener()) {
                Events.postEvent((String)"onModal", (Component)this, null);
                return;
            }
            int oldmode = this._mode;
            boolean oldvisi = this.isVisible();
            this.invalidate();
            this.setVisible(true);
            try {
                this.enterModal();
            }
            catch (SuspendNotAllowedException ex) {
                this.handleFailedModal(oldmode, oldvisi);
                throw ex;
            }
        }
    }

    private void handleFailedModal(int oldmode, boolean oldvisi) {
        try {
            if (Executions.getCurrent().getAttribute("javax.servlet.error.exception") != null) {
                this.setMode(4);
            } else {
                this.setMode(oldmode);
                this.setVisible(oldvisi);
            }
        }
        catch (Throwable ex) {
            log.realCauseBriefly("Causing another error", ex);
        }
    }

    public void doOverlapped() {
        this.checkOverlappable(2);
        this.setNonModalMode(2);
    }

    public void doPopup() {
        this.checkOverlappable(3);
        this.setNonModalMode(3);
    }

    public void doHighlighted() {
        this.checkOverlappable(4);
        this.setNonModalMode(4);
    }

    public void doEmbedded() {
        this.setNonModalMode(0);
    }

    private void setNonModalMode(int mode) {
        if (this._mode != mode) {
            if (this._mode == 1) {
                this.leaveModal();
            }
            this._mode = mode;
            this.invalidate();
        }
        this.setVisible(true);
    }

    private void enterModal() throws InterruptedException {
        this._mode = 1;
        Executions.wait((Object)this._mutex);
    }

    private void leaveModal() {
        this._mode = 2;
        Executions.notifyAll((Object)this._mutex);
    }

    private void checkOverlappable(int mode) {
        if (!"false".equals(this.getDraggable())) {
            throw new UiException("Draggable window cannot be modal, overlapped, popup, or highlighted: " + (Object)((Object)this));
        }
        if (mode == 1 || mode == 4) {
            Window comp = this;
            while ((comp = comp.getParent()) != null) {
                if (comp.isVisible()) continue;
                throw new UiException("One of its ancestors, " + (Object)((Object)comp) + ", is not visible, so unable to be modal or highlighted");
            }
        }
    }

    public boolean isClosable() {
        return this._closable;
    }

    public void setClosable(boolean closable) {
        if (this._closable != closable) {
            this._closable = closable;
            this.invalidate();
        }
    }

    public boolean isSizable() {
        return this._sizable;
    }

    public void setSizable(boolean sizable) {
        if (this._sizable != sizable) {
            this._sizable = sizable;
            this.smartUpdate("z.sizable", sizable);
        }
    }

    public String getPosition() {
        return this._pos;
    }

    public void setPosition(String pos) {
        this._pos = pos;
        if (this._mode != 0) {
            this.smartUpdate("z.pos", pos);
        }
    }

    public void onClose() {
        this.detach();
    }

    public void onModal() throws InterruptedException {
        this.doModal();
    }

    public String getContentStyle() {
        return this._cntStyle;
    }

    public void setContentStyle(String style) {
        if (!Objects.equals((Object)this._cntStyle, (Object)style)) {
            this._cntStyle = style;
            this.smartUpdate("z.cntStyle", this._cntStyle);
        }
    }

    public String getContentSclass() {
        String border;
        String cntscls = this._cntscls;
        if (cntscls == null) {
            cntscls = this.getSclass();
            cntscls = cntscls != null ? "wc-" + cntscls : "wc";
        }
        return "normal".equals(border = this.getBorder()) ? cntscls : cntscls + '-' + border;
    }

    public void setContentSclass(String scls) {
        if (!Objects.equals((Object)this._cntscls, (Object)scls)) {
            this._cntscls = scls;
            this.smartUpdate("z.cntScls", this.getContentSclass());
        }
    }

    public String getTitleSclass() {
        return "wt-" + this.getSclass();
    }

    public String getSclass() {
        String scls = super.getSclass();
        return scls != null ? scls : this.getMode();
    }

    public void setSclass(String sclass) {
        if (sclass != null && sclass.length() == 0) {
            sclass = null;
        }
        if (!Objects.equals((Object)super.getSclass(), (Object)sclass)) {
            super.setSclass(sclass);
            this.invalidate();
        }
    }

    public boolean insertBefore(Component child, Component insertBefore) {
        if (child instanceof Caption) {
            if (this._caption != null && this._caption != child) {
                throw new UiException("Only one caption is allowed: " + (Object)((Object)this));
            }
            insertBefore = this.getFirstChild();
            this._caption = (Caption)child;
            this.invalidate();
        } else if (insertBefore instanceof Caption) {
            throw new UiException("caption must be the first child");
        }
        return super.insertBefore(child, insertBefore);
    }

    public void onChildRemoved(Component child) {
        if (child instanceof Caption) {
            this._caption = null;
            this.invalidate();
        }
        super.onChildRemoved(child);
    }

    public void setPage(Page page) {
        super.setPage(page);
        if (page == null && this._mode == 1) {
            this.leaveModal();
        }
    }

    public void setParent(Component parent) {
        super.setParent(parent);
        if (this._mode == 1 && this.getPage() == null) {
            this.leaveModal();
        }
    }

    public boolean setVisible(boolean visible) {
        if (!visible && this._mode == 1) {
            this.leaveModal();
            this.invalidate();
        }
        return super.setVisible(visible);
    }

    public void setDraggable(String draggable) {
        if (this._mode != 0 && draggable != null && draggable.length() > 0 && !"false".equals(draggable)) {
            throw new UiException("Only embedded window could be draggable: " + (Object)((Object)this));
        }
        super.setDraggable(draggable);
    }

    protected String getRealStyle() {
        String style = super.getRealStyle();
        return this._mode != 0 ? "position:absolute;" + style : style;
    }

    public String getOuterAttrs() {
        StringBuffer sb = new StringBuffer(64).append(super.getOuterAttrs());
        this.appendAsapAttr(sb, "onMove");
        this.appendAsapAttr(sb, "onSize");
        this.appendAsapAttr(sb, "onZIndex");
        this.appendAsapAttr(sb, "onOK");
        this.appendAsapAttr(sb, "onCancel");
        this.appendAsapAttr(sb, "onCtrlKey");
        this.appendAsapAttr(sb, "onOpen");
        String clkattrs = this.getAllOnClickAttrs(false);
        if (clkattrs != null) {
            sb.append(clkattrs);
        }
        String aos = Window.getDefaultActionOnShow() != null ? Window.getDefaultActionOnShow() : this.getDesktop().getWebApp().getConfiguration().getPreference("org.zkoss.zul.Window.defaultActionOnShow", null);
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.aos", (String)(aos != null && aos.length() == 0 ? "z_none" : aos));
        if (this._closable) {
            sb.append(" z.closable=\"true\"");
        }
        if (this._sizable) {
            sb.append(" z.sizable=\"true\"");
        }
        if (this._mode != 0) {
            if (this._pos != null) {
                HTMLs.appendAttribute((StringBuffer)sb, (String)"z.pos", (String)this._pos);
            }
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.mode", (String)this.getMode());
        }
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.ctkeys", (String)this._ctkeys);
        return sb.toString();
    }

    public Object clone() {
        Window clone = (Window)((Object)super.clone());
        clone.init();
        if (clone._caption != null) {
            clone.afterUnmarshal();
        }
        return clone;
    }

    private void afterUnmarshal() {
        Iterator it = this.getChildren().iterator();
        while (it.hasNext()) {
            Object child = it.next();
            if (!(child instanceof Caption)) continue;
            this._caption = (Caption)((Object)child);
            break;
        }
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.init();
        this.afterUnmarshal();
    }

    protected Object newExtraCtrl() {
        return new ExtraCtrl();
    }

    protected class ExtraCtrl
    extends HtmlBasedComponent.ExtraCtrl
    implements MultiBranch,
    Openable {
        protected ExtraCtrl() {
            super((HtmlBasedComponent)Window.this);
        }

        public boolean inDifferentBranch(Component child) {
            return child instanceof Caption;
        }

        public void setOpenByClient(boolean open) {
            Window.this.setVisible(open);
        }
    }
}

