/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul.impl;

import org.zkoss.mesg.Messages;
import org.zkoss.zul.Window;
import org.zkoss.zul.mesg.MZul;

public class MessageboxDlg
extends Window {
    public static final int OK = 1;
    public static final int CANCEL = 2;
    public static final int YES = 16;
    public static final int NO = 32;
    public static final int ABORT = 256;
    public static final int RETRY = 512;
    public static final int IGNORE = 1024;
    private int _buttons;
    private int _result;

    public void onOK() {
        if ((this._buttons & 1) != 0) {
            this.endModal(1);
        } else if ((this._buttons & 0x10) != 0) {
            this.endModal(16);
        } else if ((this._buttons & 0x200) != 0) {
            this.endModal(512);
        }
    }

    public void onCancel() {
        if (this._buttons == 1) {
            this.endModal(1);
        } else if ((this._buttons & 2) != 0) {
            this.endModal(2);
        } else if ((this._buttons & 0x20) != 0) {
            this.endModal(32);
        } else if ((this._buttons & 0x100) != 0) {
            this.endModal(256);
        }
    }

    public void setButtons(int buttons) {
        this._buttons = buttons;
    }

    public void setFocus(int button) {
        Button btn;
        if (button > 0 && (btn = (Button)this.getFellowIfAny("btn" + button)) != null) {
            btn.focus();
        }
    }

    public void endModal(int button) {
        this._result = button;
        this.detach();
    }

    public int getResult() {
        return this._result;
    }

    public static class Button
    extends org.zkoss.zul.Button {
        private int _button;

        public void setIdentity(int button) {
            int label;
            this._button = button;
            switch (button) {
                case 16: {
                    label = MZul.YES;
                    break;
                }
                case 32: {
                    label = MZul.NO;
                    break;
                }
                case 512: {
                    label = MZul.RETRY;
                    break;
                }
                case 256: {
                    label = MZul.ABORT;
                    break;
                }
                case 1024: {
                    label = MZul.IGNORE;
                    break;
                }
                case 2: {
                    label = MZul.CANCEL;
                    break;
                }
                default: {
                    label = MZul.OK;
                }
            }
            this.setLabel(Messages.get((int)label));
            this.setId("btn" + this._button);
        }

        public void onClick() {
            ((MessageboxDlg)this.getSpaceOwner()).endModal(this._button);
        }
    }
}

