/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.zkoss.lang.Objects;
import org.zkoss.lang.Strings;
import org.zkoss.xml.HTMLs;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.sys.ComponentsCtrl;
import org.zkoss.zul.Popup;
import org.zkoss.zul.au.in.ColSizeCommand;
import org.zkoss.zul.au.in.PageSizeCommand;
import org.zkoss.zul.au.in.PagingCommand;

public abstract class XulElement
extends HtmlBasedComponent {
    private String _popup;
    private String _ctx;
    private String _tooltip;
    private String _action;

    public String getContext() {
        return this._ctx;
    }

    public void setContext(String context) {
        if (!Objects.equals((Object)this._ctx, (Object)context)) {
            this._ctx = context;
            this.smartUpdate("z.ctx", this._ctx);
        }
    }

    public void setContext(Popup popup) {
        this.setContext(popup != null ? "uuid(" + (Object)((Object)popup) + ")" : null);
    }

    public String getPopup() {
        return this._popup;
    }

    public void setPopup(String popup) {
        if (!Objects.equals((Object)this._popup, (Object)popup)) {
            this._popup = popup;
            this.smartUpdate("z.pop", this._popup);
        }
    }

    public void setPopup(Popup popup) {
        this.setPopup(popup != null ? "uuid(" + (Object)((Object)popup) + ")" : null);
    }

    public String getTooltip() {
        return this._tooltip;
    }

    public void setTooltip(String tooltip) {
        if (!Objects.equals((Object)this._tooltip, (Object)tooltip)) {
            this._tooltip = tooltip;
            this.smartUpdate("z.tip", this._tooltip);
        }
    }

    public void setTooltip(Popup popup) {
        this.setTooltip(popup != null ? "uuid(" + (Object)((Object)popup) + ")" : null);
    }

    public String getAction() {
        return this._action;
    }

    public void setAction(String action) {
        if (action != null && action.length() == 0) {
            action = null;
        }
        if (!Objects.equals((Object)this._action, (Object)action)) {
            this._action = action;
            this.invalidate();
        }
    }

    protected String getAllOnClickAttrs(boolean ignoreOnClick) {
        StringBuffer sb = null;
        if (!ignoreOnClick) {
            sb = this.appendAsapAttr(sb, "onClick");
        }
        sb = this.appendAsapAttr(sb, "onDoubleClick");
        return (sb = this.appendAsapAttr(sb, "onRightClick")) != null ? sb.toString() : null;
    }

    public String getActionAttrs() {
        if (this._action == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer(100);
        Iterator it = XulElement.parseAction(this._action).entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry me = it.next();
            HTMLs.appendAttribute((StringBuffer)sb, (String)((String)me.getKey()), (String)this.toJavaScript((String)me.getValue()));
        }
        return sb.toString();
    }

    public String getOuterAttrs() {
        String attrs = super.getOuterAttrs();
        String ctx = this.getContext();
        String popup = this.getPopup();
        String tip = this.getTooltip();
        if (ctx == null && tip == null && popup == null) {
            return attrs;
        }
        StringBuffer sb = new StringBuffer(80).append(attrs);
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.ctx", (String)ctx);
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.pop", (String)popup);
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.tip", (String)tip);
        return sb.toString();
    }

    public String getInnerAttrs() {
        String attrs = super.getInnerAttrs();
        return this._action == null ? attrs : attrs + this.getActionAttrs();
    }

    private static final Map parseAction(String action) {
        HashMap<String, String> map = new HashMap<String, String>();
        int k = action.indexOf(58);
        if (k < 0) {
            throw new WrongValueException("Unknown action: " + action);
        }
        int j = 0;
        int len = action.length();
        while (true) {
            int l;
            String actnm;
            if ((actnm = action.substring(j, k).trim()).length() == 0) {
                throw new WrongValueException("Unknown action: " + action);
            }
            char quote = '\u0000';
            j = ++k;
            while (true) {
                if (k >= len) {
                    l = len;
                    break;
                }
                char cc = action.charAt(k);
                if (cc != '\\') {
                    if (quote != '\u0000') {
                        if (quote == cc) {
                            quote = '\u0000';
                        }
                    } else if (cc == '\'' || cc == '\"') {
                        quote = cc;
                    } else if (cc == ';') {
                        char c2;
                        for (l = Strings.skipWhitespaces((CharSequence)action, (int)(k + 1)); l < len && ((c2 = action.charAt(l)) >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z'); ++l) {
                        }
                        if ((l = Strings.skipWhitespaces((CharSequence)action, (int)l)) >= len) {
                            k = len;
                            break;
                        }
                        if (action.charAt(l) == ':') {
                            ++k;
                            break;
                        }
                        k = l - 1;
                    }
                }
                ++k;
            }
            String val = action.substring(j, k).trim();
            if (val.length() > 0) {
                String nm = actnm.toLowerCase();
                if ("onshow".equals(nm) || "onhide".equals(nm)) {
                    actnm = "z.c" + nm;
                }
                map.put(actnm, val);
            }
            if (l >= len) {
                return map;
            }
            j = k;
            k = l;
        }
    }

    private final String toJavaScript(String action) {
        return action != null ? ComponentsCtrl.parseClientScript((Component)this, (String)action) : null;
    }

    static {
        new ColSizeCommand("onColSize", 0);
        new PagingCommand("onPaging", 1);
        new PageSizeCommand("onPageSize", 1);
    }
}

