/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.web.servlet.dsp;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.zkoss.io.Files;
import org.zkoss.lang.Exceptions;
import org.zkoss.util.logging.Log;
import org.zkoss.util.resource.Loader;
import org.zkoss.util.resource.Locator;
import org.zkoss.util.resource.ResourceCache;
import org.zkoss.web.servlet.Charsets;
import org.zkoss.web.servlet.Servlets;
import org.zkoss.web.servlet.dsp.Interpretation;
import org.zkoss.web.servlet.dsp.Interpreter;
import org.zkoss.web.servlet.dsp.ServletDspContext;
import org.zkoss.web.servlet.http.Https;
import org.zkoss.web.util.resource.ClassWebResource;
import org.zkoss.web.util.resource.ResourceCaches;
import org.zkoss.web.util.resource.ResourceLoader;
import org.zkoss.xel.taglib.Taglibs;

public class InterpreterServlet
extends HttpServlet {
    private static final Log log = Log.lookup((Class)InterpreterServlet.class);
    private ServletContext _ctx;
    private String _charset = "UTF-8";
    private Locator _locator;
    private boolean _compress = true;
    private static final String ATTR_PAGE_CACHE = "org.zkoss.web.servlet.dsp.PageCache";

    public void init(ServletConfig config) throws ServletException {
        this._ctx = config.getServletContext();
        String param = config.getInitParameter("compress");
        if (param != null) {
            this._compress = "true".equals(param);
        }
        param = config.getInitParameter("class-resource");
        final boolean bClsRes = "true".equals(param);
        this._locator = new Locator(){

            public String getDirectory() {
                return null;
            }

            public URL getResource(String name) {
                URL url = null;
                if (name.indexOf("://") < 0) {
                    try {
                        url = InterpreterServlet.this._ctx.getResource(name);
                        if (bClsRes && url == null) {
                            url = ClassWebResource.getResource(name);
                        }
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
                return url != null ? url : Taglibs.getDefaultURL((String)name);
            }

            public InputStream getResourceAsStream(String name) {
                InputStream is = InterpreterServlet.this._ctx.getResourceAsStream(name);
                return !bClsRes || is != null ? is : ClassWebResource.getResourceAsStream(name);
            }
        };
        param = config.getInitParameter("charset");
        if (param != null) {
            this._charset = param.length() > 0 ? param : null;
        }
    }

    public ServletContext getServletContext() {
        return this._ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String path = Https.getThisServletPath((ServletRequest)request);
        if (log.debugable()) {
            log.debug("Get " + path);
        }
        Object old = Charsets.setup((ServletRequest)request, (ServletResponse)response, this._charset);
        try {
            Interpretation cnt = (Interpretation)ResourceCaches.get(this.getCache(), this._ctx, path, null);
            if (cnt == null) {
                if (Https.isIncluded((ServletRequest)request)) {
                    log.error("Not found: " + path);
                }
                response.sendError(404, path);
                return;
            }
            boolean compress = this._compress && !Servlets.isIncluded((ServletRequest)request);
            StringWriter out = compress ? new StringWriter() : null;
            cnt.interpret(new ServletDspContext(this._ctx, request, response, out, null));
            if (compress) {
                String result = out.toString();
                try {
                    byte[] bs;
                    ServletOutputStream os = response.getOutputStream();
                    byte[] data = result.getBytes("UTF-8");
                    if (data.length > 200 && (bs = Https.gzip(request, response, null, data)) != null) {
                        data = bs;
                    }
                    response.setContentLength(data.length);
                    os.write(data);
                    response.flushBuffer();
                }
                catch (IllegalStateException ex) {
                    response.getWriter().write(result);
                }
            }
        }
        finally {
            Charsets.cleanup((ServletRequest)request, old);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ResourceCache getCache() {
        ResourceCache cache = (ResourceCache)this._ctx.getAttribute(ATTR_PAGE_CACHE);
        if (cache == null) {
            Class clazz = InterpreterServlet.class;
            synchronized (clazz) {
                cache = (ResourceCache)this._ctx.getAttribute(ATTR_PAGE_CACHE);
                if (cache == null) {
                    cache = new ResourceCache((Loader)new MyLoader(), 29);
                    cache.setMaxSize(1024);
                    cache.setLifetime(3600000);
                    this._ctx.setAttribute(ATTR_PAGE_CACHE, (Object)cache);
                }
            }
        }
        return cache;
    }

    private class MyLoader
    extends ResourceLoader {
        private MyLoader() {
        }

        protected Object parse(String path, File file, Object extra) throws Exception {
            try {
                return this.parse0(new FileInputStream(file), Interpreter.getContentType(file.getName()));
            }
            catch (Exception ex) {
                if (log.debugable()) {
                    log.realCauseBriefly("Failed to parse " + file, (Throwable)ex);
                } else {
                    log.error("Failed to parse " + file + "\nCause: " + Exceptions.getMessage((Throwable)ex) + "\n" + Exceptions.getBriefStackTrace((Throwable)ex));
                }
                return null;
            }
        }

        protected Object parse(String path, URL url, Object extra) throws Exception {
            try {
                return this.parse0(url.openStream(), Interpreter.getContentType(url.getPath()));
            }
            catch (Exception ex) {
                if (log.debugable()) {
                    log.realCauseBriefly("Failed to parse " + url, (Throwable)ex);
                } else {
                    log.error("Failed to parse " + url + "\nCause: " + Exceptions.getMessage((Throwable)ex));
                }
                return null;
            }
        }

        private Object parse0(InputStream is, String ctype) throws Exception {
            if (is == null) {
                return null;
            }
            String content = Files.readAll((Reader)new InputStreamReader(is, "UTF-8")).toString();
            return new Interpreter().parse(content, ctype, null, InterpreterServlet.this._locator);
        }
    }
}

