/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.web.servlet.dsp.action;

import java.io.IOException;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.zkoss.web.mesg.MWeb;
import org.zkoss.web.servlet.ServletException;
import org.zkoss.web.servlet.dsp.action.AbstractAction;
import org.zkoss.web.servlet.dsp.action.ActionContext;
import org.zkoss.web.servlet.dsp.action.LoopStatus;

public class ForEach
extends AbstractAction {
    private String _var;
    private String _varStatus;
    private Object _items;
    private int _beg = 0;
    private int _end = Integer.MAX_VALUE;
    private boolean _trim = true;
    private boolean _endSpecified;
    private boolean _itemsSpecified;

    public String getVar() {
        return this._var;
    }

    public void setVar(String var) {
        this._var = var;
    }

    public String getVarStatus() {
        return this._varStatus;
    }

    public void setVarStatus(String varStatus) {
        this._varStatus = varStatus;
    }

    public Object getItems() {
        return this._items;
    }

    public void setItems(Object items) {
        this._items = items;
        this._itemsSpecified = true;
    }

    public int getBegin() {
        return this._beg;
    }

    public void setBegin(int beg) {
        if (beg < 0) {
            throw new IllegalArgumentException("Non-negative only");
        }
        this._beg = beg;
    }

    public int getEnd() {
        return this._end;
    }

    public void setEnd(int end) {
        this._end = end;
        this._endSpecified = true;
    }

    public boolean isTrim() {
        return this._trim;
    }

    public void setTrim(boolean trim) {
        this._trim = trim;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void render(ActionContext ac, boolean nested) throws javax.servlet.ServletException, IOException {
        Status st;
        Object old2;
        Object old1;
        if (!nested || this._itemsSpecified && this._items == null || this._endSpecified && this._end < this._beg || !this._itemsSpecified && !this._endSpecified || !this.isEffective()) {
            return;
        }
        Object object = this._var != null ? ac.getAttribute(this._var, 0) : (old1 = null);
        if (this._varStatus != null) {
            old2 = ac.getAttribute(this._varStatus, 0);
            st = new Status();
            ac.setAttribute(this._varStatus, st, 0);
        } else {
            old2 = null;
            st = null;
        }
        if (this._items == null) {
            this.renderWith(ac, st);
        } else if (this._items.getClass().isArray()) {
            if (this._items instanceof Object[]) {
                this.renderWith(ac, st, (Object[])this._items);
            } else if (this._items instanceof int[]) {
                this.renderWith(ac, st, (int[])this._items);
            } else if (this._items instanceof short[]) {
                this.renderWith(ac, st, (short[])this._items);
            } else if (this._items instanceof long[]) {
                this.renderWith(ac, st, (long[])this._items);
            } else if (this._items instanceof byte[]) {
                this.renderWith(ac, st, (byte[])this._items);
            } else if (this._items instanceof char[]) {
                this.renderWith(ac, st, (char[])this._items);
            } else if (this._items instanceof double[]) {
                this.renderWith(ac, st, (double[])this._items);
            } else {
                if (!(this._items instanceof float[])) throw new InternalError("Unknown " + this._items.getClass());
                this.renderWith(ac, st, (float[])this._items);
            }
        } else if (this._beg > 0 && this._items instanceof List) {
            List l;
            int size = (l = (List)this._items).size();
            this.renderWith(ac, st, l.listIterator(this._beg > size ? size : this._beg));
        } else if (this._items instanceof Collection) {
            this.renderWith(ac, st, ((Collection)this._items).iterator());
        } else if (this._items instanceof Map) {
            this.renderWith(ac, st, ((Map)this._items).entrySet().iterator());
        } else if (this._items instanceof Iterator) {
            this.renderWith(ac, st, (Iterator)this._items);
        } else if (this._items instanceof Enumeration) {
            this.renderWith(ac, st, (Enumeration)this._items);
        } else {
            if (!(this._items instanceof String)) throw new ServletException(MWeb.DSP_UNKNOWN_ATTRIBUTE_VALUE, new Object[]{this, "items", new Integer(ac.getLineNumber())});
            this.renderWith(ac, st, (String)this._items);
        }
        if (this._var != null) {
            ac.setAttribute(this._var, old1, 0);
        }
        if (this._varStatus == null) return;
        ac.setAttribute(this._varStatus, old2, 0);
    }

    private void renderWith(ActionContext ac, Status st) throws javax.servlet.ServletException, IOException {
        StringWriter out = this._trim ? new StringWriter() : null;
        for (int j = this._beg; j <= this._end; ++j) {
            Integer val = new Integer(j);
            if (this._var != null) {
                ac.setAttribute(this._var, val, 0);
            }
            if (st != null) {
                st.update(j, val);
            }
            ac.renderFragment(out);
        }
        if (out != null) {
            ac.getOut().write(out.toString().trim());
        }
    }

    private void renderWith(ActionContext ac, Status st, ListIterator it) throws javax.servlet.ServletException, IOException {
        StringWriter out = this._trim ? new StringWriter() : null;
        int j = 0;
        int cnt = this._end - this._beg + 1;
        while (it.hasNext() && --cnt >= 0) {
            Object val = it.next();
            if (this._var != null) {
                ac.setAttribute(this._var, val, 0);
            }
            if (st != null) {
                st.update(j, val);
            }
            ac.renderFragment(out);
            ++j;
        }
        if (out != null) {
            ac.getOut().write(out.toString().trim());
        }
    }

    private void renderWith(ActionContext ac, Status st, Iterator it) throws javax.servlet.ServletException, IOException {
        StringWriter out = this._trim ? new StringWriter() : null;
        int j = 0;
        while (++j <= this._beg && it.hasNext()) {
            it.next();
        }
        j = 0;
        int cnt = this._end - this._beg + 1;
        while (it.hasNext() && --cnt >= 0) {
            Object val = it.next();
            if (this._var != null) {
                ac.setAttribute(this._var, val, 0);
            }
            if (st != null) {
                st.update(j, val);
            }
            ac.renderFragment(out);
            ++j;
        }
        if (out != null) {
            ac.getOut().write(out.toString().trim());
        }
    }

    private void renderWith(ActionContext ac, Status st, Enumeration enm) throws javax.servlet.ServletException, IOException {
        StringWriter out = this._trim ? new StringWriter() : null;
        int j = 0;
        while (++j <= this._beg && enm.hasMoreElements()) {
            enm.nextElement();
        }
        j = 0;
        int cnt = this._end - this._beg + 1;
        while (enm.hasMoreElements() && --cnt >= 0) {
            Object val = enm.nextElement();
            if (this._var != null) {
                ac.setAttribute(this._var, val, 0);
            }
            if (st != null) {
                st.update(j, val);
            }
            ac.renderFragment(out);
            ++j;
        }
        if (out != null) {
            ac.getOut().write(out.toString().trim());
        }
    }

    private void renderWith(ActionContext ac, Status st, Object[] ary) throws javax.servlet.ServletException, IOException {
        StringWriter out = this._trim ? new StringWriter() : null;
        for (int j = this._beg; j < ary.length && j <= this._end; ++j) {
            Object val = ary[j];
            if (this._var != null) {
                ac.setAttribute(this._var, val, 0);
            }
            if (st != null) {
                st.update(j, val);
            }
            ac.renderFragment(out);
        }
        if (out != null) {
            ac.getOut().write(out.toString().trim());
        }
    }

    private void renderWith(ActionContext ac, Status st, int[] ary) throws javax.servlet.ServletException, IOException {
        StringWriter out = this._trim ? new StringWriter() : null;
        for (int j = this._beg; j < ary.length && j <= this._end; ++j) {
            Integer val = new Integer(ary[j]);
            if (this._var != null) {
                ac.setAttribute(this._var, val, 0);
            }
            if (st != null) {
                st.update(j, val);
            }
            ac.renderFragment(out);
        }
        if (out != null) {
            ac.getOut().write(out.toString().trim());
        }
    }

    private void renderWith(ActionContext ac, Status st, short[] ary) throws javax.servlet.ServletException, IOException {
        StringWriter out = this._trim ? new StringWriter() : null;
        for (int j = this._beg; j < ary.length && j <= this._end; ++j) {
            Short val = new Short(ary[j]);
            if (this._var != null) {
                ac.setAttribute(this._var, val, 0);
            }
            if (st != null) {
                st.update(j, val);
            }
            ac.renderFragment(out);
        }
        if (out != null) {
            ac.getOut().write(out.toString().trim());
        }
    }

    private void renderWith(ActionContext ac, Status st, long[] ary) throws javax.servlet.ServletException, IOException {
        StringWriter out = this._trim ? new StringWriter() : null;
        for (int j = this._beg; j < ary.length && j <= this._end; ++j) {
            Long val = new Long(ary[j]);
            if (this._var != null) {
                ac.setAttribute(this._var, val, 0);
            }
            if (st != null) {
                st.update(j, val);
            }
            ac.renderFragment(out);
        }
        if (out != null) {
            ac.getOut().write(out.toString().trim());
        }
    }

    private void renderWith(ActionContext ac, Status st, char[] ary) throws javax.servlet.ServletException, IOException {
        StringWriter out = this._trim ? new StringWriter() : null;
        for (int j = this._beg; j < ary.length && j <= this._end; ++j) {
            Character val = new Character(ary[j]);
            if (this._var != null) {
                ac.setAttribute(this._var, val, 0);
            }
            if (st != null) {
                st.update(j, val);
            }
            ac.renderFragment(out);
        }
        if (out != null) {
            ac.getOut().write(out.toString().trim());
        }
    }

    private void renderWith(ActionContext ac, Status st, byte[] ary) throws javax.servlet.ServletException, IOException {
        StringWriter out = this._trim ? new StringWriter() : null;
        for (int j = this._beg; j < ary.length && j <= this._end; ++j) {
            Byte val = new Byte(ary[j]);
            if (this._var != null) {
                ac.setAttribute(this._var, val, 0);
            }
            if (st != null) {
                st.update(j, val);
            }
            ac.renderFragment(out);
        }
        if (out != null) {
            ac.getOut().write(out.toString().trim());
        }
    }

    private void renderWith(ActionContext ac, Status st, float[] ary) throws javax.servlet.ServletException, IOException {
        StringWriter out = this._trim ? new StringWriter() : null;
        for (int j = this._beg; j < ary.length && j <= this._end; ++j) {
            Float val = new Float(ary[j]);
            if (this._var != null) {
                ac.setAttribute(this._var, val, 0);
            }
            if (st != null) {
                st.update(j, val);
            }
            ac.renderFragment(out);
        }
        if (out != null) {
            ac.getOut().write(out.toString().trim());
        }
    }

    private void renderWith(ActionContext ac, Status st, double[] ary) throws javax.servlet.ServletException, IOException {
        StringWriter out = this._trim ? new StringWriter() : null;
        for (int j = this._beg; j < ary.length && j <= this._end; ++j) {
            Double val = new Double(ary[j]);
            if (this._var != null) {
                ac.setAttribute(this._var, val, 0);
            }
            if (st != null) {
                st.update(j, val);
            }
            ac.renderFragment(out);
        }
        if (out != null) {
            ac.getOut().write(out.toString().trim());
        }
    }

    private void renderWith(ActionContext ac, Status st, String txt) throws javax.servlet.ServletException, IOException {
        StringBuffer sb = new StringBuffer();
        int idx = 0;
        StringWriter out = this._trim ? new StringWriter() : null;
        int len = txt.length();
        for (int j = this._beg; j < len && j <= this._end; ++j) {
            int cc = txt.charAt(j);
            if (cc == 44) {
                String val = sb.toString();
                if (this._var != null) {
                    ac.setAttribute(this._var, val, 0);
                }
                if (st != null) {
                    st.update(idx++, val);
                }
                ac.renderFragment(out);
                sb.setLength(0);
            } else if (cc == 92 && j + 1 < len) {
                cc = txt.charAt(j + 1);
                switch (cc) {
                    case 110: {
                        cc = 10;
                        break;
                    }
                    case 114: {
                        cc = 13;
                        break;
                    }
                    case 116: {
                        cc = 9;
                        break;
                    }
                    case 98: {
                        cc = 8;
                    }
                }
            }
            sb.append((char)cc);
        }
        if (sb.length() > 0) {
            String val = sb.toString();
            if (this._var != null) {
                ac.setAttribute(this._var, val, 0);
            }
            if (st != null) {
                st.update(idx++, val);
            }
            ac.renderFragment(out);
        }
        if (out != null) {
            ac.getOut().write(out.toString().trim());
        }
    }

    public String toString() {
        return "forEach";
    }

    private static class Status
    implements LoopStatus {
        private int _j;
        private Object _cur;

        private Status() {
        }

        public int getIndex() {
            return this._j;
        }

        public Object getCurrent() {
            return this._cur;
        }

        private void update(int j, Object cur) {
            this._j = j;
            this._cur = cur;
        }
    }
}

