/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.web.servlet.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.zkoss.io.Files;
import org.zkoss.lang.SystemException;
import org.zkoss.util.logging.Log;
import org.zkoss.web.servlet.Servlets;
import org.zkoss.web.util.resource.ExtendletContext;

public class Https
extends Servlets {
    private static final Log log = Log.lookup((Class)Https.class);
    private static final SimpleDateFormat[] _dateFmts = new SimpleDateFormat[]{new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEEEEE, dd-MMM-yy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEE MMMM d HH:mm:ss yyyy", Locale.US)};

    public static final byte[] gzip(HttpServletRequest request, HttpServletResponse response, InputStream content1, byte[] content2) throws IOException {
        String ae = request.getHeader("accept-encoding");
        if (ae != null && !response.containsHeader("Content-Encoding") && ae.indexOf("gzip") >= 0) {
            response.addHeader("Content-Encoding", "gzip");
            ByteArrayOutputStream boas = new ByteArrayOutputStream(8192);
            GZIPOutputStream gzs = new GZIPOutputStream(boas);
            if (content1 != null) {
                Files.copy((OutputStream)gzs, (InputStream)content1);
            }
            if (content2 != null) {
                gzs.write(content2);
            }
            gzs.finish();
            return boas.toByteArray();
        }
        return null;
    }

    public static final String getCompleteServerName(HttpServletRequest hreq) {
        String ctx;
        StringBuffer sb = hreq.getRequestURL();
        int j = sb.indexOf(ctx = hreq.getContextPath());
        if (j < 0) {
            throw new SystemException("Unknown request: url=" + sb + ", ctx=" + ctx);
        }
        return sb.delete(j, sb.length()).toString();
    }

    public static final String getCompleteContext(HttpServletRequest hreq) {
        String ctx;
        StringBuffer sb = hreq.getRequestURL();
        int j = sb.indexOf(ctx = hreq.getContextPath());
        if (j < 0) {
            throw new SystemException("Unknown request: url=" + sb + ", ctx=" + ctx);
        }
        return sb.delete(j + ctx.length(), sb.length()).toString();
    }

    public static final String getCookieValue(HttpServletRequest request, String name) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            int j = cookies.length;
            while (--j >= 0) {
                if (!cookies[j].getName().equals(name)) continue;
                return cookies[j].getValue();
            }
        }
        return null;
    }

    public static final String getServletURI(HttpServletRequest request) {
        String sp = request.getServletPath();
        String pi = request.getPathInfo();
        if (pi == null || pi.length() == 0) {
            return sp;
        }
        if (sp.length() == 0) {
            return pi;
        }
        return sp + pi;
    }

    public static final String getThisContextPath(ServletRequest request) {
        String path = (String)request.getAttribute("javax.servlet.include.context_path");
        return path != null ? path : (request instanceof HttpServletRequest ? ((HttpServletRequest)request).getContextPath() : "");
    }

    public static final String getThisServletPath(ServletRequest request) {
        String path = (String)request.getAttribute("javax.servlet.include.servlet_path");
        return path != null ? path : (request instanceof HttpServletRequest ? ((HttpServletRequest)request).getServletPath() : "/");
    }

    public static final String getThisRequestURI(ServletRequest request) {
        String path = (String)request.getAttribute("javax.servlet.include.request_uri");
        return path != null ? path : (request instanceof HttpServletRequest ? ((HttpServletRequest)request).getRequestURI() : "/");
    }

    public static final String getThisQueryString(ServletRequest request) {
        String path = (String)request.getAttribute("javax.servlet.include.query_string");
        return path != null || Https.isIncluded(request) || !(request instanceof HttpServletRequest) ? path : ((HttpServletRequest)request).getQueryString();
    }

    public static final String getThisPathInfo(ServletRequest request) {
        String path = (String)request.getAttribute("javax.servlet.include.path_info");
        return path != null || Https.isIncluded(request) || !(request instanceof HttpServletRequest) ? path : ((HttpServletRequest)request).getPathInfo();
    }

    public static final String getOriginContextPath(ServletRequest request) {
        String path = (String)request.getAttribute("javax.servlet.forward.context_path");
        return path != null ? path : (request instanceof HttpServletRequest ? ((HttpServletRequest)request).getContextPath() : "");
    }

    public static final String getOriginServletPath(ServletRequest request) {
        String path = (String)request.getAttribute("javax.servlet.forward.servlet_path");
        return path != null ? path : (request instanceof HttpServletRequest ? ((HttpServletRequest)request).getServletPath() : "/");
    }

    public static final String getOriginRequestURI(ServletRequest request) {
        String path = (String)request.getAttribute("javax.servlet.forward.request_uri");
        return path != null ? path : (request instanceof HttpServletRequest ? ((HttpServletRequest)request).getRequestURI() : "/");
    }

    public static final String getOriginPathInfo(ServletRequest request) {
        String path = (String)request.getAttribute("javax.servlet.forward.query_string");
        return path != null ? path : (Https.isForwarded(request) ? null : (request instanceof HttpServletRequest ? ((HttpServletRequest)request).getQueryString() : null));
    }

    public static final String getOriginQueryString(ServletRequest request) {
        String path = (String)request.getAttribute("javax.servlet.forward.path_info");
        return path != null ? path : (Https.isForwarded(request) ? null : (request instanceof HttpServletRequest ? ((HttpServletRequest)request).getPathInfo() : null));
    }

    public static final String getOriginFullServlet(ServletRequest request) {
        String qstr = Https.getOriginQueryString(request);
        String pi = Https.getOriginPathInfo(request);
        if (qstr == null && pi == null) {
            return Https.getOriginServletPath(request);
        }
        StringBuffer sb = new StringBuffer(80).append(Https.getOriginServletPath(request));
        if (pi != null) {
            sb.append(pi);
        }
        if (qstr != null) {
            sb.append('?').append(qstr);
        }
        return sb.toString();
    }

    public static final String getOriginFullRequest(ServletRequest request) {
        String qstr = Https.getOriginQueryString(request);
        return qstr != null ? Https.getOriginRequestURI(request) + '?' + qstr : Https.getOriginRequestURI(request);
    }

    public static final void sendRedirect(ServletContext ctx, HttpServletRequest request, HttpServletResponse response, String uri, Map params, int mode) throws IOException, ServletException {
        String encodedUrl = Https.encodeRedirectURL(ctx, request, response, uri, params, mode);
        if (log.debugable()) {
            log.debug("redirect to " + encodedUrl);
        }
        response.sendRedirect(encodedUrl);
    }

    public static final String encodeRedirectURL(ServletContext ctx, HttpServletRequest request, HttpServletResponse response, String uri, Map params, int mode) {
        if (uri == null) {
            uri = request.getContextPath() + Https.getOriginFullServlet((ServletRequest)request);
        } else {
            int len = uri.length();
            if (len == 0 || uri.charAt(0) == '/') {
                uri = request.getContextPath() + uri;
            } else if (uri.charAt(0) == '~') {
                int j = uri.indexOf(47, 1);
                String ctxroot = j >= 0 ? "/" + uri.substring(1, j) : "/" + uri.substring(1);
                ExtendletContext extctx = Servlets.getExtendletContext(ctx, ctxroot.substring(1));
                if (extctx != null) {
                    uri = j >= 0 ? uri.substring(j) : "/";
                    return extctx.encodeRedirectURL(request, response, uri, params, mode);
                }
                uri = len >= 2 && uri.charAt(1) == '/' ? uri.substring(1) : '/' + uri.substring(1);
            }
        }
        return response.encodeRedirectURL(Https.generateURI(uri, params, mode));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Date toDate(String sdate) throws ParseException {
        int j = 0;
        while (true) {
            try {
                SimpleDateFormat simpleDateFormat = _dateFmts[j];
                synchronized (simpleDateFormat) {
                    return _dateFmts[j].parse(sdate);
                }
            }
            catch (ParseException ex) {
                if (++j != _dateFmts.length) continue;
                throw ex;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String toString(Date date) {
        SimpleDateFormat simpleDateFormat = _dateFmts[0];
        synchronized (simpleDateFormat) {
            return _dateFmts[0].format(date);
        }
    }
}

