/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.au;

import java.util.HashMap;
import java.util.Map;
import org.zkoss.zk.au.Command;
import org.zkoss.zk.au.CommandNotFoundException;
import org.zkoss.zk.au.in.BookmarkChangedCommand;
import org.zkoss.zk.au.in.CheckCommand;
import org.zkoss.zk.au.in.ClientInfoCommand;
import org.zkoss.zk.au.in.DropCommand;
import org.zkoss.zk.au.in.DummyCommand;
import org.zkoss.zk.au.in.EchoCommand;
import org.zkoss.zk.au.in.ErrorCommand;
import org.zkoss.zk.au.in.GenericCommand;
import org.zkoss.zk.au.in.GetUploadInfoCommand;
import org.zkoss.zk.au.in.InnerWidthCommand;
import org.zkoss.zk.au.in.InputCommand;
import org.zkoss.zk.au.in.KeyCommand;
import org.zkoss.zk.au.in.MouseCommand;
import org.zkoss.zk.au.in.MoveCommand;
import org.zkoss.zk.au.in.OpenCommand;
import org.zkoss.zk.au.in.RedrawCommand;
import org.zkoss.zk.au.in.RemoveCommand;
import org.zkoss.zk.au.in.RemoveDesktopCommand;
import org.zkoss.zk.au.in.RenderCommand;
import org.zkoss.zk.au.in.ScrollCommand;
import org.zkoss.zk.au.in.SelectCommand;
import org.zkoss.zk.au.in.SelectionCommand;
import org.zkoss.zk.au.in.SizeCommand;
import org.zkoss.zk.au.in.TimerCommand;
import org.zkoss.zk.au.in.UpdateResultCommand;
import org.zkoss.zk.au.in.ZIndexCommand;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.ComponentNotFoundException;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.sys.ComponentsCtrl;

public class AuRequest {
    private final Desktop _desktop;
    private Page _page;
    private Component _comp;
    private final String _uuid;
    private final Command _cmd;
    private final String[] _data;
    private static final Map _cmds = new HashMap();

    public static final boolean hasRequest(String cmdnm) {
        return _cmds.containsKey(cmdnm);
    }

    public static final Command getCommand(String name) {
        Command cmd = (Command)_cmds.get(name);
        if (cmd == null) {
            throw new CommandNotFoundException("Unknown command: " + name);
        }
        return cmd;
    }

    static final void addCommand(Command cmd) {
        if (_cmds.put(cmd.getId(), cmd) != null) {
            throw new InternalError("Replicated command: " + cmd);
        }
    }

    public AuRequest(Desktop desktop, String uuid, Command cmd, String[] data) {
        if (desktop == null || uuid == null || cmd == null) {
            throw new IllegalArgumentException("null");
        }
        this._desktop = desktop;
        this._uuid = uuid;
        this._cmd = cmd;
        this._data = data;
    }

    public AuRequest(Desktop desktop, Command cmd, String[] data) {
        if (desktop == null || cmd == null) {
            throw new IllegalArgumentException("null");
        }
        this._desktop = desktop;
        this._uuid = null;
        this._cmd = cmd;
        this._data = data;
    }

    public final Desktop getDesktop() {
        return this._desktop;
    }

    public final Page getPage() {
        this.init();
        return this._page;
    }

    private void init() {
        if (this._page == null && this._uuid != null) {
            this._comp = this._desktop.getComponentByUuidIfAny(this._uuid);
            if (this._comp != null) {
                this._page = this._comp.getPage();
            } else if (!ComponentsCtrl.isUuid(this._uuid)) {
                this._page = this._desktop.getPage(this._uuid);
            } else {
                throw new ComponentNotFoundException("Component not found: " + this._uuid);
            }
        }
    }

    public final Component getComponent() {
        this.init();
        return this._comp;
    }

    public final String getComponentUuid() {
        return this._uuid != null ? this._uuid : (this._comp != null ? this._comp.getUuid() : null);
    }

    public final Command getCommand() {
        return this._cmd;
    }

    public final String[] getData() {
        return this._data;
    }

    public final boolean equals(Object o) {
        return this == o;
    }

    public String toString() {
        if (this._uuid != null) {
            return "[uuid=" + this._uuid + ", cmd=" + this._cmd + ']';
        }
        if (this._comp != null) {
            return "[comp=" + this._comp + ", cmd=" + this._cmd + ']';
        }
        return "[page=" + this._page + ", cmd=" + this._cmd + ']';
    }

    static {
        new BookmarkChangedCommand("onBookmarkChanged", 8);
        new CheckCommand("onCheck", 0);
        new ClientInfoCommand("onClientInfo", 8);
        new UpdateResultCommand("updateResult", 0);
        new DropCommand("onDrop", 0);
        new DummyCommand("dummy", 11);
        new EchoCommand("echo", 1);
        new ErrorCommand("onError", 8);
        new GenericCommand("onBlur", 8);
        new GenericCommand("onClose", 0);
        new GenericCommand("onFocus", 8);
        new GenericCommand("onNotify", 0);
        new GenericCommand("onSort", 9);
        new TimerCommand("onTimer", 8);
        new GenericCommand("onUser", 0);
        new GetUploadInfoCommand("getUploadInfo", 2);
        new InputCommand("onChange", 16);
        new InputCommand("onChanging", 3);
        new KeyCommand("onCancel", 5);
        new KeyCommand("onCtrlKey", 5);
        new KeyCommand("onOK", 5);
        new MoveCommand("onMove", 8);
        new SizeCommand("onSize", 8);
        new InnerWidthCommand("onInnerWidth", 8);
        new MouseCommand("onClick", 5);
        new MouseCommand("onDoubleClick", 5);
        new MouseCommand("onRightClick", 5);
        new OpenCommand("onOpen", 0);
        new RemoveCommand("remove", 0);
        new RedrawCommand("redraw", 0);
        new RemoveDesktopCommand("rmDesktop", 0);
        new RenderCommand("onRender", 8);
        new ScrollCommand("onScrolling", 3);
        new ScrollCommand("onScroll", 16);
        new SelectCommand("onSelect", 0);
        new SelectionCommand("onSelection", 8);
        new ZIndexCommand("onZIndex", 8);
    }
}

