/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.au.http;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.LinkedList;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.zkoss.io.Files;
import org.zkoss.lang.Exceptions;
import org.zkoss.mesg.Messages;
import org.zkoss.util.logging.Log;
import org.zkoss.util.media.Media;
import org.zkoss.zk.au.http.AuProcessor;
import org.zkoss.zk.mesg.MZk;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.ComponentNotFoundException;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.ext.render.DynamicMedia;
import org.zkoss.zk.ui.http.ExecutionImpl;
import org.zkoss.zk.ui.sys.ComponentCtrl;
import org.zkoss.zk.ui.sys.DesktopCtrl;
import org.zkoss.zk.ui.sys.UiEngine;
import org.zkoss.zk.ui.sys.WebAppCtrl;
import org.zkoss.zk.ui.util.Configuration;

public class AuDynaMediar
implements AuProcessor {
    private static final Log log = Log.lookup((Class)AuDynaMediar.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Session sess, ServletContext ctx, HttpServletRequest request, HttpServletResponse response, String pi) throws ServletException, IOException {
        Object out;
        Media media;
        int l;
        int j = pi.indexOf(47, 1) + 1;
        int k = pi.indexOf(47, j);
        if (j <= 0 || k <= 0) {
            throw new ServletException("Wrong path info: " + pi);
        }
        String dtid = pi.substring(j, k);
        String uuid = (l = pi.indexOf(47, ++k)) >= 0 ? pi.substring(k, l) : pi.substring(k);
        boolean download = false;
        try {
            WebApp wapp = sess.getWebApp();
            WebAppCtrl wappc = (WebAppCtrl)((Object)wapp);
            UiEngine uieng = wappc.getUiEngine();
            Desktop desktop = wappc.getDesktopCache(sess).getDesktop(dtid);
            Execution oldexec = Executions.getCurrent();
            ExecutionImpl exec = new ExecutionImpl(ctx, request, response, desktop, null);
            uieng.activate(exec);
            Configuration config = wapp.getConfiguration();
            boolean err = false;
            try {
                config.invokeExecutionInits(exec, oldexec);
                media = ((DesktopCtrl)((Object)desktop)).getDownloadMedia(uuid, true);
                if (media != null) {
                    download = true;
                } else {
                    Component comp = desktop.getComponentByUuid(uuid);
                    Object cc = ((ComponentCtrl)((Object)comp)).getExtraCtrl();
                    if (!(cc instanceof DynamicMedia)) {
                        throw new ServletException(DynamicMedia.class + " must be implemented by getExtraCtrl() of " + comp);
                    }
                    media = ((DynamicMedia)cc).getMedia(l >= 0 ? pi.substring(l) : "");
                    if (media == null) {
                        response.sendError(410, "Media not found in " + comp);
                        return;
                    }
                }
            }
            catch (Throwable ex) {
                err = true;
                LinkedList<Throwable> errs = new LinkedList<Throwable>();
                errs.add(ex);
                config.invokeExecutionCleanups(exec, oldexec, errs);
                StringBuffer errmsg = new StringBuffer(100);
                if (!errs.isEmpty()) {
                    Iterator it = errs.iterator();
                    while (it.hasNext()) {
                        Throwable t = (Throwable)it.next();
                        if (t == ex) {
                            log.error("Failed to load the media.", t);
                        }
                        errmsg.append('\n').append(Exceptions.getMessage((Throwable)t));
                    }
                }
                response.sendError(410, "Failed to load the media." + errmsg);
                return;
            }
            finally {
                if (!err) {
                    config.invokeExecutionCleanups(exec, oldexec, null);
                }
                uieng.deactivate(exec);
            }
        }
        catch (ComponentNotFoundException ex) {
            response.sendError(410, Messages.get((int)MZk.UPDATE_OBSOLETE_PAGE, (Object)uuid));
            return;
        }
        String ctype = media.getContentType();
        if (ctype != null) {
            response.setContentType(ctype);
        }
        if (download) {
            String value = "attachment";
            String flnm = media.getName();
            if (flnm != null && flnm.length() > 0) {
                value = value + ";filename=\"" + URLEncoder.encode(flnm, "UTF-8") + '\"';
            }
            response.setHeader("Content-Disposition", value);
        }
        if (!media.inMemory()) {
            Closeable in;
            if (media.isBinary()) {
                out = response.getOutputStream();
                in = media.getStreamData();
                try {
                    Files.copy((OutputStream)out, (InputStream)in);
                }
                finally {
                    ((InputStream)in).close();
                }
                out.flush();
            } else {
                out = response.getWriter();
                in = media.getReaderData();
                try {
                    Files.copy((Writer)out, (Reader)in);
                }
                finally {
                    ((Reader)in).close();
                }
                ((Writer)out).flush();
            }
            return;
        }
        out = response.getOutputStream();
        byte[] data = media.isBinary() ? media.getByteData() : media.getStringData().getBytes("UTF-8");
        response.setContentLength(data.length);
        out.write(data);
        out.flush();
    }
}

