/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.au.http;

import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Exceptions;
import org.zkoss.mesg.Messages;
import org.zkoss.util.logging.Log;
import org.zkoss.web.servlet.Charsets;
import org.zkoss.web.servlet.Servlets;
import org.zkoss.web.servlet.http.Encodes;
import org.zkoss.web.servlet.http.Https;
import org.zkoss.web.util.resource.ClassWebResource;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.AuWriter;
import org.zkoss.zk.au.AuWriters;
import org.zkoss.zk.au.Command;
import org.zkoss.zk.au.CommandNotFoundException;
import org.zkoss.zk.au.http.AuDynaMediar;
import org.zkoss.zk.au.http.AuProcessor;
import org.zkoss.zk.au.http.AuUploader;
import org.zkoss.zk.au.out.AuAlert;
import org.zkoss.zk.au.out.AuObsolete;
import org.zkoss.zk.au.out.AuSendRedirect;
import org.zkoss.zk.device.Devices;
import org.zkoss.zk.mesg.MZk;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.http.ExecutionImpl;
import org.zkoss.zk.ui.http.I18Ns;
import org.zkoss.zk.ui.http.WebManager;
import org.zkoss.zk.ui.sys.DesktopCtrl;
import org.zkoss.zk.ui.sys.FailoverManager;
import org.zkoss.zk.ui.sys.SessionCtrl;
import org.zkoss.zk.ui.sys.UiEngine;
import org.zkoss.zk.ui.sys.WebAppCtrl;
import org.zkoss.zk.ui.util.Configuration;
import org.zkoss.zk.ui.util.PerformanceMeter;

public class DHtmlUpdateServlet
extends HttpServlet {
    private static final Log log = Log.lookup((Class)DHtmlUpdateServlet.class);
    private static final String ATTR_UPDATE_SERVLET = "org.zkoss.zk.au.http.UpdateServlet";
    private ServletContext _ctx;
    private long _lastModified;
    private Map _procs = new HashMap(4);
    static /* synthetic */ Class class$org$zkoss$zk$au$http$AuProcessor;

    public static DHtmlUpdateServlet getUpdateServlet(WebApp wapp) {
        return (DHtmlUpdateServlet)((Object)((ServletContext)wapp.getNativeContext()).getAttribute(ATTR_UPDATE_SERVLET));
    }

    public void init(ServletConfig config) throws ServletException {
        String param;
        if (log.debugable()) {
            log.debug("Starting DHtmlUpdateServlet at " + config.getServletContext());
        }
        this._ctx = config.getServletContext();
        int j = 0;
        while ((param = config.getInitParameter("processor" + j++)) != null) {
            int k = param.indexOf(61);
            if (k < 0) {
                log.warning("Ignore init-param: illegal format, " + param);
                continue;
            }
            String prefix = param.substring(0, k).trim();
            String clsnm = param.substring(k + 1).trim();
            try {
                this.addAuProcessor(prefix, (AuProcessor)Classes.newInstanceByThread((String)clsnm));
            }
            catch (ClassNotFoundException ex) {
                log.warning("Ignore init-param: class not found, " + clsnm);
            }
            catch (ClassCastException ex) {
                log.warning("Ignore: " + clsnm + " not implement " + (class$org$zkoss$zk$au$http$AuProcessor == null ? DHtmlUpdateServlet.class$("org.zkoss.zk.au.http.AuProcessor") : class$org$zkoss$zk$au$http$AuProcessor));
            }
            catch (Throwable ex) {
                log.warning("Ignore init-param: failed to add an AU processor, " + param, ex);
            }
        }
        if (this.getAuProcessor("/upload") == null) {
            this.addAuProcessor("/upload", new AuUploader());
        }
        if (this.getAuProcessor("/view") == null) {
            this.addAuProcessor("/view", new AuDynaMediar());
        }
        this._ctx.setAttribute(ATTR_UPDATE_SERVLET, (Object)this);
    }

    public ServletContext getServletContext() {
        return this._ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuProcessor addAuProcessor(String prefix, AuProcessor processor) {
        AuProcessor old;
        if (prefix == null || !prefix.startsWith("/") || prefix.length() < 2 || processor == null) {
            throw new IllegalArgumentException();
        }
        if ("/web".equalsIgnoreCase(prefix)) {
            throw new IllegalArgumentException("/web is reserved");
        }
        if (this._procs.get(prefix) == processor) {
            return processor;
        }
        DHtmlUpdateServlet dHtmlUpdateServlet = this;
        synchronized (dHtmlUpdateServlet) {
            HashMap<String, AuProcessor> ps = new HashMap<String, AuProcessor>(this._procs);
            old = ps.put(prefix, processor);
            this._procs = ps;
        }
        return old;
    }

    public AuProcessor getAuProcessor(String prefix) {
        return (AuProcessor)this._procs.get(prefix);
    }

    protected long getLastModified(HttpServletRequest request) {
        String ext;
        String pi = Https.getThisPathInfo((ServletRequest)request);
        if (pi != null && pi.startsWith("/web") && pi.indexOf(42) < 0 && !Servlets.isIncluded((ServletRequest)request) && ((ext = Servlets.getExtension((String)pi)) == null || this.getClassWebResource().getExtendlet(ext) == null)) {
            if (this._lastModified == 0L) {
                this._lastModified = new Date().getTime();
            }
            return this._lastModified;
        }
        return -1L;
    }

    private ClassWebResource getClassWebResource() {
        return WebManager.getWebManager(this._ctx).getClassWebResource();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block15: {
            boolean withpi;
            String pi = Https.getThisPathInfo((ServletRequest)request);
            Session sess = WebManager.getSession(this._ctx, request, false);
            boolean bl = withpi = pi != null && pi.length() != 0;
            if (withpi && pi.startsWith("/web")) {
                Object old = sess != null ? I18Ns.setup(sess, (ServletRequest)request, (ServletResponse)response, "UTF-8") : Charsets.setup((ServletRequest)request, (ServletResponse)response, (String)"UTF-8");
                try {
                    this.getClassWebResource().service(request, response, pi.substring("/web".length()));
                }
                finally {
                    if (sess != null) {
                        I18Ns.cleanup((ServletRequest)request, old);
                    } else {
                        Charsets.cleanup((ServletRequest)request, (Object)old);
                    }
                }
                return;
            }
            if (sess == null) {
                String dtid;
                if (!withpi && (dtid = request.getParameter("dtid")) != null) {
                    this.sessionTimeout(request, response, dtid, request.getParameter("cmd.0"));
                }
                return;
            }
            Object old = I18Ns.setup(sess, (ServletRequest)request, (ServletResponse)response, "UTF-8");
            try {
                if (withpi) {
                    Iterator it = this._procs.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry me = it.next();
                        if (!pi.startsWith((String)me.getKey())) continue;
                        ((AuProcessor)me.getValue()).process(sess, this._ctx, request, response, pi);
                        return;
                    }
                    log.warning("Unknown path info: " + pi);
                    break block15;
                }
                this.process(sess, request, response);
            }
            finally {
                I18Ns.cleanup((ServletRequest)request, old);
            }
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    protected void process(Session sess, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        WebApp wapp = sess.getWebApp();
        WebAppCtrl wappc = (WebAppCtrl)((Object)wapp);
        UiEngine uieng = wappc.getUiEngine();
        LinkedList<AuRequest> aureqs = new LinkedList<AuRequest>();
        String dtid = request.getParameter("dtid");
        if (dtid == null) {
            return;
        }
        Desktop desktop = wappc.getDesktopCache(sess).getDesktopIfAny(dtid);
        if (desktop == null) {
            String scmd = request.getParameter("cmd.0");
            if (!"rmDesktop".equals(scmd)) {
                desktop = this.recover(sess, request, response, wappc, dtid);
            }
            if (desktop == null) {
                this.sessionTimeout(request, response, dtid, scmd);
                return;
            }
        }
        WebManager.setDesktop(request, desktop);
        Configuration config = wapp.getConfiguration();
        boolean timerKeepAlive = config.isTimerKeepAlive();
        boolean keepAlive = false;
        try {
            String scmd;
            int j = 0;
            while ((scmd = request.getParameter("cmd." + j)) != null) {
                keepAlive = keepAlive || (timerKeepAlive || !"onTimer".equals(scmd)) && !"dummy".equals(scmd);
                Command cmd = AuRequest.getCommand(scmd);
                String uuid = request.getParameter("uuid." + j);
                String[] data = request.getParameterValues("data." + j);
                if (data != null) {
                    int k = data.length;
                    while (--k >= 0) {
                        if (!"zk_null~q".equals(data[k])) continue;
                        data[k] = null;
                    }
                }
                if (uuid == null || uuid.length() == 0) {
                    aureqs.add(new AuRequest(desktop, cmd, data));
                } else {
                    aureqs.add(new AuRequest(desktop, uuid, cmd, data));
                }
                ++j;
            }
        }
        catch (CommandNotFoundException ex) {
            DHtmlUpdateServlet.responseError(request, response, Exceptions.getMessage((Throwable)((Object)ex)));
            return;
        }
        if (aureqs.isEmpty()) {
            DHtmlUpdateServlet.responseError(request, response, "Illegal request: cmd is required");
            return;
        }
        ((SessionCtrl)((Object)sess)).notifyClientRequest(keepAlive);
        AuWriter out = AuWriters.newInstance().open(request, response, config.getResendDelay() / 2 - 500);
        PerformanceMeter pfmeter = config.getPerformanceMeter();
        ExecutionImpl exec = new ExecutionImpl(this._ctx, request, response, desktop, null);
        Collection reqIds = uieng.execUpdate(exec, aureqs, pfmeter != null ? DHtmlUpdateServlet.meterStart(pfmeter, request, exec) : null, out);
        if (reqIds != null && pfmeter != null) {
            DHtmlUpdateServlet.meterComplete(pfmeter, response, reqIds, exec);
        }
        out.close(request, response);
    }

    private void sessionTimeout(HttpServletRequest request, HttpServletResponse response, String dtid, String scmd) throws ServletException, IOException {
        AuWriter out = AuWriters.newInstance().open(request, response, 0);
        if (!("rmDesktop".equals(scmd) || "onRender".equals(scmd) || "onTimer".equals(scmd) || "dummy".equals(scmd))) {
            AuResponse resp;
            String uri = Devices.getTimeoutURI(Servlets.isMilDevice((ServletRequest)request) ? "mil" : "ajax");
            if (uri != null) {
                if (uri.length() != 0) {
                    uri = Encodes.encodeURL((ServletContext)this._ctx, (ServletRequest)request, (ServletResponse)response, (String)uri);
                }
                resp = new AuSendRedirect(uri, null);
            } else {
                resp = new AuObsolete(dtid, Messages.get((int)MZk.UPDATE_OBSOLETE_PAGE, (Object)dtid));
            }
            out.write(resp);
        }
        out.close(request, response);
    }

    private Desktop recover(Session sess, HttpServletRequest request, HttpServletResponse response, WebAppCtrl wappc, String dtid) {
        block4: {
            FailoverManager failover = wappc.getFailoverManager();
            if (failover != null) {
                Desktop desktop = null;
                try {
                    if (failover.isRecoverable(sess, dtid)) {
                        desktop = WebManager.getWebManager(this._ctx).getDesktop(sess, (ServletRequest)request, (ServletResponse)response, null, true);
                        wappc.getUiEngine().execRecover(new ExecutionImpl(this._ctx, request, response, desktop, null), failover);
                        return desktop;
                    }
                }
                catch (Throwable ex) {
                    log.error("Unable to recover " + dtid, ex);
                    if (desktop == null) break block4;
                    ((DesktopCtrl)((Object)desktop)).recoverDidFail(ex);
                }
            }
        }
        return null;
    }

    private static void responseError(HttpServletRequest request, HttpServletResponse response, String errmsg) throws IOException {
        log.debug(errmsg);
        AuWriter out = AuWriters.newInstance().open(request, response, 0);
        out.write(new AuAlert(errmsg));
        out.close(request, response);
    }

    private static String meterStart(PerformanceMeter pfmeter, HttpServletRequest request, Execution exec) {
        int j;
        String hdr = request.getHeader("ZK-Client-Complete");
        if (hdr != null) {
            j = 0;
            while (true) {
                int k;
                String ids;
                int x;
                if ((x = (ids = (k = hdr.indexOf(44, j)) >= 0 ? hdr.substring(j, k) : (j == 0 ? hdr : hdr.substring(j))).lastIndexOf(61)) > 0) {
                    try {
                        long time = Long.parseLong(ids.substring(x + 1));
                        ids = ids.substring(0, x);
                        int y = 0;
                        while (true) {
                            int z;
                            String reqId = (z = ids.indexOf(32, y)) >= 0 ? ids.substring(y, z) : (y == 0 ? ids : ids.substring(y));
                            pfmeter.requestCompleteAtClient(reqId, exec, time);
                            if (z >= 0) {
                                y = z + 1;
                                continue;
                            }
                            break;
                        }
                    }
                    catch (NumberFormatException ex) {
                        log.error("Unable to parse " + ids);
                    }
                }
                if (k < 0) break;
                j = k + 1;
            }
        }
        if ((hdr = request.getHeader("ZK-Client-Start")) != null && (j = hdr.lastIndexOf(61)) > 0) {
            try {
                String reqId = hdr.substring(0, j);
                pfmeter.requestStartAtClient(reqId, exec, Long.parseLong(hdr.substring(j + 1)));
                pfmeter.requestStartAtServer(reqId, exec, System.currentTimeMillis());
                return reqId;
            }
            catch (NumberFormatException ex) {
                log.error("Unable to parse " + hdr);
            }
        }
        return null;
    }

    private static void meterComplete(PerformanceMeter pfmeter, HttpServletResponse response, Collection reqIds, Execution exec) {
        StringBuffer sb = new StringBuffer(256);
        long time = System.currentTimeMillis();
        Iterator it = reqIds.iterator();
        while (it.hasNext()) {
            String reqId = (String)it.next();
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(reqId);
            pfmeter.requestCompleteAtServer(reqId, exec, time);
        }
        response.setHeader("ZK-Client-Complete", sb.toString());
    }
}

