/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.au.http;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.zkoss.web.servlet.http.Https;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.AuWriter;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.sys.DesktopCtrl;

public class HttpAuWriter
implements AuWriter {
    protected static final String OUTPUT_HEAD = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
    protected static final String CONTENT_TYPE = "text/xml;charset=UTF-8";
    protected StringWriter _out;

    public AuWriter open(Object request, Object response, int timeout) throws IOException {
        this._out = new StringWriter();
        this._out.write(OUTPUT_HEAD);
        this._out.write("<rs>\n");
        return this;
    }

    public void close(Object request, Object response) throws IOException {
        this._out.write("\n</rs>");
        this.flush((HttpServletRequest)request, (HttpServletResponse)response);
    }

    protected void flush(HttpServletRequest request, HttpServletResponse response) throws IOException {
        byte[] bs;
        byte[] data = this._out.toString().getBytes("UTF-8");
        if (data.length > 200 && (bs = Https.gzip((HttpServletRequest)request, (HttpServletResponse)response, null, (byte[])data)) != null) {
            data = bs;
        }
        response.setContentType(CONTENT_TYPE);
        response.setContentLength(data.length);
        response.getOutputStream().write(data);
        response.flushBuffer();
    }

    public void write(AuResponse response) throws IOException {
        this._out.write("\n<r><c>");
        this._out.write(response.getCommand());
        this._out.write("</c>");
        String[] data = response.getData();
        if (data != null) {
            for (int j = 0; j < data.length; ++j) {
                this._out.write("\n<d>");
                HttpAuWriter.encodeXML(data[j], this._out);
                this._out.write("</d>");
            }
        }
        this._out.write("\n</r>");
    }

    public void write(Collection responses) throws IOException {
        Iterator it = responses.iterator();
        while (it.hasNext()) {
            this.write((AuResponse)it.next());
        }
    }

    public void writeSequenceId(Desktop desktop) throws IOException {
        this._out.write("\n<sid>");
        this._out.write(Integer.toString(((DesktopCtrl)((Object)desktop)).getResponseSequence(true)));
        this._out.write("</sid>");
    }

    private static void encodeXML(String data, Writer out) throws IOException {
        int k;
        if (data == null || data.length() == 0) {
            return;
        }
        int j = 0;
        while ((k = data.indexOf("]]>", j)) >= 0) {
            HttpAuWriter.encodeByCData(data.substring(j, k), out);
            out.write("]]&gt;");
            j = k + 3;
        }
        HttpAuWriter.encodeByCData(data.substring(j), out);
    }

    private static void encodeByCData(String data, Writer out) throws IOException {
        int j = data.length();
        while (--j >= 0) {
            char cc = data.charAt(j);
            if (cc != '<' && cc != '>' && cc != '&') continue;
            out.write("<![CDATA[");
            out.write(data);
            out.write("]]>");
            return;
        }
        out.write(data);
    }
}

