/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.au.http;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.zkoss.util.logging.Log;
import org.zkoss.zk.ui.Desktop;

class ZkFileItemFactory
extends DiskFileItemFactory {
    private static final Log log = Log.lookup((Class)ZkFileItemFactory.class);
    private final Desktop _desktop;
    private final long _cbtotal;
    private long _cbrcv;

    ZkFileItemFactory(Desktop desktop, HttpServletRequest request) {
        this.setSizeThreshold(131072);
        this._desktop = desktop;
        long cbtotal = 0L;
        String ctlen = request.getHeader("content-length");
        if (ctlen != null) {
            try {
                cbtotal = Long.parseLong(ctlen.trim());
            }
            catch (Throwable ex) {
                log.warning(ex);
            }
        }
        this._cbtotal = cbtotal;
        this._desktop.setAttribute("zk_uploadPercent", new Integer(0));
        this._desktop.setAttribute("zk_uploadSize", new Long(this._cbtotal));
    }

    void onProgress(int diff) {
        int percent = 0;
        if (this._cbtotal > 0L) {
            this._cbrcv += (long)(diff * 100);
            percent = (int)(this._cbrcv / this._cbtotal);
        }
        this._desktop.setAttribute("zk_uploadPercent", new Integer(percent));
    }

    public FileItem createItem(String fieldName, String contentType, boolean isFormField, String fileName) {
        return new ZkFileItem(fieldName, contentType, isFormField, fileName, this.getSizeThreshold(), this.getRepository());
    }

    class ZkOutputStream
    extends OutputStream {
        private final OutputStream _out;

        ZkOutputStream(OutputStream out) {
            this._out = out;
        }

        public void close() throws IOException {
            this._out.close();
        }

        public void flush() throws IOException {
            this._out.flush();
        }

        public void write(byte[] bytes, int offset, int len) throws IOException {
            this._out.write(bytes, offset, len);
            ZkFileItemFactory.this.onProgress(len);
        }

        public void write(byte[] bytes) throws IOException {
            this._out.write(bytes);
            ZkFileItemFactory.this.onProgress(bytes.length);
        }

        public void write(int b) throws IOException {
            this._out.write(b);
            ZkFileItemFactory.this.onProgress(1);
        }
    }

    class ZkFileItem
    extends DiskFileItem {
        ZkFileItem(String fieldName, String contentType, boolean isFormField, String fileName, int sizeThreshold, File repository) {
            super(fieldName, contentType, isFormField, fileName, sizeThreshold, repository);
        }

        public String getCharSet() {
            String charset = super.getCharSet();
            return charset != null ? charset : "UTF-8";
        }

        public OutputStream getOutputStream() throws IOException {
            OutputStream out = super.getOutputStream();
            if (this.isFormField()) {
                return out;
            }
            return new ZkOutputStream(out);
        }
    }
}

