/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.device;

import java.util.HashMap;
import java.util.Map;
import org.zkoss.idom.Element;
import org.zkoss.idom.util.IDOMs;
import org.zkoss.lang.Classes;
import org.zkoss.zk.device.Device;
import org.zkoss.zk.device.DeviceConfig;
import org.zkoss.zk.device.DeviceNotFoundException;
import org.zkoss.zk.mesg.MZk;
import org.zkoss.zk.ui.UiException;

public class Devices {
    private static final Map _devs = new HashMap(8);
    static /* synthetic */ Class class$org$zkoss$zk$device$Device;

    private Devices() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Device getDevice(String deviceType) {
        Object o;
        Map map = _devs;
        synchronized (map) {
            o = _devs.get(deviceType);
        }
        if (o instanceof Device) {
            return (Device)o;
        }
        if (o == null) {
            throw new DeviceNotFoundException(deviceType, MZk.NOT_FOUND, deviceType);
        }
        Device device = ((DeviceInfo)o).newDevice(deviceType);
        Map map2 = _devs;
        synchronized (map2) {
            Device old = _devs.put(deviceType, device);
            if (old != o) {
                _devs.put(deviceType, old);
            }
        }
        return device;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean exists(String deviceType) {
        Object o;
        if (deviceType == null) {
            return false;
        }
        Map map = _devs;
        synchronized (map) {
            o = _devs.get(deviceType);
        }
        return o instanceof Device || o != null && ((DeviceInfo)o).isValid();
    }

    public static final String add(String deviceType, String clsnm) {
        return Devices.add0(deviceType, clsnm);
    }

    public static final String add(String deviceType, Class cls) {
        return Devices.add0(deviceType, cls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String add0(String deviceType, Object cls) {
        if (deviceType == null || deviceType.length() == 0 || cls == null) {
            throw new IllegalArgumentException();
        }
        Map map = _devs;
        synchronized (map) {
            Object o = _devs.get(deviceType);
            if (o instanceof DeviceInfo) {
                return ((DeviceInfo)o).setDeviceClass(cls);
            }
            if (o instanceof Device) {
                Device device = (Device)o;
                _devs.put(deviceType, new DeviceInfo(cls, device.getUnavailableMessage(), device.getTimeoutURI(), device.getServerPushClass()));
                return device.getClass().getName();
            }
            _devs.put(deviceType, new DeviceInfo(cls));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String getUnavailableMessage(String deviceType) {
        Object o;
        Map map = _devs;
        synchronized (map) {
            o = _devs.get(deviceType);
        }
        return o instanceof Device ? ((Device)o).getUnavailableMessage() : (o instanceof DeviceInfo ? ((DeviceInfo)o).getUnavailableMessage() : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String setUnavailableMessage(String deviceType, String msg) {
        if (deviceType == null || deviceType.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (msg != null && msg.length() == 0) {
            msg = null;
        }
        Map map = _devs;
        synchronized (map) {
            Object o = _devs.get(deviceType);
            if (o instanceof Device) {
                return ((Device)o).setUnavailableMessage(msg);
            }
            if (o instanceof DeviceInfo) {
                return ((DeviceInfo)o).setUnavailableMessage(msg);
            }
            DeviceInfo info = new DeviceInfo();
            _devs.put(deviceType, info);
            info.setUnavailableMessage(msg);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String getTimeoutURI(String deviceType) {
        Object o;
        Map map = _devs;
        synchronized (map) {
            o = _devs.get(deviceType);
        }
        return o instanceof Device ? ((Device)o).getTimeoutURI() : (o instanceof DeviceInfo ? ((DeviceInfo)o).getTimeoutURI() : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String setTimeoutURI(String deviceType, String timeoutURI) {
        if (deviceType == null || deviceType.length() == 0) {
            throw new IllegalArgumentException();
        }
        Map map = _devs;
        synchronized (map) {
            Object o = _devs.get(deviceType);
            if (o instanceof Device) {
                return ((Device)o).setTimeoutURI(timeoutURI);
            }
            if (o instanceof DeviceInfo) {
                return ((DeviceInfo)o).setTimeoutURI(timeoutURI);
            }
            DeviceInfo info = new DeviceInfo();
            _devs.put(deviceType, info);
            info.setTimeoutURI(timeoutURI);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String getServerPushClass(String deviceType) {
        Object o;
        Map map = _devs;
        synchronized (map) {
            o = _devs.get(deviceType);
        }
        if (o instanceof Device) {
            Class cls = ((Device)o).getServerPushClass();
            return cls != null ? cls.getName() : null;
        }
        return o instanceof DeviceInfo ? ((DeviceInfo)o).getServerPushClassName() : null;
    }

    public static final String setServerPushClass(String deviceType, String clsnm) {
        return Devices.setServerPushClass0(deviceType, clsnm);
    }

    public static final String setServerPushClass(String deviceType, Class cls) {
        return Devices.setServerPushClass0(deviceType, cls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String setServerPushClass0(String deviceType, Object cls) {
        if (deviceType == null || deviceType.length() == 0) {
            throw new IllegalArgumentException();
        }
        try {
            Map map = _devs;
            synchronized (map) {
                Object o = _devs.get(deviceType);
                if (o instanceof Device) {
                    Class old = ((Device)o).setServerPushClass(cls instanceof Class ? (Class)cls : (cls != null ? Classes.forNameByThread((String)((String)cls)) : null));
                    return old != null ? old.getName() : null;
                }
                if (o instanceof DeviceInfo) {
                    return ((DeviceInfo)o).setServerPushClass(cls);
                }
                DeviceInfo info = new DeviceInfo();
                _devs.put(deviceType, info);
                info.setServerPushClass(cls);
                return null;
            }
        }
        catch (ClassNotFoundException ex) {
            throw new UiException("Class not found: " + cls);
        }
    }

    public static final void add(Element config) {
        String type = IDOMs.getRequiredElementValue((Element)config, (String)"device-type");
        String s = config.getElementValue("device-class", true);
        if (s != null) {
            Devices.add(type, s);
        }
        if ((s = config.getElementValue("unavailable-message", true)) != null) {
            Devices.setUnavailableMessage(type, s);
        }
        if ((s = config.getElementValue("timeout-uri", true)) != null) {
            Devices.setTimeoutURI(type, s);
        }
        if ((s = config.getElementValue("server-push-class", true)) != null) {
            Devices.setServerPushClass(type, s);
        }
    }

    private static class DeviceInfo
    implements DeviceConfig {
        private Object _dvcls;
        private String _uamsg;
        private String _tmoutURI;
        private Object _spushcls;

        private DeviceInfo() {
        }

        private DeviceInfo(Object deviceClass) {
            this._dvcls = deviceClass;
        }

        private DeviceInfo(Object deviceClass, String unavailable, String timeoutURI, Class spushcls) {
            this._dvcls = deviceClass;
            this._uamsg = unavailable;
            this._tmoutURI = timeoutURI;
            this._spushcls = spushcls;
        }

        private boolean isValid() {
            return this._dvcls != null;
        }

        private String setDeviceClass(Object cls) {
            Object old = this._dvcls;
            this._dvcls = cls;
            return old instanceof Class ? ((Class)old).getName() : (String)old;
        }

        public String getUnavailableMessage() {
            return this._uamsg;
        }

        public String setUnavailableMessage(String msg) {
            String old = this._uamsg;
            this._uamsg = msg != null && msg.length() > 0 ? msg : null;
            return old;
        }

        public String getTimeoutURI() {
            return this._tmoutURI;
        }

        public String setTimeoutURI(String timeoutURI) {
            String old = this._tmoutURI;
            this._tmoutURI = timeoutURI;
            return old;
        }

        public String setServerPushClass(Object cls) {
            Object old = this._spushcls;
            this._spushcls = cls;
            return old instanceof Class ? ((Class)old).getName() : (String)old;
        }

        public String getServerPushClassName() {
            return this._spushcls instanceof Class ? ((Class)this._spushcls).getName() : (String)this._spushcls;
        }

        public Class getServerPushClass() {
            try {
                return this._spushcls instanceof Class ? (Class)this._spushcls : (this._spushcls != null ? Classes.forNameByThread((String)((String)this._spushcls)) : null);
            }
            catch (ClassNotFoundException ex) {
                throw new UiException("Class not found: " + this._spushcls);
            }
        }

        private Device newDevice(String deviceType) {
            if (this._dvcls == null) {
                throw new DeviceNotFoundException(deviceType, MZk.NOT_FOUND, deviceType);
            }
            try {
                Class cls;
                if (this._dvcls instanceof Class) {
                    cls = (Class)this._dvcls;
                } else if (!(class$org$zkoss$zk$device$Device == null ? (class$org$zkoss$zk$device$Device = Devices.class$("org.zkoss.zk.device.Device")) : class$org$zkoss$zk$device$Device).isAssignableFrom(cls = Classes.forNameByThread((String)((String)this._dvcls)))) {
                    throw new IllegalArgumentException(cls + " must implements " + (class$org$zkoss$zk$device$Device == null ? (class$org$zkoss$zk$device$Device = Devices.class$("org.zkoss.zk.device.Device")) : class$org$zkoss$zk$device$Device));
                }
                Device device = (Device)cls.newInstance();
                device.init(deviceType, this);
                return device;
            }
            catch (Exception ex) {
                throw UiException.Aide.wrap((Throwable)ex, "Unable to create " + this._dvcls);
            }
        }
    }
}

