/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.fn;

import java.io.IOException;
import java.io.Writer;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.zkoss.lang.Objects;
import org.zkoss.lang.Strings;
import org.zkoss.util.CacheMap;
import org.zkoss.util.Locales;
import org.zkoss.util.logging.Log;
import org.zkoss.web.fn.ServletFns;
import org.zkoss.web.servlet.JavaScript;
import org.zkoss.web.servlet.StyleSheet;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.http.ExecutionImpl;
import org.zkoss.zk.ui.http.WebManager;
import org.zkoss.zk.ui.metainfo.LanguageDefinition;
import org.zkoss.zk.ui.sys.ExecutionsCtrl;
import org.zkoss.zk.ui.sys.PageCtrl;
import org.zkoss.zk.ui.util.Configuration;
import org.zkoss.zk.ui.util.ThemeProvider;

public class ZkFns {
    private static final Log log = Log.lookup((Class)ZkFns.class);
    private static final String ATTR_LANG_CSS_GENED = "javax.zkoss.zk.lang.css.generated";
    private static final String ATTR_LANG_JS_GENED = "javax.zkoss.zk.lang.js.generated";
    private static final CacheMap _datejs = new CacheMap(8);

    protected ZkFns() {
    }

    public static final void redraw(Component comp, Writer out) throws IOException {
        if (comp == null) {
            return;
        }
        if (out == null) {
            out = ZkFns.getCurrentOut();
        }
        try {
            comp.redraw(out);
        }
        catch (Throwable ex) {
            log.realCauseBriefly("Failed to redraw " + comp, ex);
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            throw UiException.Aide.wrap(ex);
        }
    }

    public static final Writer getCurrentOut() throws IOException {
        return ServletFns.getCurrentOut();
    }

    public static final String outResponseJavaScripts(Collection responses) {
        if (responses == null || responses.isEmpty()) {
            return "";
        }
        StringBuffer sb = new StringBuffer(256).append("zk.addInit(function(){\n");
        Iterator it = responses.iterator();
        while (it.hasNext()) {
            AuResponse response = (AuResponse)it.next();
            sb.append("zk.process('").append(response.getCommand()).append("',");
            String[] data = response.getData();
            int datanum = data != null ? data.length : 0;
            sb.append(datanum);
            for (int j = 0; j < datanum; ++j) {
                sb.append(",\"");
                if (data[j] != null) {
                    sb.append(Strings.escape((String)data[j], (String)"\"\\\n\r"));
                }
                sb.append('\"');
            }
            sb.append(");\n");
        }
        return sb.append("});").toString();
    }

    public static final String outLangJavaScripts(String action) {
        ServletRequest request = ServletFns.getCurrentRequest();
        if (WebManager.getRequestLocal(request, ATTR_LANG_JS_GENED) != null) {
            return "";
        }
        WebManager.setRequestLocal(request, ATTR_LANG_JS_GENED, Boolean.TRUE);
        if (action == null) {
            throw new IllegalArgumentException("null");
        }
        Desktop desktop = Executions.getCurrent().getDesktop();
        WebApp wapp = desktop.getWebApp();
        Configuration config = wapp.getConfiguration();
        String deviceType = desktop.getDeviceType();
        StringBuffer sb = new StringBuffer(1536);
        LinkedHashSet jses = new LinkedHashSet(37);
        Iterator it = LanguageDefinition.getByDeviceType(deviceType).iterator();
        while (it.hasNext()) {
            jses.addAll(((LanguageDefinition)it.next()).getJavaScripts());
        }
        it = jses.iterator();
        while (it.hasNext()) {
            ZkFns.append(sb, (JavaScript)it.next());
        }
        sb.append("\n<script type=\"text/javascript\">\n").append("zk_ver='").append(wapp.getVersion()).append("';\nzk_action=\"").append(action).append("\";\nzk_procto=").append(config.getProcessingPromptDelay()).append(";\nzk_tipto=").append(config.getTooltipDelay()).append(";\nzk_resndto=").append(config.getResendDelay()).append(";\n");
        if (!config.isDisableBehindModalEnabled()) {
            sb.append("zk.ndbModal=true;\n");
        }
        if (config.isKeepDesktopAcrossVisits() || request.getAttribute("zk_desktop_no_cache") == null) {
            sb.append("zk.keepDesktop=true;\n");
        }
        if (config.getPerformanceMeter() != null) {
            sb.append("zk.pfmeter=true;\n");
        }
        sb.append("zk.eru={");
        int[] cers = config.getClientErrorReloadCodes();
        boolean first = true;
        for (int j = 0; j < cers.length; ++j) {
            String uri = config.getClientErrorReload(cers[j]);
            if (uri == null) continue;
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            sb.append("e").append(cers[j]).append(":'").append(Strings.escape((String)uri, (String)"'\\")).append('\'');
        }
        sb.append("};\n");
        Iterator it2 = LanguageDefinition.getByDeviceType(deviceType).iterator();
        while (it2.hasNext()) {
            LanguageDefinition langdef = (LanguageDefinition)it2.next();
            Set mods = langdef.getJavaScriptModules().entrySet();
            if (mods.isEmpty()) continue;
            Iterator e = mods.iterator();
            while (e.hasNext()) {
                Map.Entry me = e.next();
                sb.append("\nzk.mods[\"").append(me.getKey()).append("\"]=\"").append(me.getValue()).append("\";");
            }
        }
        sb.append("\n</script>\n");
        String uamsg = desktop.getDevice().getUnavailableMessage();
        if (uamsg != null) {
            sb.append("<noscript>\n").append(uamsg).append("\n</noscript>\n");
        }
        return sb.toString();
    }

    private static void append(StringBuffer sb, JavaScript js) {
        sb.append("\n<script type=\"text/javascript\"");
        if (js.getSrc() != null) {
            String url;
            try {
                url = ServletFns.encodeURL((String)js.getSrc());
            }
            catch (ServletException ex) {
                throw new UiException(ex);
            }
            int j = url.lastIndexOf(59);
            if (j > 0 && url.indexOf(46, j + 1) < 0 && url.indexOf(47, j + 1) < 0) {
                url = url.substring(0, j);
            }
            sb.append(" src=\"").append(url).append('\"');
            String charset = js.getCharset();
            if (charset != null) {
                sb.append(" charset=\"").append(charset).append('\"');
            }
            sb.append('>');
        } else {
            sb.append(">\n").append(js.getContent());
        }
        sb.append("\n</script>");
    }

    public static final String outLangStyleSheets() {
        ServletRequest request = ServletFns.getCurrentRequest();
        if (WebManager.getRequestLocal(request, ATTR_LANG_CSS_GENED) != null) {
            return "";
        }
        WebManager.setRequestLocal(request, ATTR_LANG_CSS_GENED, Boolean.TRUE);
        StringBuffer sb = new StringBuffer(512);
        Execution exec = Executions.getCurrent();
        Iterator it = ZkFns.getStyleSheets(exec).iterator();
        while (it.hasNext()) {
            ZkFns.append(sb, (StyleSheet)it.next(), exec, null);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String outDeviceStyleSheets(String deviceType) {
        boolean fake;
        ServletRequest request = ServletFns.getCurrentRequest();
        if (WebManager.getRequestLocal(request, ATTR_LANG_CSS_GENED) != null) {
            return "";
        }
        if (deviceType == null) {
            throw new IllegalArgumentException();
        }
        WebManager.setRequestLocal(request, ATTR_LANG_CSS_GENED, Boolean.TRUE);
        StringBuffer sb = new StringBuffer(256);
        ServletContext svlctx = ServletFns.getCurrentServletContext();
        Configuration config = WebManager.getWebManager(svlctx).getWebApp().getConfiguration();
        Execution exec = ExecutionsCtrl.getCurrent();
        boolean bl = fake = exec == null;
        if (fake) {
            exec = new ExecutionImpl(svlctx, (HttpServletRequest)request, (HttpServletResponse)ServletFns.getCurrentResponse(), null, null);
            ExecutionsCtrl.setCurrent(exec);
        }
        try {
            List ss = ZkFns.getStyleSheets0(exec, config, deviceType);
            Iterator it = ss.iterator();
            while (it.hasNext()) {
                ZkFns.append(sb, (StyleSheet)it.next(), exec, null);
            }
            String string = sb.toString();
            return string;
        }
        finally {
            if (fake) {
                ExecutionsCtrl.setCurrent(null);
            }
        }
    }

    public static final List getStyleSheets(Execution exec) {
        Desktop desktop = exec.getDesktop();
        return ZkFns.getStyleSheets0(exec, desktop.getWebApp().getConfiguration(), desktop.getDeviceType());
    }

    private static final List getStyleSheets0(Execution exec, Configuration config, String deviceType) {
        LinkedList<StyleSheet> sses;
        block7: {
            block6: {
                StyleSheet ss;
                Set disabled = config.getDisabledThemeURIs();
                sses = new LinkedList<StyleSheet>();
                Iterator it = LanguageDefinition.getByDeviceType(deviceType).iterator();
                while (it.hasNext()) {
                    LanguageDefinition langdef = (LanguageDefinition)it.next();
                    Iterator e = langdef.getStyleSheets().iterator();
                    while (e.hasNext()) {
                        ss = (StyleSheet)e.next();
                        if (disabled.contains(ss.getHref())) continue;
                        sses.add(ss);
                    }
                }
                ThemeProvider themeProvider = config.getThemeProvider();
                if (themeProvider == null) break block6;
                LinkedList<String> org = new LinkedList<String>();
                Iterator it2 = sses.iterator();
                while (it2.hasNext()) {
                    ss = (StyleSheet)it2.next();
                    org.add(ss.getHref());
                }
                String[] hrefs = config.getThemeURIs();
                for (int j = 0; j < hrefs.length; ++j) {
                    org.add(hrefs[j]);
                }
                sses.clear();
                Collection res = themeProvider.getThemeURIs(exec, org);
                if (res == null) break block7;
                Iterator it3 = res.iterator();
                while (it3.hasNext()) {
                    sses.add(new StyleSheet((String)it3.next(), "text/css"));
                }
                break block7;
            }
            String[] hrefs = config.getThemeURIs();
            for (int j = 0; j < hrefs.length; ++j) {
                sses.add(new StyleSheet(hrefs[j], "text/css"));
            }
        }
        return sses;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void append(StringBuffer sb, StyleSheet ss, Execution exec, Page page) {
        String href = ss.getHref();
        if (href != null) {
            try {
                if (exec != null) {
                    href = (String)exec.evaluate(page, href, String.class);
                }
                if (href == null || href.length() <= 0) return;
                sb.append("\n<link rel=\"stylesheet\" type=\"").append(ss.getType()).append("\" href=\"").append(ServletFns.encodeURL((String)href)).append("\"/>");
                return;
            }
            catch (ServletException ex) {
                throw new UiException(ex);
            }
        } else {
            sb.append("\n<style");
            if (ss.getType() != null) {
                sb.append(" type=\"").append(ss.getType()).append('\"');
            }
            sb.append(">\n").append(ss.getContent()).append("\n</style>");
        }
    }

    public static String toAbsoluteURI(String uri, boolean skipInclude) {
        return Executions.getCurrent().toAbsoluteURI(uri, skipInclude);
    }

    public static String toAbsoluteURI(String uri) {
        return ZkFns.toAbsoluteURI(uri, true);
    }

    public static final String outHeaders(Page page) {
        return ((PageCtrl)((Object)page)).getHeaders();
    }

    public static final String outRootAttributes(Page page) {
        return ((PageCtrl)((Object)page)).getRootAttributes();
    }

    public static final String outContentType(Page page) {
        String contentType = ((PageCtrl)((Object)page)).getContentType();
        return contentType != null ? contentType : page.getDesktop().getDevice().getContentType();
    }

    public static final String outDocType(Page page) {
        String docType = ((PageCtrl)((Object)page)).getDocType();
        return ZkFns.trimAndLF(docType != null ? docType : page.getDesktop().getDevice().getDocType());
    }

    private static final String trimAndLF(String s) {
        int len;
        if (s != null && (len = (s = s.trim()).length()) > 0 && s.charAt(len - 1) != '\n') {
            s = s + '\n';
        }
        return s;
    }

    public static final String outFirstLine(Page page) {
        return ZkFns.trimAndLF(((PageCtrl)((Object)page)).getFirstLine());
    }

    public static final String outLocaleJavaScript() {
        Locale locale = Locales.getCurrent();
        return ZkFns.outNumberJavaScript(locale) + ZkFns.outDateJavaScript(locale);
    }

    private static final String outNumberJavaScript(Locale locale) {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols(locale);
        StringBuffer sb = new StringBuffer(128);
        ZkFns.appendAssignJavaScript(sb, "zk.GROUPING", symbols.getGroupingSeparator());
        ZkFns.appendAssignJavaScript(sb, "zk.DECIMAL", symbols.getDecimalSeparator());
        ZkFns.appendAssignJavaScript(sb, "zk.PERCENT", symbols.getPercent());
        ZkFns.appendAssignJavaScript(sb, "zk.MINUS", symbols.getMinusSign());
        return sb.toString();
    }

    private static final void appendAssignJavaScript(StringBuffer sb, String nm, char val) {
        char quot = val == '\"' ? (char)'\'' : '\"';
        sb.append(nm).append('=').append(quot).append(val).append(quot).append(";\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String outDateJavaScript(Locale locale) {
        CacheMap cacheMap = _datejs;
        synchronized (cacheMap) {
            String djs = (String)_datejs.get((Object)locale);
            if (djs != null) {
                return djs;
            }
        }
        String djs = ZkFns.getDateJavaScript(locale);
        CacheMap cacheMap2 = _datejs;
        synchronized (cacheMap2) {
            Iterator it = _datejs.values().iterator();
            while (it.hasNext()) {
                String val = (String)it.next();
                if (!val.equals(djs)) continue;
                djs = val;
            }
            _datejs.put((Object)locale, (Object)djs);
        }
        return djs;
    }

    private static final String getDateJavaScript(Locale locale) {
        StringBuffer sb = new StringBuffer(512);
        Calendar cal = Calendar.getInstance(locale);
        cal.clear();
        int firstDayOfWeek = cal.getFirstDayOfWeek();
        sb.append("zk.DOW_1ST=").append(firstDayOfWeek - 1).append(";\n");
        boolean zhlang = locale.getLanguage().equals("zh");
        SimpleDateFormat df = new SimpleDateFormat("E", locale);
        String[] sdow = new String[7];
        String[] s2dow = new String[7];
        int j = firstDayOfWeek;
        for (int k = 0; k < 7; ++k) {
            int len;
            char cc;
            cal.set(7, j);
            sdow[k] = df.format(cal.getTime());
            if (++j > 7) {
                j = 1;
            }
            s2dow[k] = zhlang ? (sdow[k].length() >= 3 ? sdow[k].substring(2) : sdow[k]) : ((cc = sdow[k].charAt((len = sdow[k].length()) - 1)) == '.' || cc == ',' ? sdow[k].substring(0, len - 1) : sdow[k]);
        }
        df = new SimpleDateFormat("EEEE", locale);
        String[] fdow = new String[7];
        int j2 = firstDayOfWeek;
        for (int k = 0; k < 7; ++k) {
            cal.set(7, j2);
            fdow[k] = df.format(cal.getTime());
            if (++j2 <= 7) continue;
            j2 = 1;
        }
        df = new SimpleDateFormat("MMM", locale);
        String[] smon = new String[12];
        String[] s2mon = new String[12];
        for (int j3 = 0; j3 < 12; ++j3) {
            int len;
            char cc;
            cal.set(2, j3);
            smon[j3] = df.format(cal.getTime());
            s2mon[j3] = zhlang ? (smon[0].length() >= 2 ? smon[j3].substring(0, smon[j3].length() - 1) : smon[j3]) : ((cc = smon[j3].charAt((len = smon[j3].length()) - 1)) == '.' || cc == ',' ? smon[j3].substring(0, len - 1) : smon[j3]);
        }
        df = new SimpleDateFormat("MMMM", locale);
        String[] fmon = new String[12];
        for (int j4 = 0; j4 < 12; ++j4) {
            cal.set(2, j4);
            fmon[j4] = df.format(cal.getTime());
        }
        ZkFns.appendJavaScriptArray(sb, "SDOW", sdow);
        if (Objects.equals((Object)s2dow, (Object)sdow)) {
            sb.append("zk.S2DOW=zk.SDOW;\n");
        } else {
            ZkFns.appendJavaScriptArray(sb, "S2DOW", s2dow);
        }
        if (Objects.equals((Object)fdow, (Object)sdow)) {
            sb.append("zk.FDOW=zk.SDOW;\n");
        } else {
            ZkFns.appendJavaScriptArray(sb, "FDOW", fdow);
        }
        ZkFns.appendJavaScriptArray(sb, "SMON", smon);
        if (Objects.equals((Object)s2mon, (Object)smon)) {
            sb.append("zk.S2MON=zk.SMON;\n");
        } else {
            ZkFns.appendJavaScriptArray(sb, "S2MON", s2mon);
        }
        if (Objects.equals((Object)fmon, (Object)smon)) {
            sb.append("zk.FMON=zk.SMON;\n");
        } else {
            ZkFns.appendJavaScriptArray(sb, "FMON", fmon);
        }
        df = new SimpleDateFormat("a", locale);
        cal.set(11, 3);
        String[] ampm = new String[2];
        ampm[0] = df.format(cal.getTime());
        cal.set(11, 15);
        ampm[1] = df.format(cal.getTime());
        ZkFns.appendJavaScriptArray(sb, "APM", ampm);
        return sb.toString();
    }

    private static final void appendJavaScriptArray(StringBuffer sb, String varnm, String[] vals) {
        sb.append("zk.").append(varnm).append("=[");
        int j = 0;
        while (true) {
            sb.append('\"').append(Strings.escape((String)vals[j], (String)"\\\"")).append('\"');
            if (++j >= vals.length) break;
            sb.append(',');
        }
        sb.append("];\n");
    }

    static {
        _datejs.setLifetime(86400000);
    }
}

