/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.scripting.bsh;

import bsh.BshClassManager;
import bsh.BshMethod;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.NameSpace;
import bsh.Primitive;
import bsh.UtilEvalError;
import bsh.Variable;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.zkoss.lang.Classes;
import org.zkoss.xel.Function;
import org.zkoss.zk.scripting.HierachicalAware;
import org.zkoss.zk.scripting.Namespace;
import org.zkoss.zk.scripting.NamespaceChangeListener;
import org.zkoss.zk.scripting.SerializableAware;
import org.zkoss.zk.scripting.util.GenericInterpreter;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.UiException;

public class BSHInterpreter
extends GenericInterpreter
implements SerializableAware,
HierachicalAware {
    private static final String VAR_NS = "z_bshnS";
    private Interpreter _ip;
    private GlobalNS _bshns;
    static /* synthetic */ Class class$bsh$BshMethod;

    protected void loadDefaultImports(NameSpace bshns) {
    }

    protected void exec(String script) {
        try {
            Namespace ns = this.getCurrent();
            if (ns != null) {
                this._ip.eval(script, this.prepareNS(ns));
            } else {
                this._ip.eval(script);
            }
        }
        catch (EvalError ex) {
            throw UiException.Aide.wrap(ex);
        }
    }

    protected boolean contains(String name) {
        try {
            return this._ip.getNameSpace().getVariable(name) != Primitive.VOID;
        }
        catch (UtilEvalError ex) {
            throw UiException.Aide.wrap(ex);
        }
    }

    protected Object get(String name) {
        try {
            return Primitive.unwrap((Object)this._ip.get(name));
        }
        catch (EvalError ex) {
            throw UiException.Aide.wrap(ex);
        }
    }

    protected void set(String name, Object val) {
        try {
            this._ip.set(name, val);
        }
        catch (EvalError ex) {
            throw UiException.Aide.wrap(ex);
        }
    }

    protected void unset(String name) {
        try {
            this._ip.unset(name);
        }
        catch (EvalError ex) {
            throw UiException.Aide.wrap(ex);
        }
    }

    protected boolean contains(Namespace ns, String name) {
        NameSpace bshns;
        if (ns != null && (bshns = this.prepareNS(ns)) != this._bshns) {
            try {
                return bshns.getVariable(name) != Primitive.VOID;
            }
            catch (UtilEvalError ex) {
                throw UiException.Aide.wrap(ex);
            }
        }
        return this.contains(name);
    }

    protected Object get(Namespace ns, String name) {
        NameSpace bshns;
        if (ns != null && (bshns = this.prepareNS(ns)) != this._bshns) {
            try {
                return Primitive.unwrap((Object)bshns.getVariable(name));
            }
            catch (UtilEvalError ex) {
                throw UiException.Aide.wrap(ex);
            }
        }
        return this.get(name);
    }

    protected void set(Namespace ns, String name, Object val) {
        NameSpace bshns;
        if (ns != null && (bshns = this.prepareNS(ns)) != this._bshns) {
            try {
                bshns.setVariable(name, val != null ? val : Primitive.NULL, false);
                return;
            }
            catch (UtilEvalError ex) {
                throw UiException.Aide.wrap(ex);
            }
        }
        this.set(name, val);
    }

    protected void unset(Namespace ns, String name) {
        NameSpace bshns;
        if (ns != null && (bshns = this.prepareNS(ns)) != this._bshns) {
            bshns.unsetVariable(name);
            return;
        }
        this.unset(name);
    }

    public void init(Page owner, String zslang) {
        super.init(owner, zslang);
        this._ip = new Interpreter();
        this._ip.setClassLoader(Thread.currentThread().getContextClassLoader());
        this._bshns = new GlobalNS(this._ip.getClassManager(), "global");
        this._ip.setNameSpace((NameSpace)this._bshns);
    }

    public void destroy() {
        this.getOwner().getNamespace().unsetVariable(VAR_NS, false);
        try {
            this._bshns.clear();
            this._ip.setNameSpace(null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this._ip = null;
        this._bshns = null;
        super.destroy();
    }

    public Object getNativeInterpreter() {
        return this._ip;
    }

    public Class getClass(String clsnm) {
        try {
            return this._bshns.getClass(clsnm);
        }
        catch (UtilEvalError ex) {
            throw new UiException("Failed to load class " + clsnm, (Throwable)ex);
        }
    }

    public Function getFunction(String name, Class[] argTypes) {
        return this.getFunction0(this._bshns, name, argTypes);
    }

    public Function getFunction(Namespace ns, String name, Class[] argTypes) {
        return this.getFunction0(this.prepareNS(ns), name, argTypes);
    }

    private Function getFunction0(NameSpace bshns, String name, Class[] argTypes) {
        try {
            BshMethod m = bshns.getMethod(name, argTypes != null ? argTypes : new Class[]{}, false);
            return m != null ? new BSHFunction(m) : null;
        }
        catch (UtilEvalError ex) {
            throw UiException.Aide.wrap(ex);
        }
    }

    private NameSpace prepareNS(Namespace ns) {
        if (ns == this.getOwner().getNamespace()) {
            return this._bshns;
        }
        NSX nsx = (NSX)ns.getVariable(VAR_NS, true);
        if (nsx != null) {
            return nsx.ns;
        }
        Namespace p = ns.getParent();
        NS bshns = new NS(p != null ? this.prepareNS(p) : null, this._ip.getClassManager(), ns);
        ns.setVariable(VAR_NS, new NSX(bshns), true);
        return bshns;
    }

    private static NameSpace prepareDetachedNS(Namespace ns) {
        NSX nsx = (NSX)ns.getVariable(VAR_NS, true);
        if (nsx != null) {
            return nsx.ns;
        }
        Namespace p = ns.getParent();
        NS bshns = new NS(p != null ? BSHInterpreter.prepareDetachedNS(p) : null, null, ns);
        ns.setVariable(VAR_NS, new NSX(bshns), true);
        return bshns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ObjectOutputStream s, SerializableAware.Filter filter) throws IOException {
        int j;
        int j2;
        String[] vars = this._bshns.getVariableNames();
        int n = j2 = vars != null ? vars.length : 0;
        while (--j2 >= 0) {
            Object val;
            String nm = vars[j2];
            if (nm == null || "bsh".equals(nm) || (val = this.get(nm)) != null && !(val instanceof Serializable) && !(val instanceof Externalizable) || filter != null && !filter.accept(nm, val)) continue;
            s.writeObject(nm);
            s.writeObject(val);
        }
        s.writeObject(null);
        BshMethod[] mtds = this._bshns.getMethods();
        int n2 = j = mtds != null ? mtds.length : 0;
        while (--j >= 0) {
            String nm = mtds[j].getName();
            if (filter != null && !filter.accept(nm, mtds[j])) continue;
            Field f = null;
            boolean acs = false;
            try {
                f = Classes.getAnyField((Class)(class$bsh$BshMethod == null ? BSHInterpreter.class$("bsh.BshMethod") : class$bsh$BshMethod), (String)"declaringNameSpace");
                acs = f.isAccessible();
                f.setAccessible(true);
                Object old = f.get(mtds[j]);
                try {
                    f.set(mtds[j], null);
                    s.writeObject(mtds[j]);
                }
                finally {
                    f.set(mtds[j], old);
                }
            }
            catch (IOException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                throw UiException.Aide.wrap(ex);
            }
            finally {
                if (f == null) continue;
                f.setAccessible(acs);
            }
        }
        s.writeObject(null);
        Field f = null;
        boolean acs = false;
        try {
            f = Classes.getAnyField((Class)NameSpace.class, (String)"importedClasses");
            acs = f.isAccessible();
            f.setAccessible(true);
            Map clses = (Map)f.get((Object)this._bshns);
            if (clses != null) {
                Iterator it = clses.values().iterator();
                while (it.hasNext()) {
                    String clsnm = (String)it.next();
                    if (clsnm.startsWith("bsh.")) continue;
                    s.writeObject(clsnm);
                }
            }
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw UiException.Aide.wrap(ex);
        }
        finally {
            if (f != null) {
                f.setAccessible(acs);
            }
        }
        s.writeObject(null);
        f = null;
        acs = false;
        try {
            f = Classes.getAnyField((Class)NameSpace.class, (String)"importedPackages");
            acs = f.isAccessible();
            f.setAccessible(true);
            Collection pkgs = (Collection)f.get((Object)this._bshns);
            if (pkgs != null) {
                Iterator it = pkgs.iterator();
                while (it.hasNext()) {
                    String pkgnm = (String)it.next();
                    if (pkgnm.startsWith("java.awt") || pkgnm.startsWith("javax.swing")) continue;
                    s.writeObject(pkgnm);
                }
            }
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw UiException.Aide.wrap(ex);
        }
        finally {
            if (f != null) {
                f.setAccessible(acs);
            }
        }
        s.writeObject(null);
    }

    public void read(ObjectInputStream s) throws IOException, ClassNotFoundException {
        String nm;
        while ((nm = (String)s.readObject()) != null) {
            this.set(nm, s.readObject());
        }
        try {
            BshMethod mtd;
            while ((mtd = (BshMethod)s.readObject()) != null) {
                Field f = null;
                boolean acs = false;
                try {
                    f = Classes.getAnyField((Class)(class$bsh$BshMethod == null ? BSHInterpreter.class$("bsh.BshMethod") : class$bsh$BshMethod), (String)"declaringNameSpace");
                    acs = f.isAccessible();
                    f.setAccessible(true);
                    f.set(mtd, (Object)this._bshns);
                }
                catch (Throwable ex) {
                    throw UiException.Aide.wrap(ex);
                }
                finally {
                    if (f != null) {
                        f.setAccessible(acs);
                    }
                }
                this._bshns.setMethod(mtd.getName(), mtd);
            }
        }
        catch (UtilEvalError ex) {
            throw UiException.Aide.wrap(ex);
        }
        while ((nm = (String)s.readObject()) != null) {
            this._bshns.importClass(nm);
        }
        while ((nm = (String)s.readObject()) != null) {
            this._bshns.importPackage(nm);
        }
    }

    private class BSHFunction
    implements Function {
        private final BshMethod _method;

        private BSHFunction(BshMethod method) {
            if (method == null) {
                throw new IllegalArgumentException("null");
            }
            this._method = method;
        }

        public Class[] getParameterTypes() {
            return this._method.getParameterTypes();
        }

        public Class getReturnType() {
            return this._method.getReturnType();
        }

        public Object invoke(Object obj, Object[] args) throws Exception {
            return this._method.invoke(args != null ? args : new Object[]{}, BSHInterpreter.this._ip);
        }

        public Method toMethod() {
            return null;
        }
    }

    private static class NSX {
        NameSpace ns;

        private NSX(NameSpace ns) {
            this.ns = ns;
        }
    }

    private static class NSCListener
    implements NamespaceChangeListener {
        private final NS _bshns;

        private NSCListener(NS bshns) {
            this._bshns = bshns;
        }

        public void onAdd(String name, Object value) {
        }

        public void onRemove(String name) {
        }

        public void onParentChanged(Namespace newparent) {
            if (newparent != null) {
                BSHInterpreter ip = this._bshns.getInterpreter();
                this._bshns.setParent(ip != null ? ip.prepareNS(newparent) : BSHInterpreter.prepareDetachedNS(newparent));
                return;
            }
            this._bshns.setParent(null);
        }
    }

    private static class NS
    extends AbstractNS {
        private final Namespace _ns;

        private NS(NameSpace parent, BshClassManager classManager, Namespace ns) {
            super(parent, classManager, "ns" + System.identityHashCode(ns));
            this._ns = ns;
            this._ns.addChangeListener(new NSCListener(this));
        }

        protected Object getFromNamespace(String name) {
            BSHInterpreter ip = this.getInterpreter();
            return ip != null ? ip.getFromNamespace(this._ns, name) : this._ns.getVariable(name, false);
        }

        private BSHInterpreter getInterpreter() {
            Page owner = this._ns.getOwnerPage();
            if (owner != null) {
                Iterator it = owner.getLoadedInterpreters().iterator();
                while (it.hasNext()) {
                    Object ip = it.next();
                    if (!(ip instanceof BSHInterpreter)) continue;
                    return (BSHInterpreter)ip;
                }
            }
            return null;
        }
    }

    private class GlobalNS
    extends AbstractNS {
        private GlobalNS(BshClassManager classManager, String name) {
            super(null, classManager, name);
        }

        protected Object getFromNamespace(String name) {
            return BSHInterpreter.this.getFromNamespace(name);
        }

        public void loadDefaultImports() {
            BSHInterpreter.this.loadDefaultImports(this);
        }
    }

    private static abstract class AbstractNS
    extends NameSpace {
        private boolean _inGet;

        protected AbstractNS(NameSpace parent, BshClassManager classManager, String name) {
            super(parent, classManager, name);
        }

        protected abstract Object getFromNamespace(String var1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Variable getVariableImpl(String name, boolean recurse) throws UtilEvalError {
            Object v;
            Variable var = super.getVariableImpl(name, recurse);
            if (!this._inGet && var == null && (v = this.getFromNamespace(name)) != GenericInterpreter.UNDEFINED) {
                this._inGet = true;
                try {
                    this.setVariable(name, v != null ? v : Primitive.NULL, false);
                    var = super.getVariableImpl(name, false);
                    this.unsetVariable(name);
                }
                finally {
                    this._inGet = false;
                }
            }
            return var;
        }

        public void loadDefaultImports() {
        }
    }
}

