/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.scripting.util;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.zkoss.zk.scripting.Namespace;
import org.zkoss.zk.scripting.NamespaceChangeListener;

public abstract class AbstractNamespace
implements Namespace {
    private List _listeners;

    protected void notifyAdd(String name, Object value) {
        if (this._listeners != null) {
            Iterator it = this._listeners.iterator();
            while (it.hasNext()) {
                ((NamespaceChangeListener)it.next()).onAdd(name, value);
            }
        }
    }

    protected void notifyRemove(String name) {
        if (this._listeners != null) {
            Iterator it = this._listeners.iterator();
            while (it.hasNext()) {
                ((NamespaceChangeListener)it.next()).onRemove(name);
            }
        }
    }

    protected void notifyParentChanged(Namespace newparent) {
        if (this._listeners != null) {
            Iterator it = this._listeners.iterator();
            while (it.hasNext()) {
                ((NamespaceChangeListener)it.next()).onParentChanged(newparent);
            }
        }
    }

    public boolean addChangeListener(NamespaceChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("null");
        }
        if (this._listeners == null) {
            this._listeners = new LinkedList();
        } else if (this._listeners.contains(listener)) {
            return false;
        }
        this._listeners.add(listener);
        return true;
    }

    public boolean removeChangeListener(NamespaceChangeListener listener) {
        return this._listeners != null && this._listeners.remove(listener);
    }
}

