/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.Writer;
import java.util.AbstractSequentialList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.zkoss.io.Serializables;
import org.zkoss.lang.Objects;
import org.zkoss.util.CollectionsX;
import org.zkoss.xml.HTMLs;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuClientInfo;
import org.zkoss.zk.fn.ZkFns;
import org.zkoss.zk.mesg.MZk;
import org.zkoss.zk.scripting.Namespace;
import org.zkoss.zk.scripting.util.SimpleNamespace;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.ComponentNotFoundException;
import org.zkoss.zk.ui.Components;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.IdSpace;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.Deferrable;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.ForwardEvent;
import org.zkoss.zk.ui.ext.NonFellow;
import org.zkoss.zk.ui.ext.RawId;
import org.zkoss.zk.ui.ext.render.ZidRequired;
import org.zkoss.zk.ui.impl.ListenerIterator;
import org.zkoss.zk.ui.metainfo.Annotation;
import org.zkoss.zk.ui.metainfo.AnnotationMap;
import org.zkoss.zk.ui.metainfo.ComponentDefinition;
import org.zkoss.zk.ui.metainfo.ComponentInfo;
import org.zkoss.zk.ui.metainfo.DefinitionNotFoundException;
import org.zkoss.zk.ui.metainfo.EventHandler;
import org.zkoss.zk.ui.metainfo.EventHandlerMap;
import org.zkoss.zk.ui.metainfo.LanguageDefinition;
import org.zkoss.zk.ui.metainfo.PageDefinition;
import org.zkoss.zk.ui.metainfo.ZScript;
import org.zkoss.zk.ui.render.ComponentRenderer;
import org.zkoss.zk.ui.sys.ComponentCtrl;
import org.zkoss.zk.ui.sys.ComponentsCtrl;
import org.zkoss.zk.ui.sys.DesktopCtrl;
import org.zkoss.zk.ui.sys.ExecutionCtrl;
import org.zkoss.zk.ui.sys.IdGenerator;
import org.zkoss.zk.ui.sys.Names;
import org.zkoss.zk.ui.sys.PageCtrl;
import org.zkoss.zk.ui.sys.UiEngine;
import org.zkoss.zk.ui.sys.WebAppCtrl;
import org.zkoss.zk.ui.util.ComponentCloneListener;
import org.zkoss.zk.ui.util.ComponentSerializationListener;
import org.zkoss.zk.ui.util.DeferredValue;

public class AbstractComponent
implements Component,
ComponentCtrl,
Serializable {
    private static final long serialVersionUID = 20070920L;
    private transient Page _page;
    private String _id;
    private String _uuid;
    private transient ComponentDefinition _def;
    private String _mold = "default";
    private transient SpaceInfo _spaceInfo;
    private transient Map _attrs;
    private transient Map _listeners;
    private transient Object _xtrl;
    private transient List _apiChildren;
    private transient AbstractComponent _parent;
    private transient AbstractComponent _next;
    private transient AbstractComponent _prev;
    private transient AbstractComponent _first;
    private transient AbstractComponent _last;
    private int _nChild;
    private transient int _modCntChd;
    private transient Set _rming;
    private transient Set _adding;
    private AnnotationMap _annots;
    private EventHandlerMap _evthds;
    private transient Map _forwards;
    private transient boolean _annotsShared;
    private transient boolean _evthdsShared;
    private boolean _visible = true;

    protected AbstractComponent() {
        Execution exec = Executions.getCurrent();
        Object curInfo = ComponentsCtrl.getCurrentInfo();
        if (curInfo != null) {
            ComponentsCtrl.setCurrentInfo((ComponentInfo)null);
            if (curInfo instanceof ComponentInfo) {
                ComponentInfo compInfo = (ComponentInfo)curInfo;
                this._def = compInfo.getComponentDefinition();
                this.addSharedAnnotationMap(this._def.getAnnotationMap());
                this.addSharedAnnotationMap(compInfo.getAnnotationMap());
            } else {
                this._def = (ComponentDefinition)curInfo;
                this.addSharedAnnotationMap(this._def.getAnnotationMap());
            }
        } else {
            this._def = AbstractComponent.lookupDefinition(exec, this.getClass());
            if (this._def != null) {
                this.addSharedAnnotationMap(this._def.getAnnotationMap());
            } else {
                this._def = ComponentsCtrl.DUMMY;
            }
        }
        this.init(false);
        this._spaceInfo = this instanceof IdSpace ? new SpaceInfo((Component)this) : null;
    }

    private static final ComponentDefinition lookupDefinition(Execution exec, Class cls) {
        if (exec != null) {
            ComponentDefinition compdef;
            ExecutionCtrl execCtrl = (ExecutionCtrl)((Object)exec);
            PageDefinition pgdef = execCtrl.getCurrentPageDefinition();
            Page page = execCtrl.getCurrentPage();
            ComponentDefinition componentDefinition = pgdef != null ? pgdef.getComponentDefinition(cls, true) : (compdef = page != null ? page.getComponentDefinition(cls, true) : null);
            if (compdef != null) {
                return compdef;
            }
            return AbstractComponent.lookupDefinitionByDeviceType(exec.getDesktop().getDeviceType(), cls);
        }
        Iterator it = LanguageDefinition.getDeviceTypes().iterator();
        while (it.hasNext()) {
            ComponentDefinition compdef = AbstractComponent.lookupDefinitionByDeviceType((String)it.next(), cls);
            if (compdef == null) continue;
            return compdef;
        }
        return null;
    }

    private static final ComponentDefinition lookupDefinitionByDeviceType(String deviceType, Class cls) {
        Iterator it = LanguageDefinition.getByDeviceType(deviceType).iterator();
        while (it.hasNext()) {
            LanguageDefinition ld = (LanguageDefinition)it.next();
            try {
                return ld.getComponentDefinition(cls);
            }
            catch (DefinitionNotFoundException ex) {
            }
        }
        return null;
    }

    private void init(boolean cloning) {
        this._xtrl = this.newExtraCtrl();
        this._apiChildren = new AbstractSequentialList(){

            public int size() {
                return AbstractComponent.this._nChild;
            }

            public ListIterator listIterator(int index) {
                return new ChildIter(index);
            }
        };
        if (!cloning) {
            this._attrs = new HashMap(4);
        }
    }

    private static void addToIdSpaces(Component comp) {
        IdSpace is;
        if (comp instanceof IdSpace) {
            ((AbstractComponent)comp).bindToIdSpace(comp);
        }
        if ((is = AbstractComponent.getSpaceOwnerOfParent(comp)) instanceof Component) {
            ((AbstractComponent)((Object)is)).bindToIdSpace(comp);
        } else if (is != null) {
            ((PageCtrl)((Object)is)).addFellow(comp);
        }
    }

    private static final IdSpace getSpaceOwnerOfParent(Component comp) {
        Component parent = comp.getParent();
        if (parent != null) {
            return parent.getSpaceOwner();
        }
        return comp.getPage();
    }

    private static void removeFromIdSpaces(Component comp) {
        IdSpace is;
        AbstractComponent abcomp = (AbstractComponent)comp;
        String compId = abcomp._id;
        if (compId == null || comp instanceof NonFellow || ComponentsCtrl.isAutoId(compId)) {
            return;
        }
        if (comp instanceof IdSpace) {
            abcomp.unbindFromIdSpace(compId);
        }
        if ((is = AbstractComponent.getSpaceOwnerOfParent(comp)) instanceof Component) {
            ((AbstractComponent)((Object)is)).unbindFromIdSpace(compId);
        } else if (is != null) {
            ((PageCtrl)((Object)is)).removeFellow(comp);
        }
    }

    private static void checkIdSpaces(AbstractComponent comp, String newId) {
        if (comp instanceof NonFellow) {
            return;
        }
        if (comp instanceof IdSpace && comp._spaceInfo.fellows.containsKey(newId)) {
            throw new UiException("Not unique in the ID space of " + comp);
        }
        IdSpace is = AbstractComponent.getSpaceOwnerOfParent(comp);
        if (is instanceof Component ? ((AbstractComponent)((Object)is))._spaceInfo.fellows.containsKey(newId) : is != null && ((PageCtrl)((Object)is)).hasFellow(newId)) {
            throw new UiException("Not unique in the ID space of " + is);
        }
    }

    private static void addToIdSpacesDown(Component comp) {
        IdSpace is = AbstractComponent.getSpaceOwnerOfParent(comp);
        if (is instanceof Component) {
            AbstractComponent.addToIdSpacesDown(comp, (Component)((Object)is));
        } else if (is != null) {
            AbstractComponent.addToIdSpacesDown(comp, (PageCtrl)((Object)is));
        }
    }

    private static void addToIdSpacesDown(Component comp, Component owner) {
        if (!(comp instanceof NonFellow) && !ComponentsCtrl.isAutoId(comp.getId())) {
            ((AbstractComponent)owner).bindToIdSpace(comp);
        }
        if (!(comp instanceof IdSpace)) {
            Iterator it = comp.getChildren().iterator();
            while (it.hasNext()) {
                AbstractComponent.addToIdSpacesDown((Component)it.next(), owner);
            }
        }
    }

    private static void addToIdSpacesDown(Component comp, PageCtrl owner) {
        if (!(comp instanceof NonFellow) && !ComponentsCtrl.isAutoId(comp.getId())) {
            owner.addFellow(comp);
        }
        if (!(comp instanceof IdSpace)) {
            Iterator it = comp.getChildren().iterator();
            while (it.hasNext()) {
                AbstractComponent.addToIdSpacesDown((Component)it.next(), owner);
            }
        }
    }

    private static void removeFromIdSpacesDown(Component comp) {
        IdSpace is = AbstractComponent.getSpaceOwnerOfParent(comp);
        if (is instanceof Component) {
            AbstractComponent.removeFromIdSpacesDown(comp, (Component)((Object)is));
        } else if (is != null) {
            AbstractComponent.removeFromIdSpacesDown(comp, (PageCtrl)((Object)is));
        }
    }

    private static void removeFromIdSpacesDown(Component comp, Component owner) {
        String compId = comp.getId();
        if (!(comp instanceof NonFellow) && !ComponentsCtrl.isAutoId(compId)) {
            ((AbstractComponent)owner).unbindFromIdSpace(compId);
        }
        if (!(comp instanceof IdSpace)) {
            Iterator it = comp.getChildren().iterator();
            while (it.hasNext()) {
                AbstractComponent.removeFromIdSpacesDown((Component)it.next(), owner);
            }
        }
    }

    private static void removeFromIdSpacesDown(Component comp, PageCtrl owner) {
        if (!(comp instanceof NonFellow) && !ComponentsCtrl.isAutoId(comp.getId())) {
            owner.removeFellow(comp);
        }
        if (!(comp instanceof IdSpace)) {
            Iterator it = comp.getChildren().iterator();
            while (it.hasNext()) {
                AbstractComponent.removeFromIdSpacesDown((Component)it.next(), owner);
            }
        }
    }

    private static void checkIdSpacesDown(Component comp, Component newparent) {
        IdSpace is = newparent.getSpaceOwner();
        if (is instanceof Component) {
            AbstractComponent.checkIdSpacesDown(comp, ((AbstractComponent)((Object)is))._spaceInfo);
        } else if (is != null) {
            AbstractComponent.checkIdSpacesDown(comp, (PageCtrl)((Object)is));
        }
    }

    private static void checkIdSpacesDown(Component comp, SpaceInfo si) {
        String compId = comp.getId();
        if (!(comp instanceof NonFellow) && !ComponentsCtrl.isAutoId(compId) && si.fellows.containsKey(compId)) {
            throw new UiException("Not unique in the new ID space: " + compId);
        }
        if (!(comp instanceof IdSpace)) {
            Iterator it = comp.getChildren().iterator();
            while (it.hasNext()) {
                AbstractComponent.checkIdSpacesDown((Component)it.next(), si);
            }
        }
    }

    private static void checkIdSpacesDown(Component comp, PageCtrl pageCtrl) {
        String compId = comp.getId();
        if (!(comp instanceof NonFellow) && !ComponentsCtrl.isAutoId(compId) && pageCtrl.hasFellow(compId)) {
            throw new UiException("Not unique in the ID space of " + pageCtrl + ": " + compId);
        }
        if (!(comp instanceof IdSpace)) {
            Iterator it = comp.getChildren().iterator();
            while (it.hasNext()) {
                AbstractComponent.checkIdSpacesDown((Component)it.next(), pageCtrl);
            }
        }
    }

    private void bindToIdSpace(Component comp) {
        String compId = comp.getId();
        this._spaceInfo.fellows.put(compId, comp);
    }

    private void unbindFromIdSpace(String compId) {
        this._spaceInfo.fellows.remove(compId);
    }

    protected Object getMoldURI() {
        return this._def.getMoldURI(this, this.getMold());
    }

    private final UiEngine getThisUiEngine() {
        return ((WebAppCtrl)((Object)this._page.getDesktop().getWebApp())).getUiEngine();
    }

    public final Page getPage() {
        return this._page;
    }

    public final Desktop getDesktop() {
        return this._page != null ? this._page.getDesktop() : null;
    }

    public void setPage(Page page) {
        if (page != this._page) {
            this.setPageBefore(page, null);
        }
    }

    public void setPageBefore(Page page, Component refRoot) {
        boolean samepg;
        if (refRoot != null && (page == null || refRoot == this || refRoot.getParent() != null || refRoot.getPage() != page)) {
            refRoot = null;
        }
        if (this._parent != null) {
            throw new UiException("Only the parent of a root component can be changed: " + this);
        }
        boolean bl = samepg = page == this._page;
        if (!samepg) {
            if (page != null) {
                if (this._page != null && this._page.getDesktop() != page.getDesktop()) {
                    throw new UiException("The new page must be in the same desktop: " + page);
                }
                AbstractComponent.checkIdSpacesDown((Component)this, (PageCtrl)((Object)page));
            } else {
                AbstractComponent.checkDetach(this._page);
            }
            if (this._page != null) {
                AbstractComponent.removeFromIdSpacesDown(this);
            }
        }
        this.addMoved(this._parent, this._page, page);
        if (!samepg) {
            this.setPage0(page);
        }
        if (page != null && (samepg || refRoot != null)) {
            ((PageCtrl)((Object)page)).moveRoot(this, refRoot);
        }
        if (!samepg && this._page != null) {
            AbstractComponent.addToIdSpacesDown(this);
        }
    }

    private static void checkDetach(Page page) {
        Execution exec = Executions.getCurrent();
        if (exec == null) {
            throw new UiException("You cannot access a desktop other than an event listener");
        }
        if (page.getDesktop() != exec.getDesktop()) {
            throw new UiException("You cannot access components belong to other desktop");
        }
    }

    protected void addMoved(Component oldparent, Page oldpg, Page newpg) {
        Desktop dt;
        if (oldpg != null) {
            dt = oldpg.getDesktop();
        } else if (newpg != null) {
            dt = newpg.getDesktop();
        } else {
            return;
        }
        ((WebAppCtrl)((Object)dt.getWebApp())).getUiEngine().addMoved(this, oldparent, oldpg, newpg);
    }

    private void setPage0(Page page) {
        boolean bRoot;
        if (page == this._page) {
            return;
        }
        boolean bl = bRoot = this._parent == null;
        if (this._page != null) {
            if (bRoot) {
                ((PageCtrl)((Object)this._page)).removeRoot(this);
            }
            if (page == null) {
                ((DesktopCtrl)((Object)this._page.getDesktop())).removeComponent(this);
            }
        }
        Page oldpage = this._page;
        this._page = page;
        if (this._page != null) {
            if (bRoot) {
                ((PageCtrl)((Object)this._page)).addRoot(this);
            }
            Desktop desktop = this._page.getDesktop();
            if (oldpage == null) {
                if (this._uuid == null || this._uuid == "z__i" || desktop.getComponentByUuidIfAny(this._uuid) != null) {
                    this._uuid = this.nextUuid(desktop);
                }
                if (this._id == null || this instanceof RawId) {
                    this._id = this._uuid;
                }
                ((DesktopCtrl)((Object)desktop)).addComponent(this);
            }
            this.onPageAttached(this._page, oldpage);
        } else {
            this.onPageDetached(oldpage);
        }
        if (this._spaceInfo != null && this._parent == null) {
            this._spaceInfo.ns.setParent(page != null ? page.getNamespace() : null);
        }
        AbstractComponent p = this._first;
        while (p != null) {
            p.setPage0(page);
            p = p._next;
        }
    }

    private String nextUuid(Desktop desktop) {
        String uuid;
        IdGenerator idgen = ((WebAppCtrl)((Object)desktop.getWebApp())).getIdGenerator();
        do {
            String string = uuid = idgen != null ? idgen.nextComponentUuid(desktop, this) : null;
            if (uuid != null) continue;
            uuid = ((DesktopCtrl)((Object)desktop)).getNextUuid();
        } while (desktop.getComponentByUuidIfAny(uuid) != null);
        return uuid;
    }

    public String getId() {
        if (this._id == null) {
            this._id = this.getUuid();
        }
        return this._id;
    }

    public void setId(String id) {
        if (id == null || id.length() == 0) {
            throw new UiException("ID cannot be empty");
        }
        if (!Objects.equals((Object)this._id, (Object)id)) {
            if (Names.isReserved(id) || !(this instanceof NonFellow) && ComponentsCtrl.isAutoId(id)) {
                throw new UiException("Invalid ID: " + id + ". Cause: reserved words not allowed: " + Names.getReservedNames());
            }
            boolean rawId = this instanceof RawId;
            if (rawId && this._page != null && this._page.getDesktop().getComponentByUuidIfAny(id) != null) {
                throw new UiException("Replicated ID is not allowed for " + this.getClass() + ": " + id + "\nNote: HTML/WML tags, ID must be unique");
            }
            AbstractComponent.checkIdSpaces(this, id);
            AbstractComponent.removeFromIdSpaces(this);
            if (rawId) {
                if (this._page != null) {
                    this.getThisUiEngine().addUuidChanged(this, false);
                    ((DesktopCtrl)((Object)this._page.getDesktop())).removeComponent(this);
                }
                this._uuid = this._id = id;
                if (this._page != null) {
                    ((DesktopCtrl)((Object)this._page.getDesktop())).addComponent(this);
                    this.addMoved(this._parent, this._page, this._page);
                }
            } else {
                this._id = id;
            }
            AbstractComponent.addToIdSpaces(this);
            Object xc = this.getExtraCtrl();
            if (xc instanceof ZidRequired && ((ZidRequired)xc).isZidRequired()) {
                this.smartUpdate("z.zid", this._id);
            }
        }
    }

    public final String getUuid() {
        if (this._uuid == null) {
            Execution exec = Executions.getCurrent();
            String string = this._uuid = exec == null ? "z__i" : this.nextUuid(exec.getDesktop());
            if (this._id == null || this instanceof RawId) {
                this._id = this._uuid;
            }
        }
        return this._uuid;
    }

    public final IdSpace getSpaceOwner() {
        Component p = this;
        do {
            if (!(p instanceof IdSpace)) continue;
            return (IdSpace)((Object)p);
        } while ((p = p.getParent()) != null);
        return this._page;
    }

    public Component getFellow(String compId) {
        if (this instanceof IdSpace) {
            Component comp = (Component)this._spaceInfo.fellows.get(compId);
            if (comp == null) {
                if (compId != null && ComponentsCtrl.isAutoId(compId)) {
                    throw new ComponentNotFoundException(MZk.AUTO_ID_NOT_LOCATABLE, compId);
                }
                throw new ComponentNotFoundException("Fellow component not found: " + compId);
            }
            return comp;
        }
        IdSpace idspace = this.getSpaceOwner();
        if (idspace == null) {
            throw new ComponentNotFoundException("This component doesn't belong to any ID space: " + this);
        }
        return idspace.getFellow(compId);
    }

    public Component getFellowIfAny(String compId) {
        if (this instanceof IdSpace) {
            return (Component)this._spaceInfo.fellows.get(compId);
        }
        IdSpace idspace = this.getSpaceOwner();
        return idspace == null ? null : idspace.getFellowIfAny(compId);
    }

    public Component getNextSibling() {
        return this._next;
    }

    public Component getPreviousSibling() {
        return this._prev;
    }

    public Component getFirstChild() {
        return this._first;
    }

    public Component getLastChild() {
        return this._last;
    }

    public Map getAttributes(int scope) {
        switch (scope) {
            case 1: {
                if (this instanceof IdSpace) {
                    return this._spaceInfo.attrs;
                }
                IdSpace idspace = this.getSpaceOwner();
                return idspace instanceof Page ? ((Page)idspace).getAttributes() : (idspace == null ? Collections.EMPTY_MAP : ((Component)((Object)idspace)).getAttributes(1));
            }
            case 2: {
                return this._page != null ? this._page.getAttributes() : Collections.EMPTY_MAP;
            }
            case 3: {
                return this._page != null ? this._page.getDesktop().getAttributes() : Collections.EMPTY_MAP;
            }
            case 4: {
                return this._page != null ? this._page.getDesktop().getSession().getAttributes() : Collections.EMPTY_MAP;
            }
            case 5: {
                return this._page != null ? this._page.getDesktop().getWebApp().getAttributes() : Collections.EMPTY_MAP;
            }
            case 0: {
                return this._attrs;
            }
            case 6: {
                Execution exec = this.getExecution();
                if (exec == null) break;
                return exec.getAttributes();
            }
        }
        return Collections.EMPTY_MAP;
    }

    private final Execution getExecution() {
        return this._page != null ? this._page.getDesktop().getExecution() : Executions.getCurrent();
    }

    public Object getAttribute(String name, int scope) {
        return this.getAttributes(scope).get(name);
    }

    public Object setAttribute(String name, Object value, int scope) {
        if (value != null) {
            Map attrs = this.getAttributes(scope);
            if (attrs == Collections.EMPTY_MAP) {
                throw new IllegalStateException("This component, " + this + ", doesn't belong to the " + Components.scopeToString(scope) + " scope");
            }
            return attrs.put(name, value);
        }
        return this.removeAttribute(name, scope);
    }

    public Object removeAttribute(String name, int scope) {
        Map attrs = this.getAttributes(scope);
        if (attrs == Collections.EMPTY_MAP) {
            throw new IllegalStateException("This component doesn't belong to any ID space: " + this);
        }
        return attrs.remove(name);
    }

    public final Map getAttributes() {
        return this._attrs;
    }

    public final Object getAttribute(String name) {
        return this._attrs.get(name);
    }

    public final Object setAttribute(String name, Object value) {
        return value != null ? this._attrs.put(name, value) : this._attrs.remove(name);
    }

    public final Object removeAttribute(String name) {
        return this._attrs.remove(name);
    }

    public void setVariable(String name, Object val, boolean local) {
        this.getNamespace().setVariable(name, val, local);
    }

    public boolean containsVariable(String name, boolean local) {
        return this.getNamespace().containsVariable(name, local);
    }

    public Object getVariable(String name, boolean local) {
        return this.getNamespace().getVariable(name, local);
    }

    public void unsetVariable(String name, boolean local) {
        this.getNamespace().unsetVariable(name, local);
    }

    public Component getParent() {
        return this._parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParent(Component parent) {
        AbstractComponent op;
        boolean idSpaceChanged;
        if (this._parent == parent) {
            return;
        }
        AbstractComponent.checkParentChild(parent, this);
        boolean bl = parent != null ? parent.getSpaceOwner() != (this._parent != null ? this._parent.getSpaceOwner() : this._page) : (idSpaceChanged = this._page != null);
        if (idSpaceChanged) {
            AbstractComponent.removeFromIdSpacesDown(this);
        }
        if ((op = this._parent) != null) {
            if (!op.inRemoving(this)) {
                op.markRemoving(this, true);
                try {
                    op.removeChild(this);
                }
                finally {
                    op.markRemoving(this, false);
                }
            }
            this._parent = null;
        } else if (this._page != null) {
            ((PageCtrl)((Object)this._page)).removeRoot(this);
        }
        if (parent != null) {
            AbstractComponent np = (AbstractComponent)parent;
            if (!np.inAdding(this)) {
                np.markAdding(this, true);
                try {
                    np.insertBefore(this, null);
                }
                finally {
                    np.markAdding(this, false);
                }
            }
            this._parent = np;
        }
        Page newpg = this._parent != null ? this._parent.getPage() : null;
        this.addMoved(op, this._page, newpg);
        this.setPage0(newpg);
        if (this._spaceInfo != null) {
            this._spaceInfo.ns.setParent(this._parent != null ? this._parent.getNamespace() : null);
        }
        if (idSpaceChanged) {
            AbstractComponent.addToIdSpacesDown(this);
        }
    }

    private boolean inRemoving(Component child) {
        return this._rming != null && this._rming.contains(child);
    }

    private void markRemoving(Component child, boolean set) {
        if (set) {
            if (this._rming == null) {
                this._rming = new HashSet(2);
            }
            this._rming.add(child);
        } else if (this._rming != null && this._rming.remove(child) && this._rming.isEmpty()) {
            this._rming = null;
        }
    }

    private boolean inAdding(Component child) {
        return this._adding != null && this._adding.contains(child);
    }

    private void markAdding(Component child, boolean set) {
        if (set) {
            if (this._adding == null) {
                this._adding = new HashSet(2);
            }
            this._adding.add(child);
        } else if (this._adding != null && this._adding.remove(child) && this._adding.isEmpty()) {
            this._adding = null;
        }
    }

    private static void checkParentChild(Component parent, Component child) throws UiException {
        if (parent != null) {
            if (((AbstractComponent)parent).inAdding(child)) {
                return;
            }
            if (Components.isAncestor(child, parent)) {
                throw new UiException("A child cannot be a parent of its ancestor: " + child);
            }
            if (!parent.isChildable()) {
                throw new UiException(parent + " doesn't allow any child");
            }
            Page parentpg = parent.getPage();
            Page childpg = child.getPage();
            if (parentpg != null && childpg != null && parentpg.getDesktop() != childpg.getDesktop()) {
                throw new UiException("The parent and child must be in the same desktop: " + parent);
            }
            Component oldparent = child.getParent();
            if (parent.getSpaceOwner() != (oldparent != null ? oldparent.getSpaceOwner() : childpg)) {
                AbstractComponent.checkIdSpacesDown(child, parent);
            }
        } else {
            Page childpg = child.getPage();
            if (childpg != null) {
                AbstractComponent.checkDetach(childpg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insertBefore(Component newChild, Component refChild) {
        boolean moved;
        AbstractComponent.checkParentChild(this, newChild);
        if (refChild != null && refChild.getParent() != this) {
            refChild = null;
        }
        AbstractComponent nc = (AbstractComponent)newChild;
        boolean bl = moved = nc._parent == this;
        if (moved) {
            if (nc._next == refChild) {
                return false;
            }
            nc.addMoved(this, this._page, this._page);
            this.setNext(nc._prev, nc._next);
            this.setPrev(nc._next, nc._prev);
        } else if (!this.inAdding(nc)) {
            this.markAdding(nc, true);
            try {
                nc.setParent(this);
            }
            finally {
                this.markAdding(nc, false);
            }
        } else {
            nc._parent = this;
        }
        if (refChild != null) {
            AbstractComponent ref = (AbstractComponent)refChild;
            this.setNext(nc, ref);
            this.setPrev(nc, ref._prev);
            this.setNext(ref._prev, nc);
            this.setPrev(ref, nc);
        } else if (this._last == null) {
            this._first = this._last = nc;
            nc._prev = null;
            nc._next = null;
        } else {
            this._last._next = nc;
            nc._prev = this._last;
            nc._next = null;
            this._last = nc;
        }
        ++this._modCntChd;
        if (!moved) {
            ++this._nChild;
            this.onChildAdded(nc);
        }
        return true;
    }

    private final void setNext(AbstractComponent comp, AbstractComponent next) {
        if (comp != null) {
            comp._next = next;
        } else {
            this._first = next;
        }
    }

    private final void setPrev(AbstractComponent comp, AbstractComponent prev) {
        if (comp != null) {
            comp._prev = prev;
        } else {
            this._last = prev;
        }
    }

    public final boolean appendChild(Component child) {
        return this.insertBefore(child, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeChild(Component child) {
        if (child.getParent() != this) {
            return false;
        }
        AbstractComponent oc = (AbstractComponent)child;
        this.setNext(oc._prev, oc._next);
        this.setPrev(oc._next, oc._prev);
        oc._prev = null;
        oc._next = null;
        if (!this.inRemoving(oc)) {
            this.markRemoving(oc, true);
            try {
                oc.setParent(null);
            }
            finally {
                this.markRemoving(oc, false);
            }
        } else {
            oc._parent = null;
        }
        ++this._modCntChd;
        --this._nChild;
        this.onChildRemoved(child);
        return true;
    }

    public boolean isChildable() {
        return true;
    }

    public List getChildren() {
        return this._apiChildren;
    }

    public Component getRoot() {
        Component comp = this;
        Component parent;
        while ((parent = comp.getParent()) != null) {
            comp = parent;
        }
        return comp;
    }

    public boolean isVisible() {
        return this._visible;
    }

    public boolean setVisible(boolean visible) {
        boolean old = this._visible;
        if (old != visible) {
            this._visible = visible;
            this.smartUpdate("visibility", this._visible);
        }
        return old;
    }

    public void invalidate() {
        if (this._page != null) {
            this.getThisUiEngine().addInvalidate(this);
        }
    }

    public void response(String key, AuResponse response) {
        Execution exec;
        if (this._page != null) {
            this.getThisUiEngine().addResponse(key, response);
        } else if (response.getDepends() != this && (exec = Executions.getCurrent()) != null) {
            ((WebAppCtrl)((Object)exec.getDesktop().getWebApp())).getUiEngine().addResponse(key, response);
        }
    }

    public void smartUpdate(String attr, String value) {
        if (this._page != null) {
            this.getThisUiEngine().addSmartUpdate((Component)this, attr, value);
        }
    }

    public void smartUpdateDeferred(String attr, DeferredValue value) {
        if (this._page != null) {
            this.getThisUiEngine().addSmartUpdate((Component)this, attr, value);
        }
    }

    public void smartUpdate(String attr, int value) {
        this.smartUpdate(attr, Integer.toString(value));
    }

    public void smartUpdate(String attr, boolean value) {
        this.smartUpdate(attr, Boolean.toString(value));
    }

    public void detach() {
        if (this.getParent() != null) {
            this.setParent(null);
        } else {
            this.setPage(null);
        }
    }

    public void onChildAdded(Component child) {
    }

    public void onChildRemoved(Component child) {
    }

    public void onPageAttached(Page newpage, Page oldpage) {
        if (oldpage == null) {
            this.onListenerChanged(newpage.getDesktop(), true);
        }
    }

    public void onPageDetached(Page page) {
        this.onListenerChanged(page.getDesktop(), false);
    }

    public Component getPropagatee(String evtnm) {
        return null;
    }

    public final String getMold() {
        return this._mold;
    }

    public void setMold(String mold) {
        if (mold == null || mold.length() == 0) {
            mold = "default";
        }
        if (!Objects.equals((Object)this._mold, (Object)mold)) {
            if (!this._def.hasMold(mold)) {
                throw new UiException("Unknown mold: " + mold + ", while allowed include " + this._def.getMoldNames());
            }
            this._mold = mold;
            this.invalidate();
        }
    }

    public void redraw(Writer out) throws IOException {
        Object mold = this.getMoldURI();
        if (mold instanceof ComponentRenderer) {
            ((ComponentRenderer)mold).render(this, out != null ? out : ZkFns.getCurrentOut());
        } else {
            HashMap<String, AbstractComponent> attrs = new HashMap<String, AbstractComponent>(2);
            attrs.put("self", this);
            this.getExecution().include(out, (String)mold, attrs, 3);
        }
    }

    public void onDrawNewChild(Component child, StringBuffer out) throws IOException {
    }

    protected boolean isAsapRequired(String evtnm) {
        return Events.isListened(this, evtnm, true);
    }

    protected StringBuffer appendAsapAttr(StringBuffer sb, String evtnm) {
        if (this.isAsapRequired(evtnm)) {
            if (sb == null) {
                sb = new StringBuffer(80);
            }
            HTMLs.appendAttribute((StringBuffer)sb, (String)AbstractComponent.getAttrOfEvent(evtnm), (boolean)true);
        }
        return sb;
    }

    private static String getAttrOfEvent(String evtnm) {
        return "onClick".equals(evtnm) ? "z.lfclk" : ("onRightClick".equals(evtnm) ? "z.rtclk" : ("onDoubleClick".equals(evtnm) ? "z.dbclk" : "z." + evtnm));
    }

    public boolean addEventListener(String evtnm, EventListener listener) {
        LinkedList<EventListener> l;
        if (evtnm == null || listener == null) {
            throw new IllegalArgumentException("null");
        }
        if (!Events.isValid(evtnm)) {
            throw new IllegalArgumentException("Invalid event name: " + evtnm);
        }
        boolean asap = this.isAsapRequired(evtnm);
        if (this._listeners == null) {
            this._listeners = new HashMap(8);
        }
        if ((l = (LinkedList<EventListener>)this._listeners.get(evtnm)) != null) {
            Iterator it = l.iterator();
            while (it.hasNext()) {
                EventListener li = (EventListener)it.next();
                if (!listener.equals(li)) continue;
                return false;
            }
        } else {
            l = new LinkedList<EventListener>();
            this._listeners.put(evtnm, l);
        }
        l.add(listener);
        Desktop desktop = this.getDesktop();
        if (desktop != null) {
            if ("onClientInfo".equals(evtnm)) {
                this.response("clientInfo", new AuClientInfo(desktop));
            }
            if ("onPiggyback".equals(evtnm)) {
                ((DesktopCtrl)((Object)desktop)).onPiggybackListened(this, true);
            }
            if (!asap && this.isAsapRequired(evtnm)) {
                this.smartUpdate(AbstractComponent.getAttrOfEvent(evtnm), "true");
            }
        }
        return true;
    }

    public boolean removeEventListener(String evtnm, EventListener listener) {
        if (evtnm == null || listener == null) {
            throw new IllegalArgumentException("null");
        }
        if (this._listeners != null) {
            boolean asap = this.isAsapRequired(evtnm);
            List l = (List)this._listeners.get(evtnm);
            if (l != null) {
                Iterator it = l.iterator();
                while (it.hasNext()) {
                    EventListener li = (EventListener)it.next();
                    if (!listener.equals(li)) continue;
                    if (l.size() == 1) {
                        this._listeners.remove(evtnm);
                    } else {
                        it.remove();
                    }
                    Desktop desktop = this.getDesktop();
                    if (desktop != null) {
                        this.onListenerChanged(desktop, false);
                        if (asap && !this.isAsapRequired(evtnm)) {
                            this.smartUpdate(AbstractComponent.getAttrOfEvent(evtnm), null);
                        }
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public boolean addForward(String orgEvent, Component target, String targetEvent) {
        return this.addForward0(orgEvent, target, targetEvent);
    }

    public boolean addForward(String orgEvent, String targetPath, String targetEvent) {
        return this.addForward0(orgEvent, targetPath, targetEvent);
    }

    private boolean addForward0(String orgEvent, Object target, String targetEvent) {
        LinkedList<Object[]> fwds;
        Object[] info;
        if (orgEvent == null) {
            orgEvent = "onClick";
        } else if (!Events.isValid(orgEvent)) {
            throw new IllegalArgumentException("Illegal event name: " + orgEvent);
        }
        if (targetEvent == null) {
            targetEvent = orgEvent;
        } else if (!Events.isValid(targetEvent)) {
            throw new IllegalArgumentException("Illegal event name: " + targetEvent);
        }
        if (this._forwards == null) {
            this._forwards = new HashMap(4);
        }
        if ((info = (Object[])this._forwards.get(orgEvent)) != null) {
            fwds = (LinkedList<Object[]>)info[1];
            Iterator it = fwds.iterator();
            while (it.hasNext()) {
                Object[] fwd = (Object[])it.next();
                if (!Objects.equals((Object)fwd[0], (Object)target) || !Objects.equals((Object)fwd[1], (Object)targetEvent)) continue;
                return false;
            }
        } else {
            ForwardListener listener = new ForwardListener(orgEvent);
            this.addEventListener(orgEvent, listener);
            fwds = new LinkedList<Object[]>();
            info = new Object[]{listener, fwds};
            this._forwards.put(orgEvent, info);
        }
        fwds.add(new Object[]{target, targetEvent});
        return true;
    }

    public boolean removeForward(String orgEvent, Component target, String targetEvent) {
        return this.removeForward0(orgEvent, target, targetEvent);
    }

    public boolean removeForward(String orgEvent, String targetPath, String targetEvent) {
        return this.removeForward0(orgEvent, targetPath, targetEvent);
    }

    private boolean removeForward0(String orgEvent, Object target, String targetEvent) {
        Object[] info;
        if (this._forwards != null && (info = (Object[])this._forwards.get(orgEvent)) != null) {
            List fwds = (List)info[1];
            Iterator it = fwds.iterator();
            while (it.hasNext()) {
                Object[] fwd = (Object[])it.next();
                if (!Objects.equals((Object)fwd[0], (Object)target) || !Objects.equals((Object)fwd[1], (Object)targetEvent)) continue;
                it.remove();
                if (fwds.isEmpty()) {
                    this._forwards.remove(orgEvent);
                    this.removeEventListener(orgEvent, (EventListener)info[0]);
                }
                return true;
            }
        }
        return false;
    }

    public Namespace getNamespace() {
        if (this instanceof IdSpace) {
            return this._spaceInfo.ns;
        }
        IdSpace idspace = this.getSpaceOwner();
        return idspace instanceof Page ? ((Page)idspace).getNamespace() : (idspace == null ? null : ((Component)((Object)idspace)).getNamespace());
    }

    public boolean isListenerAvailable(String evtnm, boolean asap) {
        List l;
        if (this._listeners != null && (l = (List)this._listeners.get(evtnm)) != null) {
            if (!asap) {
                return !l.isEmpty();
            }
            Iterator it = l.iterator();
            while (it.hasNext()) {
                EventListener li = (EventListener)it.next();
                if (li instanceof Deferrable && ((Deferrable)((Object)li)).isDeferrable()) continue;
                return true;
            }
        }
        return false;
    }

    public Iterator getListenerIterator(String evtnm) {
        List l;
        if (this._listeners != null && (l = (List)this._listeners.get(evtnm)) != null) {
            return new ListenerIterator(l);
        }
        return CollectionsX.EMPTY_ITERATOR;
    }

    public void applyProperties() {
        this._def.applyProperties(this);
    }

    public ComponentDefinition getDefinition() {
        return this._def;
    }

    public void setComponentDefinition(ComponentDefinition compdef) {
        if (compdef == null) {
            throw new IllegalArgumentException("null");
        }
        if (!compdef.isInstance(this)) {
            throw new IllegalArgumentException("Incompatible " + compdef + " for " + this);
        }
        this._def = compdef;
    }

    public ZScript getEventHandler(String evtnm) {
        EventHandler evthd = this._evthds != null ? this._evthds.get(this, evtnm) : null;
        return evthd != null ? evthd.getZScript() : null;
    }

    public void addSharedEventHandlerMap(EventHandlerMap evthds) {
        if (evthds != null && !evthds.isEmpty()) {
            this.unshareEventHandlerMap(false);
            if (this._evthds == null) {
                this._evthds = evthds;
                this._evthdsShared = true;
            } else {
                this._evthds.addAll(evthds);
            }
            Desktop desktop = this.getDesktop();
            if (desktop != null) {
                this.onListenerChanged(desktop, true);
            }
        }
    }

    public Set getEventHandlerNames() {
        return this._evthds != null ? this._evthds.getEventNames() : Collections.EMPTY_SET;
    }

    private void onListenerChanged(Desktop desktop, boolean listen) {
        if (listen) {
            if (Events.isListened(this, "onClientInfo", false)) {
                this.response("clientInfo", new AuClientInfo(desktop));
            }
            if (Events.isListened(this, "onPiggyback", false)) {
                ((DesktopCtrl)((Object)desktop)).onPiggybackListened(this, true);
            }
        } else if (!Events.isListened(this, "onPiggyback", false)) {
            ((DesktopCtrl)((Object)desktop)).onPiggybackListened(this, false);
        }
    }

    public void addEventHandler(String name, EventHandler evthd) {
        if (name == null || evthd == null) {
            throw new IllegalArgumentException("name and evthd required");
        }
        this.unshareEventHandlerMap(true);
        this._evthds.add(name, evthd);
    }

    private void unshareEventHandlerMap(boolean autocreate) {
        if (this._evthdsShared) {
            this._evthds = (EventHandlerMap)this._evthds.clone();
            this._evthdsShared = false;
        } else if (autocreate && this._evthds == null) {
            this._evthds = new EventHandlerMap();
        }
    }

    public Annotation getAnnotation(String annotName) {
        return this._annots != null ? this._annots.getAnnotation(annotName) : null;
    }

    public Annotation getAnnotation(String propName, String annotName) {
        return this._annots != null ? this._annots.getAnnotation(propName, annotName) : null;
    }

    public Collection getAnnotations() {
        return this._annots != null ? this._annots.getAnnotations() : Collections.EMPTY_LIST;
    }

    public Collection getAnnotations(String propName) {
        return this._annots != null ? this._annots.getAnnotations(propName) : Collections.EMPTY_LIST;
    }

    public List getAnnotatedPropertiesBy(String annotName) {
        return this._annots != null ? this._annots.getAnnotatedPropertiesBy(annotName) : Collections.EMPTY_LIST;
    }

    public List getAnnotatedProperties() {
        return this._annots != null ? this._annots.getAnnotatedProperties() : Collections.EMPTY_LIST;
    }

    public void addSharedAnnotationMap(AnnotationMap annots) {
        if (annots != null && !annots.isEmpty()) {
            this.unshareAnnotationMap(false);
            if (this._annots == null) {
                this._annots = annots;
                this._annotsShared = true;
            } else {
                this._annots.addAll(annots);
            }
        }
    }

    public void addAnnotation(String annotName, Map annotAttrs) {
        this.unshareAnnotationMap(true);
        this._annots.addAnnotation(annotName, annotAttrs);
    }

    public void addAnnotation(String propName, String annotName, Map annotAttrs) {
        this.unshareAnnotationMap(true);
        this._annots.addAnnotation(propName, annotName, annotAttrs);
    }

    private void unshareAnnotationMap(boolean autocreate) {
        if (this._annotsShared) {
            this._annots = (AnnotationMap)this._annots.clone();
            this._annotsShared = false;
        } else if (autocreate && this._annots == null) {
            this._annots = new AnnotationMap();
        }
    }

    public void sessionWillPassivate(Page page) {
    }

    public void sessionDidActivate(Page page) {
        AbstractComponent.sessionDidActivate0(page, this, true);
    }

    private static void sessionDidActivate0(Page page, AbstractComponent comp, boolean pageLevelIdSpace) {
        comp._page = page;
        if (pageLevelIdSpace && comp._spaceInfo != null) {
            pageLevelIdSpace = false;
            comp._spaceInfo.ns.setParent(page.getNamespace());
        }
        AbstractComponent p = comp._first;
        while (p != null) {
            AbstractComponent.sessionDidActivate0(page, p, pageLevelIdSpace);
            p = p._next;
        }
    }

    public Object getExtraCtrl() {
        return this._xtrl;
    }

    protected Object newExtraCtrl() {
        return null;
    }

    public WrongValueException onWrongValue(WrongValueException ex) {
        return ex;
    }

    public String toString() {
        String clsnm = this.getClass().getName();
        int j = clsnm.lastIndexOf(46);
        return "<" + clsnm.substring(j + 1) + ' ' + (this._id == null || ComponentsCtrl.isAutoId(this._id) ? this._uuid : this._id) + '>';
    }

    public final boolean equals(Object o) {
        return this == o;
    }

    public Object clone() {
        Map.Entry me;
        AbstractComponent clone;
        try {
            clone = (AbstractComponent)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        clone._page = null;
        clone._parent = null;
        clone._attrs = new HashMap(4);
        Iterator it = this._attrs.entrySet().iterator();
        while (it.hasNext()) {
            me = it.next();
            Object val = me.getValue();
            if (val instanceof ComponentCloneListener && (val = ((ComponentCloneListener)val).clone(clone)) == null) continue;
            clone._attrs.put(me.getKey(), val);
        }
        if (this._listeners != null) {
            clone._listeners = new HashMap(4);
            it = this._listeners.entrySet().iterator();
            while (it.hasNext()) {
                me = it.next();
                LinkedList list = new LinkedList();
                Iterator it2 = ((List)me.getValue()).iterator();
                while (it2.hasNext()) {
                    Object val = it2.next();
                    if (val instanceof ComponentCloneListener && (val = ((ComponentCloneListener)val).clone(clone)) == null) continue;
                    list.add(val);
                }
                if (list.isEmpty()) continue;
                clone._listeners.put(me.getKey(), list);
            }
        }
        if (!this._annotsShared && this._annots != null) {
            clone._annots = (AnnotationMap)this._annots.clone();
        }
        if (!this._evthdsShared && this._evthds != null) {
            clone._evthds = (EventHandlerMap)this._evthds.clone();
        }
        AbstractComponent.cloneChildren(clone);
        clone.init(true);
        if (clone._spaceInfo != null) {
            clone._spaceInfo = new SpaceInfo(clone, this._spaceInfo.ns);
            AbstractComponent.cloneSpaceInfo(clone, this._spaceInfo);
        }
        if (clone._forwards != null) {
            clone._forwards = null;
            it = this._forwards.entrySet().iterator();
            while (it.hasNext()) {
                me = it.next();
                String orgEvent = (String)me.getKey();
                Object[] info = (Object[])me.getValue();
                List fwds = (List)info[1];
                Iterator e = fwds.iterator();
                while (e.hasNext()) {
                    Object[] fwd = (Object[])e.next();
                    clone.addForward0(orgEvent, fwd[0], (String)fwd[1]);
                }
            }
        }
        return clone;
    }

    private static final void cloneSpaceInfo(AbstractComponent clone, SpaceInfo from) {
        SpaceInfo to = clone._spaceInfo;
        to.attrs = new HashMap(8);
        Iterator it = from.attrs.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry me = it.next();
            Object val = me.getValue();
            if (val instanceof ComponentCloneListener && (val = ((ComponentCloneListener)val).clone(clone)) == null) continue;
            to.attrs.put(me.getKey(), val);
        }
        clone.bindToIdSpace(clone);
        AbstractComponent p = clone._first;
        while (p != null) {
            AbstractComponent.addToIdSpacesDown((Component)p, clone);
            p = p._next;
        }
    }

    private static final void cloneChildren(AbstractComponent comp) {
        AbstractComponent q = null;
        AbstractComponent p = comp._first;
        while (p != null) {
            AbstractComponent child = (AbstractComponent)p.clone();
            if (q != null) {
                q._next = child;
            } else {
                comp._first = child;
            }
            child._prev = q;
            q = child;
            child._parent = comp;
            if (child._spaceInfo != null) {
                child._spaceInfo.ns.setParent(comp.getNamespace());
            }
            p = p._next;
        }
        comp._last = q;
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        Map.Entry me;
        Iterator it;
        s.defaultWriteObject();
        if (this._def == ComponentsCtrl.DUMMY) {
            s.writeObject(null);
        } else {
            LanguageDefinition langdef = this._def.getLanguageDefinition();
            if (langdef != null) {
                s.writeObject(langdef.getName());
                s.writeObject(this._def.getName());
            } else {
                s.writeObject(this._def);
            }
        }
        AbstractComponent p = this._first;
        while (p != null) {
            s.writeObject(p);
            p = p._next;
        }
        s.writeObject(null);
        this.willSerialize(this._attrs.values());
        Serializables.smartWrite((ObjectOutputStream)s, (Map)this._attrs);
        if (this._listeners != null) {
            it = this._listeners.entrySet().iterator();
            while (it.hasNext()) {
                me = it.next();
                s.writeObject(me.getKey());
                Collection ls = (Collection)me.getValue();
                this.willSerialize(ls);
                Serializables.smartWrite((ObjectOutputStream)s, (Collection)ls);
            }
        }
        s.writeObject(null);
        if (this instanceof IdSpace) {
            this.willSerialize(this._spaceInfo.attrs.values());
            Serializables.smartWrite((ObjectOutputStream)s, (Map)this._spaceInfo.attrs);
            it = this._spaceInfo.ns.getVariableNames().iterator();
            while (it.hasNext()) {
                String nm = (String)((Object)it.next());
                Object val = this._spaceInfo.ns.getVariable(nm, true);
                this.willSerialize(val);
                if (!AbstractComponent.isVariableSerializable(nm, val) || !(val instanceof Serializable) && !(val instanceof Externalizable)) continue;
                s.writeObject(nm);
                s.writeObject(val);
            }
            s.writeObject(null);
        }
        if (this._forwards != null) {
            it = this._forwards.entrySet().iterator();
            while (it.hasNext()) {
                me = it.next();
                s.writeObject(me.getKey());
                Object[] info = (Object[])me.getValue();
                List fwds = (List)info[1];
                s.writeInt(fwds.size());
                Iterator e = fwds.iterator();
                while (e.hasNext()) {
                    Object[] fwd = (Object[])e.next();
                    s.writeObject(fwd[0] instanceof Component ? Components.componentToPath((Component)fwd[0], this) : fwd[0]);
                    s.writeObject(fwd[1]);
                }
            }
        }
        s.writeObject(null);
    }

    private void willSerialize(Collection c) {
        if (c != null) {
            Iterator it = c.iterator();
            while (it.hasNext()) {
                this.willSerialize(it.next());
            }
        }
    }

    private void willSerialize(Object o) {
        if (o instanceof ComponentSerializationListener) {
            ((ComponentSerializationListener)o).willSerialize(this);
        }
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        String orgEvent;
        String evtnm;
        s.defaultReadObject();
        this.init(false);
        Object def = s.readObject();
        if (def == null) {
            this._def = ComponentsCtrl.DUMMY;
        } else if (def instanceof String) {
            LanguageDefinition langdef = LanguageDefinition.lookup((String)def);
            this._def = langdef.getComponentDefinition((String)s.readObject());
        } else {
            this._def = (ComponentDefinition)def;
        }
        AbstractComponent q = null;
        while (true) {
            AbstractComponent child;
            if ((child = (AbstractComponent)s.readObject()) == null) break;
            if (q != null) {
                q._next = child;
            } else {
                this._first = child;
            }
            child._prev = q;
            child._parent = this;
            q = child;
        }
        this._last = q;
        Serializables.smartRead((ObjectInputStream)s, (Map)this._attrs);
        this.didDeserialize(this._attrs.values());
        while ((evtnm = (String)s.readObject()) != null) {
            if (this._listeners == null) {
                this._listeners = new HashMap(4);
            }
            Collection ls = Serializables.smartRead((ObjectInputStream)s, (Collection)null);
            this._listeners.put(evtnm, ls);
            this.didDeserialize(ls);
        }
        if (this instanceof IdSpace) {
            String nm;
            this._spaceInfo = new SpaceInfo((Component)this);
            AbstractComponent.fixSpaceParentOneLevelDown(this, this._spaceInfo.ns);
            Serializables.smartRead((ObjectInputStream)s, (Map)this._spaceInfo.attrs);
            this.didDeserialize(this._spaceInfo.attrs.values());
            while ((nm = (String)s.readObject()) != null) {
                Object val = s.readObject();
                this._spaceInfo.ns.setVariable(nm, val, true);
                this.didDeserialize(val);
            }
            this.bindToIdSpace(this);
            Iterator it = this.getChildren().iterator();
            while (it.hasNext()) {
                AbstractComponent.addToIdSpacesDown((Component)it.next(), this);
            }
        }
        while ((orgEvent = (String)s.readObject()) != null) {
            int sz = s.readInt();
            while (--sz >= 0) {
                this.addForward0(orgEvent, s.readObject(), (String)s.readObject());
            }
        }
    }

    private void didDeserialize(Collection c) {
        if (c != null) {
            Iterator it = c.iterator();
            while (it.hasNext()) {
                this.didDeserialize(it.next());
            }
        }
    }

    private void didDeserialize(Object o) {
        if (o instanceof ComponentSerializationListener) {
            ((ComponentSerializationListener)o).didDeserialize(this);
        }
    }

    private static boolean isVariableSerializable(String name, Object value) {
        return !"spaceScope".equals(name) && !"spaceOwner".equals(name) && !(value instanceof Component);
    }

    private static final void fixSpaceParentOneLevelDown(Component comp, Namespace nsparent) {
        Iterator it = comp.getChildren().iterator();
        while (it.hasNext()) {
            AbstractComponent child = (AbstractComponent)it.next();
            if (child._spaceInfo != null) {
                child._spaceInfo.ns.setParent(nsparent);
                continue;
            }
            AbstractComponent.fixSpaceParentOneLevelDown(child, nsparent);
        }
    }

    private class ForwardListener
    implements EventListener,
    ComponentCloneListener {
        private final String _orgEvent;

        private ForwardListener(String orgEvent) {
            this._orgEvent = orgEvent;
        }

        public void onEvent(Event event) {
            Object[] info = (Object[])AbstractComponent.this._forwards.get(this._orgEvent);
            if (info != null) {
                Iterator it = ((List)info[1]).iterator();
                while (it.hasNext()) {
                    Component target;
                    Object[] fwd = (Object[])it.next();
                    Component component = target = fwd[0] instanceof String ? Components.pathToComponent((String)fwd[0], AbstractComponent.this) : (Component)fwd[0];
                    if (target == null) {
                        IdSpace owner = AbstractComponent.this.getSpaceOwner();
                        if (owner instanceof Component) {
                            target = (Component)((Object)owner);
                        } else {
                            Component p;
                            target = AbstractComponent.this;
                            while ((p = target.getParent()) != null) {
                                target = p;
                            }
                        }
                    }
                    Events.postEvent(new ForwardEvent((String)fwd[1], target, event));
                }
            }
        }

        public Object clone(Component comp) {
            return null;
        }
    }

    private class ChildIter
    implements ListIterator {
        private AbstractComponent _p;
        private AbstractComponent _lastRet;
        private int _j;
        private int _modCntSnap;

        private ChildIter(int index) {
            if (index < 0 || index > AbstractComponent.this._nChild) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + AbstractComponent.this._nChild);
            }
            if (index < AbstractComponent.this._nChild >> 1) {
                this._p = AbstractComponent.this._first;
                this._j = 0;
                while (this._j < index) {
                    this._p = this._p._next;
                    ++this._j;
                }
            } else {
                this._p = null;
                this._j = AbstractComponent.this._nChild;
                while (this._j > index) {
                    this._p = this._p != null ? this._p._prev : AbstractComponent.this._last;
                    --this._j;
                }
            }
            this._modCntSnap = AbstractComponent.this._modCntChd;
        }

        public boolean hasNext() {
            this.checkComodification();
            return this._j < AbstractComponent.this._nChild;
        }

        public Object next() {
            if (this._j >= AbstractComponent.this._nChild) {
                throw new NoSuchElementException();
            }
            this.checkComodification();
            this._lastRet = this._p;
            this._p = this._p._next;
            ++this._j;
            return this._lastRet;
        }

        public boolean hasPrevious() {
            this.checkComodification();
            return this._j > 0;
        }

        public Object previous() {
            if (this._j <= 0) {
                throw new NoSuchElementException();
            }
            this.checkComodification();
            this._p = this._p != null ? this._p._prev : AbstractComponent.this._last;
            this._lastRet = this._p;
            --this._j;
            return this._lastRet;
        }

        private void checkComodification() {
            if (AbstractComponent.this._modCntChd != this._modCntSnap) {
                throw new ConcurrentModificationException();
            }
        }

        public int nextIndex() {
            return this._j;
        }

        public int previousIndex() {
            return this._j - 1;
        }

        public void add(Object o) {
            Component newChild = (Component)o;
            if (newChild.getParent() == AbstractComponent.this) {
                throw new UnsupportedOperationException("Unable to add component with the same parent: " + o);
            }
            this.checkComodification();
            AbstractComponent.this.insertBefore(newChild, this._p);
            ++this._j;
            this._lastRet = null;
            ++this._modCntSnap;
        }

        public void remove() {
            if (this._lastRet == null) {
                throw new IllegalStateException();
            }
            this.checkComodification();
            AbstractComponent.this.removeChild(this._lastRet);
            if (this._p == this._lastRet) {
                this._p = this._lastRet._next;
            } else {
                --this._j;
            }
            this._lastRet = null;
            ++this._modCntSnap;
        }

        public void set(Object o) {
            throw new UnsupportedOperationException();
        }
    }

    private static class SpaceInfo {
        private Map attrs = new HashMap(8);
        private SimpleNamespace ns;
        private Map fellows = new HashMap(32);

        private SpaceInfo(Component owner) {
            this.ns = new SimpleNamespace(owner);
            this.init(owner);
        }

        private SpaceInfo(Component owner, SimpleNamespace from) {
            this.ns = new SimpleNamespace(owner);
            this.ns.copy(from);
            this.init(owner);
        }

        private void init(Component owner) {
            this.ns.setVariable("spaceScope", this.attrs, true);
            this.ns.setVariable("spaceOwner", owner, true);
        }
    }
}

