/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.IdSpace;
import org.zkoss.zk.ui.Path;
import org.zkoss.zk.ui.sys.ComponentsCtrl;

public class Components {
    protected Components() {
    }

    public static void sort(List list, Comparator cpr) {
        Object[] ary = list.toArray();
        Arrays.sort(ary, cpr);
        ListIterator it = list.listIterator();
        int j = 0;
        while (it.hasNext()) {
            if (it.next() != ary[j]) {
                it.remove();
                if (!it.hasNext()) break;
                if (it.next() != ary[j]) {
                    it.previous();
                    break;
                }
            }
            ++j;
        }
        while (it.hasNext()) {
            it.next();
            it.remove();
        }
        while (j < ary.length) {
            list.add(ary[j]);
            ++j;
        }
    }

    public static boolean isAncestor(Component node1, Component node2) {
        while (node2 != null) {
            if (node1 == node2) {
                return true;
            }
            node2 = node2.getParent();
        }
        return false;
    }

    public static void removeAllChildren(Component comp) {
        List children = comp.getChildren();
        if (children.isEmpty()) {
            return;
        }
        Iterator it = new ArrayList(children).iterator();
        while (it.hasNext()) {
            ((Component)it.next()).setParent(null);
        }
    }

    public static boolean isRealVisible(Component comp) {
        while (comp != null) {
            if (!comp.isVisible()) {
                return false;
            }
            comp = comp.getParent();
        }
        return true;
    }

    public static Collection getVisibleChildren(Component comp) {
        final List children = comp.getChildren();
        return new AbstractCollection(){

            public int size() {
                int size = 0;
                Iterator it = children.iterator();
                while (it.hasNext()) {
                    if (!((Component)it.next()).isVisible()) continue;
                    ++size;
                }
                return size;
            }

            public Iterator iterator() {
                return new Iterator(){
                    final Iterator _it;
                    Component _next;
                    {
                        this._it = children.iterator();
                    }

                    public boolean hasNext() {
                        if (this._next != null) {
                            return true;
                        }
                        this._next = this.getNextVisible(false);
                        return this._next != null;
                    }

                    public Object next() {
                        if (this._next != null) {
                            Component c = this._next;
                            this._next = null;
                            return c;
                        }
                        return this.getNextVisible(true);
                    }

                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    private Component getNextVisible(boolean blind) {
                        while (blind || this._it.hasNext()) {
                            Component c = (Component)this._it.next();
                            if (!c.isVisible()) continue;
                            return c;
                        }
                        return null;
                    }
                };
            }
        };
    }

    public static final int getScope(String scope) {
        if ("component".equals(scope)) {
            return 0;
        }
        if ("space".equals(scope)) {
            return 1;
        }
        if ("page".equals(scope)) {
            return 2;
        }
        if ("desktop".equals(scope)) {
            return 3;
        }
        if ("session".equals(scope)) {
            return 4;
        }
        if ("application".equals(scope)) {
            return 5;
        }
        if ("request".equals(scope)) {
            return 6;
        }
        throw new IllegalArgumentException("Unknown scope: " + scope);
    }

    public static final String scopeToString(int scope) {
        switch (scope) {
            case 0: {
                return "component";
            }
            case 1: {
                return "space";
            }
            case 2: {
                return "page";
            }
            case 3: {
                return "desktop";
            }
            case 4: {
                return "session";
            }
            case 5: {
                return "application";
            }
            case 6: {
                return "request";
            }
        }
        throw new IllegalArgumentException("Unknown scope: " + scope);
    }

    public static final boolean isAutoId(String id) {
        return ComponentsCtrl.isAutoId(id);
    }

    public static final String componentToPath(Component comp, Component ref) {
        if (comp == null) {
            return null;
        }
        if (comp == ref) {
            return ".";
        }
        String id = comp.getId();
        if (!(comp instanceof IdSpace) && Components.isAutoId(id)) {
            throw new UnsupportedOperationException("comp must be assigned with ID or a space owner: " + comp);
        }
        StringBuffer sb = new StringBuffer(128);
        IdSpace space = ref.getSpaceOwner();
        while (comp != space) {
            Component parent;
            if (space.getFellowIfAny(id) == comp) {
                if (sb.length() > 0) {
                    sb.append('/');
                }
                return sb.append(id).toString();
            }
            if (sb.length() > 0) {
                sb.append('/');
            }
            sb.append("..");
            Component component = parent = space instanceof Component ? ((Component)((Object)space)).getParent() : null;
            if (parent == null) {
                throw new UnsupportedOperationException("Unable to locate " + comp + " from " + ref);
            }
            space = parent.getSpaceOwner();
        }
        return sb.toString();
    }

    public static final Component pathToComponent(String path, Component ref) {
        if (path == null) {
            return null;
        }
        if (".".equals(path)) {
            return ref;
        }
        if ("".equals(path)) {
            IdSpace owner = ref.getSpaceOwner();
            if (!(owner instanceof Component)) {
                throw new IllegalStateException("The component is moved after serialized: " + ref);
            }
            return (Component)((Object)owner);
        }
        return Path.getComponent(ref.getSpaceOwner(), path);
    }
}

