/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui;

import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import org.zkoss.idom.Document;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.DesktopUnavailableException;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.SuspendNotAllowedException;
import org.zkoss.zk.ui.metainfo.PageDefinition;
import org.zkoss.zk.ui.sys.DesktopCtrl;
import org.zkoss.zk.ui.sys.ServerPush;
import org.zkoss.zk.ui.sys.UiEngine;
import org.zkoss.zk.ui.sys.WebAppCtrl;
import org.zkoss.zk.xel.Evaluator;

public class Executions {
    protected static final ThreadLocal _exec = new ThreadLocal();

    public static final Execution getCurrent() {
        return (Execution)_exec.get();
    }

    public static final Evaluator getEvaluator(Page page, Class expfcls) {
        return Executions.getCurrent().getEvaluator(page, expfcls);
    }

    public static final Evaluator getEvaluator(Component comp, Class expfcls) {
        return Executions.getCurrent().getEvaluator(comp, expfcls);
    }

    public static final Object evaluate(Component comp, String expr, Class expectedType) {
        return Executions.getCurrent().evaluate(comp, expr, expectedType);
    }

    public static final Object evaluate(Page page, String expr, Class expectedType) {
        return Executions.getCurrent().evaluate(page, expr, expectedType);
    }

    public static final String encodeURL(String uri) {
        return Executions.getCurrent().encodeURL(uri);
    }

    public static final Component createComponents(String uri, Component parent, Map arg) {
        return Executions.getCurrent().createComponents(uri, parent, arg);
    }

    public static final Component createComponents(PageDefinition pagedef, Component parent, Map arg) {
        return Executions.getCurrent().createComponents(pagedef, parent, arg);
    }

    public static final Component createComponentsDirectly(String content, String extension, Component parent, Map arg) {
        return Executions.getCurrent().createComponentsDirectly(content, extension, parent, arg);
    }

    public static final Component createComponentsDirectly(Document content, String extension, Component parent, Map arg) {
        return Executions.getCurrent().createComponentsDirectly(content, extension, parent, arg);
    }

    public static Component createComponentsDirectly(Reader reader, String extension, Component parent, Map arg) throws IOException {
        return Executions.getCurrent().createComponentsDirectly(reader, extension, parent, arg);
    }

    public static void sendRedirect(String uri) {
        Executions.getCurrent().sendRedirect(uri);
    }

    public static void include(String page) throws IOException {
        Executions.getCurrent().include(page);
    }

    public static void forward(String page) throws IOException {
        Executions.getCurrent().forward(page);
    }

    public static final void wait(Object mutex) throws InterruptedException, SuspendNotAllowedException {
        Executions.getUiEngine().wait(mutex);
    }

    public static final void notify(Object mutex) {
        Executions.getUiEngine().notify(mutex);
    }

    public static final void notifyAll(Object mutex) {
        Executions.getUiEngine().notifyAll(mutex);
    }

    public static final void notify(Desktop desktop, Object mutex) {
        Executions.getUiEngine(desktop).notify(desktop, mutex);
    }

    public static final void notifyAll(Desktop desktop, Object mutex) {
        Executions.getUiEngine(desktop).notifyAll(desktop, mutex);
    }

    public static final void activate(Desktop desktop) throws InterruptedException, DesktopUnavailableException {
        Executions.activate(desktop, 0L);
    }

    public static final boolean activate(Desktop desktop, long timeout) throws InterruptedException, DesktopUnavailableException {
        ServerPush spush = ((DesktopCtrl)((Object)desktop)).getServerPush();
        if (spush == null) {
            if (desktop.isAlive()) {
                throw new IllegalStateException("Before activation, the server push must be enabled for " + desktop);
            }
            throw new DesktopUnavailableException("Stopped");
        }
        return spush.activate(timeout);
    }

    public static final void deactivate(Desktop desktop) {
        ServerPush spush = ((DesktopCtrl)((Object)desktop)).getServerPush();
        if (spush != null) {
            spush.deactivate();
        }
    }

    private static final UiEngine getUiEngine(Desktop desktop) {
        if (desktop == null) {
            throw new IllegalArgumentException("desktop cannot be null");
        }
        return ((WebAppCtrl)((Object)desktop.getWebApp())).getUiEngine();
    }

    private static final UiEngine getUiEngine() {
        Execution exec = Executions.getCurrent();
        if (exec == null) {
            throw new IllegalStateException("This method can be called only under an event listener");
        }
        return ((WebAppCtrl)((Object)exec.getDesktop().getWebApp())).getUiEngine();
    }
}

