/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui;

import org.zkoss.lang.Objects;
import org.zkoss.xml.HTMLs;
import org.zkoss.zk.au.out.AuFocus;
import org.zkoss.zk.ui.AbstractComponent;
import org.zkoss.zk.ui.ext.client.Movable;
import org.zkoss.zk.ui.ext.client.Sizable;
import org.zkoss.zk.ui.ext.client.ZIndexed;
import org.zkoss.zk.ui.ext.render.Floating;
import org.zkoss.zk.ui.ext.render.ZidRequired;

public abstract class HtmlBasedComponent
extends AbstractComponent {
    private String _tooltiptext;
    private String _width;
    private String _height;
    private String _sclass;
    private String _style;
    private String _left;
    private String _top;
    private String _draggable;
    private String _droppable;
    private int _zIndex = -1;
    protected static final int RS_NO_WIDTH = 1;
    protected static final int RS_NO_HEIGHT = 2;
    protected static final int RS_NO_DISPLAY = 4;

    protected HtmlBasedComponent() {
    }

    public String getLeft() {
        return this._left;
    }

    public void setLeft(String left) {
        if (!Objects.equals((Object)this._left, (Object)left)) {
            this._left = left;
            this.smartUpdate("style.left", this.getLeft());
        }
    }

    public String getTop() {
        return this._top;
    }

    public void setTop(String top) {
        if (this._top != top) {
            this._top = top;
            this.smartUpdate("style.top", this.getTop());
        }
    }

    public int getZIndex() {
        return this._zIndex;
    }

    public void setZIndex(int zIndex) {
        if (this._zIndex < -1) {
            this._zIndex = -1;
        }
        if (this._zIndex != zIndex) {
            this._zIndex = zIndex;
            if (this._zIndex < 0) {
                this.smartUpdate("style.zIndex", null);
            } else {
                this.smartUpdate("style.zIndex", this._zIndex);
            }
        }
    }

    public String getHeight() {
        return this._height;
    }

    public void setHeight(String height) {
        if (height != null && height.length() == 0) {
            height = null;
        }
        if (!Objects.equals((Object)this._height, (Object)height)) {
            this._height = height;
            this.smartUpdate("style.height", this.getHeight());
        }
    }

    public String getWidth() {
        return this._width;
    }

    public void setWidth(String width) {
        if (width != null && width.length() == 0) {
            width = null;
        }
        if (!Objects.equals((Object)this._width, (Object)width)) {
            this._width = width;
            this.smartUpdate("style.width", this.getWidth());
        }
    }

    public String getTooltiptext() {
        return this._tooltiptext;
    }

    public void setTooltiptext(String tooltiptext) {
        if (tooltiptext != null && tooltiptext.length() == 0) {
            tooltiptext = null;
        }
        if (!Objects.equals((Object)this._tooltiptext, (Object)tooltiptext)) {
            this._tooltiptext = tooltiptext;
            this.smartUpdate("title", this._tooltiptext);
        }
    }

    public String getSclass() {
        return this._sclass;
    }

    public void setSclass(String sclass) {
        if (sclass != null && sclass.length() == 0) {
            sclass = null;
        }
        if (!Objects.equals((Object)this._sclass, (Object)sclass)) {
            this._sclass = sclass;
            this.smartUpdate("class", this.getSclass());
        }
    }

    public final void setClass(String sclass) {
        this.setSclass(sclass);
    }

    public String getStyle() {
        return this._style;
    }

    public void setStyle(String style) {
        if (style != null && style.length() == 0) {
            style = null;
        }
        if (!Objects.equals((Object)this._style, (Object)style)) {
            this._style = style;
            this.smartUpdate("style", this.getRealStyle());
        }
    }

    public void setDraggable(String draggable) {
        if (draggable != null && (draggable.length() == 0 || "false".equals(draggable))) {
            draggable = null;
        }
        if (!Objects.equals((Object)this._draggable, (Object)draggable)) {
            this._draggable = draggable;
            this.smartUpdate("z.drag", this._draggable);
        }
    }

    public final String getDraggable() {
        return this._draggable != null ? this._draggable : "false";
    }

    public void setDroppable(String droppable) {
        if (droppable != null && (droppable.length() == 0 || "false".equals(droppable))) {
            droppable = null;
        }
        if (!Objects.equals((Object)this._droppable, (Object)droppable)) {
            this._droppable = droppable;
            this.smartUpdate("z.drop", this._droppable);
        }
    }

    public final String getDroppable() {
        return this._droppable != null ? this._droppable : "false";
    }

    public void focus() {
        this.response("focus", new AuFocus(this));
    }

    public String getOuterAttrs() {
        StringBuffer sb = new StringBuffer(64);
        HTMLs.appendAttribute((StringBuffer)sb, (String)"class", (String)this.getRealSclass());
        HTMLs.appendAttribute((StringBuffer)sb, (String)"style", (String)this.getRealStyle());
        HTMLs.appendAttribute((StringBuffer)sb, (String)"title", (String)this.getTooltiptext());
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.drag", (String)this._draggable);
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.drop", (String)this._droppable);
        Object xc = this.getExtraCtrl();
        if (xc instanceof ZidRequired && ((ZidRequired)xc).isZidRequired()) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.zid", (String)this.getId());
        }
        if (xc instanceof Floating && ((Floating)xc).isFloating()) {
            sb.append(" z.float=\"true\"");
        }
        return sb.toString();
    }

    public String getInnerAttrs() {
        return "";
    }

    protected String getRealSclass() {
        return this.getSclass();
    }

    protected String getRealStyle() {
        String style;
        int flags = this.getRealStyleFlags();
        StringBuffer sb = new StringBuffer(32);
        if ((flags & 1) == 0) {
            HTMLs.appendStyle((StringBuffer)sb, (String)"width", (String)this.getWidth());
        }
        if ((flags & 2) == 0) {
            HTMLs.appendStyle((StringBuffer)sb, (String)"height", (String)this.getHeight());
        }
        HTMLs.appendStyle((StringBuffer)sb, (String)"left", (String)this.getLeft());
        HTMLs.appendStyle((StringBuffer)sb, (String)"top", (String)this.getTop());
        int zIndex = this.getZIndex();
        if (zIndex > 0) {
            HTMLs.appendStyle((StringBuffer)sb, (String)"z-index", (String)Integer.toString(zIndex));
        }
        if ((style = this.getStyle()) != null && style.length() > 0) {
            sb.append(style);
            if (!style.endsWith(";")) {
                sb.append(';');
            }
        }
        if ((flags & 4) == 0 && !this.isVisible()) {
            if (sb.length() == 0) {
                return "display:none;";
            }
            sb.append("display:none;");
        }
        return sb.toString();
    }

    protected int getRealStyleFlags() {
        return 0;
    }

    protected Object newExtraCtrl() {
        return new ExtraCtrl();
    }

    protected class ExtraCtrl
    implements Movable,
    Sizable,
    ZIndexed {
        protected ExtraCtrl() {
        }

        public void setLeftByClient(String left) {
            HtmlBasedComponent.this._left = left;
        }

        public void setTopByClient(String top) {
            HtmlBasedComponent.this._top = top;
        }

        public void setWidthByClient(String width) {
            HtmlBasedComponent.this._width = width;
        }

        public void setHeightByClient(String height) {
            HtmlBasedComponent.this._height = height;
        }

        public void setZIndexByClient(int zIndex) {
            HtmlBasedComponent.this._zIndex = zIndex;
        }
    }
}

