/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import org.zkoss.io.Serializables;
import org.zkoss.lang.Objects;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.ext.Macro;

public class HtmlMacroComponent
extends HtmlBasedComponent
implements Macro {
    private transient Map _props;
    private String _uri;
    private Component[] _inlines;

    public HtmlMacroComponent() {
        this.init();
    }

    private void init() {
        this._props = new LinkedHashMap();
        this._props.put("includer", this);
    }

    public void afterCompose() {
        Execution exec = Executions.getCurrent();
        if (exec == null) {
            throw new IllegalStateException("No execution available.");
        }
        if (this.isInline()) {
            if (this._inlines != null) {
                return;
            }
            this._inlines = exec.createComponents(this._uri != null ? this._uri : this.getDefinition().getMacroURI(), this._props);
        } else {
            if (!this.getChildren().isEmpty()) {
                return;
            }
            exec.createComponents(this._uri != null ? this._uri : this.getDefinition().getMacroURI(), (Component)this, this._props);
        }
    }

    public void setMacroURI(String uri) {
        if (!Objects.equals((Object)this._uri, (Object)uri)) {
            if (uri != null && uri.length() == 0) {
                throw new IllegalArgumentException("empty uri");
            }
            this._uri = uri;
            this.recreate();
        }
    }

    public void recreate() {
        if (this._inlines != null) {
            for (int j = 0; j < this._inlines.length; ++j) {
                this._inlines[j].detach();
            }
            this._inlines = null;
        } else {
            this.getChildren().clear();
        }
        this.afterCompose();
    }

    public boolean isInline() {
        return this.getDefinition().isInlineMacro();
    }

    public void setParent(Component parent) {
        if (this.isInline()) {
            if (this._inlines == null) {
                this.afterCompose();
            }
            for (int j = 0; j < this._inlines.length; ++j) {
                this._inlines[j].setParent(parent);
            }
        } else {
            super.setParent(parent);
        }
    }

    public void setPage(Page page) {
        if (this.isInline()) {
            if (this._inlines == null) {
                this.afterCompose();
            }
            for (int j = 0; j < this._inlines.length; ++j) {
                this._inlines[j].setPage(page);
            }
        } else {
            super.setPage(page);
        }
    }

    public boolean isChildable() {
        return !this.isInline();
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        this._props.remove("includer");
        Serializables.smartWrite((ObjectOutputStream)s, (Map)this._props);
        this._props.put("includer", this);
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.init();
        Serializables.smartRead((ObjectInputStream)s, (Map)this._props);
    }

    public Object clone() {
        HtmlMacroComponent clone = (HtmlMacroComponent)super.clone();
        clone.init();
        clone._props.putAll(this._props);
        clone._props.put("includer", this);
        if (this._inlines != null) {
            clone._inlines = new Component[this._inlines.length];
            for (int j = 0; j < this._inlines.length; ++j) {
                clone._inlines[j] = (Component)this._inlines[j].clone();
            }
        }
        return clone;
    }

    public boolean hasDynamicProperty(String name) {
        return this._props.containsKey(name);
    }

    public Object getDynamicProperty(String name) {
        return this._props.get(name);
    }

    public void setDynamicProperty(String name, Object value) throws WrongValueException {
        this._props.put(name, value);
    }
}

