/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui;

import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.zkoss.idom.Namespace;
import org.zkoss.xml.HTMLs;
import org.zkoss.xml.XMLs;
import org.zkoss.zk.ui.AbstractComponent;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.ext.DynamicTag;
import org.zkoss.zk.ui.ext.Native;
import org.zkoss.zk.ui.impl.NativeHelpers;
import org.zkoss.zk.ui.sys.ComponentsCtrl;

public class HtmlNativeComponent
extends AbstractComponent
implements DynamicTag,
Native {
    private static Native.Helper _helper = new HtmlHelper();
    private String _tag;
    private String _prolog = "";
    private String _epilog = "";
    private Map _props;
    private List _dns;
    private static final Set _noLFs;
    private static final Set _begNoLFs;

    public HtmlNativeComponent() {
    }

    public HtmlNativeComponent(String tag) {
        this.setTag(tag);
    }

    public HtmlNativeComponent(String tag, String prolog, String epilog) {
        this(tag);
        this._prolog = prolog != null ? prolog : "";
        this._epilog = epilog != null ? epilog : "";
    }

    public String getTag() {
        return this._tag;
    }

    public List getDeclaredNamespaces() {
        return this._dns != null ? this._dns : Collections.EMPTY_LIST;
    }

    public void addDeclaredNamespace(Namespace ns) {
        if (ns == null) {
            throw new IllegalArgumentException();
        }
        if (this._dns == null) {
            this._dns = new LinkedList();
        }
        this._dns.add(ns);
    }

    public String getPrologContent() {
        return this._prolog;
    }

    public void setPrologContent(String prolog) {
        this._prolog = prolog != null ? prolog : "";
    }

    public String getEpilogContent() {
        return this._epilog;
    }

    public void setEpilogContent(String epilog) {
        this._epilog = epilog != null ? epilog : "";
    }

    public Native.Helper getHelper() {
        return _helper;
    }

    public void setId(String id) {
        super.setId(id);
        this.setDynamicProperty("id", id);
    }

    public boolean setVisible(boolean visible) {
        throw new UnsupportedOperationException("Use client-dependent attribute, such as display:none");
    }

    public void redraw(Writer out) throws IOException {
        StringBuffer sb = new StringBuffer(128);
        Native.Helper helper = this.getHelper();
        helper.getFirstHalf(sb, this._tag, this._props, this._dns);
        sb.append(this._prolog);
        out.write(sb.toString());
        sb.setLength(0);
        Iterator it = this.getChildren().iterator();
        while (it.hasNext()) {
            ((Component)it.next()).redraw(out);
        }
        sb.append(this._epilog);
        helper.getSecondHalf(sb, this._tag);
        out.write(sb.toString());
    }

    public void setTag(String tag) throws WrongValueException {
        this._tag = tag != null && tag.length() > 0 ? tag : null;
    }

    public boolean hasTag(String tag) {
        return true;
    }

    public boolean hasDynamicProperty(String name) {
        return ComponentsCtrl.isReservedAttribute(name);
    }

    public Object getDynamicProperty(String name) {
        return this._props != null ? this._props.get(name) : null;
    }

    public void setDynamicProperty(String name, Object value) throws WrongValueException {
        if (name == null) {
            throw new WrongValueException("name required");
        }
        if (value == null) {
            if (this._props != null) {
                this._props.remove(name);
            }
        } else {
            if (this._props == null) {
                this._props = new LinkedHashMap();
            }
            this._props.put(name, value);
        }
    }

    static {
        String[] noLFs = new String[]{"a", "abbr", "acronym", "address", "b", "basefont", "bdo", "big", "blink", "cite", "code", "del", "dfn", "dir", "em", "font", "i", "img", "input", "ins", "kbd", "q", "s", "samp", "small", "strike", "strong", "style", "sub", "sup", "u"};
        _noLFs = new HashSet((noLFs.length << 2) / 5);
        int j = noLFs.length;
        while (--j >= 0) {
            _noLFs.add(noLFs[j]);
        }
        String[] begNoLFs = new String[]{"caption", "dd", "div", "dt", "legend", "li", "p", "pre", "span", "td", "tfoot", "th", "title"};
        _begNoLFs = new HashSet((begNoLFs.length << 2) / 5);
        int j2 = begNoLFs.length;
        while (--j2 >= 0) {
            _begNoLFs.add(begNoLFs[j2]);
        }
    }

    public static class HtmlHelper
    implements Native.Helper {
        public Component newNative(String text) {
            HtmlNativeComponent nc = new HtmlNativeComponent();
            if (text != null) {
                nc.setPrologContent(text);
            }
            return nc;
        }

        public void getFirstHalf(StringBuffer sb, String tag, Map props, Collection namespaces) {
            if (tag != null) {
                sb.append('<').append(tag);
            }
            NativeHelpers.getAttributes(sb, props, namespaces);
            if (tag != null) {
                String tn = tag.toLowerCase();
                if (HTMLs.isOrphanTag((String)tn)) {
                    sb.append('/');
                }
                sb.append('>');
                if (!_noLFs.contains(tn) && !_begNoLFs.contains(tn)) {
                    sb.append('\n');
                }
            }
        }

        public void getSecondHalf(StringBuffer sb, String tag) {
            if (tag != null) {
                String tn = tag.toLowerCase();
                if (HTMLs.isOrphanTag((String)tn)) {
                    return;
                }
                sb.append("</").append(tag).append('>');
                if (!_noLFs.contains(tn)) {
                    sb.append('\n');
                }
            }
        }

        public void appendText(StringBuffer sb, String text) {
            XMLs.encodeText((StringBuffer)sb, (String)text);
        }
    }
}

