/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui;

import java.util.Collection;
import org.zkoss.zk.mesg.MZk;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.IdSpace;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.sys.ComponentsCtrl;
import org.zkoss.zk.ui.sys.ExecutionCtrl;

public class Path {
    private final String _path;

    public Path() {
        this((String)null);
    }

    public Path(String path) {
        this._path = Path.normalize(path);
    }

    public Path(String parent, String child) {
        this(parent == null || parent.length() == 0 ? child : (child == null || child.length() == 0 ? parent : parent + '/' + child));
    }

    public Path(Path parent, String child) {
        this(parent != null ? parent.getPath() : null, child);
    }

    public Path(Component comp) {
        this(Path.getPath(comp));
    }

    public String getPath() {
        return this._path;
    }

    public Component getComponent() {
        return Path.getComponent0(null, this._path);
    }

    public static final String getPath(Component comp) {
        StringBuffer sb = new StringBuffer(64);
        while (true) {
            Component p;
            String compId;
            if (sb.length() > 0) {
                sb.insert(0, '/');
            }
            if (ComponentsCtrl.isAutoId(compId = comp.getId())) {
                throw new UiException(MZk.AUTO_ID_NOT_ALLOWED_IN_PATH, comp);
            }
            sb.insert(0, compId);
            IdSpace is = comp.getSpaceOwner();
            if (is instanceof Page || is == comp && ((p = ((Component)((Object)is)).getParent()) == null || (is = p.getSpaceOwner()) instanceof Page)) break;
            comp = (Component)((Object)is);
        }
        sb.insert(0, '/');
        return sb.toString();
    }

    public static final Component getComponent(String path) {
        return Path.getComponent0(null, Path.normalize(path));
    }

    public static final Component getComponent(IdSpace is, String path) {
        return Path.getComponent0(is, Path.normalize(path));
    }

    private static final Component getComponent0(IdSpace is, String path) {
        Object found = null;
        int j = 0;
        while (true) {
            int k;
            if ((k = path.indexOf(47, j)) == 0) {
                Execution exec = Executions.getCurrent();
                Desktop desktop = exec.getDesktop();
                Page page = ((ExecutionCtrl)((Object)exec)).getCurrentPage();
                if (page == null) {
                    Collection pages = desktop.getPages();
                    if (pages.isEmpty()) {
                        return null;
                    }
                    page = (Page)pages.iterator().next();
                }
                if (path.length() == 1) {
                    return Path.getFirstRoot(page);
                }
                if (path.charAt(1) == '/') {
                    k = path.indexOf(47, 2);
                    if (k < 0) {
                        return Path.getFirstRoot(page);
                    }
                    String nm = path.substring(2, k);
                    is = desktop.getPageIfAny(nm);
                    if (is == null) {
                        return null;
                    }
                } else {
                    is = page;
                }
            } else {
                Component c;
                String nm;
                String string = nm = k >= 0 ? path.substring(j, k) : path.substring(j);
                if ("..".equals(nm)) {
                    if (!(is instanceof Component)) {
                        return null;
                    }
                    c = (Component)((Object)is);
                    Component p = c.getParent();
                    IdSpace idSpace = is = p != null ? p.getSpaceOwner() : c.getPage();
                    if (k < 0) {
                        return is instanceof Component ? (Component)((Object)is) : null;
                    }
                } else {
                    if (is == null) {
                        return null;
                    }
                    c = is.getFellow(nm);
                    if (k < 0) {
                        return c;
                    }
                    if (!(c instanceof IdSpace)) {
                        return null;
                    }
                    is = (IdSpace)((Object)c);
                }
            }
            j = k + 1;
        }
    }

    private static Component getFirstRoot(Page page) {
        Collection roots = page.getRoots();
        return roots.isEmpty() ? null : (Component)roots.iterator().next();
    }

    private static final String normalize(String path) {
        int j;
        if (path == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer(path);
        boolean slash = false;
        int len = sb.length();
        for (j = 0; j < len; ++j) {
            boolean curslash;
            boolean bl = curslash = sb.charAt(j) == '/';
            if (curslash && slash && j != 1) {
                sb.deleteCharAt(j);
                --j;
                --len;
            }
            slash = curslash;
        }
        if (sb.length() > 1 && slash) {
            sb.setLength(sb.length() - 1);
        }
        while (sb.length() >= 2 && sb.charAt(0) == '.' && sb.charAt(1) == '/') {
            sb.delete(0, 2);
        }
        j = 0;
        while ((j = sb.indexOf("/./", j)) >= 0) {
            sb.delete(j + 1, j + 3);
        }
        int len2 = sb.length();
        if (len2 >= 2 && sb.charAt(len2 - 1) == '.' && sb.charAt(len2 - 2) == '/') {
            if (len2 == 2) {
                return "/";
            }
            sb.delete(len2 - 2, len2);
        }
        int j2 = 0;
        while ((j2 = sb.indexOf("/../", j2)) >= 0) {
            j2 = Path.removeDotDot(sb, j2);
        }
        len2 = sb.length();
        if (len2 >= 3 && sb.charAt(len2 - 1) == '.' && sb.charAt(len2 - 2) == '.' && sb.charAt(len2 - 3) == '/') {
            if (len2 == 3) {
                return "/";
            }
            Path.removeDotDot(sb, len2 - 3);
        }
        return sb.length() == path.length() ? path : sb.toString();
    }

    private static int removeDotDot(StringBuffer sb, int j) {
        int k = j;
        while (--k >= 0 && sb.charAt(k) != '/') {
        }
        if (k + 3 == j && sb.charAt(k + 1) == '.' && sb.charAt(k + 2) == '.') {
            return j + 4;
        }
        sb.delete(j, j + 3);
        if (j == 0) {
            return 0;
        }
        if (k < 0) {
            sb.delete(0, j < sb.length() ? j + 1 : j);
            return 0;
        }
        if (j >= sb.length()) {
            ++k;
        }
        sb.delete(k, j);
        return k;
    }

    public boolean equals(Object o) {
        return o instanceof Path && ((Path)o)._path.equals(this._path);
    }

    public int hashCode() {
        return this._path.hashCode();
    }

    public String toString() {
        return this._path;
    }
}

