/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.event;

import org.zkoss.zk.au.out.AuEcho;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.impl.EventProcessor;
import org.zkoss.zk.ui.sys.ComponentCtrl;
import org.zkoss.zk.ui.sys.ComponentsCtrl;
import org.zkoss.zk.ui.sys.DesktopCtrl;
import org.zkoss.zk.ui.sys.EventProcessingThread;
import org.zkoss.zk.ui.sys.ExecutionCtrl;
import org.zkoss.zk.ui.util.Clients;

public class Events {
    public static final String ON_CLICK = "onClick";
    public static final String ON_RIGHT_CLICK = "onRightClick";
    public static final String ON_DOUBLE_CLICK = "onDoubleClick";
    public static final String ON_OK = "onOK";
    public static final String ON_CANCEL = "onCancel";
    public static final String ON_CTRL_KEY = "onCtrlKey";
    public static final String ON_CHANGE = "onChange";
    public static final String ON_CHANGING = "onChanging";
    public static final String ON_ERROR = "onError";
    public static final String ON_SCROLL = "onScroll";
    public static final String ON_SCROLLING = "onScrolling";
    public static final String ON_SELECT = "onSelect";
    public static final String ON_SELECTION = "onSelection";
    public static final String ON_CHECK = "onCheck";
    public static final String ON_MOVE = "onMove";
    public static final String ON_SIZE = "onSize";
    public static final String ON_Z_INDEX = "onZIndex";
    public static final String ON_OPEN = "onOpen";
    public static final String ON_CLOSE = "onClose";
    public static final String ON_RENDER = "onRender";
    public static final String ON_TIMER = "onTimer";
    public static final String ON_FOCUS = "onFocus";
    public static final String ON_BLUR = "onBlur";
    public static final String ON_DROP = "onDrop";
    public static final String ON_NOTIFY = "onNotify";
    public static final String ON_SORT = "onSort";
    public static final String ON_UPLOAD = "onUpload";
    public static final String ON_BOOKMARK_CHANGED = "onBookmarkChanged";
    public static final String ON_CLIENT_INFO = "onClientInfo";
    public static final String ON_CREATE = "onCreate";
    public static final String ON_MODAL = "onModal";
    public static final String ON_PIGGYBACK = "onPiggyback";
    public static final String ON_USER = "onUser";

    private Events() {
    }

    public static final boolean isValid(String name) {
        return name != null && name.length() > 2 && name.charAt(0) == 'o' && name.charAt(1) == 'n' && Character.isUpperCase(name.charAt(2));
    }

    public static final boolean inEventListener() {
        return EventProcessor.inEventListener();
    }

    public static boolean isListened(Component comp, String evtnm, boolean asap) {
        if (((ComponentCtrl)((Object)comp)).getEventHandler(evtnm) != null) {
            return true;
        }
        if (ComponentsCtrl.getEventMethod(comp.getClass(), evtnm) != null || comp.isListenerAvailable(evtnm, asap)) {
            return true;
        }
        if (!asap) {
            Page page = comp.getPage();
            return page != null && page.isListenerAvailable(evtnm);
        }
        return false;
    }

    public static boolean isListenerAvailable(Component comp, String evtnm, boolean asap) {
        return Events.isListened(comp, evtnm, asap);
    }

    public static void sendEvent(Component comp, Event event) {
        Execution exec = Executions.getCurrent();
        Desktop desktop = exec.getDesktop();
        event = ((DesktopCtrl)((Object)desktop)).beforeSendEvent(event);
        if (event == null) {
            return;
        }
        Thread thd = Thread.currentThread();
        if (!(thd instanceof EventProcessingThread)) {
            if (!desktop.getWebApp().getConfiguration().isEventThreadEnabled()) {
                ExecutionCtrl execCtrl = (ExecutionCtrl)((Object)exec);
                Page page = execCtrl.getCurrentPage();
                EventProcessor proc = new EventProcessor(desktop, comp, event);
                proc.setup();
                try {
                    proc.process();
                }
                catch (Exception ex) {
                    throw UiException.Aide.wrap(ex);
                }
                finally {
                    execCtrl.setCurrentPage(page);
                }
                return;
            }
            throw new UiException("Callable only in the event listener");
        }
        try {
            ((EventProcessingThread)((Object)thd)).sendEvent(comp, event);
        }
        catch (Exception ex) {
            throw UiException.Aide.wrap(ex);
        }
    }

    public static void sendEvent(Event event) {
        Events.sendEvent(event.getTarget(), event);
    }

    public static final void postEvent(Event event) {
        Executions.getCurrent().postEvent(event);
    }

    public static final void postEvent(String name, Component target, Object data) {
        if (name == null || name.length() == 0 || target == null) {
            throw new IllegalArgumentException("null");
        }
        Events.postEvent(new Event(name, target, data));
    }

    public static final void echoEvent(String name, Component target, String data) {
        if (name == null || name.length() == 0 || target == null) {
            throw new IllegalArgumentException();
        }
        Clients.response(new AuEcho(target, name, data));
    }
}

