/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.http;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.security.Principal;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.zkoss.idom.Document;
import org.zkoss.lang.Classes;
import org.zkoss.web.servlet.Servlets;
import org.zkoss.web.servlet.http.Encodes;
import org.zkoss.web.servlet.http.HttpBufferedResponse;
import org.zkoss.web.servlet.xel.AttributesMap;
import org.zkoss.web.servlet.xel.RequestContext;
import org.zkoss.web.servlet.xel.RequestContexts;
import org.zkoss.web.servlet.xel.RequestXelResolver;
import org.zkoss.web.util.resource.ClassWebResource;
import org.zkoss.xel.Expression;
import org.zkoss.xel.ExpressionFactory;
import org.zkoss.xel.Expressions;
import org.zkoss.xel.FunctionMapper;
import org.zkoss.xel.VariableResolver;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.http.WebManager;
import org.zkoss.zk.ui.http.ZumlExtendlet;
import org.zkoss.zk.ui.impl.AbstractExecution;
import org.zkoss.zk.ui.impl.RequestInfoImpl;
import org.zkoss.zk.ui.metainfo.PageDefinition;
import org.zkoss.zk.ui.metainfo.PageDefinitions;
import org.zkoss.zk.ui.sys.RequestInfo;
import org.zkoss.zk.ui.sys.WebAppCtrl;
import org.zkoss.zk.xel.Evaluator;
import org.zkoss.zk.xel.impl.ExecutionResolver;
import org.zkoss.zk.xel.impl.SimpleEvaluator;

public class ExecutionImpl
extends AbstractExecution {
    private final ServletContext _ctx;
    private final HttpServletRequest _request;
    private final HttpServletResponse _response;
    private final RequestContext _xelctx;
    private final Map _attrs;
    private MyEval _eval;
    private ExecutionResolver _resolver;
    private boolean _voided;

    public ExecutionImpl(ServletContext ctx, HttpServletRequest request, HttpServletResponse response, Desktop desktop, Page creating) {
        super(desktop, creating);
        this._ctx = ctx;
        this._request = request;
        this._response = response;
        this._xelctx = new ReqContext();
        this._attrs = new AttributesMap(){

            protected Enumeration getKeys() {
                return ExecutionImpl.this._request.getAttributeNames();
            }

            protected Object getValue(String key) {
                return ExecutionImpl.this._request.getAttribute(key);
            }

            protected void setValue(String key, Object val) {
                ExecutionImpl.this._request.setAttribute(key, val);
            }

            protected void removeValue(String key) {
                ExecutionImpl.this._request.removeAttribute(key);
            }
        };
    }

    public void onActivate() {
        super.onActivate();
        RequestContexts.push((RequestContext)this._xelctx);
    }

    public void onDeactivate() {
        RequestContexts.pop();
        super.onDeactivate();
    }

    public String[] getParameterValues(String name) {
        return this._request.getParameterValues(name);
    }

    public String getParameter(String name) {
        return this._request.getParameter(name);
    }

    public Map getParameterMap() {
        return this._request.getParameterMap();
    }

    public VariableResolver getVariableResolver() {
        if (this._resolver == null) {
            this._resolver = new ExecutionResolver(this, (VariableResolver)new RequestXelResolver(this._ctx, (ServletRequest)this._request, (ServletResponse)this._response){

                public ExpressionFactory getExpressionFactory() {
                    return ExecutionImpl.this.getExpressionFactory();
                }
            });
        }
        return this._resolver;
    }

    private ExpressionFactory getExpressionFactory() {
        return Expressions.newExpressionFactory();
    }

    public Evaluator getEvaluator(Page page, Class expfcls) {
        Collection c;
        if (page == null && (page = this.getCurrentPage()) == null && !(c = this.getDesktop().getPages()).isEmpty()) {
            page = (Page)c.iterator().next();
        }
        if (this._eval == null || this._eval.page != page || this._eval.getExpressionFactoryClass() != expfcls) {
            this._eval = new MyEval(page, expfcls);
        }
        return this._eval;
    }

    public Evaluator getEvaluator(Component comp, Class expfcls) {
        return this.getEvaluator(comp != null ? comp.getPage() : null, expfcls);
    }

    public Object evaluate(Component comp, String expr, Class expectedType) {
        return this.evaluate0(comp, expr, expectedType, comp != null ? comp.getPage() : null);
    }

    public Object evaluate(Page page, String expr, Class expectedType) {
        return this.evaluate0(page, expr, expectedType, page);
    }

    private Object evaluate0(Object self, String expr, Class expectedType, Page page) {
        if (expr == null || expr.length() == 0 || expr.indexOf("${") < 0) {
            if (expectedType == Object.class || expectedType == String.class) {
                return expr;
            }
            return Classes.coerce((Class)expectedType, (Object)expr);
        }
        Evaluator eval = this.getEvaluator(page, null);
        Expression expression = eval.parseExpression(expr, expectedType);
        return self instanceof Page ? eval.evaluate((Page)self, expression) : eval.evaluate((Component)self, expression);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void include(Writer out, String page, Map params, int mode) throws IOException {
        HttpServletResponse bufresp = HttpBufferedResponse.getInstance((HttpServletResponse)this._response, (Writer)out);
        try {
            ClassWebResource cwr;
            if ((mode == 3 || params == null) && page.startsWith("~./") && page.indexOf(63) < 0 && !ExecutionImpl.isZumlExtendlet(cwr = WebManager.getWebManager(this._ctx).getClassWebResource(), page)) {
                Object old = null;
                if (mode == 3) {
                    old = this._request.getAttribute("arg");
                    this._request.setAttribute("arg", (Object)params);
                }
                try {
                    cwr.service(this._request, bufresp, page.substring(2));
                    return;
                }
                finally {
                    if (mode == 3) {
                        this._request.setAttribute("arg", old);
                    }
                }
            }
            Servlets.include((ServletContext)this._ctx, (ServletRequest)this._request, (ServletResponse)bufresp, (String)page, (Map)params, (int)mode);
        }
        catch (ServletException ex) {
            throw new UiException(ex);
        }
    }

    private static boolean isZumlExtendlet(ClassWebResource cwr, String path) {
        String ext = Servlets.getExtension((String)path);
        return ext != null && cwr.getExtendlet(ext) instanceof ZumlExtendlet;
    }

    public void include(String page) throws IOException {
        this.include(null, page, null, 0);
    }

    public void forward(Writer out, String page, Map params, int mode) throws IOException {
        if (this.getVisualizer().isEverAsyncUpdate()) {
            throw new IllegalStateException("Use sendRedirect instead when processing user's request");
        }
        this.setVoided(true);
        try {
            Servlets.forward((ServletContext)this._ctx, (ServletRequest)this._request, (ServletResponse)HttpBufferedResponse.getInstance((HttpServletResponse)this._response, (Writer)out), (String)page, (Map)params, (int)mode);
        }
        catch (ServletException ex) {
            throw new UiException(ex);
        }
    }

    public void forward(String page) throws IOException {
        this.forward(null, page, null, 0);
    }

    public boolean isIncluded() {
        return Servlets.isIncluded((ServletRequest)this._request);
    }

    public boolean isForwarded() {
        return Servlets.isForwarded((ServletRequest)this._request);
    }

    public boolean isVoided() {
        return this._voided;
    }

    public void setVoided(boolean voided) {
        this._voided = voided;
    }

    public String encodeURL(String uri) {
        try {
            return Encodes.encodeURL((ServletContext)this._ctx, (ServletRequest)this._request, (ServletResponse)this._response, (String)uri);
        }
        catch (ServletException ex) {
            throw new UiException(ex);
        }
    }

    public Principal getUserPrincipal() {
        return this._request.getUserPrincipal();
    }

    public boolean isUserInRole(String role) {
        return this._request.isUserInRole(role);
    }

    public String getRemoteUser() {
        return this._request.getRemoteUser();
    }

    public String getRemoteHost() {
        return this._request.getRemoteHost();
    }

    public String getRemoteName() {
        return this.getRemoteHost();
    }

    public String getRemoteAddr() {
        return this._request.getRemoteAddr();
    }

    public String getServerName() {
        return this._request.getServerName();
    }

    public int getServerPort() {
        return this._request.getServerPort();
    }

    public String getLocalName() {
        return this._request.getLocalName();
    }

    public String getLocalAddr() {
        return this._request.getLocalAddr();
    }

    public int getLocalPort() {
        return this._request.getLocalPort();
    }

    public String getContextPath() {
        return this._request.getContextPath();
    }

    public PageDefinition getPageDefinition(String uri) {
        uri = this.toAbsoluteURI(uri, false);
        PageDefinition pagedef = ((WebAppCtrl)((Object)this.getDesktop().getWebApp())).getUiFactory().getPageDefinition(this.newRequestInfo(uri), uri);
        if (pagedef == null) {
            throw new UiException("Page not found: " + uri);
        }
        return pagedef;
    }

    public PageDefinition getPageDefinitionDirectly(String content, String ext) {
        return ((WebAppCtrl)((Object)this.getDesktop().getWebApp())).getUiFactory().getPageDefinitionDirectly(this.newRequestInfo(null), content, ext);
    }

    public PageDefinition getPageDefinitionDirectly(Document content, String ext) {
        return ((WebAppCtrl)((Object)this.getDesktop().getWebApp())).getUiFactory().getPageDefinitionDirectly(this.newRequestInfo(null), content, ext);
    }

    public PageDefinition getPageDefinitionDirectly(Reader reader, String ext) throws IOException {
        return ((WebAppCtrl)((Object)this.getDesktop().getWebApp())).getUiFactory().getPageDefinitionDirectly(this.newRequestInfo(null), reader, ext);
    }

    private RequestInfo newRequestInfo(String uri) {
        Desktop dt = this.getDesktop();
        return new RequestInfoImpl(dt, this._request, PageDefinitions.getLocator(this.getDesktop().getWebApp(), uri));
    }

    public void setHeader(String name, String value) {
        if (this._response instanceof HttpServletResponse) {
            this._response.setHeader(name, value);
        }
    }

    public void setDateHeader(String name, long value) {
        if (this._response instanceof HttpServletResponse) {
            this._response.setDateHeader(name, value);
        }
    }

    public void addHeader(String name, String value) {
        if (this._response instanceof HttpServletResponse) {
            this._response.addHeader(name, value);
        }
    }

    public void addDateHeader(String name, long value) {
        if (this._response instanceof HttpServletResponse) {
            this._response.addDateHeader(name, value);
        }
    }

    public Object getRequestAttribute(String name) {
        return this._request.getAttribute(name);
    }

    public void setRequestAttribute(String name, Object value) {
        this._request.setAttribute(name, value);
    }

    public boolean isBrowser() {
        return true;
    }

    public boolean isRobot() {
        return Servlets.isRobot((ServletRequest)this._request);
    }

    public boolean isExplorer() {
        return Servlets.isExplorer((ServletRequest)this._request);
    }

    public boolean isExplorer7() {
        return Servlets.isExplorer7((ServletRequest)this._request);
    }

    public boolean isGecko() {
        return Servlets.isGecko((ServletRequest)this._request);
    }

    public boolean isSafari() {
        return Servlets.isSafari((ServletRequest)this._request);
    }

    public boolean isMilDevice() {
        return Servlets.isMilDevice((ServletRequest)this._request);
    }

    public boolean isHilDevice() {
        return Servlets.isHilDevice((ServletRequest)this._request);
    }

    public String getUserAgent() {
        return Servlets.getUserAgent((ServletRequest)this._request);
    }

    public Object getNativeRequest() {
        return this._request;
    }

    public Object getNativeResponse() {
        return this._response;
    }

    public Object getAttribute(String name) {
        return this._request.getAttribute(name);
    }

    public void setAttribute(String name, Object value) {
        this._request.setAttribute(name, value);
    }

    public void removeAttribute(String name) {
        this._request.removeAttribute(name);
    }

    public Map getAttributes() {
        return this._attrs;
    }

    private class MyEval
    extends SimpleEvaluator {
        private Page page;

        private MyEval(Page page, Class expfcls) {
            super(null, expfcls);
            this.page = page;
        }

        public FunctionMapper getFunctionMapper(Object ref) {
            return this.page != null ? this.page.getFunctionMapper() : null;
        }
    }

    private class ReqContext
    implements RequestContext {
        private ReqContext() {
        }

        public Writer getOut() throws IOException {
            return ExecutionImpl.this._response.getWriter();
        }

        public VariableResolver getVariableResolver() {
            return ExecutionImpl.this.getVariableResolver();
        }

        public ServletRequest getRequest() {
            return ExecutionImpl.this._request;
        }

        public ServletResponse getResponse() {
            return ExecutionImpl.this._response;
        }

        public ServletContext getServletContext() {
            return ExecutionImpl.this._ctx;
        }
    }
}

