/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.http;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpSession;
import org.zkoss.util.logging.Log;
import org.zkoss.web.servlet.Servlets;
import org.zkoss.web.servlet.xel.AttributesMap;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.http.WebManager;
import org.zkoss.zk.ui.http.WebManagerActivationListener;
import org.zkoss.zk.ui.sys.DesktopCache;
import org.zkoss.zk.ui.sys.SessionCtrl;
import org.zkoss.zk.ui.sys.WebAppCtrl;
import org.zkoss.zk.ui.util.Configuration;
import org.zkoss.zk.ui.util.Monitor;
import org.zkoss.zk.ui.util.SessionSerializationListener;

public class SimpleSession
implements Session,
SessionCtrl {
    private static final Log log = Log.lookup((Class)SimpleSession.class);
    private static final String ATTR_PRIVATE = "javax.zkoss.ui.session.private";
    private WebApp _wapp;
    private HttpSession _hsess;
    private String _devType = "ajax";
    private Map _attrs;
    private String _remoteAddr;
    private String _remoteHost;
    private String _serverName;
    private String _localAddr;
    private String _localName;
    private DesktopCache _cache;
    private int _nextUuid;
    private long _tmLastReq = System.currentTimeMillis();
    private boolean _invalid;

    public SimpleSession(WebApp wapp, HttpSession hsess, Object request) {
        if (wapp == null || hsess == null) {
            throw new IllegalArgumentException();
        }
        SimpleSession.cleanSessAttrs(hsess);
        this._wapp = wapp;
        this._hsess = hsess;
        if (request instanceof ServletRequest) {
            ServletRequest req = (ServletRequest)request;
            this._remoteAddr = req.getRemoteAddr();
            this._remoteHost = req.getRemoteHost();
            this._serverName = req.getServerName();
            if (Servlets.isServlet24()) {
                this._localAddr = req.getLocalAddr();
                this._localName = req.getLocalName();
            } else {
                this._localName = "";
                this._localAddr = "";
            }
        }
        this.init();
        Configuration config = this.getWebApp().getConfiguration();
        config.invokeSessionInits(this, request);
        Monitor monitor = config.getMonitor();
        if (monitor != null) {
            try {
                monitor.sessionCreated(this);
            }
            catch (Throwable ex) {
                log.error(ex);
            }
        }
    }

    private final void init() {
        this._attrs = new AttributesMap(){

            protected Enumeration getKeys() {
                return SimpleSession.this._hsess.getAttributeNames();
            }

            protected Object getValue(String key) {
                return SimpleSession.this._hsess.getAttribute(key);
            }

            protected void setValue(String key, Object val) {
                SimpleSession.this.setAttribute(key, val);
            }

            protected void removeValue(String key) {
                SimpleSession.this.removeAttribute(key);
            }
        };
    }

    public String getDeviceType() {
        return this._devType;
    }

    public void setDeviceType(String deviceType) {
        if (deviceType == null || deviceType.length() == 0) {
            throw new IllegalArgumentException();
        }
        this._devType = deviceType;
    }

    public Object getAttribute(String name) {
        return this._hsess.getAttribute(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String name, Object value) {
        if (name.startsWith("javax.zkoss")) {
            throw new IllegalArgumentException("Unable to change the readonly attribute: " + name);
        }
        if (!(this instanceof Serializable) && !(this instanceof Externalizable) && (value instanceof Serializable || value instanceof Externalizable)) {
            SimpleSession simpleSession = this;
            synchronized (simpleSession) {
                this._hsess.setAttribute(name, value);
                HashMap<String, Object> prv = (HashMap<String, Object>)this._hsess.getAttribute(ATTR_PRIVATE);
                if (prv == null) {
                    prv = new HashMap<String, Object>();
                    this._hsess.setAttribute(ATTR_PRIVATE, prv);
                }
                prv.put(name, value);
            }
        } else {
            this._hsess.setAttribute(name, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAttribute(String name) {
        if (name.startsWith("javax.zkoss")) {
            throw new IllegalArgumentException("Unable to remove the readonly attribute: " + name);
        }
        if (!(this instanceof Serializable) && !(this instanceof Externalizable)) {
            SimpleSession simpleSession = this;
            synchronized (simpleSession) {
                this._hsess.removeAttribute(name);
                Map prv = (Map)this._hsess.getAttribute(ATTR_PRIVATE);
                if (prv != null) {
                    prv.remove(name);
                }
            }
        } else {
            this._hsess.removeAttribute(name);
        }
    }

    public Map getAttributes() {
        return this._attrs;
    }

    private static void cleanSessAttrs(HttpSession hsess) {
        Map prv = (Map)hsess.getAttribute(ATTR_PRIVATE);
        if (prv != null) {
            Iterator it = prv.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry me = it.next();
                String nm = (String)me.getKey();
                if (hsess.getAttribute(nm) != me.getValue()) continue;
                hsess.removeAttribute(nm);
            }
        }
    }

    public String getRemoteAddr() {
        return this._remoteAddr;
    }

    public String getRemoteHost() {
        return this._remoteHost;
    }

    public String getServerName() {
        return this._serverName;
    }

    public String getLocalName() {
        return this._localName;
    }

    public String getLocalAddr() {
        return this._localAddr;
    }

    public String getClientAddr() {
        return this.getRemoteAddr();
    }

    public String getClientHost() {
        return this.getRemoteHost();
    }

    public void invalidateNow() {
        this._hsess.invalidate();
    }

    public void setMaxInactiveInterval(int interval) {
        this._hsess.setMaxInactiveInterval(interval);
    }

    public int getMaxInactiveInterval() {
        return this._hsess.getMaxInactiveInterval();
    }

    public Object getNativeSession() {
        return this._hsess;
    }

    public void notifyClientRequest(boolean keepAlive) {
        long now = System.currentTimeMillis();
        if (keepAlive) {
            this._tmLastReq = now;
        } else {
            int tmout = this.getMaxInactiveInterval();
            if (tmout >= 0 && (now - this._tmLastReq) / 1000L > (long)tmout) {
                this.invalidate();
            }
        }
    }

    public synchronized int getNextUuidGroup(int groupSize) {
        int uuid = this._nextUuid;
        this._nextUuid += groupSize;
        return uuid;
    }

    public final WebApp getWebApp() {
        return this._wapp;
    }

    public final void invalidate() {
        this._invalid = true;
    }

    public final boolean isInvalidated() {
        return this._invalid;
    }

    public DesktopCache getDesktopCache() {
        return this._cache;
    }

    public void setDesktopCache(DesktopCache cache) {
        this._cache = cache;
    }

    public void recover(Object nativeSession) {
        this.sessionDidActivate((HttpSession)nativeSession);
    }

    public void onDestroyed() {
        Configuration config = this.getWebApp().getConfiguration();
        config.invokeSessionCleanups(this);
        Monitor monitor = config.getMonitor();
        if (monitor != null) {
            try {
                monitor.sessionDestroyed(this);
            }
            catch (Throwable ex) {
                log.error(ex);
            }
        }
    }

    protected SimpleSession() {
    }

    protected void writeThis(ObjectOutputStream s) throws IOException {
        s.writeObject(this._remoteAddr);
        s.writeObject(this._remoteHost);
        s.writeObject(this._serverName);
        s.writeObject(this._localAddr);
        s.writeObject(this._localName);
        s.writeObject(this._cache);
        s.writeInt(this._nextUuid);
        Enumeration en = this._hsess.getAttributeNames();
        while (en.hasMoreElements()) {
            String nm = (String)en.nextElement();
            this.willSerialize(this._hsess.getAttribute(nm));
        }
    }

    private void willSerialize(Object o) {
        if (o instanceof SessionSerializationListener) {
            ((SessionSerializationListener)o).willSerialize(this);
        }
    }

    protected void readThis(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.init();
        this._remoteAddr = (String)s.readObject();
        this._remoteHost = (String)s.readObject();
        this._serverName = (String)s.readObject();
        this._localAddr = (String)s.readObject();
        this._localName = (String)s.readObject();
        this._cache = (DesktopCache)s.readObject();
        this._nextUuid = s.readInt();
        Enumeration en = this._hsess.getAttributeNames();
        while (en.hasMoreElements()) {
            String nm = (String)en.nextElement();
            this.didDeserialize(this._hsess.getAttribute(nm));
        }
    }

    private void didDeserialize(Object o) {
        if (o instanceof SessionSerializationListener) {
            ((SessionSerializationListener)o).didDeserialize(this);
        }
    }

    protected void sessionWillPassivate() {
        ((WebAppCtrl)((Object)this._wapp)).sessionWillPassivate(this);
    }

    protected void sessionDidActivate(HttpSession hsess) {
        this._hsess = hsess;
        WebManager.addActivationListener(this._hsess.getServletContext(), new WebManagerActivationListener(){

            public void didActivate(WebManager webman) {
                SimpleSession.this._wapp = webman.getWebApp();
                ((WebAppCtrl)((Object)SimpleSession.this._wapp)).sessionDidActivate(SimpleSession.this);
            }
        });
    }
}

