/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.http;

import java.net.URL;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.zkoss.util.logging.Log;
import org.zkoss.util.resource.LabelLocator;
import org.zkoss.util.resource.Labels;
import org.zkoss.util.resource.Locator;
import org.zkoss.web.util.resource.ClassWebResource;
import org.zkoss.web.util.resource.Extendlet;
import org.zkoss.web.util.resource.ServletContextLocator;
import org.zkoss.web.util.resource.ServletLabelLocator;
import org.zkoss.web.util.resource.ServletLabelResovler;
import org.zkoss.xel.VariableResolver;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.Richlet;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.http.DHtmlLayoutServlet;
import org.zkoss.zk.ui.http.ExecutionImpl;
import org.zkoss.zk.ui.http.SimpleWebApp;
import org.zkoss.zk.ui.http.WebManagerActivationListener;
import org.zkoss.zk.ui.http.ZumlExtendlet;
import org.zkoss.zk.ui.impl.RequestInfoImpl;
import org.zkoss.zk.ui.metainfo.LanguageDefinition;
import org.zkoss.zk.ui.metainfo.PageDefinition;
import org.zkoss.zk.ui.metainfo.PageDefinitions;
import org.zkoss.zk.ui.sys.ConfigParser;
import org.zkoss.zk.ui.sys.DesktopCtrl;
import org.zkoss.zk.ui.sys.ExecutionsCtrl;
import org.zkoss.zk.ui.sys.RequestInfo;
import org.zkoss.zk.ui.sys.SessionCtrl;
import org.zkoss.zk.ui.sys.UiFactory;
import org.zkoss.zk.ui.sys.WebAppCtrl;
import org.zkoss.zk.ui.util.Configuration;

public class WebManager {
    private static final Log log = Log.lookup((Class)WebManager.class);
    private static final String ATTR_SESS = "javax.zkoss.zk.ui.Session";
    static final String ATTR_WEB_MANAGER = "javax.zkoss.zk.ui.WebManager";
    static final String ATTR_DESKTOP = "javax.zkoss.zk.ui.desktop";
    private static final Map _actListeners = new HashMap();
    private final ServletContext _ctx;
    private final WebApp _wapp;
    private final String _updateURI;
    private final ClassWebResource _cwr;

    WebManager(ServletContext ctx, String updateURI) {
        if (log.debugable()) {
            log.debug("Starting WebManager at " + ctx);
        }
        if (ctx == null || updateURI == null) {
            throw new IllegalArgumentException("null");
        }
        this._ctx = ctx;
        this._updateURI = updateURI;
        Labels.register((LabelLocator)new ServletLabelLocator(this._ctx));
        Labels.setVariableResolver((VariableResolver)new ServletLabelResovler());
        this._cwr = ClassWebResource.getInstance((ServletContext)this._ctx, (String)this._updateURI);
        this._cwr.setCompress(new String[]{"js", "css"});
        this._ctx.setAttribute(ATTR_WEB_MANAGER, (Object)this);
        ZumlExtendlet extlet = null;
        Iterator it = LanguageDefinition.getAll().iterator();
        while (it.hasNext()) {
            LanguageDefinition langdef = (LanguageDefinition)it.next();
            List exts = langdef.getExtensions();
            if (exts.isEmpty()) continue;
            if (extlet == null) {
                extlet = new ZumlExtendlet();
            }
            this._cwr.addExtendlet((String)exts.get(0), (Extendlet)extlet);
        }
        Configuration config = new Configuration();
        try {
            URL cfgUrl = this._ctx.getResource("/WEB-INF/zk.xml");
            if (cfgUrl != null) {
                new ConfigParser().parse(cfgUrl, config, (Locator)new ServletContextLocator(this._ctx));
            }
        }
        catch (Throwable ex) {
            log.error("Unable to load /WEB-INF/zk.xml", ex);
        }
        this._wapp = WebManager.newWebApp(config);
        ((WebAppCtrl)((Object)this._wapp)).init(this._ctx, config);
        List listeners = (List)_actListeners.remove(this._ctx);
        if (listeners != null) {
            Iterator it2 = listeners.iterator();
            while (it2.hasNext()) {
                try {
                    ((WebManagerActivationListener)it2.next()).didActivate(this);
                }
                catch (ConcurrentModificationException ex) {
                    throw ex;
                }
                catch (Throwable ex) {
                    log.realCause(ex);
                }
            }
        }
    }

    private static WebApp newWebApp(Configuration config) {
        Class cls = config.getWebAppClass();
        if (cls == null) {
            return new SimpleWebApp();
        }
        try {
            return (WebApp)cls.newInstance();
        }
        catch (Exception ex) {
            throw UiException.Aide.wrap((Throwable)ex, "Unable to construct " + cls);
        }
    }

    public void destroy() {
        ((WebAppCtrl)((Object)this._wapp)).destroy();
    }

    public final ClassWebResource getClassWebResource() {
        return this._cwr;
    }

    public final WebApp getWebApp() {
        return this._wapp;
    }

    public static Object getRequestLocal(ServletRequest request, String name) {
        return request.getAttribute(name);
    }

    public static void setRequestLocal(ServletRequest request, String name, Object value) {
        request.setAttribute(name, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void addActivationListener(ServletContext ctx, WebManagerActivationListener listener) {
        if (ctx == null || listener == null) {
            throw new IllegalArgumentException("null");
        }
        WebManager webman = WebManager.getWebManagerIfAny(ctx);
        if (webman != null) {
            listener.didActivate(webman);
        } else {
            Class clazz = WebManager.class;
            synchronized (clazz) {
                LinkedList<WebManagerActivationListener> l = (LinkedList<WebManagerActivationListener>)_actListeners.get(ctx);
                if (l == null) {
                    l = new LinkedList<WebManagerActivationListener>();
                    _actListeners.put(ctx, l);
                }
                l.add(listener);
            }
        }
    }

    public static final WebManager getWebManager(ServletContext ctx) {
        WebManager webman = WebManager.getWebManagerIfAny(ctx);
        if (webman == null) {
            throw new UiException("The Web manager not found. Make sure <load-on-startup> is specified for " + DHtmlLayoutServlet.class.getName());
        }
        return webman;
    }

    static final WebManager getWebManagerIfAny(ServletContext ctx) {
        return (WebManager)ctx.getAttribute(ATTR_WEB_MANAGER);
    }

    public static final Session getSession(ServletContext ctx, HttpServletRequest request) {
        return WebManager.getSession(ctx, request, request.getSession());
    }

    public static final Session getSession(ServletContext ctx, HttpServletRequest request, boolean create) {
        HttpSession hsess = request.getSession(create);
        return hsess != null ? WebManager.getSession(ctx, request, hsess) : null;
    }

    static final Session newSession(WebApp wapp, HttpSession hsess, Object request) {
        if (log.debugable()) {
            log.debug("Creating a new sess for " + hsess);
        }
        Session sess = ((WebAppCtrl)((Object)wapp)).getUiFactory().newSession(wapp, hsess, request);
        hsess.setAttribute(ATTR_SESS, (Object)sess);
        Configuration config = wapp.getConfiguration();
        int v = config.getSessionMaxInactiveInterval();
        if (v != 0) {
            sess.setMaxInactiveInterval(v);
        }
        return sess;
    }

    private static final Session getSession(ServletContext ctx, HttpServletRequest request, HttpSession hsess) {
        Session sess = WebManager.getSession(hsess);
        return sess != null ? sess : WebManager.newSession(WebManager.getWebManager(ctx).getWebApp(), hsess, request);
    }

    static final Session getSession(HttpSession hsess) {
        Session sess = (Session)hsess.getAttribute(ATTR_SESS);
        if (sess != null && sess.getNativeSession() == null) {
            ((SessionCtrl)((Object)sess)).recover(hsess);
        }
        return sess;
    }

    static final void onSessionDestroyed(HttpSession hsess) {
        Session sess = WebManager.getSession(hsess);
        if (sess != null) {
            try {
                WebApp wapp = WebManager.getWebManager(hsess.getServletContext()).getWebApp();
                ((WebAppCtrl)((Object)wapp)).getDesktopCacheProvider().sessionDestroyed(sess);
            }
            catch (Throwable ex) {
                log.error("Failed to cleanup session", ex);
            }
            try {
                ((SessionCtrl)((Object)sess)).onDestroyed();
            }
            catch (Throwable ex) {
                log.error("Failed to cleanup session", ex);
            }
            hsess.removeAttribute(ATTR_SESS);
        }
    }

    public Desktop getDesktop(Session sess, ServletRequest request, ServletResponse response, String path, boolean autocreate) {
        Desktop desktop = (Desktop)WebManager.getRequestLocal(request, ATTR_DESKTOP);
        if (desktop == null && autocreate) {
            if (log.debugable()) {
                log.debug("Create desktop for " + path);
            }
            desktop = this.newDesktop(sess, request, response, path);
            WebManager.setRequestLocal(request, ATTR_DESKTOP, desktop);
        }
        return desktop;
    }

    public Desktop getDesktop(Session sess, ServletRequest request, String path, boolean autocreate) {
        return this.getDesktop(sess, request, null, path, autocreate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Desktop newDesktop(Session sess, ServletRequest request, ServletResponse response, String path) {
        Locator loc = PageDefinitions.getLocator(this._wapp, path);
        Execution exec = ExecutionsCtrl.getCurrent();
        if (exec == null) {
            ExecutionsCtrl.setCurrent(new ExecutionImpl(this._ctx, (HttpServletRequest)request, (HttpServletResponse)response, null, null));
        }
        try {
            Desktop desktop = ((WebAppCtrl)((Object)this._wapp)).getUiFactory().newDesktop(new RequestInfoImpl(this._wapp, sess, null, request, loc), this._updateURI, path);
            return desktop;
        }
        finally {
            if (exec == null) {
                ExecutionsCtrl.setCurrent(null);
            }
        }
    }

    public static void setDesktop(HttpServletRequest request, Desktop desktop) {
        WebManager.setRequestLocal((ServletRequest)request, ATTR_DESKTOP, desktop);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Page newPage(UiFactory uf, RequestInfo ri, PageDefinition pagedef, ServletResponse response, String path) {
        Execution exec = ExecutionsCtrl.getCurrent();
        if (exec == null) {
            ExecutionImpl ei = new ExecutionImpl((ServletContext)ri.getWebApp().getNativeContext(), (HttpServletRequest)ri.getNativeRequest(), (HttpServletResponse)response, ri.getDesktop(), null);
            ((DesktopCtrl)((Object)ri.getDesktop())).setExecution(ei);
            ExecutionsCtrl.setCurrent(ei);
        }
        try {
            Page page = uf.newPage(ri, pagedef, path);
            return page;
        }
        finally {
            if (exec == null) {
                ExecutionsCtrl.setCurrent(null);
                ((DesktopCtrl)((Object)ri.getDesktop())).setExecution(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Page newPage(UiFactory uf, RequestInfo ri, Richlet richlet, ServletResponse response, String path) {
        Execution exec = ExecutionsCtrl.getCurrent();
        if (exec == null) {
            ExecutionImpl ei = new ExecutionImpl((ServletContext)ri.getWebApp().getNativeContext(), (HttpServletRequest)ri.getNativeRequest(), (HttpServletResponse)response, ri.getDesktop(), null);
            ((DesktopCtrl)((Object)ri.getDesktop())).setExecution(ei);
            ExecutionsCtrl.setCurrent(ei);
        }
        try {
            Page page = uf.newPage(ri, richlet, path);
            return page;
        }
        finally {
            if (exec == null) {
                ExecutionsCtrl.setCurrent(null);
                ((DesktopCtrl)((Object)ri.getDesktop())).setExecution(null);
            }
        }
    }
}

