/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.zkoss.lang.Exceptions;
import org.zkoss.util.logging.Log;
import org.zkoss.util.resource.Loader;
import org.zkoss.util.resource.ResourceCache;
import org.zkoss.web.servlet.Servlets;
import org.zkoss.web.servlet.http.Https;
import org.zkoss.web.util.resource.Extendlet;
import org.zkoss.web.util.resource.ExtendletConfig;
import org.zkoss.web.util.resource.ExtendletContext;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.http.ExecutionImpl;
import org.zkoss.zk.ui.http.I18Ns;
import org.zkoss.zk.ui.http.Utils;
import org.zkoss.zk.ui.http.WebManager;
import org.zkoss.zk.ui.impl.RequestInfoImpl;
import org.zkoss.zk.ui.metainfo.PageDefinition;
import org.zkoss.zk.ui.metainfo.PageDefinitions;
import org.zkoss.zk.ui.sys.RequestInfo;
import org.zkoss.zk.ui.sys.WebAppCtrl;

class ZumlExtendlet
implements Extendlet {
    private static final Log log = Log.lookup((Class)ZumlExtendlet.class);
    private ExtendletContext _webctx;
    private ResourceCache _cache;

    ZumlExtendlet() {
    }

    private ServletContext getServletContext() {
        return this._webctx.getServletContext();
    }

    private WebManager getWebManager() {
        return WebManager.getWebManager(this.getServletContext());
    }

    private WebApp getWebApp() {
        return this.getWebManager().getWebApp();
    }

    public void init(ExtendletConfig config) {
        this._webctx = config.getExtendletContext();
        this._cache = new ResourceCache((Loader)new ZUMLLoader(), 17);
        this._cache.setMaxSize(512);
        this._cache.setLifetime(3600000);
        this._cache.setCheckPeriod(3600000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(HttpServletRequest request, HttpServletResponse response, String path, String extra) throws ServletException, IOException {
        if (extra != null) {
            log.warning("extra is not supported by ZumlExtendlet: " + extra);
        }
        Session sess = WebManager.getSession(this.getServletContext(), request);
        PageDefinition pagedef = (PageDefinition)this._cache.get((Object)path);
        if (pagedef == null) {
            this.handleError(sess, request, response, path, null);
            return;
        }
        Object old = I18Ns.setup(sess, (ServletRequest)request, (ServletResponse)response, sess.getWebApp().getConfiguration().getResponseCharset());
        try {
            this.process(sess, request, response, pagedef, path);
        }
        catch (Throwable ex) {
            this.handleError(sess, request, response, path, ex);
        }
        finally {
            I18Ns.cleanup((ServletRequest)request, old);
        }
    }

    private void process(Session sess, HttpServletRequest request, HttpServletResponse response, PageDefinition pagedef, String path) throws ServletException, IOException {
        WebApp wapp = sess.getWebApp();
        WebAppCtrl wappc = (WebAppCtrl)((Object)wapp);
        Desktop desktop = this.getWebManager().getDesktop(sess, (ServletRequest)request, (ServletResponse)response, path, true);
        RequestInfoImpl ri = new RequestInfoImpl(wapp, sess, desktop, request, PageDefinitions.getLocator(wapp, path));
        boolean compress = !Servlets.isIncluded((ServletRequest)request);
        Page page = WebManager.newPage(wappc.getUiFactory(), (RequestInfo)ri, pagedef, (ServletResponse)response, path);
        ExecutionImpl exec = new ExecutionImpl(this.getServletContext(), request, response, desktop, page);
        Writer out = compress ? new StringWriter() : response.getWriter();
        wappc.getUiEngine().execNewPage((Execution)exec, pagedef, page, out);
        if (compress) {
            String result = ((StringWriter)out).toString();
            try {
                byte[] bs;
                ServletOutputStream os = response.getOutputStream();
                byte[] data = result.getBytes("UTF-8");
                if (data.length > 200 && (bs = Https.gzip((HttpServletRequest)request, (HttpServletResponse)response, null, (byte[])data)) != null) {
                    data = bs;
                }
                response.setContentLength(data.length);
                os.write(data);
                response.flushBuffer();
            }
            catch (IllegalStateException ex) {
                response.getWriter().write(result);
            }
        }
    }

    private void handleError(Session sess, HttpServletRequest request, HttpServletResponse response, String path, Throwable err) throws ServletException, IOException {
        String errpg;
        if (err != null && Servlets.isIncluded((ServletRequest)request) && (errpg = sess.getWebApp().getConfiguration().getErrorPage(sess.getDeviceType(), err)) != null) {
            try {
                request.setAttribute("javax.servlet.error.message", (Object)Exceptions.getMessage((Throwable)err));
                request.setAttribute("javax.servlet.error.exception", (Object)err);
                request.setAttribute("javax.servlet.error.exception_type", err.getClass());
                request.setAttribute("javax.servlet.error.status_code", (Object)new Integer(500));
                Servlets.forward((ServletContext)this.getServletContext(), (ServletRequest)request, (ServletResponse)response, (String)errpg, null, (int)0);
                return;
            }
            catch (IOException ex) {
            }
            catch (Throwable ex) {
                log.warning("Failed to load the error page: " + errpg, ex);
            }
        }
        Utils.handleError(this.getServletContext(), request, response, path, err);
    }

    private class ZUMLLoader
    implements Loader {
        private ZUMLLoader() {
        }

        public boolean shallCheck(Object src, long expiredMillis) {
            return expiredMillis > 0L;
        }

        public long getLastModified(Object src) {
            return 1L;
        }

        public Object load(Object src) throws Exception {
            String path = (String)src;
            InputStream is = ZumlExtendlet.this._webctx.getResourceAsStream(path);
            if (is == null) {
                return null;
            }
            try {
                return this.parse0(is, Servlets.getExtension((String)path));
            }
            catch (Exception ex) {
                if (log.debugable()) {
                    log.realCauseBriefly("Failed to parse " + path, (Throwable)ex);
                } else {
                    log.error("Failed to parse " + path + "\nCause: " + ex.getClass().getName() + " " + Exceptions.getMessage((Throwable)ex) + "\n" + Exceptions.getBriefStackTrace((Throwable)ex));
                }
                return null;
            }
        }

        private Object parse0(InputStream is, String ext) throws Exception {
            return PageDefinitions.getPageDefinitionDirectly(ZumlExtendlet.this.getWebApp(), ZumlExtendlet.this._webctx.getLocator(), new InputStreamReader(is, "UTF-8"), ext);
        }
    }
}

