/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.impl;

import java.io.IOException;
import java.io.Reader;
import org.zkoss.idom.Document;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.Richlet;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.impl.DesktopImpl;
import org.zkoss.zk.ui.impl.PageImpl;
import org.zkoss.zk.ui.metainfo.ComponentDefinition;
import org.zkoss.zk.ui.metainfo.ComponentInfo;
import org.zkoss.zk.ui.metainfo.DefinitionNotFoundException;
import org.zkoss.zk.ui.metainfo.LanguageDefinition;
import org.zkoss.zk.ui.metainfo.PageDefinition;
import org.zkoss.zk.ui.metainfo.PageDefinitions;
import org.zkoss.zk.ui.sys.RequestInfo;
import org.zkoss.zk.ui.sys.UiFactory;

public abstract class AbstractUiFactory
implements UiFactory {
    public void start(WebApp wapp) {
    }

    public void stop(WebApp wapp) {
    }

    public boolean isRichlet(RequestInfo ri, boolean bRichlet) {
        return bRichlet;
    }

    public Richlet getRichlet(RequestInfo ri, String path) {
        return ri.getWebApp().getConfiguration().getRichletByPath(path);
    }

    public Desktop newDesktop(RequestInfo ri, String updateURI, String path) {
        int k;
        String deviceType = null;
        if (path != null && (k = path.lastIndexOf(46) + 1) > 0 && path.indexOf(47, k) < 0 && k < path.length()) {
            String ext = path.substring(k);
            try {
                deviceType = LanguageDefinition.getByExtension(ext).getDeviceType();
            }
            catch (DefinitionNotFoundException ex) {
                // empty catch block
            }
        }
        return new DesktopImpl(ri.getWebApp(), updateURI, path, deviceType, ri.getNativeRequest());
    }

    public Page newPage(RequestInfo ri, PageDefinition pagedef, String path) {
        return new PageImpl(pagedef);
    }

    public Page newPage(RequestInfo ri, Richlet richlet, String path) {
        return new PageImpl(richlet, path);
    }

    public Component newComponent(Page page, Component parent, ComponentInfo compInfo) {
        Component comp = compInfo.newInstance(page, parent);
        if (parent != null) {
            comp.setParent(parent);
        } else {
            comp.setPage(page);
        }
        compInfo.applyProperties(comp);
        return comp;
    }

    public Component newComponent(Page page, Component parent, ComponentDefinition compdef, String clsnm) {
        Component comp = compdef.newInstance(page, clsnm);
        if (parent != null) {
            comp.setParent(parent);
        } else {
            comp.setPage(page);
        }
        comp.applyProperties();
        return comp;
    }

    public PageDefinition getPageDefinition(RequestInfo ri, String path) {
        return PageDefinitions.getPageDefinition(ri.getWebApp(), ri.getLocator(), path);
    }

    public PageDefinition getPageDefinitionDirectly(RequestInfo ri, String content, String extension) {
        return PageDefinitions.getPageDefinitionDirectly(ri.getWebApp(), ri.getLocator(), content, extension);
    }

    public PageDefinition getPageDefinitionDirectly(RequestInfo ri, Document content, String extension) {
        return PageDefinitions.getPageDefinitionDirectly(ri.getWebApp(), ri.getLocator(), content, extension);
    }

    public PageDefinition getPageDefinitionDirectly(RequestInfo ri, Reader reader, String extension) throws IOException {
        return PageDefinitions.getPageDefinitionDirectly(ri.getWebApp(), ri.getLocator(), reader, extension);
    }
}

