/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.impl;

import java.io.InputStream;
import org.zkoss.io.Files;
import org.zkoss.util.Utils;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.http.SimpleUiFactory;
import org.zkoss.zk.ui.impl.SessionDesktopCacheProvider;
import org.zkoss.zk.ui.impl.UiEngineImpl;
import org.zkoss.zk.ui.sys.DesktopCache;
import org.zkoss.zk.ui.sys.DesktopCacheProvider;
import org.zkoss.zk.ui.sys.FailoverManager;
import org.zkoss.zk.ui.sys.IdGenerator;
import org.zkoss.zk.ui.sys.UiEngine;
import org.zkoss.zk.ui.sys.UiFactory;
import org.zkoss.zk.ui.sys.WebAppCtrl;
import org.zkoss.zk.ui.util.Configuration;

public abstract class AbstractWebApp
implements WebApp,
WebAppCtrl {
    private String _appnm = "ZK";
    private String _build;
    private Configuration _config;
    private UiEngine _engine;
    private DesktopCacheProvider _provider;
    private UiFactory _factory;
    private FailoverManager _failover;
    private IdGenerator _idgen;

    protected AbstractWebApp() {
    }

    public String getAppName() {
        return this._appnm;
    }

    public void setAppName(String name) {
        this._appnm = name != null ? name : "";
    }

    public final String getVersion() {
        return "3.0.2";
    }

    public final String getBuild() {
        if (this._build == null) {
            this.loadBuild();
        }
        return this._build;
    }

    public int getSubversion(int portion) {
        return Utils.getSubversion((String)this.getVersion(), (int)portion);
    }

    public final Configuration getConfiguration() {
        return this._config;
    }

    public void init(Object context, Configuration config) {
        if (this._config != null) {
            throw new IllegalStateException("Cannot be initialized twice");
        }
        if (config == null) {
            throw new IllegalArgumentException("null");
        }
        WebApp oldwapp = config.getWebApp();
        if (oldwapp != null && oldwapp != this) {
            throw new IllegalArgumentException("config already belongs to other Web app, " + oldwapp);
        }
        this._config = config;
        this._config.setWebApp(this);
        Class cls = this._config.getUiEngineClass();
        if (cls == null) {
            this._engine = new UiEngineImpl();
        } else {
            try {
                this._engine = (UiEngine)cls.newInstance();
            }
            catch (Exception ex) {
                throw UiException.Aide.wrap((Throwable)ex, "Unable to construct " + cls);
            }
        }
        cls = this._config.getDesktopCacheProviderClass();
        if (cls == null) {
            this._provider = new SessionDesktopCacheProvider();
        } else {
            try {
                this._provider = (DesktopCacheProvider)cls.newInstance();
            }
            catch (Exception ex) {
                throw UiException.Aide.wrap((Throwable)ex, "Unable to construct " + cls);
            }
        }
        cls = this._config.getUiFactoryClass();
        if (cls == null) {
            this._factory = new SimpleUiFactory();
        } else {
            try {
                this._factory = (UiFactory)cls.newInstance();
            }
            catch (Exception ex) {
                throw UiException.Aide.wrap((Throwable)ex, "Unable to construct " + cls);
            }
        }
        cls = this._config.getFailoverManagerClass();
        if (cls != null) {
            try {
                this._failover = (FailoverManager)cls.newInstance();
            }
            catch (Exception ex) {
                throw UiException.Aide.wrap((Throwable)ex, "Unable to construct " + cls);
            }
        }
        if ((cls = this._config.getIdGeneratorClass()) != null) {
            try {
                this._idgen = (IdGenerator)cls.newInstance();
            }
            catch (Exception ex) {
                throw UiException.Aide.wrap((Throwable)ex, "Unable to construct " + cls);
            }
        }
        this._engine.start(this);
        this._provider.start(this);
        this._factory.start(this);
        this._config.invokeWebAppInits();
    }

    public void destroy() {
        this._config.invokeWebAppCleanups();
        this._config.detroyRichlets();
        this.getUiFactory().stop(this);
        this.getDesktopCacheProvider().stop(this);
        this.getUiEngine().stop(this);
    }

    public final UiEngine getUiEngine() {
        return this._engine;
    }

    public DesktopCache getDesktopCache(Session sess) {
        return this._provider.getDesktopCache(sess);
    }

    public DesktopCacheProvider getDesktopCacheProvider() {
        return this._provider;
    }

    public UiFactory getUiFactory() {
        return this._factory;
    }

    public FailoverManager getFailoverManager() {
        return this._failover;
    }

    public IdGenerator getIdGenerator() {
        return this._idgen;
    }

    public void sessionWillPassivate(Session sess) {
        this._provider.sessionWillPassivate(sess);
    }

    public void sessionDidActivate(Session sess) {
        this._provider.sessionDidActivate(sess);
    }

    private synchronized void loadBuild() {
        if (this._build == null) {
            String FILE = "/metainfo/zk/build";
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("/metainfo/zk/build");
            if (is == null && (is = AbstractWebApp.class.getResourceAsStream("/metainfo/zk/build")) == null) {
                this._build = "";
                return;
            }
            try {
                this._build = new String(Files.readAll((InputStream)is));
            }
            catch (Exception ex) {
                this._build = "error";
            }
        }
    }
}

