/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.zkoss.io.Serializables;
import org.zkoss.lang.Strings;
import org.zkoss.util.Cache;
import org.zkoss.util.CacheMap;
import org.zkoss.util.logging.Log;
import org.zkoss.util.media.Media;
import org.zkoss.zk.au.out.AuBookmark;
import org.zkoss.zk.device.Device;
import org.zkoss.zk.device.DeviceNotFoundException;
import org.zkoss.zk.device.Devices;
import org.zkoss.zk.mesg.MZk;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.ComponentNotFoundException;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.Sessions;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.ext.render.DynamicMedia;
import org.zkoss.zk.ui.impl.EventInterceptors;
import org.zkoss.zk.ui.impl.RequestQueueImpl;
import org.zkoss.zk.ui.metainfo.LanguageDefinition;
import org.zkoss.zk.ui.sys.ComponentCtrl;
import org.zkoss.zk.ui.sys.ComponentsCtrl;
import org.zkoss.zk.ui.sys.DesktopCache;
import org.zkoss.zk.ui.sys.DesktopCtrl;
import org.zkoss.zk.ui.sys.EventProcessingThread;
import org.zkoss.zk.ui.sys.ExecutionCtrl;
import org.zkoss.zk.ui.sys.IdGenerator;
import org.zkoss.zk.ui.sys.PageCtrl;
import org.zkoss.zk.ui.sys.RequestQueue;
import org.zkoss.zk.ui.sys.ServerPush;
import org.zkoss.zk.ui.sys.SessionCtrl;
import org.zkoss.zk.ui.sys.WebAppCtrl;
import org.zkoss.zk.ui.util.Configuration;
import org.zkoss.zk.ui.util.DesktopSerializationListener;
import org.zkoss.zk.ui.util.EventInterceptor;
import org.zkoss.zk.ui.util.Monitor;

public class DesktopImpl
implements Desktop,
DesktopCtrl,
Serializable {
    private static final Log log = Log.lookup((Class)DesktopImpl.class);
    private static final long serialVersionUID = 20070416L;
    private static final String MEDIA_PREFIX = "med";
    private transient WebApp _wapp;
    private transient Session _sess;
    private String _id;
    private String _dir;
    private final String _path;
    private final String _updateURI;
    private final Map _pages = new LinkedHashMap(3);
    private transient Map _comps;
    private transient Map _attrs;
    private transient Execution _exec;
    private int _nextKey;
    private transient int _nextUuid;
    private String _uuidPrefix;
    private transient RequestQueue _rque;
    private String _bookmark = "";
    private String _devType = "ajax";
    private transient Device _dev;
    private Cache _meds;
    private int _medId;
    private ServerPush _spush;
    private final EventInterceptors _eis = new EventInterceptors();
    private static final int MAX_RESPONSE_SEQUENCE = 1024;
    private int _respSeqId = 1023;
    private boolean _piggybackListened;
    private static final int UUID_STEP = 128;
    private static final int UUID_STEP_MASK = 127;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DesktopImpl(WebApp wapp, String updateURI, String path, String deviceType, Object request) {
        if (updateURI == null || wapp == null) {
            throw new IllegalArgumentException("null");
        }
        Execution exec = Executions.getCurrent();
        if (exec != null) {
            ((ExecutionCtrl)((Object)exec)).setDesktop(this);
        }
        this._wapp = wapp;
        this._updateURI = updateURI;
        this.init();
        this._sess = Sessions.getCurrent();
        String dir = null;
        if (path != null) {
            this._path = path;
            int j = path.lastIndexOf(47);
            if (j >= 0) {
                dir = path.substring(0, j + 1);
            }
        } else {
            this._path = "";
        }
        this.setCurrentDirectory(dir);
        if (deviceType != null && deviceType.length() != 0) {
            this.setDeviceType(deviceType);
        }
        Configuration config = this._wapp.getConfiguration();
        this._exec = exec;
        try {
            WebAppCtrl wappc = (WebAppCtrl)((Object)this._wapp);
            DesktopCache dc = wappc.getDesktopCache(this._sess);
            IdGenerator idgen = wappc.getIdGenerator();
            if (idgen != null) {
                this._id = idgen.nextDesktopId(this);
            }
            if (this._id == null) {
                this._id = Strings.encode((StringBuffer)new StringBuffer(12).append("g"), (int)dc.getNextKey()).toString();
            }
            this.updateUuidPrefix();
            config.invokeDesktopInits(this, request);
            dc.addDesktop(this);
            Monitor monitor = config.getMonitor();
            if (monitor != null) {
                try {
                    monitor.desktopCreated(this);
                }
                catch (Throwable ex) {
                    log.error(ex);
                }
            }
        }
        finally {
            this._exec = null;
        }
    }

    private void init() {
        this._rque = this.newRequestQueue();
        this._comps = new HashMap(41);
        this._attrs = new HashMap();
    }

    private void updateUuidPrefix() {
        this._uuidPrefix = this._id.substring(1, this._id.length() <= 2 ? 2 : 3);
    }

    public String getId() {
        return this._id;
    }

    protected RequestQueue newRequestQueue() {
        return new RequestQueueImpl();
    }

    public String getDeviceType() {
        return this._devType;
    }

    public Device getDevice() {
        if (this._dev == null) {
            this._dev = Devices.getDevice(this._devType);
        }
        return this._dev;
    }

    public void setDeviceType(String deviceType) {
        if (!this._devType.equals(deviceType)) {
            if (deviceType == null || deviceType.length() == 0) {
                throw new IllegalArgumentException("empty");
            }
            if (!Devices.exists(deviceType)) {
                throw new DeviceNotFoundException(deviceType, MZk.NOT_FOUND, deviceType);
            }
            if (!this._comps.isEmpty()) {
                throw new UiException("Unable to change the device type since some components are attached.");
            }
            this._devType = deviceType;
            this._dev = null;
            ((SessionCtrl)((Object)this._sess)).setDeviceType(this._devType);
        }
    }

    public Execution getExecution() {
        return this._exec;
    }

    public final Session getSession() {
        return this._sess;
    }

    public String getUpdateURI(String pathInfo) {
        String uri;
        if (pathInfo == null || pathInfo.length() == 0) {
            uri = this._updateURI;
        } else {
            if (pathInfo.charAt(0) != '/') {
                pathInfo = '/' + pathInfo;
            }
            uri = this._updateURI + pathInfo;
        }
        return this._exec.encodeURL(uri);
    }

    public String getDynamicMediaURI(Component comp, String pathInfo) {
        if (!(((ComponentCtrl)((Object)comp)).getExtraCtrl() instanceof DynamicMedia)) {
            throw new UiException(DynamicMedia.class + " not implemented by getExtraCtrl() of " + comp);
        }
        StringBuffer sb = new StringBuffer(64).append("/view/").append(this.getId()).append('/').append(comp.getUuid());
        if (pathInfo != null && pathInfo.length() > 0) {
            if (!pathInfo.startsWith("/")) {
                sb.append('/');
            }
            sb.append(pathInfo);
        }
        return this.getUpdateURI(sb.toString());
    }

    public String getDownloadMediaURI(Media media, String pathInfo) {
        if (media == null) {
            throw new IllegalArgumentException("null media");
        }
        if (this._meds == null) {
            this._meds = new CacheMap();
            this._meds.setMaxSize(16384);
            this._meds.setLifetime(360000);
        }
        String medId = Strings.encode((StringBuffer)new StringBuffer(12).append(MEDIA_PREFIX), (int)this._medId++).toString();
        this._meds.put((Object)medId, (Object)media);
        StringBuffer sb = new StringBuffer(64).append("/view/").append(this.getId()).append('/').append(medId);
        if (pathInfo != null && pathInfo.length() > 0) {
            if (!pathInfo.startsWith("/")) {
                sb.append('/');
            }
            sb.append(pathInfo);
        }
        return this.getUpdateURI(sb.toString());
    }

    public Media getDownloadMedia(String medId, boolean remove) {
        return this._meds != null ? (remove ? (Media)this._meds.remove((Object)medId) : (Media)this._meds.get((Object)medId)) : null;
    }

    public Page getPage(String pageId) {
        Page page = this.getPageIfAny(pageId);
        if (page == null) {
            throw new ComponentNotFoundException("Page not found: " + pageId);
        }
        return page;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Page getPageIfAny(String pageId) {
        Map map = this._pages;
        synchronized (map) {
            return (Page)this._pages.get(pageId);
        }
    }

    public boolean hasPage(String pageId) {
        return this._pages.containsKey(pageId);
    }

    public Collection getPages() {
        return this._pages.values();
    }

    public String getBookmark() {
        return this._bookmark;
    }

    public void setBookmark(String name) {
        if (this._exec == null) {
            throw new IllegalStateException("Not the current desktop: " + this);
        }
        if (name.indexOf(35) >= 0 || name.indexOf(63) >= 0) {
            throw new IllegalArgumentException("Illegal character: # ?");
        }
        this._bookmark = name;
        ((WebAppCtrl)((Object)this._wapp)).getUiEngine().addResponse("bookmark", new AuBookmark(name));
    }

    public Collection getComponents() {
        return this._comps.values();
    }

    public Component getComponentByUuid(String uuid) {
        Component comp = (Component)this._comps.get(uuid);
        if (comp == null) {
            throw new ComponentNotFoundException("Component not found: " + uuid);
        }
        return comp;
    }

    public Component getComponentByUuidIfAny(String uuid) {
        return (Component)this._comps.get(uuid);
    }

    public void addComponent(Component comp) {
        LanguageDefinition langdef = comp.getDefinition().getLanguageDefinition();
        if (langdef != null && !this._devType.equals(langdef.getDeviceType())) {
            throw new UiException("Component, " + comp + ", does not belong to the same device type of the desktop, " + this._devType);
        }
        Component old = this._comps.put(comp.getUuid(), comp);
        if (old != comp && old != null) {
            this._comps.put(old.getUuid(), old);
            throw new InternalError("Caller shall prevent it: Register a component twice: " + comp);
        }
    }

    public void removeComponent(Component comp) {
        this._comps.remove(comp.getUuid());
    }

    public Map getAttributes() {
        return this._attrs;
    }

    public Object getAttribute(String name) {
        return this._attrs.get(name);
    }

    public Object setAttribute(String name, Object value) {
        return value != null ? this._attrs.put(name, value) : this.removeAttribute(name);
    }

    public Object removeAttribute(String name) {
        return this._attrs.remove(name);
    }

    public WebApp getWebApp() {
        return this._wapp;
    }

    public String getRequestPath() {
        return this._path;
    }

    public String getCurrentDirectory() {
        return this._dir;
    }

    public void setCurrentDirectory(String dir) {
        if (dir == null) {
            dir = "";
        } else {
            int len = dir.length() - 1;
            if (len >= 0 && dir.charAt(len) != '/') {
                dir = dir + '/';
            }
        }
        this._dir = dir;
    }

    public boolean isAlive() {
        return this._comps != null;
    }

    public RequestQueue getRequestQueue() {
        return this._rque;
    }

    public void setExecution(Execution exec) {
        this._exec = exec;
    }

    public int getNextKey() {
        return this._nextKey++;
    }

    public String getNextUuid() {
        if ((this._nextUuid & 0x7F) == 0) {
            this._nextUuid = ((SessionCtrl)((Object)this._sess)).getNextUuidGroup(128);
        }
        return ComponentsCtrl.toAutoId(this._uuidPrefix, this._nextUuid++);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPage(Page page) {
        Map map = this._pages;
        synchronized (map) {
            Page old = this._pages.put(page.getId(), page);
            if (old != null) {
                this._pages.put(old.getId(), old);
                log.warning(page == old ? "Register a page twice: " + page : "Replicated ID: " + page + "; already used by " + old);
            }
            if (log.debugable()) {
                log.debug("After added, pages: " + this._pages);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePage(Page page) {
        Map map = this._pages;
        synchronized (map) {
            if (this._pages.remove(page.getId()) == null) {
                log.warning("Removing non-exist page: " + page + "\nCurrent pages: " + this._pages.values());
                return;
            }
            if (log.debugable()) {
                log.debug("After removed, pages: " + this._pages.values());
            }
        }
        this.removeComponents(page.getRoots());
        ((PageCtrl)((Object)page)).destroy();
    }

    private void removeComponents(Collection comps) {
        Iterator it = comps.iterator();
        while (it.hasNext()) {
            Component comp = (Component)it.next();
            this.removeComponents(comp.getChildren());
            this.removeComponent(comp);
        }
    }

    public void setBookmarkByClient(String name) {
        this._bookmark = name != null ? name : "";
    }

    public void setId(String id) {
        if (!((ExecutionCtrl)((Object)this._exec)).isRecovering()) {
            throw new IllegalStateException("Callable only in recovring");
        }
        if (id == null || id.length() <= 1 || id.charAt(0) != 'g') {
            throw new IllegalArgumentException("Invalid desktop ID. You have to recover to the original value, not creating a new value: " + id);
        }
        DesktopCache dc = ((WebAppCtrl)((Object)this._wapp)).getDesktopCache(this._sess);
        dc.removeDesktop(this);
        this._id = id;
        this.updateUuidPrefix();
        dc.addDesktop(this);
    }

    public void recoverDidFail(Throwable ex) {
        ((WebAppCtrl)((Object)this._wapp)).getDesktopCache(this._sess).removeDesktop(this);
    }

    public int getResponseSequence(boolean advance) {
        if (advance && ++this._respSeqId == 1024) {
            this._respSeqId = 0;
        }
        return this._respSeqId;
    }

    public void setResponseSequence(int seqId) {
        if (seqId >= 1024) {
            throw new IllegalArgumentException("Invalid sequence: " + seqId);
        }
        this._respSeqId = seqId < 0 ? 1023 : seqId;
    }

    public void destroy() {
        Iterator it = this._pages.values().iterator();
        while (it.hasNext()) {
            PageCtrl pgc = (PageCtrl)it.next();
            try {
                pgc.destroy();
            }
            catch (Throwable ex) {
                log.error("Failed to destroy " + pgc, ex);
            }
        }
        if (this._spush != null) {
            this._spush.stop();
            this._spush = null;
        }
        this._pages.clear();
        this._attrs = null;
        this._comps = null;
        this._meds = null;
        this._rque = null;
    }

    public Collection getSuspendedThreads() {
        return ((WebAppCtrl)((Object)this._wapp)).getUiEngine().getSuspendedThreads(this);
    }

    public boolean ceaseSuspendedThread(EventProcessingThread evtthd, String cause) {
        return ((WebAppCtrl)((Object)this._wapp)).getUiEngine().ceaseSuspendedThread(this, evtthd, cause);
    }

    public String toString() {
        return "[Desktop " + this._id + ']';
    }

    public void sessionWillPassivate(Session sess) {
        Iterator it = this._pages.values().iterator();
        while (it.hasNext()) {
            ((PageCtrl)it.next()).sessionWillPassivate(this);
        }
        if (this._dev != null) {
            this._dev.sessionWillPassivate(this);
        }
    }

    public void sessionDidActivate(Session sess) {
        this._sess = sess;
        this._wapp = sess.getWebApp();
        if (this._dev != null) {
            this._dev.sessionDidActivate(this);
        }
        Iterator it = this._pages.values().iterator();
        while (it.hasNext()) {
            ((PageCtrl)it.next()).sessionDidActivate(this);
        }
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        this.willSerialize(this._attrs.values());
        Serializables.smartWrite((ObjectOutputStream)s, (Map)this._attrs);
    }

    private void willSerialize(Collection c) {
        if (c != null) {
            Iterator it = c.iterator();
            while (it.hasNext()) {
                this.willSerialize(it.next());
            }
        }
    }

    private void willSerialize(Object o) {
        if (o instanceof DesktopSerializationListener) {
            ((DesktopSerializationListener)o).willSerialize(this);
        }
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.init();
        Iterator it = this._pages.values().iterator();
        while (it.hasNext()) {
            Iterator e = ((Page)it.next()).getRoots().iterator();
            while (e.hasNext()) {
                this.addAllComponents((Component)e.next());
            }
        }
        Serializables.smartRead((ObjectInputStream)s, (Map)this._attrs);
        this.didDeserialize(this._attrs.values());
    }

    private void didDeserialize(Collection c) {
        if (c != null) {
            Iterator it = c.iterator();
            while (it.hasNext()) {
                this.didDeserialize(it.next());
            }
        }
    }

    private void didDeserialize(Object o) {
        if (o instanceof DesktopSerializationListener) {
            ((DesktopSerializationListener)o).didDeserialize(this);
        }
    }

    private void addAllComponents(Component comp) {
        this.addComponent(comp);
        Iterator it = comp.getChildren().iterator();
        while (it.hasNext()) {
            this.addAllComponents((Component)it.next());
        }
    }

    public void addEventInterceptor(EventInterceptor ei) {
        this._eis.addEventInterceptor(ei);
    }

    public boolean removeEventInterceptor(EventInterceptor ei) {
        return this._eis.removeEventInterceptor(ei);
    }

    public Event beforeSendEvent(Event event) {
        if ((event = this._eis.beforeSendEvent(event)) != null) {
            event = this._wapp.getConfiguration().beforeSendEvent(event);
        }
        return event;
    }

    public Event beforePostEvent(Event event) {
        if ((event = this._eis.beforePostEvent(event)) != null) {
            event = this._wapp.getConfiguration().beforePostEvent(event);
        }
        return event;
    }

    public Event beforeProcessEvent(Event event) {
        if ((event = this._eis.beforeProcessEvent(event)) != null) {
            event = this._wapp.getConfiguration().beforeProcessEvent(event);
        }
        return event;
    }

    public void afterProcessEvent(Event event) {
        this._eis.afterProcessEvent(event);
        this._wapp.getConfiguration().afterProcessEvent(event);
    }

    public boolean enableServerPush(boolean enable) {
        boolean old;
        boolean bl = old = this._spush != null;
        if (old != enable) {
            if (enable) {
                Class cls = this.getDevice().getServerPushClass();
                if (cls == null) {
                    throw new UiException("No server push defined. Make sure you are using the professional or enterprise edition, or you configured your own implementation");
                }
                try {
                    this._spush = (ServerPush)cls.newInstance();
                }
                catch (Throwable ex) {
                    throw UiException.Aide.wrap(ex, "Unable to instantiate " + cls);
                }
                this._spush.start(this);
            } else {
                this._spush.stop();
                this._spush = null;
            }
        }
        return old;
    }

    public boolean enableServerPush(ServerPush serverpush) {
        boolean old;
        if (serverpush == null) {
            return this.enableServerPush(false);
        }
        boolean bl = old = this._spush != null;
        if (!old || serverpush != this._spush) {
            if (old) {
                this.enableServerPush(false);
            }
            this._spush = serverpush;
            this._spush.start(this);
        }
        return old;
    }

    public boolean isServerPushEnabled() {
        return this._spush != null;
    }

    public ServerPush getServerPush() {
        return this._spush;
    }

    public void setServerPushDelay(int min, int max, int factor) {
        if (this._spush == null) {
            throw new IllegalStateException("Not started");
        }
        this._spush.setDelay(min, max, factor);
    }

    public void onPiggybackListened(Component comp, boolean listen) {
        if (listen) {
            this._piggybackListened = true;
        }
    }

    public void onPiggyback() {
        if (this._piggybackListened) {
            Iterator it = this._pages.values().iterator();
            while (it.hasNext()) {
                Page p = (Page)it.next();
                if (!Executions.getCurrent().isAsyncUpdate(p)) continue;
                Iterator e = p.getRoots().iterator();
                while (e.hasNext()) {
                    Component c = (Component)e.next();
                    if (!Events.isListened(c, "onPiggyback", false)) continue;
                    Events.postEvent(new Event("onPiggyback", c));
                }
            }
        }
        if (this._spush != null) {
            this._spush.onPiggyback();
        }
    }
}

