/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.Writer;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.zkoss.io.Serializables;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Objects;
import org.zkoss.lang.Strings;
import org.zkoss.util.CollectionsX;
import org.zkoss.util.logging.Log;
import org.zkoss.xel.Function;
import org.zkoss.xel.FunctionMapper;
import org.zkoss.xel.VariableResolver;
import org.zkoss.xel.util.DualFunctionMapper;
import org.zkoss.zk.au.out.AuSetTitle;
import org.zkoss.zk.mesg.MZk;
import org.zkoss.zk.scripting.HierachicalAware;
import org.zkoss.zk.scripting.Interpreter;
import org.zkoss.zk.scripting.InterpreterNotFoundException;
import org.zkoss.zk.scripting.Interpreters;
import org.zkoss.zk.scripting.Method;
import org.zkoss.zk.scripting.Namespace;
import org.zkoss.zk.scripting.SerializableAware;
import org.zkoss.zk.scripting.util.AbstractNamespace;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.ComponentNotFoundException;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.IdSpace;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.Richlet;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.impl.FuncMethod;
import org.zkoss.zk.ui.impl.ListenerIterator;
import org.zkoss.zk.ui.metainfo.ComponentDefinition;
import org.zkoss.zk.ui.metainfo.ComponentDefinitionMap;
import org.zkoss.zk.ui.metainfo.DefinitionNotFoundException;
import org.zkoss.zk.ui.metainfo.LanguageDefinition;
import org.zkoss.zk.ui.metainfo.PageDefinition;
import org.zkoss.zk.ui.metainfo.ZScript;
import org.zkoss.zk.ui.sys.ComponentCtrl;
import org.zkoss.zk.ui.sys.ComponentsCtrl;
import org.zkoss.zk.ui.sys.DesktopCtrl;
import org.zkoss.zk.ui.sys.ExecutionCtrl;
import org.zkoss.zk.ui.sys.IdGenerator;
import org.zkoss.zk.ui.sys.PageConfig;
import org.zkoss.zk.ui.sys.PageCtrl;
import org.zkoss.zk.ui.sys.UiEngine;
import org.zkoss.zk.ui.sys.WebAppCtrl;
import org.zkoss.zk.ui.util.Condition;
import org.zkoss.zk.ui.util.PageSerializationListener;
import org.zkoss.zk.xel.ExValue;

public class PageImpl
implements Page,
PageCtrl,
Serializable {
    private static final Log log;
    private static final Log _zklog;
    private static final long serialVersionUID = 20070413L;
    private final ExValue _dkURI;
    private final ExValue _pgURI;
    private transient Component _owner;
    private transient String _ownerUuid;
    private transient Desktop _desktop;
    private String _id;
    private String _uuid;
    private String _title = "";
    private String _style = "";
    private final String _path;
    private String _zslang;
    private List _zsDeferred;
    private final List _roots = new LinkedList();
    private transient List _roRoots;
    private transient Map _fellows;
    private transient Map _attrs;
    private transient Map _listeners;
    private transient Component _defparent;
    private FunctionMapper _mapper;
    private ComponentDefinitionMap _compdefs;
    private transient LanguageDefinition _langdef;
    private String _headers = "";
    private String _rootAttrs = "";
    private String _contentType;
    private String _docType;
    private String _firstLine;
    private Boolean _cacheable;
    private transient Map _ips;
    private transient NS _ns;
    private transient List _resolvers;
    private static final Map REQUEST_ATTRS;
    private static final Set _nonSerNames;
    static final /* synthetic */ boolean $assertionsDisabled;

    public PageImpl(PageDefinition pgdef) {
        this(pgdef.getLanguageDefinition(), pgdef.getComponentDefinitionMap(), pgdef.getRequestPath(), pgdef.getZScriptLanguage());
    }

    public PageImpl(LanguageDefinition langdef, ComponentDefinitionMap compdefs, String path, String zslang) {
        this.init();
        this._langdef = langdef;
        this._dkURI = new ExValue(this._langdef.getDesktopURI(), String.class);
        this._pgURI = new ExValue(this._langdef.getPageURI(), String.class);
        this._compdefs = compdefs != null ? compdefs : new ComponentDefinitionMap(this._langdef.getComponentDefinitionMap().isCaseInsensitive());
        this._path = path != null ? path : "";
        this._zslang = zslang != null ? zslang : "Java";
    }

    public PageImpl(Richlet richlet, String path) {
        this.init();
        this._langdef = richlet.getLanguageDefinition();
        this._dkURI = new ExValue(this._langdef.getDesktopURI(), String.class);
        this._pgURI = new ExValue(this._langdef.getPageURI(), String.class);
        this._compdefs = new ComponentDefinitionMap(this._langdef.getComponentDefinitionMap().isCaseInsensitive());
        this._path = path != null ? path : "";
        this._zslang = "Java";
    }

    protected void init() {
        this._ips = new LinkedHashMap(3);
        this._ns = new NS();
        this._roRoots = Collections.unmodifiableList(this._roots);
        this._attrs = new HashMap();
        this._fellows = new HashMap();
    }

    private final UiEngine getUiEngine() {
        return ((WebAppCtrl)((Object)this._desktop.getWebApp())).getUiEngine();
    }

    private final Execution getExecution() {
        return this._desktop != null ? this._desktop.getExecution() : Executions.getCurrent();
    }

    public final FunctionMapper getFunctionMapper() {
        return this._mapper;
    }

    public void addFunctionMapper(FunctionMapper mapper) {
        this._mapper = DualFunctionMapper.combine((FunctionMapper)mapper, (FunctionMapper)this._mapper);
    }

    public String getRequestPath() {
        return this._path;
    }

    public final String getId() {
        return this._id;
    }

    public final String getUuid() {
        return this._uuid;
    }

    public void setId(String id) {
        if (this._desktop != null) {
            throw new UiException("Unable to change the identifier after the page is initialized");
        }
        if (id != null && id.length() > 0) {
            this._id = id;
        }
    }

    public String getTitle() {
        return this._title;
    }

    public void setTitle(String title) {
        if (title == null) {
            title = "";
        }
        if (!this._title.equals(title)) {
            this._title = title;
            if (this._desktop != null) {
                Execution exec = this.getExecution();
                if (this._title.length() > 0) {
                    this._title = (String)exec.evaluate(this, this._title, String.class);
                    if (this._title == null) {
                        this._title = "";
                    }
                }
                if (exec.isAsyncUpdate(this)) {
                    this.getUiEngine().addResponse("setTitle", new AuSetTitle(this._title));
                }
            }
        }
    }

    public String getStyle() {
        return this._style;
    }

    public void setStyle(String style) {
        if (style == null) {
            style = "";
        }
        if (!this._style.equals(style)) {
            this._style = style;
            if (this._desktop != null) {
                Execution exec = this.getExecution();
                if (this._style.length() > 0) {
                    this._style = (String)exec.evaluate(this, this._style, String.class);
                    if (this._style == null) {
                        this._style = "";
                    }
                }
            }
        }
    }

    public Collection getRoots() {
        return this._roRoots;
    }

    public Map getAttributes(int scope) {
        switch (scope) {
            case 3: {
                return this._desktop != null ? this._desktop.getAttributes() : Collections.EMPTY_MAP;
            }
            case 4: {
                return this._desktop != null ? this._desktop.getSession().getAttributes() : Collections.EMPTY_MAP;
            }
            case 5: {
                return this._desktop != null ? this._desktop.getWebApp().getAttributes() : Collections.EMPTY_MAP;
            }
            case 2: {
                return this._attrs;
            }
            case 6: {
                Execution exec = this.getExecution();
                if (exec == null) break;
                return exec.getAttributes();
            }
        }
        return Collections.EMPTY_MAP;
    }

    public Object getAttribute(String name, int scope) {
        return this.getAttributes(scope).get(name);
    }

    public Object setAttribute(String name, Object value, int scope) {
        if (value != null) {
            Map attrs = this.getAttributes(scope);
            if (attrs == Collections.EMPTY_MAP) {
                throw new IllegalStateException("This component doesn't belong to any ID space: " + this);
            }
            return attrs.put(name, value);
        }
        return this.removeAttribute(name, scope);
    }

    public Object removeAttribute(String name, int scope) {
        Map attrs = this.getAttributes(scope);
        if (attrs == Collections.EMPTY_MAP) {
            throw new IllegalStateException("This component doesn't belong to any ID space: " + this);
        }
        return attrs.remove(name);
    }

    public Map getAttributes() {
        return this._attrs;
    }

    public Object getAttribute(String name) {
        return this._attrs.get(name);
    }

    public Object setAttribute(String name, Object value) {
        return value != null ? this._attrs.put(name, value) : this.removeAttribute(name);
    }

    public Object removeAttribute(String name) {
        return this._attrs.remove(name);
    }

    public void invalidate() {
        this.getUiEngine().addInvalidate(this);
    }

    public void removeComponents() {
        Iterator it = new ArrayList(this.getRoots()).iterator();
        while (it.hasNext()) {
            ((Component)it.next()).detach();
        }
    }

    public Class resolveClass(String clsnm) throws ClassNotFoundException {
        try {
            return Classes.forNameByThread((String)clsnm);
        }
        catch (ClassNotFoundException ex) {
            Iterator it = this.getLoadedInterpreters().iterator();
            while (it.hasNext()) {
                Class c = ((Interpreter)it.next()).getClass(clsnm);
                if (c == null) continue;
                return c;
            }
            throw ex;
        }
    }

    public void setVariable(String name, Object val) {
        this._ns.setVariable(name, val, true);
    }

    public boolean containsVariable(String name) {
        return this._ns.containsVariable(name, true);
    }

    public Object getVariable(String name) {
        return this._ns.getVariable(name, true);
    }

    public void unsetVariable(String name) {
        this._ns.unsetVariable(name, true);
    }

    public Class getZScriptClass(String clsnm) {
        Iterator it = this.getLoadedInterpreters().iterator();
        while (it.hasNext()) {
            Class cls = ((Interpreter)it.next()).getClass(clsnm);
            if (cls == null) continue;
            return cls;
        }
        try {
            return Classes.forNameByThread((String)clsnm);
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
    }

    public Function getZScriptFunction(String name, Class[] argTypes) {
        Iterator it = this.getLoadedInterpreters().iterator();
        while (it.hasNext()) {
            Function mtd = ((Interpreter)it.next()).getFunction(name, argTypes);
            if (mtd == null) continue;
            return mtd;
        }
        return null;
    }

    public Function getZScriptFunction(Namespace ns, String name, Class[] argTypes) {
        Iterator it = this.getLoadedInterpreters().iterator();
        while (it.hasNext()) {
            Object ip = it.next();
            Function mtd = ip instanceof HierachicalAware ? ((HierachicalAware)ip).getFunction(ns, name, argTypes) : ((Interpreter)ip).getFunction(name, argTypes);
            if (mtd == null) continue;
            return mtd;
        }
        return null;
    }

    public Function getZScriptFunction(Component comp, String name, Class[] argTypes) {
        return this.getZScriptFunction(comp != null ? comp.getNamespace() : null, name, argTypes);
    }

    public Method getZScriptMethod(String name, Class[] argTypes) {
        Function fun = this.getZScriptFunction(name, argTypes);
        return fun != null ? new FuncMethod(fun) : null;
    }

    public Method getZScriptMethod(Namespace ns, String name, Class[] argTypes) {
        Function fun = this.getZScriptFunction(ns, name, argTypes);
        return fun != null ? new FuncMethod(fun) : null;
    }

    public Object getZScriptVariable(String name) {
        Iterator it = this.getLoadedInterpreters().iterator();
        while (it.hasNext()) {
            Object val = ((Interpreter)it.next()).getVariable(name);
            if (val == null) continue;
            return val;
        }
        return null;
    }

    public Object getZScriptVariable(Namespace ns, String name) {
        Iterator it = this.getLoadedInterpreters().iterator();
        while (it.hasNext()) {
            Object ip = it.next();
            Object val = ip instanceof HierachicalAware ? ((HierachicalAware)ip).getVariable(ns, name) : ((Interpreter)ip).getVariable(name);
            if (val == null) continue;
            return val;
        }
        return null;
    }

    public Object getZScriptVariable(Component comp, String name) {
        return this.getZScriptVariable(comp != null ? comp.getNamespace() : null, name);
    }

    public Object getXelVariable(String name) {
        VariableResolver resolv = this.getExecution().getVariableResolver();
        return resolv != null ? resolv.resolveVariable(name) : null;
    }

    public Object getELVariable(String name) {
        return this.getXelVariable(name);
    }

    private Object resolveVariable(String name) {
        if (this._resolvers != null) {
            Iterator it = this._resolvers.iterator();
            while (it.hasNext()) {
                Object o = ((VariableResolver)it.next()).resolveVariable(name);
                if (o == null) continue;
                return o;
            }
        }
        return null;
    }

    public boolean addVariableResolver(VariableResolver resolver) {
        if (resolver == null) {
            throw new IllegalArgumentException("null");
        }
        if (this._resolvers == null) {
            this._resolvers = new LinkedList();
        } else if (this._resolvers.contains(resolver)) {
            return false;
        }
        this._resolvers.add(0, resolver);
        return true;
    }

    public boolean removeVariableResolver(VariableResolver resolver) {
        return this._resolvers != null && this._resolvers.remove(resolver);
    }

    public boolean addEventListener(String evtnm, EventListener listener) {
        LinkedList<EventListener> l;
        if (evtnm == null || listener == null) {
            throw new IllegalArgumentException("null");
        }
        if (!Events.isValid(evtnm)) {
            throw new IllegalArgumentException("Invalid event name: " + evtnm);
        }
        if (this._listeners == null) {
            this._listeners = new HashMap(3);
        }
        if ((l = (LinkedList<EventListener>)this._listeners.get(evtnm)) != null) {
            Iterator it = l.iterator();
            while (it.hasNext()) {
                EventListener li = (EventListener)it.next();
                if (!listener.equals(li)) continue;
                return false;
            }
        } else {
            l = new LinkedList<EventListener>();
            this._listeners.put(evtnm, l);
        }
        l.add(listener);
        return true;
    }

    public boolean removeEventListener(String evtnm, EventListener listener) {
        List l;
        if (evtnm == null || listener == null) {
            throw new NullPointerException();
        }
        if (this._listeners != null && (l = (List)this._listeners.get(evtnm)) != null) {
            Iterator it = l.iterator();
            while (it.hasNext()) {
                EventListener li = (EventListener)it.next();
                if (!listener.equals(li)) continue;
                if (l.size() == 1) {
                    this._listeners.remove(evtnm);
                } else {
                    it.remove();
                }
                return true;
            }
        }
        return false;
    }

    public Component getFellow(String compId) {
        Component comp = (Component)this._fellows.get(compId);
        if (comp == null) {
            if (compId != null && ComponentsCtrl.isAutoId(compId)) {
                throw new ComponentNotFoundException(MZk.AUTO_ID_NOT_LOCATABLE, compId);
            }
            throw new ComponentNotFoundException("Fellow component not found: " + compId);
        }
        return comp;
    }

    public Component getFellowIfAny(String compId) {
        return (Component)this._fellows.get(compId);
    }

    public void init(PageConfig config) {
        Boolean b;
        String id;
        if (this._desktop != null) {
            throw new IllegalStateException("Don't init twice");
        }
        Execution exec = Executions.getCurrent();
        this._desktop = exec.getDesktop();
        if (this._desktop == null) {
            throw new IllegalArgumentException("null desktop");
        }
        this.initVariables();
        if (((ExecutionCtrl)((Object)exec)).isRecovering()) {
            String uuid = config.getUuid();
            id = config.getId();
            if (uuid == null || id == null) {
                throw new IllegalArgumentException("both id and uuid are required in recovering");
            }
            this._uuid = uuid;
            this._id = id;
        } else {
            IdGenerator idgen = ((WebAppCtrl)((Object)this._desktop.getWebApp())).getIdGenerator();
            if (idgen != null) {
                this._uuid = idgen.nextPageUuid(this);
            }
            if (this._uuid == null) {
                this._uuid = ((DesktopCtrl)((Object)this._desktop)).getNextUuid();
            }
            if (this._id == null && (id = config.getId()) != null && id.length() != 0) {
                this._id = id;
            }
            if (this._id != null) {
                this._id = (String)exec.evaluate(this, this._id, String.class);
            }
            if (this._id != null && this._id.length() != 0) {
                String INVALID = ".&\\%";
                if (Strings.anyOf((String)this._id, (String)".&\\%", (int)0) < this._id.length()) {
                    throw new IllegalArgumentException("Invalid page ID: " + this._id + ". Invalid characters: " + ".&\\%");
                }
            } else {
                this._id = this._uuid;
            }
        }
        String s = config.getHeaders();
        if (s != null) {
            this._headers = s;
        }
        if ((s = config.getRootAttributes()) != null) {
            this._rootAttrs = s;
        }
        if ((s = config.getContentType()) != null) {
            this._contentType = s;
        }
        if ((s = config.getDocType()) != null) {
            this._docType = s;
        }
        if ((s = config.getFirstLine()) != null) {
            this._firstLine = s;
        }
        if ((b = config.getCacheable()) != null) {
            this._cacheable = b;
        }
        if (this._title.length() == 0 && (s = config.getTitle()) != null) {
            this.setTitle(s);
        }
        if (this._style.length() == 0 && (s = config.getStyle()) != null) {
            this.setStyle(s);
        }
        ((DesktopCtrl)((Object)this._desktop)).addPage(this);
    }

    private void initVariables() {
        this.setVariable("log", _zklog);
        this.setVariable("page", this);
        this.setVariable("pageScope", this.getAttributes());
        this.setVariable("requestScope", REQUEST_ATTRS);
        this.setVariable("spaceOwner", this);
        if (this._desktop != null) {
            this.setVariable("desktop", this._desktop);
            this.setVariable("desktopScope", this._desktop.getAttributes());
            WebApp wapp = this._desktop.getWebApp();
            this.setVariable("application", wapp);
            this.setVariable("applicationScope", wapp.getAttributes());
            Session sess = this._desktop.getSession();
            this.setVariable("session", sess);
            this.setVariable("sessionScope", sess.getAttributes());
        }
    }

    public void destroy() {
        Iterator it = this.getLoadedInterpreters().iterator();
        while (it.hasNext()) {
            Interpreter ip = (Interpreter)it.next();
            try {
                ip.destroy();
            }
            catch (Throwable ex) {
                log.error("Failed to destroy " + ip, ex);
            }
        }
        this._ips.clear();
        this._roots.clear();
        this._desktop = null;
        this._defparent = null;
        this._owner = null;
        this._ips = null;
        this._fellows = null;
        this._attrs = null;
        this._listeners = null;
        this._ns = null;
        this._resolvers = null;
    }

    public String getHeaders() {
        return this._headers;
    }

    public String getRootAttributes() {
        return this._rootAttrs;
    }

    public void setRootAttributes(String rootAttrs) {
        this._rootAttrs = rootAttrs;
    }

    public String getContentType() {
        return this._contentType;
    }

    public void setContentType(String contentType) {
        this._contentType = contentType;
    }

    public String getDocType() {
        return this._docType;
    }

    public void setDocType(String docType) {
        this._docType = docType;
    }

    public String getFirstLine() {
        return this._firstLine;
    }

    public void setFirstLine(String firstLine) {
        this._firstLine = firstLine;
    }

    public Boolean getCacheable() {
        return this._cacheable;
    }

    public void setCacheable(Boolean cacheable) {
        this._cacheable = cacheable;
    }

    public final Desktop getDesktop() {
        return this._desktop;
    }

    public void addRoot(Component comp) {
        if (!$assertionsDisabled && comp.getParent() != null) {
            throw new AssertionError();
        }
        Iterator it = this._roots.iterator();
        while (it.hasNext()) {
            if (comp != it.next()) continue;
            return;
        }
        this._roots.add(comp);
    }

    public void removeRoot(Component comp) {
        Iterator it = this._roots.iterator();
        while (it.hasNext()) {
            if (comp != it.next()) continue;
            it.remove();
            return;
        }
    }

    public void moveRoot(Component comp, Component refRoot) {
        if (comp.getPage() != this || comp.getParent() != null) {
            return;
        }
        boolean added = false;
        boolean found = false;
        ListIterator<Component> it = this._roots.listIterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (o == comp) {
                if (!added) {
                    if (!it.hasNext()) {
                        return;
                    }
                    if (it.next() == refRoot) {
                        return;
                    }
                    it.previous();
                    it.previous();
                    it.next();
                }
                it.remove();
                found = true;
                if (!added && refRoot != null) continue;
                break;
            }
            if (o != refRoot) continue;
            it.previous();
            it.add(comp);
            it.next();
            added = true;
            if (!found) continue;
            break;
        }
        if (!added) {
            this._roots.add(comp);
        }
    }

    public void addFellow(Component comp) {
        String compId = comp.getId();
        if (!$assertionsDisabled && ComponentsCtrl.isAutoId(compId)) {
            throw new AssertionError();
        }
        Component old = this._fellows.put(compId, comp);
        if (old != comp && old != null) {
            this._fellows.put(old.getId(), old);
            throw new InternalError("Called shall prevent replicated ID for roots");
        }
    }

    public void removeFellow(Component comp) {
        this._fellows.remove(comp.getId());
    }

    public boolean hasFellow(String compId) {
        return this._fellows.containsKey(compId);
    }

    public void redraw(Collection responses, Writer out) throws IOException {
        Execution exec;
        ExecutionCtrl execCtrl;
        boolean asyncUpdate;
        if (log.debugable()) {
            log.debug("Redrawing page: " + this + ", roots=" + this._roots);
        }
        boolean bIncluded = (asyncUpdate = (execCtrl = (ExecutionCtrl)((Object)(exec = this.getExecution()))).getVisualizer().isEverAsyncUpdate()) || exec.isIncluded() || exec.getAttribute("org.zkoss.zk.ui.redrawByInclude") != null;
        String uri = (String)(bIncluded ? this._pgURI : this._dkURI).getValue(this._langdef.getEvaluator(), this);
        HashMap<String, Object> attrs = new HashMap<String, Object>(6);
        attrs.put("page", this);
        attrs.put("asyncUpdate", asyncUpdate);
        attrs.put("action", this._desktop.getUpdateURI(null));
        attrs.put("responses", responses != null ? responses : Collections.EMPTY_LIST);
        if (bIncluded) {
            exec.include(out, uri, attrs, 3);
        } else {
            boolean cacheable;
            boolean bl = cacheable = this._cacheable != null ? this._cacheable.booleanValue() : this._desktop.getDevice().isCacheable();
            if (!cacheable) {
                execCtrl.setHeader("Pragma", "no-cache");
                execCtrl.addHeader("Cache-Control", "no-cache");
                execCtrl.addHeader("Cache-Control", "no-store");
                execCtrl.setHeader("Expires", "-1");
                exec.setAttribute("zk_desktop_no_cache", Boolean.TRUE);
            }
            exec.forward(out, uri, attrs, 3);
        }
    }

    public final Namespace getNamespace() {
        return this._ns;
    }

    public void interpret(String zslang, String script, Namespace ns) {
        this.getInterpreter(zslang).interpret(script, ns);
    }

    public Interpreter getInterpreter(String zslang) {
        Interpreter ip = (Interpreter)this._ips.get(zslang = (zslang != null ? zslang : this._zslang).toLowerCase());
        if (ip == null) {
            ip = Interpreters.newInterpreter(zslang, this);
            this._ips.put(zslang, ip);
            String script = this._langdef.getInitScript(zslang);
            if (script != null) {
                this._ns.setVariable("log", _zklog, true);
                this._ns.setVariable("page", this, true);
                ip.interpret(script, this._ns);
            }
            try {
                this.evalDeferredZScripts(ip, zslang);
            }
            catch (IOException ex) {
                throw new UiException(ex);
            }
        }
        return ip;
    }

    public Collection getLoadedInterpreters() {
        return this._ips != null ? this._ips.values() : Collections.EMPTY_LIST;
    }

    public String getZScriptLanguage() {
        return this._zslang;
    }

    public void setZScriptLanguage(String zslang) throws InterpreterNotFoundException {
        if (!Objects.equals((Object)zslang, (Object)this._zslang)) {
            if (!Interpreters.exists(zslang)) {
                throw new InterpreterNotFoundException(zslang, MZk.NOT_FOUND, zslang);
            }
            this._zslang = zslang;
        }
    }

    public void addDeferredZScript(Component parent, ZScript zscript) {
        if (zscript != null) {
            if (this._zsDeferred == null) {
                this._zsDeferred = new LinkedList();
            }
            this._zsDeferred.add(new Object[]{parent, zscript});
        }
    }

    private void evalDeferredZScripts(Interpreter ip, String zslang) throws IOException {
        if (this._zsDeferred != null) {
            Iterator it = this._zsDeferred.iterator();
            while (it.hasNext()) {
                Object[] zsInfo = (Object[])it.next();
                ZScript zscript = (ZScript)zsInfo[1];
                String targetlang = zscript.getLanguage();
                if (targetlang == null) {
                    targetlang = this._zslang;
                }
                if (!targetlang.equalsIgnoreCase(zslang)) continue;
                it.remove();
                Component parent = (Component)zsInfo[0];
                if (parent != null && parent.getPage() != this || !this.isEffective(zscript, parent)) continue;
                ip.interpret(zscript.getContent(this, parent), parent != null ? parent.getNamespace() : this._ns);
            }
            if (this._zsDeferred.isEmpty()) {
                this._zsDeferred = null;
            }
        }
    }

    private boolean isEffective(Condition cond, Component comp) {
        return comp != null ? cond.isEffective(comp) : cond.isEffective(this);
    }

    public boolean isListenerAvailable(String evtnm) {
        if (this._listeners != null) {
            List l = (List)this._listeners.get(evtnm);
            return l != null && !l.isEmpty();
        }
        return false;
    }

    public Iterator getListenerIterator(String evtnm) {
        List l;
        if (this._listeners != null && (l = (List)this._listeners.get(evtnm)) != null) {
            return new ListenerIterator(l);
        }
        return CollectionsX.EMPTY_ITERATOR;
    }

    public final Component getOwner() {
        return this._owner;
    }

    public final void setOwner(Component comp) {
        if (this._owner != null) {
            throw new IllegalStateException("owner can be set only once");
        }
        this._owner = comp;
    }

    public Component getDefaultParent() {
        return this._defparent;
    }

    public void setDefaultParent(Component comp) {
        this._defparent = comp;
    }

    public void sessionWillPassivate(Desktop desktop) {
        Iterator it = this._roots.iterator();
        while (it.hasNext()) {
            ((ComponentCtrl)it.next()).sessionWillPassivate(this);
        }
    }

    public void sessionDidActivate(Desktop desktop) {
        this._desktop = desktop;
        if (this._ownerUuid != null) {
            this._owner = this._desktop.getComponentByUuid(this._ownerUuid);
            this._ownerUuid = null;
        }
        Iterator it = this._roots.iterator();
        while (it.hasNext()) {
            ((ComponentCtrl)it.next()).sessionDidActivate(this);
        }
        this.initVariables();
    }

    public LanguageDefinition getLanguageDefinition() {
        return this._langdef;
    }

    public ComponentDefinitionMap getComponentDefinitionMap() {
        return this._compdefs;
    }

    public ComponentDefinition getComponentDefinition(String name, boolean recur) {
        ComponentDefinition compdef = this._compdefs.get(name);
        if (!recur || compdef != null) {
            return compdef;
        }
        try {
            return this._langdef.getComponentDefinition(name);
        }
        catch (DefinitionNotFoundException ex) {
            return null;
        }
    }

    public ComponentDefinition getComponentDefinition(Class cls, boolean recur) {
        ComponentDefinition compdef = this._compdefs.get(cls);
        if (!recur || compdef != null) {
            return compdef;
        }
        try {
            return this._langdef.getComponentDefinition(cls);
        }
        catch (DefinitionNotFoundException ex) {
            return null;
        }
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        Map.Entry me;
        Iterator it;
        s.defaultWriteObject();
        s.writeObject(this._langdef != null ? this._langdef.getName() : null);
        s.writeObject(this._owner != null ? this._owner.getUuid() : null);
        s.writeObject(this._defparent != null ? this._defparent.getUuid() : null);
        this.willSerialize(this._attrs.values());
        Serializables.smartWrite((ObjectOutputStream)s, (Map)this._attrs);
        if (this._listeners != null) {
            it = this._listeners.entrySet().iterator();
            while (it.hasNext()) {
                me = it.next();
                s.writeObject(me.getKey());
                Collection ls = (Collection)me.getValue();
                this.willSerialize(ls);
                Serializables.smartWrite((ObjectOutputStream)s, (Collection)ls);
            }
        }
        s.writeObject(null);
        this.willSerialize(this._resolvers);
        Serializables.smartWrite((ObjectOutputStream)s, (Collection)this._resolvers);
        it = this._ns._vars.entrySet().iterator();
        while (it.hasNext()) {
            me = it.next();
            String nm = (String)me.getKey();
            Object val = me.getValue();
            this.willSerialize(val);
            if (!PageImpl.isVariableSerializable(nm, val) || !(val instanceof Serializable) && !(val instanceof Externalizable)) continue;
            s.writeObject(nm);
            s.writeObject(val);
        }
        s.writeObject(null);
        it = this._ips.entrySet().iterator();
        while (it.hasNext()) {
            me = it.next();
            Object ip = me.getValue();
            if (!(ip instanceof SerializableAware)) continue;
            s.writeObject((String)me.getKey());
            ((SerializableAware)ip).write(s, new SerializableAware.Filter(){

                public boolean accept(String name, Object value) {
                    return PageImpl.isVariableSerializable(name, value);
                }
            });
        }
        s.writeObject(null);
    }

    private void willSerialize(Collection c) {
        if (c != null) {
            Iterator it = c.iterator();
            while (it.hasNext()) {
                this.willSerialize(it.next());
            }
        }
    }

    private void willSerialize(Object o) {
        if (o instanceof PageSerializationListener) {
            ((PageSerializationListener)o).willSerialize(this);
        }
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        String zslang;
        String nm;
        String evtnm;
        s.defaultReadObject();
        this.init();
        String langnm = (String)s.readObject();
        if (langnm != null) {
            this._langdef = LanguageDefinition.lookup(langnm);
        }
        this._ownerUuid = (String)s.readObject();
        String pid = (String)s.readObject();
        if (pid != null) {
            this._defparent = PageImpl.fixDefaultParent(this._roots, pid);
        }
        Serializables.smartRead((ObjectInputStream)s, (Map)this._attrs);
        this.didDeserialize(this._attrs.values());
        while ((evtnm = (String)s.readObject()) != null) {
            if (this._listeners == null) {
                this._listeners = new HashMap();
            }
            Collection ls = Serializables.smartRead((ObjectInputStream)s, (Collection)null);
            this._listeners.put(evtnm, ls);
            this.didDeserialize(ls);
        }
        this._resolvers = (List)Serializables.smartRead((ObjectInputStream)s, (Collection)this._resolvers);
        this.didDeserialize(this._resolvers);
        this.initVariables();
        while ((nm = (String)s.readObject()) != null) {
            Object val = s.readObject();
            this._ns.setVariable(nm, val, true);
            this.didDeserialize(val);
        }
        this.fixFellows(this._roots);
        while ((zslang = (String)s.readObject()) != null) {
            ((SerializableAware)((Object)this.getInterpreter(zslang))).read(s);
        }
    }

    private void didDeserialize(Collection c) {
        if (c != null) {
            Iterator it = c.iterator();
            while (it.hasNext()) {
                this.didDeserialize(it.next());
            }
        }
    }

    private void didDeserialize(Object o) {
        if (o instanceof PageSerializationListener) {
            ((PageSerializationListener)o).didDeserialize(this);
        }
    }

    private static boolean isVariableSerializable(String name, Object value) {
        return !_nonSerNames.contains(name) && !(value instanceof Component);
    }

    private final void fixFellows(Collection c) {
        Iterator it = c.iterator();
        while (it.hasNext()) {
            Component comp = (Component)it.next();
            String compId = comp.getId();
            if (!ComponentsCtrl.isAutoId(compId)) {
                this.addFellow(comp);
            }
            if (comp instanceof IdSpace) continue;
            this.fixFellows(comp.getChildren());
        }
    }

    private static final Component fixDefaultParent(Collection c, String uuid) {
        Iterator it = c.iterator();
        while (it.hasNext()) {
            Component comp = (Component)it.next();
            if (uuid.equals(comp.getUuid())) {
                return comp;
            }
            if ((comp = PageImpl.fixDefaultParent(comp.getChildren(), uuid)) == null) continue;
            return comp;
        }
        return null;
    }

    public String toString() {
        return "[Page " + this._id + ']';
    }

    static {
        $assertionsDisabled = !PageImpl.class.desiredAssertionStatus();
        log = Log.lookup((Class)PageImpl.class);
        _zklog = Log.lookup((String)"org.zkoss.zk.log");
        REQUEST_ATTRS = new AbstractMap(){

            public Set entrySet() {
                Execution exec = Executions.getCurrent();
                if (exec == null) {
                    return Collections.EMPTY_SET;
                }
                return exec.getAttributes().entrySet();
            }

            public Object put(Object name, Object value) {
                Execution exec = Executions.getCurrent();
                if (exec == null) {
                    throw new IllegalStateException("No execution at all");
                }
                return exec.getAttributes().put(name, value);
            }

            public boolean containsKey(Object name) {
                Execution exec = Executions.getCurrent();
                return exec != null && exec.getAttributes().containsKey(name);
            }

            public Object get(Object name) {
                Execution exec = Executions.getCurrent();
                if (exec == null) {
                    return null;
                }
                return exec.getAttributes().get(name);
            }

            public Object remove(Object name) {
                Execution exec = Executions.getCurrent();
                if (exec == null) {
                    return null;
                }
                return exec.getAttributes().remove(name);
            }
        };
        _nonSerNames = new HashSet();
        String[] nms = new String[]{"log", "page", "desktop", "pageScope", "desktopScope", "applicationScope", "requestScope", "spaceOwner", "session", "sessionScope"};
        for (int j = 0; j < nms.length; ++j) {
            _nonSerNames.add(nms[j]);
        }
    }

    private class NS
    extends AbstractNamespace {
        private final Map _vars = new HashMap();

        private NS() {
        }

        public Component getOwner() {
            return null;
        }

        public Page getOwnerPage() {
            return PageImpl.this;
        }

        public Set getVariableNames() {
            return this._vars.keySet();
        }

        public boolean containsVariable(String name, boolean local) {
            return this._vars.containsKey(name) || PageImpl.this._fellows.containsKey(name) || PageImpl.this.resolveVariable(name) != null;
        }

        public Object getVariable(String name, boolean local) {
            Object val = this._vars.get(name);
            if (val != null || this._vars.containsKey(name)) {
                return val;
            }
            val = PageImpl.this._fellows.get(name);
            return val != null ? val : PageImpl.this.resolveVariable(name);
        }

        public void setVariable(String name, Object value, boolean local) {
            this._vars.put(name, value);
            this.notifyAdd(name, value);
        }

        public void unsetVariable(String name, boolean local) {
            this._vars.remove(name);
            this.notifyRemove(name);
        }

        public Namespace getParent() {
            return null;
        }

        public void setParent(Namespace parent) {
            throw new UnsupportedOperationException();
        }
    }
}

