/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.zkoss.lang.Objects;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.Command;
import org.zkoss.zk.ui.sys.RequestQueue;

public class RequestQueueImpl
implements RequestQueue {
    private final List _requests = new LinkedList();
    private List _reqIds;
    private boolean _process;

    public void addRequestId(String requestId) {
        if (this._reqIds == null) {
            this._reqIds = new LinkedList();
        }
        this._reqIds.add(requestId);
    }

    public Collection clearRequestIds() {
        List old = this._reqIds;
        this._reqIds = null;
        return old;
    }

    public synchronized boolean endWithRequest() {
        this._process = false;
        return !this._requests.isEmpty();
    }

    public synchronized AuRequest nextRequest() {
        if (this._requests.isEmpty()) {
            this._process = false;
            return null;
        }
        return (AuRequest)this._requests.remove(0);
    }

    public synchronized void setInProcess() {
        this._process = true;
    }

    public synchronized boolean addRequests(Collection requests) {
        Iterator it = requests.iterator();
        while (it.hasNext()) {
            this.addRequest((AuRequest)it.next());
        }
        return this._process;
    }

    private void addRequest(AuRequest request) {
        int last;
        AuRequest req2;
        Command cmd;
        int flags;
        int last2 = this._requests.size() - 1;
        if (last2 < 0) {
            this._requests.add(request);
            return;
        }
        AuRequest req22 = (AuRequest)this._requests.get(last2);
        if ((req22.getCommand().getFlags() & 2) != 0) {
            this._requests.remove(last2);
            if (last2 == 0) {
                this._requests.add(request);
                return;
            }
        }
        if (((flags = (cmd = request.getCommand()).getFlags()) & 8) != 0) {
            String uuid = request.getComponentUuid();
            Iterator it = this._requests.iterator();
            while (it.hasNext()) {
                AuRequest req23 = (AuRequest)it.next();
                if (req23.getCommand() != cmd || !Objects.equals((Object)req23.getComponentUuid(), (Object)uuid)) continue;
                it.remove();
                break;
            }
        } else if ((flags & 0x10) != 0 && (req2 = (AuRequest)this._requests.get(last = this._requests.size() - 1)).getCommand() == cmd && Objects.equals((Object)req2.getComponentUuid(), (Object)request.getComponentUuid())) {
            this._requests.remove(last);
        }
        this._requests.add(request);
    }
}

