/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import org.zkoss.util.CacheMap;
import org.zkoss.util.logging.Log;
import org.zkoss.zk.ui.ComponentNotFoundException;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.sys.DesktopCache;
import org.zkoss.zk.ui.sys.DesktopCtrl;
import org.zkoss.zk.ui.sys.WebAppCtrl;
import org.zkoss.zk.ui.util.Configuration;
import org.zkoss.zk.ui.util.Monitor;

public class SimpleDesktopCache
implements DesktopCache,
Serializable {
    private static final Log log = Log.lookup((Class)SimpleDesktopCache.class);
    private static final long serialVersionUID = 20060622L;
    private final Cache _desktops;
    private int _nextKey = (int)System.currentTimeMillis() & 0xFFFF;

    public SimpleDesktopCache(Configuration config) {
        this._desktops = new Cache(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNextKey() {
        SimpleDesktopCache simpleDesktopCache = this;
        synchronized (simpleDesktopCache) {
            return this._nextKey++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Desktop getDesktopIfAny(String desktopId) {
        Cache cache = this._desktops;
        synchronized (cache) {
            return (Desktop)this._desktops.get(desktopId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Desktop getDesktop(String desktopId) {
        Desktop desktop;
        Cache cache = this._desktops;
        synchronized (cache) {
            desktop = (Desktop)this._desktops.get(desktopId);
        }
        if (desktop == null) {
            throw new ComponentNotFoundException("Desktop not found: " + desktopId);
        }
        return desktop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDesktop(Desktop desktop) {
        Object old;
        Cache cache = this._desktops;
        synchronized (cache) {
            old = this._desktops.put(desktop.getId(), desktop);
        }
        if (old != null) {
            this._desktops.put(((Desktop)old).getId(), old);
            log.warning(desktop == old ? "Register a desktop twice: " + desktop : "Replicated ID: " + desktop + "; already used by " + old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDesktop(Desktop desktop) {
        Object old;
        Cache cache = this._desktops;
        synchronized (cache) {
            old = this._desktops.remove(desktop.getId());
        }
        if (old == null) {
            log.warning("Removing non-existent desktop: " + desktop);
        }
        SimpleDesktopCache.desktopDestroyed(desktop);
    }

    private static void desktopDestroyed(Desktop desktop) {
        WebApp wapp = desktop.getWebApp();
        wapp.getConfiguration().invokeDesktopCleanups(desktop);
        ((WebAppCtrl)((Object)wapp)).getUiEngine().desktopDestroyed(desktop);
        Monitor monitor = desktop.getWebApp().getConfiguration().getMonitor();
        if (monitor != null) {
            try {
                monitor.desktopDestroyed(desktop);
            }
            catch (Throwable ex) {
                log.error(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionWillPassivate(Session sess) {
        Cache cache = this._desktops;
        synchronized (cache) {
            Iterator it = this._desktops.values().iterator();
            while (it.hasNext()) {
                ((DesktopCtrl)it.next()).sessionWillPassivate(sess);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionDidActivate(Session sess) {
        Cache cache = this._desktops;
        synchronized (cache) {
            Iterator it = this._desktops.values().iterator();
            while (it.hasNext()) {
                ((DesktopCtrl)it.next()).sessionDidActivate(sess);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Cache cache = this._desktops;
        synchronized (cache) {
            if (log.debugable()) {
                log.debug("Invalidated and remove: " + (Object)((Object)this._desktops));
            }
            Iterator it = new ArrayList(this._desktops.values()).iterator();
            while (it.hasNext()) {
                SimpleDesktopCache.desktopDestroyed((Desktop)it.next());
            }
            this._desktops.clear();
        }
    }

    private static class Cache
    extends CacheMap {
        private Cache(Configuration config) {
            super(16);
            int v = config.getSessionMaxDesktops();
            this.setMaxSize(v >= 0 ? v : 0x1FFFFFFF);
            v = config.getDesktopMaxInactiveInterval();
            this.setLifetime(v >= 0 ? v * 1000 : 0x1FFFFFFF);
        }

        protected boolean shallExpunge() {
            return super.shallExpunge() || this.sizeWithoutExpunge() > this.getMaxSize() << 2;
        }

        protected int canExpunge(CacheMap.Value v) {
            if (((Desktop)v.getValue()).getExecution() != null) {
                return 0;
            }
            return super.canExpunge(v);
        }

        protected void onExpunge(CacheMap.Value v) {
            super.onExpunge(v);
            SimpleDesktopCache.desktopDestroyed((Desktop)v.getValue());
            if (log.debugable()) {
                log.debug("Expunge desktop: " + v.getValue());
            }
        }
    }
}

