/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.impl;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Exceptions;
import org.zkoss.lang.Expectable;
import org.zkoss.util.logging.Log;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.AuWriter;
import org.zkoss.zk.au.out.AuAlert;
import org.zkoss.zk.au.out.AuEcho;
import org.zkoss.zk.au.out.AuWrongValue;
import org.zkoss.zk.mesg.MZk;
import org.zkoss.zk.scripting.Namespace;
import org.zkoss.zk.scripting.Namespaces;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.ComponentNotFoundException;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.Richlet;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.SuspendNotAllowedException;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.CreateEvent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.Express;
import org.zkoss.zk.ui.ext.AfterCompose;
import org.zkoss.zk.ui.ext.Native;
import org.zkoss.zk.ui.impl.AbortBySendRedirect;
import org.zkoss.zk.ui.impl.EventProcessingThreadImpl;
import org.zkoss.zk.ui.impl.EventProcessor;
import org.zkoss.zk.ui.impl.Initiators;
import org.zkoss.zk.ui.impl.UiVisualizer;
import org.zkoss.zk.ui.metainfo.AttributesInfo;
import org.zkoss.zk.ui.metainfo.ComponentDefinition;
import org.zkoss.zk.ui.metainfo.ComponentInfo;
import org.zkoss.zk.ui.metainfo.NativeInfo;
import org.zkoss.zk.ui.metainfo.NodeInfo;
import org.zkoss.zk.ui.metainfo.PageDefinition;
import org.zkoss.zk.ui.metainfo.Property;
import org.zkoss.zk.ui.metainfo.TextInfo;
import org.zkoss.zk.ui.metainfo.VariablesInfo;
import org.zkoss.zk.ui.metainfo.ZScript;
import org.zkoss.zk.ui.sys.AbortingReason;
import org.zkoss.zk.ui.sys.ComponentCtrl;
import org.zkoss.zk.ui.sys.ComponentsCtrl;
import org.zkoss.zk.ui.sys.DesktopCtrl;
import org.zkoss.zk.ui.sys.EventProcessingThread;
import org.zkoss.zk.ui.sys.ExecutionCtrl;
import org.zkoss.zk.ui.sys.ExecutionsCtrl;
import org.zkoss.zk.ui.sys.FailoverManager;
import org.zkoss.zk.ui.sys.PageConfig;
import org.zkoss.zk.ui.sys.PageCtrl;
import org.zkoss.zk.ui.sys.RequestQueue;
import org.zkoss.zk.ui.sys.SessionCtrl;
import org.zkoss.zk.ui.sys.UiEngine;
import org.zkoss.zk.ui.sys.UiFactory;
import org.zkoss.zk.ui.sys.WebAppCtrl;
import org.zkoss.zk.ui.util.ComponentCloneListener;
import org.zkoss.zk.ui.util.ComponentSerializationListener;
import org.zkoss.zk.ui.util.Composer;
import org.zkoss.zk.ui.util.ComposerExt;
import org.zkoss.zk.ui.util.Condition;
import org.zkoss.zk.ui.util.Configuration;
import org.zkoss.zk.ui.util.DeferredValue;
import org.zkoss.zk.ui.util.ForEach;
import org.zkoss.zk.ui.util.Monitor;

public class UiEngineImpl
implements UiEngine {
    private static final Log log;
    private WebApp _wapp;
    private final List _idles = new LinkedList();
    private final Map _suspended = new HashMap();
    private final Map _resumed = new HashMap();
    private int _suspCnt;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$java$lang$String;

    public void start(WebApp wapp) {
        this._wapp = wapp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(WebApp wapp) {
        Iterator<Object> i2;
        Object object;
        Iterator<Object> it;
        Object object2 = this._idles;
        synchronized (object2) {
            it = this._idles.iterator();
            while (it.hasNext()) {
                ((EventProcessingThreadImpl)it.next()).cease("Stop application");
            }
            this._idles.clear();
        }
        object2 = this._suspended;
        synchronized (object2) {
            it = this._suspended.values().iterator();
            while (it.hasNext()) {
                Map map = (Map)it.next();
                object = map;
                synchronized (object) {
                    i2 = map.values().iterator();
                    while (i2.hasNext()) {
                        List list = (List)i2.next();
                        Iterator i3 = list.iterator();
                        while (i3.hasNext()) {
                            ((EventProcessingThreadImpl)i3.next()).cease("Stop application");
                        }
                    }
                }
            }
            this._suspended.clear();
        }
        object2 = this._resumed;
        synchronized (object2) {
            it = this._resumed.values().iterator();
            while (it.hasNext()) {
                List list = (List)it.next();
                object = list;
                synchronized (object) {
                    i2 = list.iterator();
                    while (i2.hasNext()) {
                        ((EventProcessingThreadImpl)i2.next()).cease("Stop application");
                    }
                }
            }
            this._resumed.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasSuspendedThread() {
        if (!this._suspended.isEmpty()) {
            Map map = this._suspended;
            synchronized (map) {
                Iterator it = this._suspended.values().iterator();
                while (it.hasNext()) {
                    Map map2 = (Map)it.next();
                    if (map2.isEmpty()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getSuspendedThreads(Desktop desktop) {
        Map map;
        Map map2 = this._suspended;
        synchronized (map2) {
            map = (Map)this._suspended.get(desktop);
        }
        return map == null || map.isEmpty() ? Collections.EMPTY_LIST : Collections.synchronizedMap(map).values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ceaseSuspendedThread(Desktop desktop, EventProcessingThread evtthd, String cause) {
        Map map;
        Map map2 = this._suspended;
        synchronized (map2) {
            map = (Map)this._suspended.get(desktop);
        }
        if (map == null) {
            return false;
        }
        boolean found = false;
        Map map3 = map;
        synchronized (map3) {
            Iterator it = map.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry me = it.next();
                List list = (List)me.getValue();
                found = list.remove(evtthd);
                if (!found) continue;
                if (!list.isEmpty()) break;
                it.remove();
                break;
            }
        }
        if (found) {
            ((EventProcessingThreadImpl)evtthd).cease(cause);
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void desktopDestroyed(Desktop desktop) {
        List list;
        Map map;
        Configuration conf = this._wapp.getConfiguration();
        Map map2 = this._suspended;
        synchronized (map2) {
            map = (Map)this._suspended.remove(desktop);
        }
        if (map != null) {
            map2 = map;
            synchronized (map2) {
                Iterator it = map.values().iterator();
                while (it.hasNext()) {
                    List list2 = (List)it.next();
                    Iterator i2 = list2.iterator();
                    while (i2.hasNext()) {
                        EventProcessingThreadImpl evtthd = (EventProcessingThreadImpl)i2.next();
                        evtthd.ceaseSilently("Destroy desktop " + desktop);
                        conf.invokeEventThreadResumeAborts(evtthd.getComponent(), evtthd.getEvent());
                    }
                }
            }
        }
        Object object = this._resumed;
        synchronized (object) {
            list = (List)this._resumed.remove(desktop);
        }
        if (list != null) {
            object = list;
            synchronized (object) {
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    EventProcessingThreadImpl evtthd = (EventProcessingThreadImpl)it.next();
                    evtthd.ceaseSilently("Destroy desktop " + desktop);
                    conf.invokeEventThreadResumeAborts(evtthd.getComponent(), evtthd.getEvent());
                }
            }
        }
        ((DesktopCtrl)((Object)desktop)).destroy();
    }

    private static UiVisualizer getCurrentVisualizer() {
        ExecutionCtrl execCtrl = ExecutionsCtrl.getCurrentCtrl();
        if (execCtrl == null) {
            throw new IllegalStateException("Components can be accessed only in event listeners");
        }
        return (UiVisualizer)execCtrl.getVisualizer();
    }

    public void pushOwner(Component comp) {
        UiEngineImpl.getCurrentVisualizer().pushOwner(comp);
    }

    public void popOwner() {
        UiEngineImpl.getCurrentVisualizer().popOwner();
    }

    public void addInvalidate(Page page) {
        if (page == null) {
            throw new IllegalArgumentException();
        }
        UiEngineImpl.getCurrentVisualizer().addInvalidate(page);
    }

    public void addInvalidate(Component comp) {
        if (comp == null) {
            throw new IllegalArgumentException();
        }
        UiEngineImpl.getCurrentVisualizer().addInvalidate(comp);
    }

    public void addSmartUpdate(Component comp, String attr, String value) {
        if (comp == null) {
            throw new IllegalArgumentException();
        }
        UiEngineImpl.getCurrentVisualizer().addSmartUpdate(comp, attr, value);
    }

    public void addSmartUpdate(Component comp, String attr, DeferredValue value) {
        if (comp == null) {
            throw new IllegalArgumentException();
        }
        UiEngineImpl.getCurrentVisualizer().addSmartUpdate(comp, attr, value);
    }

    public void addResponse(String key, AuResponse response) {
        UiEngineImpl.getCurrentVisualizer().addResponse(key, response);
    }

    public void addMoved(Component comp, Component oldparent, Page oldpg, Page newpg) {
        if (comp == null) {
            throw new IllegalArgumentException();
        }
        UiEngineImpl.getCurrentVisualizer().addMoved(comp, oldparent, oldpg, newpg);
    }

    public void addUuidChanged(Component comp, boolean addOnlyMoved) {
        if (comp == null) {
            throw new IllegalArgumentException();
        }
        UiEngineImpl.getCurrentVisualizer().addUuidChanged(comp, addOnlyMoved);
    }

    public void execNewPage(Execution exec, Richlet richlet, Page page, Writer out) throws IOException {
        this.execNewPage0(exec, null, richlet, page, out);
    }

    public void execNewPage(Execution exec, PageDefinition pagedef, Page page, Writer out) throws IOException {
        this.execNewPage0(exec, pagedef, null, page, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void execNewPage0(Execution exec, PageDefinition pagedef, Richlet richlet, Page page, Writer out) throws IOException {
        desktop = exec.getDesktop();
        v0 = pagedef != null ? pagedef.getLanguageDefinition() : (langdef = richlet != null ? richlet.getLanguageDefinition() : null);
        if (langdef != null) {
            desktop.setDeviceType(langdef.getDeviceType());
        }
        olduv = (oldexecCtrl = (ExecutionCtrl)(oldexec = Executions.getCurrent())) != null ? (UiVisualizer)oldexecCtrl.getVisualizer() : null;
        uv = olduv != null ? UiEngineImpl.doReactivate(exec, olduv) : UiEngineImpl.doActivate(exec, null, false);
        execCtrl = (ExecutionCtrl)exec;
        old = execCtrl.getCurrentPage();
        olddef = execCtrl.getCurrentPageDefinition();
        execCtrl.setCurrentPage(page);
        execCtrl.setCurrentPageDefinition(pagedef);
        config = this._wapp.getConfiguration();
        abrn = null;
        cleaned = false;
        try {
            config.invokeExecutionInits(exec, oldexec);
            if (olduv != null && (owner = olduv.getOwner()) != null) {
                ((PageCtrl)page).setOwner(owner);
            }
            if (pagedef != null) {
                pagedef.initXelContext(page);
                inits = Initiators.doInit(pagedef, page);
                try {
                    pagedef.init(page, uv.isEverAsyncUpdate() == false && uv.isAborting() == false);
                    uri = pagedef.getForwardURI(page);
                    if (uri != null) {
                        comps = new Component[]{};
                        exec.forward(uri);
                    } else {
                        comps = uv.isAborting() != false || exec.isVoided() != false ? null : UiEngineImpl.execCreate(new CreateInfo(((WebAppCtrl)this._wapp).getUiFactory(), exec, page), pagedef, null);
                    }
                    inits.doAfterCompose(page, comps);
                }
                catch (Throwable ex) {
                    if (inits.doCatch(ex)) ** GOTO lbl40
                    throw UiException.Aide.wrap(ex);
                }
                finally {
                    inits.doFinally();
                }
            } else {
                ((PageCtrl)page).init(new PageConfig(){

                    public String getId() {
                        return null;
                    }

                    public String getUuid() {
                        return null;
                    }

                    public String getTitle() {
                        return null;
                    }

                    public String getStyle() {
                        return null;
                    }

                    public String getHeaders() {
                        return null;
                    }

                    public String getRootAttributes() {
                        return null;
                    }

                    public String getContentType() {
                        return null;
                    }

                    public String getDocType() {
                        return null;
                    }

                    public String getFirstLine() {
                        return null;
                    }

                    public Boolean getCacheable() {
                        return null;
                    }
                });
                richlet.service(page);
            }
lbl40:
            // 3 sources

            if (exec.isVoided()) {
                return;
            }
            event = UiEngineImpl.nextEvent(uv);
            while (true) {
                if (event != null) {
                    this.process(desktop, event);
                    event = UiEngineImpl.nextEvent(uv);
                    continue;
                }
                this.resumeAll(desktop, uv, null);
                event = UiEngineImpl.nextEvent(uv);
                if (event == null) break;
            }
            abrn = uv.getAbortingReason();
            if (abrn != null) {
                abrn.execute();
            }
            responses = uv.getResponses();
            if (olduv != null && olduv.addToFirstAsyncUpdate(responses)) {
                responses = null;
            }
            ((PageCtrl)page).redraw(responses, out);
        }
        catch (Throwable ex) {
            cleaned = true;
            errs = new LinkedList<Throwable>();
            errs.add(ex);
            config.invokeExecutionCleanups(exec, oldexec, errs);
            if (!errs.isEmpty()) {
                ex = (Throwable)errs.get(0);
                if (ex instanceof IOException) {
                    throw (IOException)ex;
                }
                throw UiException.Aide.wrap(ex);
            }
        }
        finally {
            if (!cleaned) {
                config.invokeExecutionCleanups(exec, oldexec, null);
            }
            if (abrn != null) {
                try {
                    abrn.finish();
                }
                catch (Throwable t) {
                    UiEngineImpl.log.warning(t);
                }
            }
            execCtrl.setCurrentPage(old);
            execCtrl.setCurrentPageDefinition(olddef);
            if (olduv != null) {
                UiEngineImpl.doDereactivate(exec, olduv);
            } else {
                UiEngineImpl.doDeactivate(exec);
            }
        }
    }

    private static final Event nextEvent(UiVisualizer uv) {
        Event evt = ((ExecutionCtrl)((Object)uv.getExecution())).getNextEvent();
        return evt != null && !uv.isAborting() ? evt : null;
    }

    private static final Component[] execCreate(CreateInfo ci, NodeInfo parentInfo, Component parent) throws IOException {
        ComponentInfo pi;
        String fulfill;
        if (parentInfo instanceof ComponentInfo && (fulfill = (pi = (ComponentInfo)parentInfo).getFulfill()) != null && fulfill.length() > 0) {
            new FulfillListener(fulfill, pi, parent);
            return new Component[0];
        }
        return UiEngineImpl.execCreate0(ci, parentInfo, parent);
    }

    private static final Component[] execCreate0(CreateInfo ci, NodeInfo parentInfo, Component parent) throws IOException {
        LinkedList<Component> created = new LinkedList<Component>();
        Page page = ci.page;
        PageDefinition pagedef = parentInfo.getPageDefinition();
        Iterator it = parentInfo.getChildren().iterator();
        while (it.hasNext()) {
            Object meta = it.next();
            if (meta instanceof ComponentInfo) {
                int j;
                Component[] children;
                ComponentInfo childInfo = (ComponentInfo)meta;
                ForEach forEach = childInfo.getForEach(page, parent);
                if (forEach == null) {
                    if (!UiEngineImpl.isEffective(childInfo, page, parent)) continue;
                    children = UiEngineImpl.execCreateChild(ci, parent, childInfo);
                    for (j = 0; j < children.length; ++j) {
                        created.add(children[j]);
                    }
                    continue;
                }
                while (forEach.next()) {
                    if (!UiEngineImpl.isEffective(childInfo, page, parent)) continue;
                    children = UiEngineImpl.execCreateChild(ci, parent, childInfo);
                    for (j = 0; j < children.length; ++j) {
                        created.add(children[j]);
                    }
                }
                continue;
            }
            if (meta instanceof TextInfo) {
                String s = ((TextInfo)meta).getValue(parent);
                if (s == null || s.length() <= 0) continue;
                parent.appendChild(((Native)((Object)parent)).getHelper().newNative(s));
                continue;
            }
            UiEngineImpl.execNonComponent(ci, parent, meta);
        }
        return created.toArray(new Component[created.size()]);
    }

    private static Component[] execCreateChild(CreateInfo ci, Component parent, ComponentInfo childInfo) throws IOException {
        Component[] componentArray;
        ComponentDefinition childdef = childInfo.getComponentDefinition();
        if (ComponentDefinition.ZK == childdef) {
            return UiEngineImpl.execCreate(ci, childInfo, parent);
        }
        if (childdef.isInlineMacro()) {
            HashMap<String, Component> props = new HashMap<String, Component>();
            props.put("includer", parent);
            childInfo.evalProperties(props, ci.page, parent, true);
            return new Component[]{ci.exec.createComponents(childdef.getMacroURI(), parent, props)};
        }
        Component child = UiEngineImpl.execCreateChild0(ci, parent, childInfo);
        if (child != null) {
            Component[] componentArray2 = new Component[1];
            componentArray = componentArray2;
            componentArray2[0] = child;
        } else {
            componentArray = new Component[]{};
        }
        return componentArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Component execCreateChild0(CreateInfo ci, Component parent, ComponentInfo childInfo) throws IOException {
        Composer composer = childInfo.getComposer(ci.page, parent);
        ComposerExt composerExt = composer instanceof ComposerExt ? (ComposerExt)((Object)composer) : null;
        Component child = null;
        try {
            if (composerExt != null && (childInfo = composerExt.doBeforeCompose(ci.page, parent, childInfo)) == null) {
                Component component = null;
                return component;
            }
            child = ci.uf.newComponent(ci.page, parent, childInfo);
            boolean bNative = childInfo instanceof NativeInfo;
            if (bNative) {
                UiEngineImpl.setProlog(ci, child, (NativeInfo)childInfo);
            }
            if (composerExt != null) {
                composerExt.doBeforeComposeChildren(child);
            }
            UiEngineImpl.execCreate(ci, childInfo, child);
            if (bNative) {
                UiEngineImpl.setEpilog(ci, child, (NativeInfo)childInfo);
            }
            if (child instanceof AfterCompose) {
                ((AfterCompose)((Object)child)).afterCompose();
            }
            if (composer != null) {
                composer.doAfterCompose(child);
            }
            ComponentsCtrl.applyForward(child, childInfo.getForward());
            if (Events.isListened(child, "onCreate", false)) {
                Events.postEvent(new CreateEvent("onCreate", child, ci.exec.getArg()));
            }
            Component ex = child;
            return ex;
        }
        catch (Throwable ex) {
            boolean ignore = false;
            if (composerExt != null) {
                try {
                    ignore = composerExt.doCatch(ex);
                }
                catch (Throwable t) {
                    log.error("Failed to invoke doCatch for " + childInfo, t);
                }
            }
            if (!ignore) {
                throw UiException.Aide.wrap(ex);
            }
            Component component = child != null && child.getPage() != null ? child : null;
            return component;
        }
        finally {
            if (composerExt != null) {
                try {
                    composerExt.doFinally();
                }
                catch (Throwable ex) {
                    throw UiException.Aide.wrap(ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void execNonComponent(CreateInfo ci, Component comp, Object meta) {
        Page page = ci.page;
        if (meta instanceof ZScript) {
            ZScript zscript = (ZScript)meta;
            if (zscript.isDeferred()) {
                ((PageCtrl)((Object)page)).addDeferredZScript(comp, zscript);
            } else if (UiEngineImpl.isEffective(zscript, page, comp)) {
                HashMap backup = new HashMap();
                Namespace ns = comp != null ? Namespaces.beforeInterpret(backup, comp, false) : Namespaces.beforeInterpret(backup, page, false);
                try {
                    page.interpret(zscript.getLanguage(), zscript.getContent(page, comp), ns);
                }
                finally {
                    Namespaces.afterInterpret(backup, ns, false);
                }
            }
        } else if (meta instanceof AttributesInfo) {
            AttributesInfo attrs = (AttributesInfo)meta;
            if (comp != null) {
                attrs.apply(comp);
            } else {
                attrs.apply(page);
            }
        } else if (meta instanceof VariablesInfo) {
            VariablesInfo vars = (VariablesInfo)meta;
            if (comp != null) {
                vars.apply(comp);
            } else {
                vars.apply(page);
            }
        } else {
            throw new IllegalStateException("Unknown metainfo: " + meta);
        }
    }

    private static final boolean isEffective(Condition cond, Page page, Component comp) {
        return comp != null ? cond.isEffective(comp) : cond.isEffective(page);
    }

    public Component[] createComponents(Execution exec, PageDefinition pagedef, Page page, Component parent, Map arg) {
        ExecutionCtrl execCtrl;
        if (pagedef == null) {
            throw new IllegalArgumentException("pagedef");
        }
        if (parent != null) {
            if (parent.getPage() != null) {
                page = parent.getPage();
            }
        } else if (page != null) {
            parent = ((PageCtrl)((Object)page)).getDefaultParent();
        }
        if (page == null) {
            page = UiEngineImpl.getCurrentPage(exec);
        }
        if (!(execCtrl = (ExecutionCtrl)((Object)exec)).isActivated()) {
            throw new IllegalStateException("Not activated yet");
        }
        Page old = execCtrl.getCurrentPage();
        PageDefinition olddef = execCtrl.getCurrentPageDefinition();
        if (page != null && page != old) {
            execCtrl.setCurrentPage(page);
        }
        execCtrl.setCurrentPageDefinition(pagedef);
        exec.pushArg(arg != null ? arg : Collections.EMPTY_MAP);
        if (page != null) {
            pagedef.initXelContext(page);
        }
        Initiators inits = Initiators.doInit(pagedef, page);
        try {
            Component[] comps = UiEngineImpl.execCreate(new CreateInfo(((WebAppCtrl)((Object)exec.getDesktop().getWebApp())).getUiFactory(), exec, page), pagedef, parent);
            inits.doAfterCompose(page, comps);
            Component[] componentArray = comps;
            return componentArray;
        }
        catch (Throwable ex) {
            inits.doCatch(ex);
            throw UiException.Aide.wrap(ex);
        }
        finally {
            exec.popArg();
            execCtrl.setCurrentPage(old);
            execCtrl.setCurrentPageDefinition(olddef);
            inits.doFinally();
        }
    }

    public void sendRedirect(String uri, String target) {
        if (uri != null && uri.length() == 0) {
            uri = null;
        }
        UiVisualizer uv = UiEngineImpl.getCurrentVisualizer();
        uv.setAbortingReason(new AbortBySendRedirect(uri != null ? uv.getExecution().encodeURL(uri) : "", target));
    }

    public void setAbortingReason(AbortingReason aborting) {
        UiVisualizer uv = UiEngineImpl.getCurrentVisualizer();
        uv.setAbortingReason(aborting);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execRecover(Execution exec, FailoverManager failover) {
        Desktop desktop = exec.getDesktop();
        Session sess = desktop.getSession();
        UiEngineImpl.doActivate(exec, null, true);
        try {
            failover.recover(sess, exec, desktop);
        }
        finally {
            UiEngineImpl.doDeactivate(exec);
        }
    }

    public void execUpdate(Execution exec, List requests, AuWriter out) throws IOException {
        this.execUpdate(exec, requests, null, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection execUpdate(Execution exec, List requests, String reqId, AuWriter out) throws IOException {
        if (requests == null) {
            throw new IllegalArgumentException("null requests");
        }
        if (!$assertionsDisabled && ExecutionsCtrl.getCurrentCtrl() != null) {
            throw new AssertionError((Object)("Impossible to re-activate for update: old=" + ExecutionsCtrl.getCurrentCtrl() + ", new=" + exec + ", reqs=" + requests));
        }
        UiVisualizer uv = UiEngineImpl.doActivate(exec, requests, false);
        if (uv == null) {
            return null;
        }
        Desktop desktop = exec.getDesktop();
        Configuration config = desktop.getWebApp().getConfiguration();
        Monitor monitor = config.getMonitor();
        if (monitor != null) {
            try {
                monitor.beforeUpdate(desktop, requests);
            }
            catch (Throwable ex) {
                log.error(ex);
            }
        }
        Collection doneReqIds = null;
        AbortingReason abrn = null;
        boolean cleaned = false;
        try {
            LinkedList<AuResponse> responses;
            AuRequest request;
            config.invokeExecutionInits(exec, null);
            RequestQueue rque = ((DesktopCtrl)((Object)desktop)).getRequestQueue();
            if (reqId != null) {
                rque.addRequestId(reqId);
            }
            LinkedList errs = new LinkedList();
            long tmexpired = System.currentTimeMillis() + (long)config.getMaxProcessTime();
            while (System.currentTimeMillis() < tmexpired && (request = rque.nextRequest()) != null) {
                try {
                    this.process(exec, request, !errs.isEmpty());
                }
                catch (ComponentNotFoundException ex) {
                }
                catch (Throwable ex) {
                    UiEngineImpl.handleError(ex, uv, errs);
                }
                Event event = UiEngineImpl.nextEvent(uv);
                while (true) {
                    block44: {
                        if (event != null) {
                            try {
                                this.process(desktop, event);
                            }
                            catch (Throwable ex) {
                                UiEngineImpl.handleError(ex, uv, errs);
                                break block44;
                            }
                            event = UiEngineImpl.nextEvent(uv);
                            continue;
                        }
                    }
                    this.resumeAll(desktop, uv, errs);
                    event = UiEngineImpl.nextEvent(uv);
                    if (event == null) break;
                }
            }
            abrn = uv.getAbortingReason();
            if (abrn != null) {
                abrn.execute();
            }
            try {
                if (!errs.isEmpty()) {
                    this.visualizeErrors(exec, uv, errs);
                }
                responses = uv.getResponses();
            }
            catch (Throwable ex) {
                responses = new LinkedList<AuResponse>();
                responses.add(new AuAlert(Exceptions.getMessage((Throwable)ex)));
                log.error(ex);
            }
            if (rque.endWithRequest()) {
                responses.add(new AuEcho(desktop));
            } else {
                doneReqIds = rque.clearRequestIds();
            }
            out.writeSequenceId(desktop);
            out.write(responses);
            cleaned = true;
            config.invokeExecutionCleanups(exec, null, errs);
        }
        catch (Throwable ex) {
            if (!cleaned) {
                cleaned = true;
                LinkedList<Throwable> errs = new LinkedList<Throwable>();
                errs.add(ex);
                config.invokeExecutionCleanups(exec, null, errs);
                Throwable throwable = ex = errs.isEmpty() ? null : (Throwable)errs.get(0);
            }
            if (ex != null) {
                if (ex instanceof IOException) {
                    throw (IOException)ex;
                }
                throw UiException.Aide.wrap(ex);
            }
        }
        finally {
            if (!cleaned) {
                config.invokeExecutionCleanups(exec, null, null);
            }
            if (abrn != null) {
                try {
                    abrn.finish();
                }
                catch (Throwable t) {
                    log.warning(t);
                }
            }
            UiEngineImpl.doDeactivate(exec);
            if (monitor != null) {
                try {
                    monitor.afterUpdate(desktop);
                }
                catch (Throwable ex) {
                    log.error(ex);
                }
            }
            return doneReqIds;
        }
    }

    private static final void handleError(Throwable ex, UiVisualizer uv, List errs) {
        WrongValueException wve;
        Component comp;
        Throwable err = ex;
        Throwable t = Exceptions.findCause((Throwable)ex, (Class)Expectable.class);
        if (t == null) {
            log.realCauseBriefly(ex);
        } else {
            ex = t;
            if (log.debugable()) {
                log.debug(Exceptions.getRealCause((Throwable)ex));
            }
        }
        if (ex instanceof WrongValueException && (comp = (wve = (WrongValueException)((Object)ex)).getComponent()) != null) {
            if ((wve = ((ComponentCtrl)((Object)comp)).onWrongValue(wve)) != null) {
                uv.addResponse("wrongValue", new AuWrongValue(comp, Exceptions.getMessage((Throwable)((Object)wve))));
            }
            return;
        }
        errs.add(err);
    }

    private final void visualizeErrors(Execution exec, UiVisualizer uv, List errs) {
        StringBuffer sb = new StringBuffer(128);
        Iterator it = errs.iterator();
        while (it.hasNext()) {
            Throwable t = (Throwable)it.next();
            if (sb.length() > 0) {
                sb.append('\n');
            }
            sb.append(Exceptions.getMessage((Throwable)t));
        }
        String msg = sb.toString();
        Throwable err = (Throwable)errs.get(0);
        Desktop desktop = exec.getDesktop();
        Configuration config = desktop.getWebApp().getConfiguration();
        String location = config.getErrorPage(desktop.getDeviceType(), err);
        if (location != null) {
            try {
                exec.setAttribute("javax.servlet.error.message", msg);
                exec.setAttribute("javax.servlet.error.exception", err);
                exec.setAttribute("javax.servlet.error.exception_type", err.getClass());
                exec.setAttribute("javax.servlet.error.status_code", new Integer(500));
                Richlet richlet = config.getRichletByPath(location);
                if (richlet != null) {
                    richlet.service(UiEngineImpl.getCurrentPage(exec));
                } else {
                    exec.createComponents(location, null, null);
                }
                Event event = UiEngineImpl.nextEvent(uv);
                while (true) {
                    if (event != null) {
                        try {
                            this.process(desktop, event);
                        }
                        catch (SuspendNotAllowedException ex) {
                            // empty catch block
                        }
                        event = UiEngineImpl.nextEvent(uv);
                        continue;
                    }
                    this.resumeAll(desktop, uv, null);
                    event = UiEngineImpl.nextEvent(uv);
                    if (event == null) break;
                }
                return;
            }
            catch (Throwable ex) {
                log.realCause("Unable to generate custom error page, " + location, ex);
            }
        }
        uv.addResponse(null, new AuAlert(msg));
    }

    private static final Page getCurrentPage(Execution exec) {
        Page page = ((ExecutionCtrl)((Object)exec)).getCurrentPage();
        return page != null ? page : (Page)exec.getDesktop().getPages().iterator().next();
    }

    private void process(Execution exec, AuRequest request, boolean everError) {
        ExecutionCtrl execCtrl = (ExecutionCtrl)((Object)exec);
        execCtrl.setCurrentPage(request.getPage());
        request.getCommand().process(request, everError);
    }

    private void process(Desktop desktop, Event event) {
        Component comp = event.getTarget();
        if (comp != null) {
            this.processEvent(desktop, comp, event);
        } else {
            LinkedList roots = new LinkedList();
            Iterator it = desktop.getPages().iterator();
            while (it.hasNext()) {
                roots.addAll(((Page)it.next()).getRoots());
            }
            it = roots.iterator();
            while (it.hasNext()) {
                Component c = (Component)it.next();
                if (c.getPage() == null) continue;
                this.processEvent(desktop, c, event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wait(Object mutex) throws InterruptedException, SuspendNotAllowedException {
        IdentityHashMap<Object, LinkedList<EventProcessingThreadImpl>> map;
        if (mutex == null) {
            throw new IllegalArgumentException("null mutex");
        }
        Thread thd = Thread.currentThread();
        if (!(thd instanceof EventProcessingThreadImpl)) {
            throw new UiException("This method can be called only in an event listener, not in paging loading.");
        }
        EventProcessingThreadImpl evtthd = (EventProcessingThreadImpl)thd;
        evtthd.newEventThreadSuspends(mutex);
        Execution exec = Executions.getCurrent();
        Desktop desktop = exec.getDesktop();
        this.incSuspended();
        Map map2 = this._suspended;
        synchronized (map2) {
            map = (IdentityHashMap<Object, LinkedList<EventProcessingThreadImpl>>)this._suspended.get(desktop);
            if (map == null) {
                map = new IdentityHashMap<Object, LinkedList<EventProcessingThreadImpl>>(3);
                this._suspended.put(desktop, map);
            }
        }
        map2 = map;
        synchronized (map2) {
            LinkedList<EventProcessingThreadImpl> list = (LinkedList<EventProcessingThreadImpl>)map.get(mutex);
            if (list == null) {
                list = new LinkedList<EventProcessingThreadImpl>();
                map.put(mutex, list);
            }
            list.add(evtthd);
        }
        try {
            EventProcessingThreadImpl.doSuspend(mutex);
        }
        catch (Throwable ex) {
            IdentityHashMap<Object, LinkedList<EventProcessingThreadImpl>> identityHashMap = map;
            synchronized (identityHashMap) {
                List list = (List)map.get(mutex);
                if (list != null) {
                    list.remove(evtthd);
                    if (list.isEmpty()) {
                        map.remove(mutex);
                    }
                }
            }
            if (ex instanceof InterruptedException) {
                throw (InterruptedException)ex;
            }
            throw UiException.Aide.wrap(ex, "Unable to suspend " + evtthd);
        }
        finally {
            this.decSuspended();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incSuspended() {
        int v = this._wapp.getConfiguration().getMaxSuspendedThreads();
        UiEngineImpl uiEngineImpl = this;
        synchronized (uiEngineImpl) {
            if (v >= 0 && this._suspCnt >= v) {
                throw new SuspendNotAllowedException(MZk.TOO_MANY_SUSPENDED);
            }
            ++this._suspCnt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decSuspended() {
        UiEngineImpl uiEngineImpl = this;
        synchronized (uiEngineImpl) {
            --this._suspCnt;
        }
    }

    public void notify(Object mutex) {
        this.notify(Executions.getCurrent().getDesktop(), mutex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notify(Desktop desktop, Object mutex) {
        EventProcessingThreadImpl evtthd;
        Map map;
        if (desktop == null || mutex == null) {
            throw new IllegalArgumentException("desktop and mutex cannot be null");
        }
        Map map2 = this._suspended;
        synchronized (map2) {
            map = (Map)this._suspended.get(desktop);
        }
        if (map == null) {
            return;
        }
        Map map3 = map;
        synchronized (map3) {
            List list = (List)map.get(mutex);
            if (list == null) {
                return;
            }
            evtthd = (EventProcessingThreadImpl)list.remove(0);
            if (list.isEmpty()) {
                map.remove(mutex);
            }
        }
        this.addResumed(desktop, evtthd);
    }

    public void notifyAll(Object mutex) {
        Execution exec = Executions.getCurrent();
        if (exec == null) {
            throw new UiException("resume can be called only in processing a request");
        }
        this.notifyAll(exec.getDesktop(), mutex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyAll(Desktop desktop, Object mutex) {
        List list;
        Map map;
        if (desktop == null || mutex == null) {
            throw new IllegalArgumentException("desktop and mutex cannot be null");
        }
        Map map2 = this._suspended;
        synchronized (map2) {
            map = (Map)this._suspended.get(desktop);
        }
        if (map == null) {
            return;
        }
        Map map3 = map;
        synchronized (map3) {
            list = (List)map.remove(mutex);
            if (list == null) {
                return;
            }
        }
        Iterator it = list.iterator();
        while (it.hasNext()) {
            this.addResumed(desktop, (EventProcessingThreadImpl)it.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addResumed(Desktop desktop, EventProcessingThreadImpl evtthd) {
        LinkedList<EventProcessingThreadImpl> list;
        Object object = this._resumed;
        synchronized (object) {
            list = (LinkedList<EventProcessingThreadImpl>)this._resumed.get(desktop);
            if (list == null) {
                list = new LinkedList<EventProcessingThreadImpl>();
                this._resumed.put(desktop, list);
            }
        }
        object = list;
        synchronized (object) {
            list.add(evtthd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resumeAll(Desktop desktop, UiVisualizer uv, List errs) {
        while (true) {
            List list;
            Object object = this._resumed;
            synchronized (object) {
                list = (List)this._resumed.remove(desktop);
                if (list == null) {
                    return;
                }
            }
            object = list;
            synchronized (object) {
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    EventProcessingThreadImpl evtthd = (EventProcessingThreadImpl)it.next();
                    if (uv.isAborting()) {
                        evtthd.ceaseSilently("Resume aborted");
                        continue;
                    }
                    try {
                        if (!evtthd.doResume()) continue;
                        this.recycleEventThread(evtthd);
                    }
                    catch (Throwable ex) {
                        this.recycleEventThread(evtthd);
                        if (errs == null) {
                            log.error("Unable to resume " + evtthd, ex);
                            throw UiException.Aide.wrap(ex);
                        }
                        UiEngineImpl.handleError(ex, uv, errs);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processEvent(Desktop desktop, Component comp, Event event) {
        Configuration config = desktop.getWebApp().getConfiguration();
        if (config.isEventThreadEnabled()) {
            EventProcessingThreadImpl evtthd = null;
            List list = this._idles;
            synchronized (list) {
                if (!this._idles.isEmpty()) {
                    evtthd = (EventProcessingThreadImpl)this._idles.remove(0);
                }
            }
            if (evtthd == null) {
                evtthd = new EventProcessingThreadImpl();
            }
            try {
                if (!evtthd.processEvent(desktop, comp, event)) return;
                this.recycleEventThread(evtthd);
                return;
            }
            catch (Throwable ex) {
                this.recycleEventThread(evtthd);
                throw UiException.Aide.wrap(ex);
            }
        }
        EventProcessor proc = new EventProcessor(desktop, comp, event);
        List cleanups = null;
        LinkedList<Throwable> errs = null;
        try {
            List inits = config.newEventThreadInits(comp, event);
            EventProcessor.inEventListener(true);
            if (!config.invokeEventThreadInits(inits, comp, event)) return;
            proc.process();
            return;
        }
        catch (Throwable ex) {
            errs = new LinkedList<Throwable>();
            errs.add(ex);
            cleanups = config.newEventThreadCleanups(comp, event, errs);
            throw UiException.Aide.wrap(ex);
        }
        finally {
            EventProcessor.inEventListener(false);
            if (errs == null) {
                cleanups = config.newEventThreadCleanups(comp, event, null);
            }
            config.invokeEventThreadCompletes(cleanups, comp, event, errs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recycleEventThread(EventProcessingThreadImpl evtthd) {
        if (!evtthd.isCeased()) {
            if (evtthd.isIdle()) {
                int max = this._wapp.getConfiguration().getMaxSpareThreads();
                List list = this._idles;
                synchronized (list) {
                    if (max < 0 || this._idles.size() < max) {
                        this._idles.add(evtthd);
                        return;
                    }
                }
            }
            evtthd.ceaseSilently("Recycled");
        }
    }

    public void activate(Execution exec) {
        if (!$assertionsDisabled && ExecutionsCtrl.getCurrentCtrl() != null) {
            throw new AssertionError((Object)("Impossible to re-activate for update: old=" + ExecutionsCtrl.getCurrentCtrl() + ", new=" + exec));
        }
        UiEngineImpl.doActivate(exec, null, false);
    }

    public void deactivate(Execution exec) {
        UiEngineImpl.doDeactivate(exec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static UiVisualizer doActivate(Execution exec, List requests, boolean recovering) {
        UiVisualizer uv;
        Map eis;
        boolean asyncupd;
        if (Executions.getCurrent() != null) {
            throw new IllegalStateException("Use doReactivate instead");
        }
        Desktop desktop = exec.getDesktop();
        DesktopCtrl desktopCtrl = (DesktopCtrl)((Object)desktop);
        Session sess = desktop.getSession();
        boolean bl = asyncupd = requests != null;
        if (!$assertionsDisabled && recovering && asyncupd) {
            throw new AssertionError();
        }
        boolean inProcess = asyncupd && !UiEngineImpl.isRecovering(desktop) && desktopCtrl.getRequestQueue().addRequests(requests);
        Map map = eis = UiEngineImpl.getVisualizers(sess);
        synchronized (map) {
            UiVisualizer old;
            while ((old = (UiVisualizer)eis.get(desktop)) != null) {
                if (inProcess) {
                    return null;
                }
                try {
                    eis.wait(120000L);
                }
                catch (InterruptedException ex) {
                    throw UiException.Aide.wrap(ex);
                }
            }
            if (asyncupd) {
                desktopCtrl.getRequestQueue().setInProcess();
            }
            uv = new UiVisualizer(exec, asyncupd, recovering);
            eis.put(desktop, uv);
            desktopCtrl.setExecution(exec);
        }
        ExecutionCtrl execCtrl = (ExecutionCtrl)((Object)exec);
        execCtrl.setVisualizer(uv);
        ExecutionsCtrl.setCurrent(exec);
        execCtrl.onActivate();
        return uv;
    }

    private static final boolean isRecovering(Desktop desktop) {
        Execution exec = desktop.getExecution();
        return exec != null && ((ExecutionCtrl)((Object)exec)).isRecovering();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void doDeactivate(Execution exec) {
        Desktop desktop = exec.getDesktop();
        Session sess = desktop.getSession();
        ExecutionCtrl execCtrl = (ExecutionCtrl)((Object)exec);
        try {
            Map eis;
            Map map = eis = UiEngineImpl.getVisualizers(sess);
            synchronized (map) {
                Object o = eis.remove(desktop);
                if (!$assertionsDisabled && o == null) {
                    throw new AssertionError();
                }
                ((DesktopCtrl)((Object)desktop)).setExecution(null);
                eis.notify();
            }
        }
        finally {
            execCtrl.onDeactivate();
            execCtrl.setCurrentPage(null);
            execCtrl.setVisualizer(null);
            ExecutionsCtrl.setCurrent(null);
        }
        SessionCtrl sessCtrl = (SessionCtrl)((Object)sess);
        if (sessCtrl.isInvalidated()) {
            sessCtrl.invalidateNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static UiVisualizer doReactivate(Execution curExec, UiVisualizer olduv) {
        Map eis;
        Desktop desktop = curExec.getDesktop();
        Session sess = desktop.getSession();
        if (!$assertionsDisabled && olduv.getExecution().getDesktop() != desktop) {
            throw new AssertionError((Object)("old dt: " + olduv.getExecution().getDesktop() + ", new:" + desktop));
        }
        UiVisualizer uv = new UiVisualizer(olduv, curExec);
        Map map = eis = UiEngineImpl.getVisualizers(sess);
        synchronized (map) {
            UiVisualizer o = eis.put(desktop, uv);
            if (o != olduv) {
                throw new InternalError();
            }
            ((DesktopCtrl)((Object)desktop)).setExecution(curExec);
        }
        ExecutionCtrl curCtrl = (ExecutionCtrl)((Object)curExec);
        curCtrl.setVisualizer(uv);
        ExecutionsCtrl.setCurrent(curExec);
        curCtrl.onActivate();
        return uv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doDereactivate(Execution curExec, UiVisualizer olduv) {
        Map eis;
        if (olduv == null) {
            throw new IllegalArgumentException("null");
        }
        Desktop desktop = curExec.getDesktop();
        Session sess = desktop.getSession();
        ExecutionCtrl curCtrl = (ExecutionCtrl)((Object)curExec);
        curCtrl.onDeactivate();
        curCtrl.setCurrentPage(null);
        curCtrl.setVisualizer(null);
        Execution oldexec = olduv.getExecution();
        Map map = eis = UiEngineImpl.getVisualizers(sess);
        synchronized (map) {
            eis.put(desktop, olduv);
            ((DesktopCtrl)((Object)desktop)).setExecution(oldexec);
        }
        ExecutionsCtrl.setCurrent(oldexec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map getVisualizers(Session sess) {
        Session session = sess;
        synchronized (session) {
            String attr = "org.zkoss.zk.ui.Visualizers";
            HashMap eis = (HashMap)sess.getAttribute("org.zkoss.zk.ui.Visualizers");
            if (eis == null) {
                eis = new HashMap();
                sess.setAttribute("org.zkoss.zk.ui.Visualizers", eis);
            }
            return eis;
        }
    }

    private static final void setProlog(CreateInfo ci, Component comp, NativeInfo compInfo) {
        NativeInfo splitInfo;
        Native nc = (Native)((Object)comp);
        StringBuffer sb = null;
        List prokids = compInfo.getPrologChildren();
        if (!prokids.isEmpty()) {
            sb = new StringBuffer(256);
            UiEngineImpl.getNativeContent(ci, sb, comp, prokids);
        }
        if ((splitInfo = compInfo.getSplitChild()) != null && splitInfo.isEffective(comp)) {
            if (sb == null) {
                sb = new StringBuffer(256);
            }
            UiEngineImpl.getNativeFirstHalf(ci, sb, comp, splitInfo);
        }
        if (sb != null && sb.length() > 0) {
            nc.setPrologContent(sb.insert(0, nc.getPrologContent()).toString());
        }
    }

    private static final void setEpilog(CreateInfo ci, Component comp, NativeInfo compInfo) {
        List epikids;
        Native nc = (Native)((Object)comp);
        StringBuffer sb = null;
        NativeInfo splitInfo = compInfo.getSplitChild();
        if (splitInfo != null && splitInfo.isEffective(comp)) {
            sb = new StringBuffer(256);
            UiEngineImpl.getNativeSecondHalf(ci, sb, comp, splitInfo);
        }
        if (!(epikids = compInfo.getEpilogChildren()).isEmpty()) {
            if (sb == null) {
                sb = new StringBuffer(256);
            }
            UiEngineImpl.getNativeContent(ci, sb, comp, epikids);
        }
        if (sb != null && sb.length() > 0) {
            nc.setEpilogContent(sb.append(nc.getEpilogContent()).toString());
        }
    }

    private static final void getNativeContent(CreateInfo ci, StringBuffer sb, Component comp, List children) {
        Iterator it = children.iterator();
        while (it.hasNext()) {
            Object meta = it.next();
            if (meta instanceof NativeInfo) {
                NativeInfo childInfo = (NativeInfo)meta;
                ForEach forEach = childInfo.getForEach(ci.page, comp);
                if (forEach == null) {
                    if (!childInfo.isEffective(comp)) continue;
                    UiEngineImpl.getNativeFirstHalf(ci, sb, comp, childInfo);
                    UiEngineImpl.getNativeSecondHalf(ci, sb, comp, childInfo);
                    continue;
                }
                while (forEach.next()) {
                    if (!childInfo.isEffective(comp)) continue;
                    UiEngineImpl.getNativeFirstHalf(ci, sb, comp, childInfo);
                    UiEngineImpl.getNativeSecondHalf(ci, sb, comp, childInfo);
                }
                continue;
            }
            if (meta instanceof TextInfo) {
                String s = ((TextInfo)meta).getValue(comp);
                ((Native)((Object)comp)).getHelper().appendText(sb, s);
                continue;
            }
            UiEngineImpl.execNonComponent(ci, comp, meta);
        }
    }

    private static final void getNativeFirstHalf(CreateInfo ci, StringBuffer sb, Component comp, NativeInfo childInfo) {
        NativeInfo splitInfo;
        ((Native)((Object)comp)).getHelper().getFirstHalf(sb, childInfo.getTag(), UiEngineImpl.evalProperties(comp, childInfo.getProperties()), childInfo.getDeclaredNamespaces());
        List prokids = childInfo.getPrologChildren();
        if (!prokids.isEmpty()) {
            UiEngineImpl.getNativeContent(ci, sb, comp, prokids);
        }
        if ((splitInfo = childInfo.getSplitChild()) != null && splitInfo.isEffective(comp)) {
            UiEngineImpl.getNativeFirstHalf(ci, sb, comp, splitInfo);
        }
    }

    private static final void getNativeSecondHalf(CreateInfo ci, StringBuffer sb, Component comp, NativeInfo childInfo) {
        List epikids;
        NativeInfo splitInfo = childInfo.getSplitChild();
        if (splitInfo != null && splitInfo.isEffective(comp)) {
            UiEngineImpl.getNativeSecondHalf(ci, sb, comp, splitInfo);
        }
        if (!(epikids = childInfo.getEpilogChildren()).isEmpty()) {
            UiEngineImpl.getNativeContent(ci, sb, comp, epikids);
        }
        ((Native)((Object)comp)).getHelper().getSecondHalf(sb, childInfo.getTag());
    }

    private static final Map evalProperties(Component comp, List props) {
        if (props == null || props.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(props.size() * 2);
        Iterator it = props.iterator();
        while (it.hasNext()) {
            Property prop = (Property)it.next();
            if (!prop.isEffective(comp)) continue;
            map.put(prop.getName(), Classes.coerce((Class)(class$java$lang$String == null ? UiEngineImpl.class$("java.lang.String") : class$java$lang$String), (Object)prop.getValue(comp)));
        }
        return map;
    }

    static {
        $assertionsDisabled = !UiEngineImpl.class.desiredAssertionStatus();
        log = Log.lookup((Class)UiEngineImpl.class);
    }

    private static class CreateInfo {
        private final Execution exec;
        private final Page page;
        private final UiFactory uf;

        private CreateInfo(UiFactory uf, Execution exec, Page page) {
            this.exec = exec;
            this.page = page;
            this.uf = uf;
        }
    }

    private static class FulfillListener
    implements EventListener,
    Express,
    Serializable,
    Cloneable,
    ComponentSerializationListener,
    ComponentCloneListener {
        private transient String[] _evtnms;
        private transient Component[] _targets;
        private transient Component _comp;
        private final ComponentInfo _compInfo;
        private final String _fulfill;

        private FulfillListener(String fulfill, ComponentInfo compInfo, Component comp) {
            this._fulfill = fulfill;
            this._compInfo = compInfo;
            this._comp = comp;
            this.init();
            int j = this._targets.length;
            while (--j >= 0) {
                this._targets[j].addEventListener(this._evtnms[j], this);
            }
        }

        private void init() {
            int k;
            LinkedList<Object[]> results = new LinkedList<Object[]>();
            int j = 0;
            int len = this._fulfill.length();
            do {
                String sub;
                if ((sub = ((k = this._fulfill.indexOf(44, j)) >= 0 ? this._fulfill.substring(j, k) : this._fulfill.substring(j)).trim()).length() <= 0) continue;
                results.add(ComponentsCtrl.parseEventExpression(this._comp, sub, this._comp, false));
            } while (k >= 0 && (j = k + 1) < len);
            j = results.size();
            this._targets = new Component[j];
            this._evtnms = new String[j];
            j = 0;
            Iterator it = results.iterator();
            while (it.hasNext()) {
                Object[] result = (Object[])it.next();
                this._targets[j] = (Component)result[0];
                this._evtnms[j] = (String)result[1];
                ++j;
            }
        }

        public void onEvent(Event evt) throws Exception {
            int j = this._targets.length;
            while (--j >= 0) {
                this._targets[j].removeEventListener(this._evtnms[j], this);
            }
            Execution exec = Executions.getCurrent();
            UiEngineImpl.execCreate0(new CreateInfo(((WebAppCtrl)((Object)exec.getDesktop().getWebApp())).getUiFactory(), exec, this._comp.getPage()), this._compInfo, this._comp);
        }

        public void willSerialize(Component comp) {
        }

        public void didDeserialize(Component comp) {
            this._comp = comp;
            this.init();
        }

        public Object clone(Component comp) {
            FulfillListener clone;
            try {
                clone = (FulfillListener)this.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError();
            }
            clone._comp = comp;
            clone.init();
            return clone;
        }
    }
}

