/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.impl;

import java.io.IOException;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuAppendChild;
import org.zkoss.zk.au.out.AuInsertAfter;
import org.zkoss.zk.au.out.AuInsertBefore;
import org.zkoss.zk.au.out.AuRemove;
import org.zkoss.zk.au.out.AuRemoveAttribute;
import org.zkoss.zk.au.out.AuReplace;
import org.zkoss.zk.au.out.AuSetAttribute;
import org.zkoss.zk.au.out.AuSetDeferredAttribute;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Components;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.ext.render.ChildChangedAware;
import org.zkoss.zk.ui.ext.render.Cropper;
import org.zkoss.zk.ui.ext.render.MultiBranch;
import org.zkoss.zk.ui.sys.AbortingReason;
import org.zkoss.zk.ui.sys.ComponentCtrl;
import org.zkoss.zk.ui.sys.DesktopCtrl;
import org.zkoss.zk.ui.sys.PageCtrl;
import org.zkoss.zk.ui.sys.Visualizer;
import org.zkoss.zk.ui.util.DeferredValue;

class UiVisualizer
implements Visualizer {
    private final UiVisualizer _1stec;
    private final Execution _exec;
    private Set _pgInvalid;
    private Set _pgRemoved;
    private final Set _invalidated = new LinkedHashSet(37);
    private final Map _smartUpdated = new HashMap(53);
    private final Set _attached = new LinkedHashSet(37);
    private final Set _moved = new LinkedHashSet(37);
    private Map _idChgd;
    private Map _responses;
    private final List _owners;
    private int _timed;
    private AbortingReason _aborting;
    private final boolean _1stau;
    private final boolean _recovering;
    private boolean _ending;
    private boolean _disabled;
    static final /* synthetic */ boolean $assertionsDisabled;

    public UiVisualizer(Execution exec, boolean asyncUpdate, boolean recovering) {
        this._exec = exec;
        this._1stec = this;
        this._1stau = asyncUpdate;
        this._recovering = recovering;
        this._owners = new LinkedList();
    }

    public UiVisualizer(UiVisualizer parent, Execution exec) {
        this._exec = exec;
        this._1stec = parent._1stec;
        this._1stau = parent._1stau;
        this._recovering = false;
        this._owners = null;
    }

    public final Execution getExecution() {
        return this._exec;
    }

    public final boolean isEverAsyncUpdate() {
        return this._1stau;
    }

    public final boolean addToFirstAsyncUpdate(List responses) {
        if (!this._1stau) {
            return false;
        }
        Iterator it = responses.iterator();
        while (it.hasNext()) {
            this._1stec.addResponse(null, (AuResponse)it.next());
        }
        return true;
    }

    public boolean isRecovering() {
        return this._recovering;
    }

    public void disable() {
        this._disabled = true;
    }

    public void addInvalidate(Page page) {
        if (this._recovering || this._disabled || page == null || !this._exec.isAsyncUpdate(page)) {
            return;
        }
        if (this._pgInvalid == null) {
            this._pgInvalid = new LinkedHashSet(7);
        }
        this._pgInvalid.add(page);
    }

    public void addInvalidate(Component comp) {
        Page page = comp.getPage();
        if (this._recovering || this._disabled || page == null || !this._exec.isAsyncUpdate(page)) {
            return;
        }
        if (this._ending) {
            throw new IllegalStateException("ended");
        }
        this.checkDesktop(comp);
        if (this._invalidated.add(comp)) {
            this._smartUpdated.remove(comp);
        }
    }

    private void checkDesktop(Component comp) {
        Desktop dt = comp.getDesktop();
        if (dt != null && dt != this._exec.getDesktop()) {
            throw new IllegalStateException("Access denied: component, " + comp + ", belongs to another desktop: " + dt);
        }
    }

    public void addSmartUpdate(Component comp, String attr, String value) {
        Map respmap = this.getAttrRespMap(comp, attr);
        if (respmap != null) {
            respmap.put(attr, new TimedValue(this._timed++, comp, attr, value));
        }
    }

    public void addSmartUpdate(Component comp, String attr, DeferredValue value) {
        Map respmap = this.getAttrRespMap(comp, attr);
        if (respmap != null) {
            respmap.put(attr, new TimedValue(this._timed++, comp, attr, value));
        }
    }

    private Map getAttrRespMap(Component comp, String attr) {
        Page page = comp.getPage();
        if (this._recovering || this._disabled || page == null || !this._exec.isAsyncUpdate(page) || this._invalidated.contains(comp)) {
            return null;
        }
        if (this._ending) {
            throw new IllegalStateException("ended");
        }
        this.checkDesktop(comp);
        HashMap respmap = (HashMap)this._smartUpdated.get(comp);
        if (respmap == null) {
            respmap = new HashMap();
            this._smartUpdated.put(comp, respmap);
        }
        return respmap;
    }

    public void addMoved(Component comp, Component oldparent, Page oldpg, Page newpg) {
        if (this._recovering || this._disabled || newpg == null && oldpg == null || newpg == null && !this._exec.isAsyncUpdate(oldpg) || oldpg == null && !this._exec.isAsyncUpdate(newpg)) {
            return;
        }
        if (this._ending) {
            throw new IllegalStateException("ended");
        }
        if (oldpg == null && !this._moved.contains(comp)) {
            this._attached.add(comp);
        } else {
            Object xc;
            if (this._moved.add(comp) && oldparent != null && (xc = ((ComponentCtrl)((Object)oldparent)).getExtraCtrl()) instanceof Cropper && ((Cropper)xc).isCropper()) {
                this._invalidated.add(oldparent);
            }
            this._attached.remove(comp);
        }
    }

    public void addUuidChanged(Component comp, boolean addOnlyMoved) {
        if (!(addOnlyMoved && !this._moved.contains(comp) || this._idChgd != null && this._idChgd.containsKey(comp))) {
            if (this._idChgd == null) {
                this._idChgd = new LinkedHashMap(23);
            }
            this._idChgd.put(comp, comp.getUuid());
        }
    }

    public void addResponse(String key, AuResponse response) {
        Object depends;
        HashMap<String, Object> respmap;
        if (response == null) {
            throw new IllegalArgumentException();
        }
        if (this._responses == null) {
            this._responses = new HashMap();
        }
        if ((respmap = (HashMap<String, Object>)this._responses.get(depends = response.getDepends())) == null) {
            respmap = new HashMap<String, Object>();
            this._responses.put(depends, respmap);
        }
        TimedValue tval = new TimedValue(this._timed++, response);
        if (key != null) {
            respmap.put(key, tval);
        } else {
            LinkedList<TimedValue> resps = (LinkedList<TimedValue>)respmap.get(null);
            if (resps == null) {
                resps = new LinkedList<TimedValue>();
                respmap.put(null, resps);
            }
            resps.add(tval);
        }
    }

    private boolean doCrop() {
        HashMap cropping = new HashMap();
        boolean invAdded = this.crop(this._attached, cropping, true, false);
        boolean bl = invAdded = this.crop(this._smartUpdated.keySet(), cropping, false, false) || invAdded;
        if (this._responses != null) {
            invAdded = this.crop(this._responses.keySet(), cropping, false, true) || invAdded;
        }
        invAdded = this.crop(this._invalidated, cropping, false, false) || invAdded;
        return invAdded;
    }

    private boolean crop(Set coll, Map cropping, boolean bAttached, boolean bResponse) {
        HashSet<Component> newInvalid = null;
        Iterator it = coll.iterator();
        block0: while (it.hasNext()) {
            Component p;
            Object o = it.next();
            if (!(o instanceof Component)) continue;
            Component comp = (Component)o;
            Page page = comp.getPage();
            if (page == null || !this._exec.isAsyncUpdate(page)) {
                if (bResponse) continue;
                it.remove();
                continue;
            }
            Component c = comp;
            while ((p = c.getParent()) != null) {
                block7: {
                    Set avail;
                    block8: {
                        block9: {
                            avail = UiVisualizer.getAvailableAtClient(p, cropping);
                            if (avail == null) break block7;
                            if (!bAttached) break block8;
                            if (!avail.contains(c)) break block9;
                            if (c != comp) break block7;
                            if (newInvalid == null) {
                                newInvalid = new HashSet<Component>();
                            }
                            newInvalid.add(p);
                        }
                        it.remove();
                        continue block0;
                    }
                    if (!avail.contains(c)) {
                        it.remove();
                        continue block0;
                    }
                }
                c = p;
            }
        }
        return newInvalid != null && this._invalidated.addAll(newInvalid);
    }

    private static Set getAvailableAtClient(Component comp, Map cropping) {
        Object xc = ((ComponentCtrl)((Object)comp)).getExtraCtrl();
        if (xc instanceof Cropper) {
            Set set = (Set)cropping.get(comp);
            if (set != null) {
                return set != Collections.EMPTY_SET ? set : null;
            }
            set = ((Cropper)xc).getAvailableAtClient();
            cropping.put(comp, set != null ? set : Collections.EMPTY_SET);
            return set;
        }
        return null;
    }

    private void doChildChanged() {
        LinkedHashSet ccawares = new LinkedHashSet();
        HashSet checked = new HashSet(79);
        this.doChildChanged(this._invalidated, ccawares, checked);
        this.doChildChanged(this._attached, ccawares, checked);
        this.doChildChanged(this._smartUpdated.keySet(), ccawares, checked);
        if (!ccawares.isEmpty()) {
            Iterator it = ccawares.iterator();
            while (it.hasNext()) {
                this.addSmartUpdate((Component)it.next(), "z.chchg", "true");
            }
        }
    }

    private void doChildChanged(Collection col, Set ccawares, Set checked) {
        Iterator it = col.iterator();
        while (it.hasNext()) {
            Component comp = (Component)it.next();
            Page page = comp.getPage();
            if (page == null || !this._exec.isAsyncUpdate(page)) continue;
            while ((comp = comp.getParent()) != null && checked.add(comp)) {
                Object xc = ((ComponentCtrl)((Object)comp)).getExtraCtrl();
                if (!(xc instanceof ChildChangedAware) || !((ChildChangedAware)xc).isChildChangedAware()) continue;
                ccawares.add(comp);
            }
        }
    }

    private void checkPageRemoved(Set removed) {
        boolean pgRemovedFound;
        Desktop desktop = this._exec.getDesktop();
        HashSet<Page> pages = null;
        Iterator it = desktop.getPages().iterator();
        while (it.hasNext()) {
            Page page = (Page)it.next();
            Component owner = ((PageCtrl)((Object)page)).getOwner();
            if (owner == null) continue;
            Page ownerPage = owner.getPage();
            if (ownerPage == null || this._pgInvalid != null && this._pgInvalid.contains(ownerPage) || this.isAncestor(this._invalidated, owner, true) || this.isAncestor(this._attached, owner, true) || this.isAncestor(removed, owner, true)) {
                this.addPageRemoved(page);
                continue;
            }
            if (pages == null) {
                pages = new HashSet<Page>();
            }
            pages.add(page);
        }
        if (this._pgRemoved == null || pages == null) {
            return;
        }
        do {
            pgRemovedFound = false;
            Iterator it2 = pages.iterator();
            while (it2.hasNext()) {
                Page page = (Page)it2.next();
                Component owner = ((PageCtrl)((Object)page)).getOwner();
                if (!this._pgRemoved.contains(owner.getPage())) continue;
                it2.remove();
                this.addPageRemoved(page);
                pgRemovedFound = true;
            }
        } while (pgRemovedFound);
    }

    private void addPageRemoved(Page page) {
        if (this._pgRemoved == null) {
            this._pgRemoved = new HashSet();
        }
        this._pgRemoved.add(page);
        if (this._pgInvalid != null) {
            this._pgInvalid.remove(page);
        }
    }

    private void clearInInvalidPage(Collection coll) {
        Iterator it = coll.iterator();
        while (it.hasNext()) {
            Component comp = (Component)it.next();
            Page page = comp.getPage();
            if (page == null || (this._pgRemoved == null || !this._pgRemoved.contains(page)) && (this._pgInvalid == null || !this._pgInvalid.contains(page))) continue;
            it.remove();
        }
    }

    private boolean isAncestor(Collection coll, Component comp, boolean includingEquals) {
        Iterator it = coll.iterator();
        while (it.hasNext()) {
            Component c = (Component)it.next();
            if (!includingEquals && c == comp || !Components.isAncestor(c, comp)) continue;
            return true;
        }
        return false;
    }

    public List getResponses() throws IOException {
        AuResponse abtresp;
        Iterator<Object> it;
        LinkedList<AuResponse> responses = new LinkedList<AuResponse>();
        Set removed = this.doMoved(responses);
        UiVisualizer.removeRedundant(this._invalidated);
        UiVisualizer.removeRedundant(this._attached);
        this.removeCrossRedundant();
        if (this.doCrop()) {
            UiVisualizer.removeRedundant(this._invalidated);
            this.removeCrossRedundant();
        }
        this.checkPageRemoved(removed);
        if (this._pgInvalid != null && this._pgInvalid.isEmpty()) {
            this._pgInvalid = null;
        }
        if (this._pgRemoved != null && this._pgRemoved.isEmpty()) {
            this._pgRemoved = null;
        }
        if (this._pgInvalid != null || this._pgRemoved != null) {
            this.clearInInvalidPage(this._invalidated);
            this.clearInInvalidPage(this._attached);
            this.clearInInvalidPage(this._smartUpdated.keySet());
            if (this._idChgd != null) {
                this.clearInInvalidPage(this._idChgd.keySet());
            }
        }
        if (this._pgRemoved != null) {
            DesktopCtrl dtctl = (DesktopCtrl)((Object)this._exec.getDesktop());
            Iterator it2 = this._pgRemoved.iterator();
            while (it2.hasNext()) {
                dtctl.removePage((Page)it2.next());
            }
        }
        if (this._pgInvalid != null) {
            it = this._pgInvalid.iterator();
            while (it.hasNext()) {
                Page page = (Page)it.next();
                responses.add(new AuReplace(page, UiVisualizer.redraw(page)));
            }
        }
        if (this._idChgd != null) {
            it = this._idChgd.values().iterator();
            while (it.hasNext()) {
                responses.add(new AuRemove((String)it.next()));
            }
            this._idChgd = null;
        }
        this.doChildChanged();
        it = this._invalidated.iterator();
        while (it.hasNext()) {
            Component comp = (Component)it.next();
            responses.add(new AuReplace(comp, UiVisualizer.redraw(comp)));
        }
        this._ending = true;
        LinkedList desktops = new LinkedList();
        Component[] attached = this._attached.toArray(new Component[this._attached.size()]);
        for (int j = 0; j < attached.length; ++j) {
            Page page;
            Component comp = attached[j];
            if (comp == null || (page = comp.getPage()) == null || !this._exec.isAsyncUpdate(page)) continue;
            Component parent = comp.getParent();
            LinkedHashSet<Component> newsibs = new LinkedHashSet<Component>(37);
            newsibs.add(comp);
            desktops.add(newsibs);
            for (int k = j + 1; k < attached.length; ++k) {
                Component ck = attached[k];
                if (ck == null || ck.getParent() != parent) continue;
                newsibs.add(ck);
                attached[k] = null;
            }
        }
        Iterator it3 = desktops.iterator();
        while (it3.hasNext()) {
            Set newsibs = (Set)it3.next();
            UiVisualizer.addResponsesForCreatedPerSiblings(responses, newsibs);
        }
        LinkedList tvals = new LinkedList();
        Iterator it4 = this._smartUpdated.values().iterator();
        while (it4.hasNext()) {
            Map attrs = (Map)it4.next();
            tvals.addAll(attrs.values());
        }
        if (this._responses != null) {
            it4 = this._responses.values().iterator();
            while (it4.hasNext()) {
                Map resps = (Map)it4.next();
                List keyless = (List)resps.remove(null);
                if (keyless != null) {
                    tvals.addAll(keyless);
                }
                tvals.addAll(resps.values());
            }
        }
        if (!tvals.isEmpty()) {
            Object[] tvs = tvals.toArray(new TimedValue[tvals.size()]);
            Arrays.sort(tvs);
            for (int j = 0; j < tvs.length; ++j) {
                responses.add(((TimedValue)tvs[j]).getResponse());
            }
        }
        if (this._aborting != null && (abtresp = this._aborting.getResponse()) != null) {
            responses.add(abtresp);
        }
        this._invalidated.clear();
        this._smartUpdated.clear();
        this._attached.clear();
        this._pgRemoved = null;
        this._pgInvalid = null;
        this._responses = null;
        return responses;
    }

    private Set doMoved(List responses) {
        HashSet<Component> removed = new HashSet<Component>();
        Iterator it = this._moved.iterator();
        while (it.hasNext()) {
            Component comp = (Component)it.next();
            Page page = comp.getPage();
            if (page == null) {
                removed.add(comp);
                if (this._responses != null) {
                    this._responses.remove(comp);
                }
                this._invalidated.remove(comp);
                this._smartUpdated.remove(comp);
                responses.add(new AuRemove(comp));
                continue;
            }
            if (this._exec.isAsyncUpdate(page)) {
                responses.add(new AuRemove(comp));
            }
            this._attached.add(comp);
        }
        this._moved.clear();
        return removed;
    }

    private static void addResponsesForCreatedPerSiblings(List responses, Set newsibs) throws IOException {
        Component comp;
        Component comp2 = (Component)newsibs.iterator().next();
        Component parent = comp2.getParent();
        Page page = comp2.getPage();
        Collection sibs = parent != null ? parent.getChildren() : page.getRoots();
        LinkedList<Component> before = new LinkedList<Component>();
        Component anchor = null;
        ComponentCtrl parentCtrl = (ComponentCtrl)((Object)parent);
        Object parentxc = parentCtrl != null ? parentCtrl.getExtraCtrl() : null;
        Iterator it = sibs.iterator();
        while (it.hasNext()) {
            comp = (Component)it.next();
            if (parentxc instanceof MultiBranch && ((MultiBranch)parentxc).inDifferentBranch(comp)) continue;
            if (anchor != null) {
                if (newsibs.remove(comp)) {
                    responses.add(new AuInsertAfter(anchor, UiVisualizer.drawNew(comp)));
                    if (newsibs.isEmpty()) {
                        return;
                    }
                    anchor = comp;
                    continue;
                }
                anchor = comp;
                continue;
            }
            if (newsibs.remove(comp)) {
                before.add(comp);
                continue;
            }
            anchor = comp;
            ListIterator i2 = before.listIterator(before.size());
            while (i2.hasPrevious()) {
                Component c = (Component)i2.previous();
                responses.add(new AuInsertBefore(anchor, UiVisualizer.drawNew(c)));
                anchor = c;
            }
            if (newsibs.isEmpty()) {
                return;
            }
            anchor = comp;
        }
        if (!($assertionsDisabled || anchor == null && newsibs.isEmpty())) {
            throw new AssertionError((Object)("anchor=" + anchor + " newsibs=" + newsibs + " sibs=" + sibs));
        }
        it = before.iterator();
        if (it.hasNext()) {
            anchor = (Component)it.next();
            responses.add(parent != null ? new AuAppendChild(parent, UiVisualizer.drawNew(anchor)) : new AuAppendChild(page, UiVisualizer.drawNew(anchor)));
            while (it.hasNext()) {
                comp = (Component)it.next();
                responses.add(new AuInsertAfter(anchor, UiVisualizer.drawNew(comp)));
                anchor = comp;
            }
        }
    }

    private static void removeRedundant(Set comps) {
        Iterator j = comps.iterator();
        block0: while (j.hasNext()) {
            Component cj = (Component)j.next();
            Iterator k = comps.iterator();
            while (k.hasNext()) {
                Component ck = (Component)k.next();
                if (ck == cj || !Components.isAncestor(ck, cj)) continue;
                j.remove();
                continue block0;
            }
        }
    }

    private void removeCrossRedundant() {
        Component ck;
        Iterator k;
        Component cj;
        Iterator<Object> j = this._invalidated.iterator();
        block0: while (j.hasNext()) {
            cj = (Component)j.next();
            k = this._attached.iterator();
            while (k.hasNext()) {
                ck = (Component)k.next();
                if (Components.isAncestor(ck, cj)) {
                    j.remove();
                    continue block0;
                }
                if (!Components.isAncestor(cj, ck)) continue;
                k.remove();
            }
        }
        j = this._smartUpdated.keySet().iterator();
        block2: while (j.hasNext()) {
            cj = (Component)j.next();
            k = this._invalidated.iterator();
            while (k.hasNext()) {
                ck = (Component)k.next();
                if (!Components.isAncestor(ck, cj)) continue;
                j.remove();
                continue block2;
            }
            k = this._attached.iterator();
            while (k.hasNext()) {
                ck = (Component)k.next();
                if (!Components.isAncestor(ck, cj)) continue;
                j.remove();
                continue block2;
            }
        }
    }

    private static String drawNew(Component comp) throws IOException {
        StringWriter out = new StringWriter(8192);
        comp.redraw(out);
        StringBuffer buf = out.getBuffer();
        Component parent = comp.getParent();
        if (parent != null) {
            parent.onDrawNewChild(comp, buf);
        }
        return buf.toString();
    }

    private static String redraw(Component comp) throws IOException {
        StringWriter out = new StringWriter(8192);
        comp.redraw(out);
        return out.toString();
    }

    private static String redraw(Page page) throws IOException {
        StringWriter out = new StringWriter(8192);
        ((PageCtrl)((Object)page)).redraw(null, out);
        return out.toString();
    }

    public void pushOwner(Component comp) {
        this._1stec._owners.add(0, comp);
    }

    public void popOwner() {
        this._1stec._owners.remove(0);
    }

    public Component getOwner() {
        return this._1stec._owners.isEmpty() ? null : (Component)this._1stec._owners.get(0);
    }

    public void setAbortingReason(AbortingReason reason) {
        if (this._aborting != null && reason == null) {
            throw new IllegalStateException("Aborting reason is set and you cannot clear it");
        }
        this._aborting = reason;
    }

    public AbortingReason getAbortingReason() {
        return this._aborting;
    }

    public boolean isAborting() {
        return this._aborting != null && this._aborting.isAborting();
    }

    static {
        $assertionsDisabled = !UiVisualizer.class.desiredAssertionStatus();
    }

    private static class TimedValue
    implements Comparable {
        private final int _timed;
        private final AuResponse _response;

        private TimedValue(int timed, AuResponse response) {
            this._timed = timed;
            this._response = response;
        }

        private TimedValue(int timed, Component comp, String name, String value) {
            this._timed = timed;
            this._response = value != null ? new AuSetAttribute(comp, name, value) : new AuRemoveAttribute(comp, name);
        }

        private TimedValue(int timed, Component comp, String name, DeferredValue value) {
            this._timed = timed;
            this._response = value != null ? new AuSetDeferredAttribute(comp, name, value) : new AuRemoveAttribute(comp, name);
        }

        public String toString() {
            return 40 + this._timed + ":" + this._response + ')';
        }

        public int compareTo(Object o) {
            int t = ((TimedValue)o)._timed;
            return this._timed > t ? 1 : (this._timed == t ? 0 : -1);
        }

        private AuResponse getResponse() {
            return this._response;
        }
    }
}

