/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.metainfo;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.zkoss.zk.ui.metainfo.Annotation;

public class AnnotationMap
implements Cloneable,
Serializable {
    private Map _annots;

    public boolean isEmpty() {
        return this._annots == null || this._annots.isEmpty();
    }

    public Annotation getAnnotation(String annotName) {
        return this.getAnnotation0(null, annotName);
    }

    public Annotation getAnnotation(String propName, String annotName) {
        if (propName == null || propName.length() == 0) {
            throw new IllegalArgumentException("The property name is required");
        }
        return this.getAnnotation0(propName, annotName);
    }

    public Collection getAnnotations() {
        return this.getAnnotations0(null);
    }

    public Collection getAnnotations(String propName) {
        if (propName == null || propName.length() == 0) {
            throw new IllegalArgumentException("The property name is required");
        }
        return this.getAnnotations0(propName);
    }

    public List getAnnotatedPropertiesBy(String annotName) {
        LinkedList list = null;
        if (this._annots != null) {
            Iterator it = this._annots.entrySet().iterator();
            while (it.hasNext()) {
                Map ans;
                Map.Entry me = it.next();
                Object propName = me.getKey();
                if (propName == null || !(ans = (Map)me.getValue()).containsKey(annotName)) continue;
                if (list == null) {
                    list = new LinkedList();
                }
                list.add(propName);
            }
        }
        return list != null ? list : Collections.EMPTY_LIST;
    }

    public List getAnnotatedProperties() {
        LinkedList list = null;
        if (this._annots != null) {
            Iterator it = this._annots.keySet().iterator();
            while (it.hasNext()) {
                Object propName = it.next();
                if (propName == null) continue;
                if (list == null) {
                    list = new LinkedList();
                }
                list.add(propName);
            }
        }
        return list != null ? list : Collections.EMPTY_LIST;
    }

    public void addAll(AnnotationMap src) {
        if (src != null && !src.isEmpty()) {
            this.initAnnots();
            Iterator it = src._annots.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry me = it.next();
                Object propName = me.getKey();
                Map ans = (Map)this._annots.get(propName);
                if (ans == null) {
                    ans = AnnotationMap.newAnnotImpls();
                    this._annots.put(propName, ans);
                }
                AnnotationMap.addAllAns(ans, (Map)me.getValue());
            }
        }
    }

    public static void addAllAns(Map ans, Map srcans) {
        Iterator it = srcans.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry me = it.next();
            String annotName = (String)me.getKey();
            AnnotImpl ai = (AnnotImpl)ans.get(annotName);
            if (ai == null) {
                ai = new AnnotImpl(annotName);
                ans.put(annotName, ai);
            }
            ai.addAttributes(((AnnotImpl)me.getValue())._attrs);
        }
    }

    public void addAnnotation(String annotName, Map annotAttrs) {
        this.addAnnotation0(null, annotName, annotAttrs);
    }

    public void addAnnotation(String propName, String annotName, Map annotAttrs) {
        if (propName == null || propName.length() == 0) {
            throw new IllegalArgumentException("The property name is required");
        }
        this.addAnnotation0(propName, annotName, annotAttrs);
    }

    private Annotation getAnnotation0(String propName, String annotName) {
        Map ans;
        if (this._annots != null && (ans = (Map)this._annots.get(propName)) != null) {
            return (Annotation)ans.get(annotName);
        }
        return null;
    }

    private Collection getAnnotations0(String propName) {
        Map ans;
        if (this._annots != null && (ans = (Map)this._annots.get(propName)) != null) {
            return ans.values();
        }
        return Collections.EMPTY_LIST;
    }

    private void addAnnotation0(String propName, String annotName, Map annotAttrs) {
        AnnotImpl ai;
        this.initAnnots();
        Map ans = (Map)this._annots.get(propName);
        if (ans == null) {
            ans = AnnotationMap.newAnnotImpls();
            this._annots.put(propName, ans);
        }
        if ((ai = (AnnotImpl)ans.get(annotName)) == null) {
            ai = new AnnotImpl(annotName);
            ans.put(annotName, ai);
        }
        ai.addAttributes(annotAttrs);
    }

    private void initAnnots() {
        if (this._annots == null) {
            this._annots = new HashMap(4);
        }
    }

    private static Map newAnnotImpls() {
        return new LinkedHashMap(4);
    }

    public Object clone() {
        AnnotationMap clone;
        try {
            clone = (AnnotationMap)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        if (this._annots != null) {
            clone._annots = new HashMap(this._annots);
            Iterator it = clone._annots.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry me = it.next();
                Map ans = clone.newAnnotImpls();
                AnnotationMap.addAllAns(ans, (Map)me.getValue());
                me.setValue(ans);
            }
        }
        return clone;
    }

    public String toString() {
        return "[annot:" + this._annots + ']';
    }

    private static class AnnotImpl
    implements Annotation {
        private final String _name;
        private Map _attrs;

        private AnnotImpl(String name) {
            this._name = name;
        }

        private void addAttribute(String name, String value) {
            if (name == null || name.length() == 0) {
                name = "value";
            }
            if (value == null) {
                value = "";
            }
            if (this._attrs == null) {
                this._attrs = new LinkedHashMap(3);
            }
            this._attrs.put(name, value);
        }

        private void addAttributes(Map attrs) {
            if (attrs != null) {
                Iterator it = attrs.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry me = it.next();
                    this.addAttribute((String)me.getKey(), (String)me.getValue());
                }
            }
        }

        public String getName() {
            return this._name;
        }

        public Map getAttributes() {
            return this._attrs != null ? this._attrs : Collections.EMPTY_MAP;
        }

        public String getAttribute(String name) {
            return this._attrs != null ? (String)this._attrs.get(name) : null;
        }

        public String toString() {
            return '[' + this._name + ": " + this._attrs + ']';
        }
    }
}

