/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.metainfo;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.zkoss.util.resource.Locator;
import org.zkoss.xel.ExpressionFactory;
import org.zkoss.xel.Expressions;
import org.zkoss.xel.Function;
import org.zkoss.xel.FunctionMapper;
import org.zkoss.xel.VariableResolver;
import org.zkoss.xel.taglib.Taglib;
import org.zkoss.xel.taglib.Taglibs;
import org.zkoss.xml.HTMLs;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.metainfo.ComponentDefinition;
import org.zkoss.zk.ui.metainfo.ComponentDefinitionMap;
import org.zkoss.zk.ui.metainfo.DefinitionNotFoundException;
import org.zkoss.zk.ui.metainfo.ForwardInfo;
import org.zkoss.zk.ui.metainfo.HeaderInfo;
import org.zkoss.zk.ui.metainfo.InitiatorInfo;
import org.zkoss.zk.ui.metainfo.LanguageDefinition;
import org.zkoss.zk.ui.metainfo.NodeInfo;
import org.zkoss.zk.ui.metainfo.PageEvalRef;
import org.zkoss.zk.ui.metainfo.VariableResolverInfo;
import org.zkoss.zk.ui.sys.PageConfig;
import org.zkoss.zk.ui.sys.PageCtrl;
import org.zkoss.zk.ui.util.Initiator;
import org.zkoss.zk.xel.Evaluator;
import org.zkoss.zk.xel.ExValue;
import org.zkoss.zk.xel.impl.EvaluatorRef;
import org.zkoss.zk.xel.impl.SimpleEvaluator;

public class PageDefinition
extends NodeInfo {
    private final LanguageDefinition _langdef;
    private final Locator _locator;
    private String _id;
    private String _title;
    private String _style;
    private String _path = "";
    private String _zslang = "Java";
    private List _taglibs;
    private Map _expimps;
    private List _xelmtds;
    private Evaluator _eval;
    private EvaluatorRef _evalr;
    private FunctionMapper _mapper;
    private List _initdefs;
    private List _resolvdefs;
    private List _headerdefs;
    private List _forwdefs;
    private Map _rootAttrs;
    private ExValue _contentType;
    private ExValue _docType;
    private ExValue _firstLine;
    private Class _expfcls;
    private final ComponentDefinitionMap _compdefs;
    private Boolean _cacheable;

    public PageDefinition(LanguageDefinition langdef, Locator locator) {
        if (langdef == null) {
            throw new IllegalArgumentException("null langdef");
        }
        if (locator == null) {
            throw new IllegalArgumentException("null locator");
        }
        this._langdef = langdef;
        this._locator = locator;
        this._compdefs = new ComponentDefinitionMap(this._langdef.getComponentDefinitionMap().isCaseInsensitive());
    }

    public PageDefinition(LanguageDefinition langdef, String id, String title, String style, Locator locator) {
        this(langdef, locator);
        this.setId(id);
        this.setTitle(title);
        this.setStyle(style);
    }

    public LanguageDefinition getLanguageDefinition() {
        return this._langdef;
    }

    public NodeInfo getParent() {
        return null;
    }

    public Locator getLocator() {
        return this._locator;
    }

    public String getZScriptLanguage() {
        return this._zslang;
    }

    public void setZScriptLanguage(String zslang) {
        if (zslang == null || zslang.length() == 0) {
            throw new IllegalArgumentException("null or empty");
        }
        this._zslang = zslang;
    }

    public String getId() {
        return this._id;
    }

    public void setId(String id) {
        this._id = id != null && id.length() > 0 ? id : null;
    }

    public String getTitle() {
        return this._title;
    }

    public void setTitle(String title) {
        this._title = title != null && title.length() > 0 ? title : null;
    }

    public String getStyle() {
        return this._style;
    }

    public void setStyle(String style) {
        this._style = style != null && style.length() > 0 ? style : null;
    }

    public String getRequestPath() {
        return this._path;
    }

    public void setRequestPath(String path) {
        this._path = path != null ? path : "";
    }

    public void imports(PageDefinition pgdef, String[] directives) {
        Iterator it;
        if (pgdef._initdefs != null && (directives == null || PageDefinition.contains(directives, "init"))) {
            it = pgdef._initdefs.iterator();
            while (it.hasNext()) {
                this.addInitiatorInfo((InitiatorInfo)it.next());
            }
        }
        if (directives == null || PageDefinition.contains(directives, "component")) {
            it = pgdef._compdefs.getNames().iterator();
            while (it.hasNext()) {
                this.addComponentDefinition(pgdef._compdefs.get((String)it.next()));
            }
        }
        if (pgdef._taglibs != null && directives != null && PageDefinition.contains(directives, "taglib")) {
            it = pgdef._taglibs.iterator();
            while (it.hasNext()) {
                this.addTaglib((Taglib)it.next());
            }
        }
        if (pgdef._resolvdefs != null && directives != null && PageDefinition.contains(directives, "variable-resolver")) {
            it = pgdef._resolvdefs.iterator();
            while (it.hasNext()) {
                this.addVariableResolverInfo((VariableResolverInfo)it.next());
            }
        }
        if (pgdef._xelmtds != null && directives != null && PageDefinition.contains(directives, "xel-method")) {
            it = pgdef._xelmtds.iterator();
            while (it.hasNext()) {
                Object[] inf = (Object[])it.next();
                this.addXelMethod((String)inf[0], (String)inf[1], (Function)inf[2]);
            }
        }
        if (pgdef._headerdefs != null && directives != null && PageDefinition.contains(directives, "meta")) {
            it = pgdef._headerdefs.iterator();
            while (it.hasNext()) {
                this.addHeaderInfo((HeaderInfo)it.next());
            }
        }
    }

    private static boolean contains(String[] dirs, String dir) {
        int j = dirs.length;
        while (--j >= 0) {
            if (!"*".equals(dirs[j]) && !dir.equalsIgnoreCase(dirs[j])) continue;
            return true;
        }
        return false;
    }

    public void imports(PageDefinition pgdef) {
        this.imports(pgdef, null);
    }

    public void addInitiatorInfo(InitiatorInfo init) {
        if (init == null) {
            throw new IllegalArgumentException("null");
        }
        if (this._initdefs == null) {
            this._initdefs = new LinkedList();
        }
        this._initdefs.add(init);
    }

    public List doInit(Page page) {
        if (this._initdefs == null) {
            return Collections.EMPTY_LIST;
        }
        LinkedList<Initiator> inits = new LinkedList<Initiator>();
        Iterator it = this._initdefs.iterator();
        while (it.hasNext()) {
            InitiatorInfo def = (InitiatorInfo)it.next();
            try {
                Initiator init = def.newInitiator(this, page);
                if (init == null) continue;
                init.doInit(page, def.resolveArguments(this, page));
                inits.add(init);
            }
            catch (Throwable ex) {
                throw UiException.Aide.wrap(ex);
            }
        }
        return inits;
    }

    public void addVariableResolverInfo(VariableResolverInfo resolver) {
        if (resolver == null) {
            throw new IllegalArgumentException("null");
        }
        if (this._resolvdefs == null) {
            this._resolvdefs = new LinkedList();
        }
        this._resolvdefs.add(resolver);
    }

    public void addXelMethod(String prefix, String name, Function func) {
        if (name == null || prefix == null || func == null) {
            throw new IllegalArgumentException();
        }
        if (this._xelmtds == null) {
            this._xelmtds = new LinkedList();
        }
        this._xelmtds.add(new Object[]{prefix, name, func});
        this._eval = null;
        this._mapper = null;
    }

    public void initXelContext(Page page) {
        page.addFunctionMapper(this.getFunctionMapper());
        if (this._resolvdefs != null) {
            Iterator it = this._resolvdefs.iterator();
            while (it.hasNext()) {
                VariableResolverInfo def = (VariableResolverInfo)it.next();
                try {
                    VariableResolver resolver = def.newVariableResolver(this, page);
                    if (resolver == null) continue;
                    page.addVariableResolver(resolver);
                }
                catch (Throwable ex) {
                    throw UiException.Aide.wrap(ex);
                }
            }
        }
    }

    public void addHeaderInfo(HeaderInfo header) {
        if (header == null) {
            throw new IllegalArgumentException("null");
        }
        if (this._headerdefs == null) {
            this._headerdefs = new LinkedList();
        }
        this._headerdefs.add(header);
    }

    public String getHeaders(Page page) {
        if (this._headerdefs == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer(256);
        Iterator it = this._headerdefs.iterator();
        while (it.hasNext()) {
            sb.append(((HeaderInfo)it.next()).toHTML(this, page)).append('\n');
        }
        return sb.toString();
    }

    public void addForwardInfo(ForwardInfo forward) {
        if (forward == null) {
            throw new IllegalArgumentException("null");
        }
        if (this._forwdefs == null) {
            this._forwdefs = new LinkedList();
        }
        this._forwdefs.add(forward);
    }

    public String getForwardURI(Page page) {
        if (this._forwdefs == null) {
            return null;
        }
        Iterator it = this._forwdefs.iterator();
        while (it.hasNext()) {
            String uri = ((ForwardInfo)it.next()).resolveURI(this, page);
            if (uri == null) continue;
            return uri;
        }
        return null;
    }

    public String getContentType(Page page) {
        return this._contentType != null ? (String)this._contentType.getValue((Evaluator)this._evalr, page) : null;
    }

    public void setContentType(String contentType) {
        this._contentType = contentType != null && contentType.length() > 0 ? new ExValue(contentType, String.class) : null;
    }

    public String getDocType(Page page) {
        return this._docType != null ? (String)this._docType.getValue((Evaluator)this._evalr, page) : null;
    }

    public void setDocType(String docType) {
        this._docType = docType != null && docType.length() > 0 ? new ExValue(docType, String.class) : null;
    }

    public String getFirstLine(Page page) {
        return this._firstLine != null ? (String)this._firstLine.getValue((Evaluator)this._evalr, page) : null;
    }

    public void setFirstLine(String firstLine) {
        this._firstLine = firstLine != null && firstLine.length() > 0 ? new ExValue(firstLine, String.class) : null;
    }

    public Boolean getCacheable() {
        return this._cacheable;
    }

    public void setCacheable(Boolean cacheable) {
        this._cacheable = cacheable;
    }

    public void setRootAttribute(String name, String value) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (this._rootAttrs == null) {
            if (value == null) {
                return;
            }
            this._rootAttrs = new LinkedHashMap();
        }
        if (value == null) {
            this._rootAttrs.remove(name);
        } else {
            this._rootAttrs.put(name, new ExValue(value, String.class));
        }
    }

    public String getRootAttributes(Page page) {
        if (this._rootAttrs == null || this._rootAttrs.isEmpty()) {
            return "";
        }
        Evaluator eval = this.getEvaluator();
        StringBuffer sb = new StringBuffer(256);
        Iterator it = this._rootAttrs.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry me = it.next();
            String val = (String)((ExValue)me.getValue()).getValue(eval, page);
            if (val == null) continue;
            HTMLs.appendAttribute((StringBuffer)sb, (String)((String)me.getKey()), (String)val);
        }
        return sb.toString();
    }

    public ComponentDefinitionMap getComponentDefinitionMap() {
        return this._compdefs;
    }

    public void addComponentDefinition(ComponentDefinition compdef) {
        LanguageDefinition ld2;
        LanguageDefinition langdef = compdef.getLanguageDefinition();
        if (langdef != null && langdef != (ld2 = this.getLanguageDefinition()) && !langdef.getDeviceType().equals(ld2.getDeviceType())) {
            throw new UiException("Component definition, " + compdef + ", does not belong to the same device type of the page definition, " + ld2.getDeviceType());
        }
        this._compdefs.add(compdef);
    }

    public ComponentDefinition getComponentDefinition(String name, boolean recur) {
        ComponentDefinition compdef = this._compdefs.get(name);
        if (!recur || compdef != null) {
            return compdef;
        }
        try {
            return this.getLanguageDefinition().getComponentDefinition(name);
        }
        catch (DefinitionNotFoundException ex) {
            return null;
        }
    }

    public ComponentDefinition getComponentDefinition(Class cls, boolean recur) {
        ComponentDefinition compdef = this._compdefs.get(cls);
        if (!recur || compdef != null) {
            return compdef;
        }
        try {
            return this.getLanguageDefinition().getComponentDefinition(cls);
        }
        catch (DefinitionNotFoundException ex) {
            return null;
        }
    }

    public void addTaglib(Taglib taglib) {
        if (taglib == null) {
            throw new IllegalArgumentException("null");
        }
        if (this._taglibs == null) {
            this._taglibs = new LinkedList();
        }
        this._taglibs.add(taglib);
        this._eval = null;
        this._mapper = null;
    }

    public void addExpressionImport(String nm, Class cls) {
        if (nm == null || cls == null) {
            throw new IllegalArgumentException();
        }
        if (this._expimps == null) {
            this._expimps = new HashMap(4);
        }
        this._expimps.put(nm, cls);
        this._eval = null;
        this._mapper = null;
    }

    public void setExpressionFactoryClass(Class expfcls) {
        if (expfcls != null && !ExpressionFactory.class.isAssignableFrom(expfcls)) {
            throw new IllegalArgumentException(expfcls + " must implement " + ExpressionFactory.class);
        }
        this._expfcls = expfcls;
    }

    public Class getExpressionFactoryClass() {
        return this._expfcls;
    }

    public Evaluator getEvaluator() {
        if (this._eval == null) {
            this._eval = this.newEvaluator();
        }
        return this._eval;
    }

    private Evaluator newEvaluator() {
        return new SimpleEvaluator(this.getFunctionMapper(), this._expfcls);
    }

    public EvaluatorRef getEvaluatorRef() {
        if (this._evalr == null) {
            this._evalr = this.newEvaluatorRef();
        }
        return this._evalr;
    }

    private EvaluatorRef newEvaluatorRef() {
        return new PageEvalRef(this);
    }

    public FunctionMapper getFunctionMapper() {
        if (this._mapper == null) {
            this._mapper = Taglibs.getFunctionMapper((List)this._taglibs, (Map)this._expimps, (List)this._xelmtds, (Locator)this._locator);
            if (this._mapper == null) {
                this._mapper = Expressions.EMPTY_MAPPER;
            }
        }
        return this._mapper != Expressions.EMPTY_MAPPER ? this._mapper : null;
    }

    public void init(final Page page, final boolean evalHeaders) {
        ((PageCtrl)((Object)page)).init(new PageConfig(){

            public String getId() {
                return PageDefinition.this._id;
            }

            public String getUuid() {
                return null;
            }

            public String getTitle() {
                return PageDefinition.this._title;
            }

            public String getStyle() {
                return PageDefinition.this._style;
            }

            public String getHeaders() {
                return evalHeaders ? PageDefinition.this.getHeaders(page) : "";
            }

            public String getRootAttributes() {
                return PageDefinition.this.getRootAttributes(page);
            }

            public String getContentType() {
                return PageDefinition.this.getContentType(page);
            }

            public String getDocType() {
                return PageDefinition.this.getDocType(page);
            }

            public String getFirstLine() {
                return PageDefinition.this.getFirstLine(page);
            }

            public Boolean getCacheable() {
                return PageDefinition.this._cacheable;
            }
        });
    }

    public PageDefinition getPageDefinition() {
        return this;
    }

    public String toString() {
        return "[PageDefinition:" + (this._id != null ? this._id : this._title) + ']';
    }
}

